/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.bindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.lsp.client.LSPBindings;
import org.netbeans.modules.lsp.client.Utils;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldInfo;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;

public class FoldManagerImpl
implements FoldManager,
LSPBindings.BackgroundTask {
    private FoldOperation operation;
    private FileObject file;
    private static final Logger LOG = Logger.getLogger(FoldManagerImpl.class.getName());

    public void init(FoldOperation operation) {
        this.operation = operation;
    }

    public void initFolds(FoldHierarchyTransaction transaction) {
        Document doc = this.operation.getHierarchy().getComponent().getDocument();
        this.file = NbEditorUtilities.getFileObject((Document)doc);
        if (this.file == null) {
            return;
        }
        LSPBindings.addBackgroundTask(this.file, this);
    }

    public void insertUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void changedUpdate(DocumentEvent evt, FoldHierarchyTransaction transaction) {
    }

    public void removeEmptyNotify(Fold epmtyFold) {
    }

    public void removeDamagedNotify(Fold damagedFold) {
    }

    public void expandNotify(Fold expandedFold) {
    }

    public void release() {
        if (this.file != null) {
            LSPBindings.removeBackgroundTask(this.file, this);
            this.file = null;
        }
    }

    @Override
    public void run(LSPBindings bindings, FileObject file) {
        StyledDocument doc;
        EditorCookie ec = (EditorCookie)file.getLookup().lookup(EditorCookie.class);
        StyledDocument styledDocument = doc = ec != null ? ec.getDocument() : null;
        if (doc == null) {
            return;
        }
        List<FoldingRange> ranges = FoldManagerImpl.computeRanges(bindings, file);
        ArrayList<FoldInfo> infos = new ArrayList<FoldInfo>();
        if (ranges != null) {
            for (FoldingRange r : ranges) {
                int start = Utils.getOffset(doc, new Position(r.getStartLine(), r.getStartCharacter() != null ? r.getStartCharacter() : 0));
                int end = r.getEndCharacter() == null ? Utils.getOffset(doc, new Position(r.getEndLine() + 1, 0)) - 1 : Utils.getOffset(doc, new Position(r.getEndLine(), r.getEndCharacter()));
                infos.add(FoldInfo.range((int)start, (int)end, (FoldType)FoldType.CODE_BLOCK));
            }
        }
        SwingUtilities.invokeLater(() -> doc.render(() -> this.operation.getHierarchy().render(() -> {
            try {
                this.operation.update((Collection)infos, null, null);
            }
            catch (BadLocationException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        })));
    }

    static List<FoldingRange> computeRanges(LSPBindings bindings, FileObject file) {
        if (bindings.getInitResult() != null && bindings.getInitResult().getCapabilities() != null && bindings.getInitResult().getCapabilities().getFoldingRangeProvider() != null) {
            try {
                return bindings.getTextDocumentService().foldingRange(new FoldingRangeRequestParams(new TextDocumentIdentifier(Utils.toURI(file)))).get();
            }
            catch (InterruptedException | ExecutionException ex) {
                LOG.log(Level.FINE, null, ex);
            }
        }
        return Collections.emptyList();
    }

    public static final class FactoryImpl
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new FoldManagerImpl();
        }
    }
}

