/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.project;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormServices;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.modules.ModuleInfo;
import org.openide.util.Lookup;

class ProjectClassLoader
extends ClassLoader {
    private ClassLoader projectClassLoaderDelegate;
    private ClassPath sources;
    private ClassLoader systemClassLoader;
    private ClassLoader orgJDesktopLayoutClassLoader;
    private ClassLoader commonsLoggingClassLoader;
    private boolean commonsLoggingClassLoaderSearched = false;

    private ProjectClassLoader(ClassLoader projectClassLoaderDelegate, ClassPath sources) {
        this.projectClassLoaderDelegate = projectClassLoaderDelegate;
        this.sources = sources;
        this.systemClassLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
    }

    static ClassLoader getUpToDateClassLoader(FileObject fileInProject, ClassLoader clSoFar) {
        ClassLoader actualCL;
        ClassLoader existingCL = clSoFar instanceof ProjectClassLoader ? ((ProjectClassLoader)clSoFar).projectClassLoaderDelegate : clSoFar;
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/execute");
        ClassLoader classLoader = actualCL = classPath != null ? classPath.getClassLoader(true) : null;
        if (actualCL == existingCL) {
            return clSoFar;
        }
        if (actualCL == null) {
            return null;
        }
        return new ProjectClassLoader(actualCL, ClassPath.getClassPath((FileObject)fileInProject, (String)"classpath/source"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class findClass(String name) throws ClassNotFoundException {
        if (name.startsWith("org.apache.commons.logging.")) {
            try {
                ClassLoader classLoader = this.getCommonsLoggingClassLoader();
                if (classLoader != null) {
                    return classLoader.loadClass(name);
                }
            }
            catch (ClassNotFoundException classLoader) {
                // empty catch block
            }
        }
        Class<?> c = null;
        if (ClassPathUtils.getClassLoadingType(name) == ClassPathUtils.SYSTEM_CLASS) {
            if (name.startsWith("org.jdesktop.layout")) {
                if (this.orgJDesktopLayoutClassLoader == null) {
                    FormServices services = (FormServices)Lookup.getDefault().lookup(FormServices.class);
                    this.orgJDesktopLayoutClassLoader = services.getClass().getClassLoader();
                }
                c = this.orgJDesktopLayoutClassLoader.loadClass(name);
            } else {
                c = this.systemClassLoader.loadClass(name);
            }
        } else {
            String filename = name.replace('.', '/').concat(".class");
            URL url = this.projectClassLoaderDelegate.getResource(filename);
            if (url != null) {
                InputStream is = null;
                try {
                    String packageName;
                    Package pakcage;
                    int first;
                    is = url.openStream();
                    byte[] data = null;
                    int available = is.available();
                    while ((first = is.read()) != -1) {
                        int count;
                        int read;
                        int length = is.available();
                        if (length != available) {
                            ++length;
                        }
                        byte[] b = new byte[length];
                        b[0] = (byte)first;
                        for (count = 1; count < length; count += read) {
                            read = is.read(b, count, length - count);
                            assert (read != -1);
                        }
                        if (data == null) {
                            data = b;
                            continue;
                        }
                        byte[] temp = new byte[data.length + count];
                        System.arraycopy(data, 0, temp, 0, data.length);
                        System.arraycopy(b, 0, temp, data.length, count);
                        data = temp;
                    }
                    int dot = name.lastIndexOf(46);
                    if (dot != -1 && (pakcage = this.getPackage(packageName = name.substring(0, dot))) == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    }
                    c = this.defineClass(name, data, 0, data.length);
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
        if (c == null) {
            throw new ClassNotFoundException(name);
        }
        return c;
    }

    @Override
    protected URL findResource(String name) {
        FileObject fo;
        if (!((name.equals("Bundle.properties") || name.endsWith("/Bundle.properties")) && this.isProjectWithNbBundle() || (fo = this.sources.findResource(name)) == null)) {
            return fo.toURL();
        }
        return this.projectClassLoaderDelegate.getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        HashSet<URL> urls = new HashSet<URL>();
        List fos = this.sources.findAllResources(name);
        for (FileObject fo : fos) {
            try {
                urls.add(fo.getURL());
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
        Enumeration<URL> e = this.projectClassLoaderDelegate.getResources(name);
        while (e.hasMoreElements()) {
            urls.add(e.nextElement());
        }
        return Collections.enumeration(urls);
    }

    private boolean isProjectWithNbBundle() {
        return this.projectClassLoaderDelegate.getResource("org/openide/util/NbBundle.class") != null;
    }

    private ClassLoader getCommonsLoggingClassLoader() {
        if (!this.commonsLoggingClassLoaderSearched) {
            for (ModuleInfo info : Lookup.getDefault().lookupAll(ModuleInfo.class)) {
                if (!info.getCodeName().startsWith("o.apache.commons.logging")) continue;
                this.commonsLoggingClassLoader = info.getClassLoader();
                break;
            }
            this.commonsLoggingClassLoaderSearched = true;
        }
        return this.commonsLoggingClassLoader;
    }
}

