/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.jdbcimpl.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.dbschema.jdbcimpl.ConnectionProvider;
import org.netbeans.modules.dbschema.jdbcimpl.DDLBridge;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.DBSchemaWizardData;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.ProgressPanel;
import org.netbeans.modules.dbschema.jdbcimpl.wizard.SortedListModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DBSchemaTablesPanel
extends JPanel
implements ListDataListener {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.dbschema.jdbcimpl.wizard");
    private static final boolean LOG = LOGGER.isLoggable(Level.INFO);
    private final ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.dbschema.jdbcimpl.resources.Bundle");
    private LinkedList<String> tables;
    private LinkedList<String> views;
    private ConnectionProvider cp;
    private String schema;
    private String driver;
    private DatabaseConnection dbconnOld;
    private Connection conn;
    private DBSchemaWizardData data;
    private int tablesCount;
    private ArrayList list;
    private JButton jButtonAdd;
    private JButton jButtonAddAll;
    private JButton jButtonRemove;
    private JButton jButtonRemoveAll;
    private JLabel jLabelAvailableTables;
    private JLabel jLabelNote;
    private JLabel jLabelSelectedTables;
    private JList jListAvailableTables;
    private JList jListSelectedTables;
    private JPanel jPanelButtons;
    private JScrollPane jScrollPaneAvailableTables;
    private JScrollPane jScrollPaneSelectedTables;

    public DBSchemaTablesPanel(DBSchemaWizardData data, ArrayList list) {
        this.list = list;
        this.data = data;
        this.tables = new LinkedList();
        this.views = new LinkedList();
        this.cp = null;
        this.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
        this.setName(this.bundle.getString("TablesChooser"));
        this.initComponents();
        this.initAccessibility();
        this.jListAvailableTables.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBSchemaTablesPanel.this.jListAvailableTables.requestFocus();
            }
        }, KeyStroke.getKeyStroke(84, 8), 2);
        this.jListSelectedTables.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBSchemaTablesPanel.this.jListSelectedTables.requestFocus();
            }
        }, KeyStroke.getKeyStroke(83, 8), 2);
        this.jListSelectedTables.getModel().addListDataListener(this);
        this.jListAvailableTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DBSchemaTablesPanel.this.jButtonAdd.setEnabled(DBSchemaTablesPanel.this.jListAvailableTables.getSelectedIndex() != -1);
            }
        });
        this.jListSelectedTables.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DBSchemaTablesPanel.this.jButtonRemove.setEnabled(DBSchemaTablesPanel.this.jListSelectedTables.getSelectedIndex() != -1);
            }
        });
    }

    protected boolean init() {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        Parameters params = new Parameters();
        boolean init = true;
        if (this.data.getConnectionProvider() != null) {
            if (this.data.getDatabaseConnection() == this.dbconnOld) {
                init = false;
            }
            if (init) {
                this.cp = this.data.getConnectionProvider();
                handlers.add(new Handler(){

                    @Override
                    public void handle(Parameters params) {
                        DBSchemaTablesPanel.this.uninit();
                    }

                    @Override
                    public String getMessage() {
                        return NbBundle.getMessage(DBSchemaTablesPanel.class, (String)"MSG_ClosingPrevious");
                    }
                });
            }
        }
        if (!init) {
            this.updateButtons();
            return true;
        }
        this.data.setConnected(false);
        if (!this.data.isExistingConn()) {
            return false;
        }
        final DatabaseConnection dbconn = this.data.getDatabaseConnection();
        this.conn = dbconn.getJDBCConnection();
        if (this.conn != null) {
            handlers.add(new Handler(){

                @Override
                public void handle(Parameters params) {
                    try {
                        DBSchemaTablesPanel.this.conn.getCatalog();
                    }
                    catch (SQLException exc) {
                        DBSchemaTablesPanel.this.conn = null;
                    }
                }

                @Override
                public String getMessage() {
                    return NbBundle.getMessage(DBSchemaTablesPanel.class, (String)"MSG_CheckingExisting");
                }
            });
        }
        handlers.add(new Handler(){

            @Override
            public void handle(Parameters params) {
                ConnectionManager.getDefault().showConnectionDialog(dbconn);
                DBSchemaTablesPanel.this.conn = dbconn.getJDBCConnection();
                for (int count = 0; DBSchemaTablesPanel.this.conn == null && count < 10; ++count) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    DBSchemaTablesPanel.this.conn = dbconn.getJDBCConnection();
                }
            }

            @Override
            public boolean getRunInEDT() {
                return true;
            }

            @Override
            public boolean isRunnable() {
                return DBSchemaTablesPanel.this.conn == null;
            }
        });
        handlers.add(new Handler(){

            @Override
            public void handle(Parameters params) {
                int i;
                if (DBSchemaTablesPanel.this.conn != null) {
                    try {
                        DBSchemaTablesPanel.this.conn.getCatalog();
                    }
                    catch (SQLException exc) {
                        DBSchemaTablesPanel.this.conn = null;
                        DBSchemaTablesPanel.this.data.setConnected(false);
                        params.setResult(false);
                        return;
                    }
                }
                DBSchemaTablesPanel.this.data.setConnected(true);
                DBSchemaTablesPanel.this.schema = dbconn.getSchema();
                DBSchemaTablesPanel.this.driver = dbconn.getDriverClass();
                DBSchemaTablesPanel.this.dbconnOld = dbconn;
                try {
                    if (DBSchemaTablesPanel.this.conn == null) {
                        params.setResult(false);
                        return;
                    }
                    DBSchemaTablesPanel.this.cp = new ConnectionProvider(DBSchemaTablesPanel.this.conn, DBSchemaTablesPanel.this.driver);
                    DBSchemaTablesPanel.this.cp.setSchema(DBSchemaTablesPanel.this.schema);
                }
                catch (SQLException exc) {
                    // empty catch block
                }
                DBSchemaTablesPanel.this.data.setConnectionProvider(DBSchemaTablesPanel.this.cp);
                DBSchemaTablesPanel.this.tables.clear();
                DBSchemaTablesPanel.this.views.clear();
                try {
                    DDLBridge bridge = new DDLBridge(DBSchemaTablesPanel.this.cp.getConnection(), DBSchemaTablesPanel.this.cp.getSchema(), DBSchemaTablesPanel.this.cp.getDatabaseMetaData());
                    bridge.getDriverSpecification().getTables("%", new String[]{"TABLE"});
                    ResultSet rs = bridge.getDriverSpecification().getResultSet();
                    if (rs != null) {
                        while (rs.next()) {
                            DBSchemaTablesPanel.this.tables.add(rs.getString("TABLE_NAME").trim());
                        }
                        rs.close();
                    }
                    rs = null;
                    if (bridge.getDriverSpecification().areViewsSupported()) {
                        bridge.getDriverSpecification().getTables("%", new String[]{"VIEW"});
                        rs = bridge.getDriverSpecification().getResultSet();
                    }
                    if (rs != null) {
                        while (rs.next()) {
                            DBSchemaTablesPanel.this.views.add(rs.getString("TABLE_NAME").trim());
                        }
                        rs.close();
                    }
                }
                catch (SQLException exc) {
                    LOGGER.info(exc.getLocalizedMessage());
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DBSchemaTablesPanel.class, (String)"DBSchemaTablesPanel_SQLException", (Object)exc.getLocalizedMessage()), 2));
                }
                ((SortedListModel)DBSchemaTablesPanel.this.jListAvailableTables.getModel()).clear();
                ((SortedListModel)DBSchemaTablesPanel.this.jListSelectedTables.getModel()).clear();
                DBSchemaTablesPanel.this.tablesCount = DBSchemaTablesPanel.this.tables.size();
                for (i = 0; i < DBSchemaTablesPanel.this.tables.size(); ++i) {
                    ((SortedListModel)DBSchemaTablesPanel.this.jListAvailableTables.getModel()).add(DBSchemaTablesPanel.this.bundle.getString("TablePrefix") + " " + ((String)DBSchemaTablesPanel.this.tables.get(i)).toString());
                }
                for (i = 0; i < DBSchemaTablesPanel.this.views.size(); ++i) {
                    ((SortedListModel)DBSchemaTablesPanel.this.jListAvailableTables.getModel()).add(DBSchemaTablesPanel.this.bundle.getString("ViewPrefix") + " " + ((String)DBSchemaTablesPanel.this.views.get(i)).toString());
                }
                if (DBSchemaTablesPanel.this.jListAvailableTables.getModel().getSize() > 0) {
                    DBSchemaTablesPanel.this.jListAvailableTables.setSelectedIndex(0);
                }
                DBSchemaTablesPanel.this.tables.clear();
                DBSchemaTablesPanel.this.views.clear();
                params.setResult(true);
            }

            @Override
            public String getMessage() {
                return NbBundle.getMessage(DBSchemaTablesPanel.class, (String)"MSG_RetrievingTables");
            }

            @Override
            public boolean isRunnable() {
                return DBSchemaTablesPanel.this.conn != null;
            }
        });
        this.invokeHandlers(handlers, params);
        this.updateButtons();
        return params.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeHandlers(final List<Handler> handlers, final Parameters params) {
        final ProgressPanel progressPanel = new ProgressPanel();
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle(null);
        JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        final int[] index = new int[1];
        try {
            RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

                @Override
                public void run() {
                    index[0] = DBSchemaTablesPanel.this.invokeHandlers(handlers, index[0], params, progressPanel);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            progressPanel.close();
                        }
                    });
                }
            });
            while (index[0] < handlers.size()) {
                index[0] = this.invokeHandlers(handlers, index[0], params, null);
                if (index[0] >= handlers.size()) continue;
                task.schedule(0);
                progressPanel.open(progressComponent);
            }
        }
        finally {
            progressHandle.finish();
        }
    }

    private int invokeHandlers(List<Handler> handlers, int start, Parameters params, final ProgressPanel progressPanel) {
        int i;
        boolean isEDT = SwingUtilities.isEventDispatchThread();
        for (i = start; i < handlers.size(); ++i) {
            String message;
            Handler h = handlers.get(i);
            if (!h.isRunnable()) {
                if (!LOG) continue;
                LOGGER.log(Level.FINE, "Skipping " + h);
                continue;
            }
            if (h.getRunInEDT() != isEDT) break;
            if (LOG) {
                LOGGER.log(Level.FINE, "Invoking " + h);
            }
            if (progressPanel != null && (message = h.getMessage()) != null) {
                Mutex.EVENT.readAccess(new Runnable(){

                    @Override
                    public void run() {
                        progressPanel.setText(message);
                    }
                });
            }
            h.handle(params);
        }
        return i;
    }

    public void uninit() {
        try {
            if (this.cp != null && this.data.isConnected()) {
                if (this.data.isExistingConn()) {
                    ConnectionManager.getDefault().disconnect(this.dbconnOld);
                } else if (this.dbconnOld.getJDBCConnection() != null) {
                    ConnectionManager.getDefault().disconnect(this.dbconnOld);
                } else {
                    this.cp.closeConnection();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_TablesPanelA11yDesc"));
        this.jLabelAvailableTables.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_AvailableTablesA11yDesc"));
        this.jListAvailableTables.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_AvailableTablesListA11yName"));
        this.jLabelSelectedTables.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_SelectedTablesA11yDesc"));
        this.jListSelectedTables.getAccessibleContext().setAccessibleName(this.bundle.getString("ACS_SelectedTablesListA11yName"));
        this.jLabelNote.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACS_FKReferenceNoteA11yDesc"));
    }

    private void initComponents() {
        this.jLabelAvailableTables = new JLabel();
        this.jScrollPaneAvailableTables = new JScrollPane();
        this.jListAvailableTables = new JList();
        this.jPanelButtons = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonAddAll = new JButton();
        this.jButtonRemoveAll = new JButton();
        this.jLabelSelectedTables = new JLabel();
        this.jScrollPaneSelectedTables = new JScrollPane();
        this.jListSelectedTables = new JList();
        this.jLabelNote = new JLabel();
        FormListener formListener = new FormListener();
        this.setPreferredSize(new Dimension(400, 199));
        this.setLayout(new GridBagLayout());
        this.jLabelAvailableTables.setLabelFor(this.jListAvailableTables);
        Mnemonics.setLocalizedText((JLabel)this.jLabelAvailableTables, (String)this.bundle.getString("AvailableTables"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabelAvailableTables, gridBagConstraints);
        this.jListAvailableTables.setModel(new SortedListModel());
        this.jListAvailableTables.setToolTipText(this.bundle.getString("ACS_AvailableTablesListA11yDesc"));
        this.jScrollPaneAvailableTables.setViewportView(this.jListAvailableTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 12, 0, 0);
        this.add((Component)this.jScrollPaneAvailableTables, gridBagConstraints);
        this.jPanelButtons.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAdd, (String)this.bundle.getString("AddButton"));
        this.jButtonAdd.setToolTipText(this.bundle.getString("ACS_AddButtonA11yDesc"));
        this.jButtonAdd.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.jPanelButtons.add((Component)this.jButtonAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonRemove, (String)this.bundle.getString("RemoveButton"));
        this.jButtonRemove.setToolTipText(this.bundle.getString("ACS_RemoveButtonA11yDesc"));
        this.jButtonRemove.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAddAll, (String)this.bundle.getString("AddAllButton"));
        this.jButtonAddAll.setToolTipText(this.bundle.getString("ACS_AddAllButtonA11yDesc"));
        this.jButtonAddAll.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonAddAll, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonRemoveAll, (String)this.bundle.getString("RemoveAllButton"));
        this.jButtonRemoveAll.setToolTipText(this.bundle.getString("ACS_RemoveAllButtonA11yDesc"));
        this.jButtonRemoveAll.addActionListener(formListener);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.jPanelButtons.add((Component)this.jButtonRemoveAll, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(12, 11, 0, 11);
        this.add((Component)this.jPanelButtons, gridBagConstraints);
        this.jLabelSelectedTables.setLabelFor(this.jListSelectedTables);
        Mnemonics.setLocalizedText((JLabel)this.jLabelSelectedTables, (String)this.bundle.getString("SelectedTables"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 11);
        this.add((Component)this.jLabelSelectedTables, gridBagConstraints);
        this.jListSelectedTables.setModel(new SortedListModel());
        this.jListSelectedTables.setToolTipText(this.bundle.getString("ACS_SelectedTablesListA11yDesc"));
        this.jScrollPaneSelectedTables.setViewportView(this.jListSelectedTables);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(11, 0, 0, 11);
        this.add((Component)this.jScrollPaneSelectedTables, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabelNote, (String)this.bundle.getString("FKReferenceNote"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        this.add((Component)this.jLabelNote, gridBagConstraints);
    }

    private void jButtonRemoveAllActionPerformed(ActionEvent evt) {
        SortedListModel ulm = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel slm = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] values = slm.toArray();
        for (int i = 0; i < values.length; ++i) {
            ulm.add(values[i]);
            slm.remove(values[i]);
        }
        this.tables.clear();
        this.views.clear();
        int[] sel = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            sel[i] = ulm.indexOf(values[i]);
        }
        this.jListAvailableTables.setSelectedIndices(sel);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonAddAllActionPerformed(ActionEvent evt) {
        SortedListModel ulm = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel slm = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] values = ulm.toArray();
        for (int i = 0; i < values.length; ++i) {
            slm.add(values[i]);
            ulm.remove(values[i]);
            String name = values[i].toString();
            if (name.startsWith(this.bundle.getString("TablePrefix"))) {
                this.tables.add(name.substring(name.indexOf(" ") + 1));
                continue;
            }
            this.views.add(name.substring(name.indexOf(" ") + 1));
        }
        int[] sel = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            sel[i] = slm.indexOf(values[i]);
        }
        this.jListSelectedTables.setSelectedIndices(sel);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        SortedListModel ulm = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel slm = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] values = this.jListSelectedTables.getSelectedValues();
        for (int i = 0; i < values.length; ++i) {
            ulm.add(values[i]);
            slm.remove(values[i]);
            String name = values[i].toString();
            name = name.substring(name.indexOf(" ")).trim();
            if (this.tables.contains(name)) {
                this.tables.remove(name);
                continue;
            }
            this.views.remove(name);
        }
        int[] sel = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            sel[i] = ulm.indexOf(values[i]);
        }
        this.jListAvailableTables.setSelectedIndices(sel);
        this.setSelection();
        this.updateButtons();
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        SortedListModel ulm = (SortedListModel)this.jListAvailableTables.getModel();
        SortedListModel slm = (SortedListModel)this.jListSelectedTables.getModel();
        Object[] values = this.jListAvailableTables.getSelectedValues();
        for (int i = 0; i < values.length; ++i) {
            slm.add(values[i]);
            ulm.remove(values[i]);
            String name = values[i].toString();
            if (name.startsWith(this.bundle.getString("TablePrefix"))) {
                this.tables.add(name.substring(name.indexOf(" ") + 1));
                continue;
            }
            this.views.add(name.substring(name.indexOf(" ") + 1));
        }
        int[] sel = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            sel[i] = slm.indexOf(values[i]);
        }
        this.jListSelectedTables.setSelectedIndices(sel);
        this.setSelection();
        this.updateButtons();
    }

    private void setSelection() {
        this.data.setTables(this.tables);
        this.data.setViews(this.views);
        if (this.tablesCount == this.tables.size()) {
            this.data.setAllTables(true);
        } else {
            this.data.setAllTables(false);
        }
    }

    private void updateButtons() {
        this.jButtonAdd.setEnabled(this.jListAvailableTables.getSelectedIndex() != -1);
        this.jButtonAddAll.setEnabled(!((SortedListModel)this.jListAvailableTables.getModel()).isEmpty());
        this.jButtonRemove.setEnabled(this.jListSelectedTables.getSelectedIndex() != -1);
        this.jButtonRemoveAll.setEnabled(!((SortedListModel)this.jListSelectedTables.getModel()).isEmpty());
    }

    public boolean isInputValid() {
        return this.jListSelectedTables.getModel().getSize() > 0;
    }

    @Override
    public void intervalAdded(ListDataEvent p1) {
        this.fireChange(this);
    }

    @Override
    public void intervalRemoved(ListDataEvent p1) {
        this.fireChange(this);
    }

    @Override
    public void contentsChanged(ListDataEvent p1) {
        this.fireChange(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(Object source) {
        ArrayList lst;
        DBSchemaTablesPanel dBSchemaTablesPanel = this;
        synchronized (dBSchemaTablesPanel) {
            lst = (ArrayList)this.list.clone();
        }
        ChangeEvent event = new ChangeEvent(source);
        for (int i = 0; i < lst.size(); ++i) {
            ChangeListener listener = (ChangeListener)lst.get(i);
            listener.stateChanged(event);
        }
    }

    private static final class Parameters {
        private boolean result;

        private Parameters() {
        }

        public boolean getResult() {
            return this.result;
        }

        public void setResult(boolean result) {
            this.result = result;
        }
    }

    private static abstract class Handler {
        private Handler() {
        }

        public abstract void handle(Parameters var1);

        public String getMessage() {
            return null;
        }

        public boolean getRunInEDT() {
            return false;
        }

        public boolean isRunnable() {
            return true;
        }

        public String toString() {
            return "Handler[message='" + this.getMessage() + "',runInEDT=" + this.getRunInEDT() + ",runnable=" + this.isRunnable() + "]";
        }
    }

    private class FormListener
    implements ActionListener {
        FormListener() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() == DBSchemaTablesPanel.this.jButtonAdd) {
                DBSchemaTablesPanel.this.jButtonAddActionPerformed(evt);
            } else if (evt.getSource() == DBSchemaTablesPanel.this.jButtonRemove) {
                DBSchemaTablesPanel.this.jButtonRemoveActionPerformed(evt);
            } else if (evt.getSource() == DBSchemaTablesPanel.this.jButtonAddAll) {
                DBSchemaTablesPanel.this.jButtonAddAllActionPerformed(evt);
            } else if (evt.getSource() == DBSchemaTablesPanel.this.jButtonRemoveAll) {
                DBSchemaTablesPanel.this.jButtonRemoveAllActionPerformed(evt);
            }
        }
    }
}

