/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Constants;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CronTriggerFactoryBean
implements FactoryBean<CronTrigger>,
BeanNameAware,
InitializingBean {
    private static final Constants constants = new Constants(CronTrigger.class);
    private String name;
    private String group;
    private JobDetail jobDetail;
    private JobDataMap jobDataMap = new JobDataMap();
    private Date startTime;
    private long startDelay = 0L;
    private String cronExpression;
    private TimeZone timeZone;
    private String calendarName;
    private int priority;
    private int misfireInstruction;
    private String description;
    private String beanName;
    private CronTrigger cronTrigger;

    public void setName(String name) {
        this.name = name;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setJobDetail(JobDetail jobDetail) {
        this.jobDetail = jobDetail;
    }

    public void setJobDataMap(JobDataMap jobDataMap) {
        this.jobDataMap = jobDataMap;
    }

    public JobDataMap getJobDataMap() {
        return this.jobDataMap;
    }

    public void setJobDataAsMap(Map<String, ?> jobDataAsMap) {
        this.jobDataMap.putAll(jobDataAsMap);
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setStartDelay(long startDelay) {
        Assert.isTrue((startDelay >= 0L ? 1 : 0) != 0, (String)"Start delay cannot be negative");
        this.startDelay = startDelay;
    }

    public void setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public void setCalendarName(String calendarName) {
        this.calendarName = calendarName;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setMisfireInstruction(int misfireInstruction) {
        this.misfireInstruction = misfireInstruction;
    }

    public void setMisfireInstructionName(String constantName) {
        this.misfireInstruction = constants.asNumber(constantName).intValue();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() {
        Method jobKeyMethod;
        Class cronTriggerClass;
        if (this.name == null) {
            this.name = this.beanName;
        }
        if (this.group == null) {
            this.group = "DEFAULT";
        }
        if (this.jobDetail != null) {
            this.jobDataMap.put((Object)"jobDetail", (Object)this.jobDetail);
        }
        if (this.startDelay > 0L || this.startTime == null) {
            this.startTime = new Date(System.currentTimeMillis() + this.startDelay);
        }
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        try {
            cronTriggerClass = ClassUtils.forName((String)"org.quartz.impl.triggers.CronTriggerImpl", (ClassLoader)this.getClass().getClassLoader());
            jobKeyMethod = JobDetail.class.getMethod("getKey", new Class[0]);
        }
        catch (ClassNotFoundException ex) {
            cronTriggerClass = CronTrigger.class;
            jobKeyMethod = null;
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Incompatible Quartz version");
        }
        BeanWrapperImpl bw = new BeanWrapperImpl(cronTriggerClass);
        MutablePropertyValues pvs = new MutablePropertyValues();
        pvs.add("name", (Object)this.name);
        pvs.add("group", (Object)this.group);
        if (this.jobDetail != null) {
            if (jobKeyMethod != null) {
                pvs.add("jobKey", ReflectionUtils.invokeMethod((Method)jobKeyMethod, (Object)this.jobDetail));
            } else {
                pvs.add("jobName", (Object)this.jobDetail.getName());
                pvs.add("jobGroup", (Object)this.jobDetail.getGroup());
            }
        }
        pvs.add("jobDataMap", (Object)this.jobDataMap);
        pvs.add("startTime", (Object)this.startTime);
        pvs.add("cronExpression", (Object)this.cronExpression);
        pvs.add("timeZone", (Object)this.timeZone);
        pvs.add("calendarName", (Object)this.calendarName);
        pvs.add("priority", (Object)this.priority);
        pvs.add("misfireInstruction", (Object)this.misfireInstruction);
        pvs.add("description", (Object)this.description);
        bw.setPropertyValues((PropertyValues)pvs);
        this.cronTrigger = (CronTrigger)bw.getWrappedInstance();
    }

    public CronTrigger getObject() {
        return this.cronTrigger;
    }

    public Class<?> getObjectType() {
        return CronTrigger.class;
    }

    public boolean isSingleton() {
        return true;
    }
}

