/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.markdown.core.token;

import org.eclipse.mylyn.internal.wikitext.markdown.core.LinkDefinition;
import org.eclipse.mylyn.internal.wikitext.markdown.core.MarkdownContentState;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElement;
import org.eclipse.mylyn.wikitext.core.parser.markup.PatternBasedElementProcessor;

public class ReferenceStyleImageReplacementToken
extends PatternBasedElement {
    protected String getPattern(int groupOffset) {
        return "!(\\[\\s*(.*?)\\s*\\]\\s*\\[\\s*(.*?)\\s*\\])";
    }

    protected int getPatternGroupCount() {
        return 3;
    }

    protected PatternBasedElementProcessor newProcessor() {
        return new ReferenceStyleLinkReplacementTokenProcessor();
    }

    private static class ReferenceStyleLinkReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private ReferenceStyleLinkReplacementTokenProcessor() {
        }

        public void emit() {
            MarkdownContentState mdContentState;
            LinkDefinition linkDefinition;
            String altText = this.group(2);
            String refid = this.group(3);
            if (refid.isEmpty()) {
                refid = altText;
            }
            if ((linkDefinition = (mdContentState = (MarkdownContentState)this.getState()).getLinkDefinition(refid)) != null) {
                String href = linkDefinition.getUrl();
                String title = linkDefinition.getTitle();
                ImageAttributes attributes = new ImageAttributes();
                attributes.setTitle(title);
                attributes.setAlt(altText);
                this.builder.image((Attributes)attributes, href);
            } else {
                this.builder.characters(this.group(1));
            }
        }
    }
}

