<?php
/*
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or (at your
 * option) any later version.  Please see LICENSE.txt at the top level of
 * the source code distribution for details.
 *
 * @package    LibreNMS
 * @subpackage webui
 * @link       https://www.librenms.org
 * @copyright  2017 LibreNMS
 * @author     Cercel Valentin <crc@nuamchefazi.ro>
*/

require 'includes/html/graphs/common.inc.php';
$scale_min = 0;
$colours = 'mixed';
$unit_text = 'Queries answer latency';
$unitlen = 6;
$bigdescrlen = 25;
$smalldescrlen = 25;
$dostack = 0;
$printtotal = 0;
$addarea = 1;
$transparency = 33;
$rrd_filename = rrd_name($device['hostname'], ['app', $app['app_type'], $app['app_id']]);

$array = [
    'latency_0_1' => ['descr' => '< 1ms', 'colour' => '58b146'],
    'latency_1_10' => ['descr' => '1-10 ms', 'colour' => '4f9f3f'],
    'latency_10_50' => ['descr' => '10-50 ms', 'colour' => '3d7b31'],
    'latency_50_100' => ['descr' => '50-100 ms', 'colour' => '23461c'],
    'latency_100_1000' => ['descr' => '100-1000 ms', 'colour' => '11230e'],
    'latency_slow' => ['descr' => '> 1 sec', 'colour' => '727F8C'],
];

$i = 0;

if (rrdtool_check_rrd_exists($rrd_filename)) {
    foreach ($array as $ds => $var) {
        $rrd_list[$i]['filename'] = $rrd_filename;
        $rrd_list[$i]['descr'] = $var['descr'];
        $rrd_list[$i]['ds'] = $ds;
        $rrd_list[$i]['colour'] = $var['colour'];
        $i++;
    }
} else {
    echo "file missing: $rrd_filename";
}

require 'includes/html/graphs/generic_v3_multiline_float.inc.php';
