/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssFontFeatureSettings
extends org.w3c.css.properties.css.CssFontFeatureSettings {
    public static final CssIdent on = CssIdent.getIdent("on");
    public static final CssIdent off = CssIdent.getIdent("off");
    public static final CssIdent normal = CssIdent.getIdent("normal");

    public CssFontFeatureSettings() {
        this.value = initial;
    }

    public CssFontFeatureSettings(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        CssExpression singleExpr = null;
        CssValue b_val = null;
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            if (inherit.equals(val)) {
                if (expression.getCount() > 1) {
                    throw new InvalidParamException("value", val, this.getPropertyName(), ac);
                }
                this.value = inherit;
                expression.next();
                return;
            }
            if (singleExpr == null) {
                singleExpr = new CssExpression();
            }
            singleExpr.addValue(val);
            singleExpr.setOperator(op);
            expression.next();
            if (expression.end()) continue;
            if (op == ',') {
                singleExpr.setOperator(' ');
                b_val = this.check(ac, singleExpr);
                values.add(b_val);
                singleExpr = null;
                continue;
            }
            if (op == ' ') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (singleExpr != null) {
            b_val = this.check(ac, singleExpr);
            values.add(b_val);
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssLayerList(values);
    }

    public CssFontFeatureSettings(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    public CssValue check(ApplContext ac, CssExpression exp) throws InvalidParamException {
        if (exp.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = exp.getValue();
        switch (val.getType()) {
            case 1: {
                String s = val.toString();
                if (s.length() == 6) break;
                throw new InvalidParamException("value", s, this.getPropertyName(), ac);
            }
            case 0: {
                if (normal.equals(val) && exp.getCount() == 1) {
                    return normal;
                }
            }
            default: {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        }
        if (exp.getCount() == 1) {
            return val;
        }
        ArrayList<CssValue> v = new ArrayList<CssValue>(2);
        v.add(val);
        exp.next();
        val = exp.getValue();
        switch (val.getType()) {
            case 5: {
                CssCheckableValue n = val.getCheckableValue();
                n.checkPositiveness(ac, this);
                v.add(val);
                break;
            }
            case 0: {
                if (on.equals(val)) {
                    v.add(on);
                    break;
                }
                if (off.equals(val)) {
                    v.add(off);
                    break;
                }
            }
            default: {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        }
        return v.size() == 1 ? (CssValue)v.get(0) : new CssValueList(v);
    }
}

