CREATE TABLE `wireless_sensors` (sensor_id INT(11) PRIMARY KEY NOT NULL AUTO_INCREMENT, sensor_deleted TINYINT(1) DEFAULT '0' NOT NULL, sensor_class VARCHAR(64) NOT NULL, device_id INT(11) unsigned DEFAULT '0' NOT NULL, sensor_index VARCHAR(64), sensor_type VARCHAR(255) NOT NULL, sensor_descr VARCHAR(255), sensor_divisor INT(11) DEFAULT '1' NOT NULL, sensor_multiplier INT(11) DEFAULT '1' NOT NULL, sensor_aggregator VARCHAR(16) DEFAULT 'sum' NOT NULL, sensor_current FLOAT, sensor_prev FLOAT, sensor_limit FLOAT, sensor_limit_warn FLOAT, sensor_limit_low FLOAT, sensor_limit_low_warn FLOAT, sensor_alert TINYINT(1) DEFAULT '1' NOT NULL, sensor_custom ENUM('No', 'Yes') DEFAULT 'No' NOT NULL, entPhysicalIndex VARCHAR(16), entPhysicalIndex_measured VARCHAR(16), lastupdate TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL, sensor_oids VARCHAR(255) NOT NULL, access_point_id INT(11), CONSTRAINT wireless_sensors_device_id_foreign FOREIGN KEY (device_id) REFERENCES `devices` (device_id) ON DELETE CASCADE);
CREATE INDEX sensor_class ON `wireless_sensors` (sensor_class);
CREATE INDEX sensor_host ON `wireless_sensors` (device_id);
CREATE INDEX sensor_type ON `wireless_sensors` (sensor_type);
