/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.pkg;

import java.lang.invoke.MethodHandles;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.logging.MDCLoggingContext;
import org.apache.solr.pkg.PackageLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageListeners {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PACKAGE_VERSIONS = "PKG_VERSIONS";
    private SolrCore core;
    private List<Reference<Listener>> listeners = new CopyOnWriteArrayList<Reference<Listener>>();

    public PackageListeners(SolrCore core) {
        this.core = core;
    }

    public synchronized void addListener(Listener listener) {
        this.listeners.add(new SoftReference<Listener>(listener));
    }

    public synchronized void removeListener(Listener listener) {
        Iterator<Reference<Listener>> it = this.listeners.iterator();
        while (it.hasNext()) {
            Reference<Listener> ref = it.next();
            Listener pkgListener = ref.get();
            if (pkgListener != null && pkgListener != listener) continue;
            it.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void packagesUpdated(List<PackageLoader.Package> pkgs) {
        MDCLoggingContext.setCore(this.core);
        try {
            for (PackageLoader.Package pkgInfo : pkgs) {
                this.invokeListeners(pkgInfo);
            }
        }
        finally {
            MDCLoggingContext.clear();
        }
    }

    private synchronized void invokeListeners(PackageLoader.Package pkg) {
        for (Reference<Listener> ref : this.listeners) {
            Listener listener = ref.get();
            if (listener == null || listener.packageName() != null && !listener.packageName().equals(pkg.name())) continue;
            listener.changed(pkg);
        }
    }

    public List<Listener> getListeners() {
        ArrayList<Listener> result = new ArrayList<Listener>();
        for (Reference<Listener> ref : this.listeners) {
            Listener l = ref.get();
            if (l == null) continue;
            result.add(l);
        }
        return result;
    }

    public static interface Listener {
        public String packageName();

        public PluginInfo pluginInfo();

        public void changed(PackageLoader.Package var1);

        public PackageLoader.Package.Version getPackageVersion();
    }
}

