/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.packagemanager;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.zafarkhaja.semver.Version;
import com.google.common.base.Strings;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.client.solrj.response.V2Response;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.BlobRepository;
import org.apache.solr.filestore.DistribPackageStore;
import org.apache.solr.filestore.PackageStoreAPI;
import org.apache.solr.packagemanager.SolrPackage;
import org.apache.solr.util.SolrJacksonAnnotationInspector;

public class PackageUtils {
    public static String LATEST = "latest";
    public static String PACKAGE_PATH = "/api/cluster/package";
    public static String CLUSTER_PLUGINS_PATH = "/api/cluster/plugin";
    public static String REPOSITORIES_ZK_PATH = "/repositories.json";
    public static String CLUSTERPROPS_PATH = "/api/cluster/zk/data/clusterprops.json";
    public static String BLACK = "\u001b[30m";
    public static String RED = "\u001b[31m";
    public static String GREEN = "\u001b[32m";
    public static String YELLOW = "\u001b[33m";
    public static String BLUE = "\u001b[34m";
    public static String PURPLE = "\u001b[35m";
    public static String CYAN = "\u001b[36m";
    public static String WHITE = "\u001b[37m";

    public static Configuration jsonPathConfiguration() {
        JacksonMappingProvider provider = new JacksonMappingProvider();
        JacksonJsonProvider jsonProvider = new JacksonJsonProvider();
        Configuration c = Configuration.builder().jsonProvider((JsonProvider)jsonProvider).mappingProvider((MappingProvider)provider).options(new Option[]{Option.REQUIRE_PROPERTIES}).build();
        return c;
    }

    public static ObjectMapper getMapper() {
        return new ObjectMapper().setAnnotationIntrospector((AnnotationIntrospector)new SolrJacksonAnnotationInspector());
    }

    public static void postFile(SolrClient client, ByteBuffer buffer, String name, String sig) throws SolrServerException, IOException {
        V2Response rsp;
        String resource = "/api/cluster/files" + name;
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (sig != null) {
            params.add("sig", new String[]{sig});
        }
        if (!name.equals((rsp = (V2Response)new V2Request.Builder(resource).withMethod(SolrRequest.METHOD.PUT).withPayload((Object)buffer).forceV2(true).withMimeType("application/octet-stream").withParams((SolrParams)params).build().process(client)).getResponse().get("file"))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Mismatch in file uploaded. Uploaded: " + rsp.getResponse().get("file") + ", Original: " + name);
        }
    }

    public static <T> T getJson(HttpClient client, String url, Class<T> klass) {
        try {
            return (T)PackageUtils.getMapper().readValue(PackageUtils.getJsonStringFromUrl(client, url), klass);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileFromJarsAsString(List<Path> jars, String filename) {
        Iterator<Path> iterator = jars.iterator();
        while (iterator.hasNext()) {
            Path jarfile = iterator.next();
            try {
                ZipFile zipFile = new ZipFile(jarfile.toFile());
                Throwable throwable = null;
                try {
                    ZipEntry entry = zipFile.getEntry(filename);
                    if (entry == null) continue;
                    String string = IOUtils.toString((InputStream)zipFile.getInputStream(entry), (String)"UTF-8");
                    return string;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (zipFile == null) continue;
                    if (throwable != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    zipFile.close();
                }
            }
            catch (Exception ex) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)ex);
            }
        }
        return null;
    }

    public static String getJsonStringFromUrl(HttpClient client, String url) {
        try {
            HttpResponse resp = client.execute((HttpUriRequest)new HttpGet(url));
            if (resp.getStatusLine().getStatusCode() != 200) {
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "Error (code=" + resp.getStatusLine().getStatusCode() + ") fetching from URL: " + url);
            }
            return IOUtils.toString((InputStream)resp.getEntity().getContent(), (String)"UTF-8");
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean checkVersionConstraint(String ver, String constraint) {
        return Strings.isNullOrEmpty((String)constraint) || Version.valueOf((String)ver).satisfies(constraint);
    }

    public static SolrPackage.Manifest fetchManifest(HttpSolrClient solrClient, String solrBaseUrl, String manifestFilePath, String expectedSHA512) throws MalformedURLException, IOException {
        String manifestJson = PackageUtils.getJsonStringFromUrl(solrClient.getHttpClient(), solrBaseUrl + "/api/node/files" + manifestFilePath);
        String calculatedSHA512 = BlobRepository.sha512Digest(ByteBuffer.wrap(manifestJson.getBytes("UTF-8")));
        if (!expectedSHA512.equals(calculatedSHA512)) {
            throw new SolrException(SolrException.ErrorCode.UNAUTHORIZED, "The manifest SHA512 doesn't match expected SHA512. Possible unauthorized manipulation. Expected: " + expectedSHA512 + ", calculated: " + calculatedSHA512 + ", manifest location: " + manifestFilePath);
        }
        SolrPackage.Manifest manifest = (SolrPackage.Manifest)PackageUtils.getMapper().readValue(manifestJson, SolrPackage.Manifest.class);
        return manifest;
    }

    public static String resolve(String str, Map<String, String> defaults, Map<String, String> overrides, Map<String, String> systemParams) {
        if (str == null) {
            return null;
        }
        if (defaults != null) {
            for (String param : defaults.keySet()) {
                str = str.replaceAll("\\$\\{" + param + "\\}", overrides.containsKey(param) ? overrides.get(param) : defaults.get(param));
            }
        }
        for (String param : overrides.keySet()) {
            str = str.replaceAll("\\$\\{" + param + "\\}", overrides.get(param));
        }
        for (String param : systemParams.keySet()) {
            str = str.replaceAll("\\$\\{" + param + "\\}", systemParams.get(param));
        }
        return str;
    }

    public static int compareVersions(String v1, String v2) {
        return Version.valueOf((String)v1).compareTo(Version.valueOf((String)v2));
    }

    public static void printGreen(Object message) {
        PackageUtils.print(GREEN, message);
    }

    public static void printRed(Object message) {
        PackageUtils.print(RED, message);
    }

    public static void print(Object message) {
        PackageUtils.print(null, message);
    }

    @SuppressForbidden(reason="Need to use System.out.println() instead of log4j/slf4j for cleaner output")
    public static void print(String color, Object message) {
        String RESET = "\u001b[0m";
        if (color != null) {
            System.out.println(color + String.valueOf(message) + RESET);
        } else {
            System.out.println(message);
        }
    }

    public static String[] validateCollections(String[] collections) {
        String collectionNameRegex = "^[a-zA-Z0-9_-]*$";
        for (String c : collections) {
            if (c.matches(collectionNameRegex)) continue;
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid collection name: " + c + ". Didn't match the pattern: '" + collectionNameRegex + "'");
        }
        return collections;
    }

    public static Map map(Object ... params) {
        LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < params.length; i += 2) {
            Object object = ret.put(params[i], params[i + 1]);
        }
        return ret;
    }

    public static String getCollectionParamsPath(String collection) {
        return "/api/collections/" + collection + "/config/params";
    }

    public static void uploadKey(byte[] bytes, String path, Path home, HttpSolrClient client) throws IOException {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        PackageStoreAPI.MetaData meta = PackageStoreAPI._createJsonMetaData(buf, null);
        DistribPackageStore._persistToFile(home, path, buf, ByteBuffer.wrap(Utils.toJSON((Object)meta)));
    }
}

