/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hsqldb.lib.InputStreamInterface;
import org.hsqldb.lib.InputStreamWrapper;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.PIFGenerator;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarFileOutputStream;
import org.hsqldb.lib.tar.TarHeaderField;
import org.hsqldb.lib.tar.TarMalformatException;

public class TarGenerator {
    protected TarFileOutputStream archive;
    protected List<TarEntrySupplicant> entryQueue = new ArrayList<TarEntrySupplicant>();
    protected long paxThreshold = 0x200000000L;

    public void setPaxThreshold(long l) {
        this.paxThreshold = l;
    }

    public long getPaxThreshold() {
        return this.paxThreshold;
    }

    public TarGenerator(File file, boolean bl, Integer n) throws IOException {
        File file2 = file.getAbsoluteFile();
        int n2 = 0;
        if (file2.getName().endsWith(".tgz") || file2.getName().endsWith(".tar.gz")) {
            n2 = 1;
        } else if (!file2.getName().endsWith(".tar")) {
            throw new IllegalArgumentException(RB.unsupported_ext.getString(this.getClass().getName(), file2.getPath()));
        }
        if (file2.exists()) {
            if (!bl) {
                throw new IOException(RB.dest_exists.getString(file2.getPath()));
            }
        } else {
            File file3 = file2.getParentFile();
            if (file3.exists()) {
                if (!file3.isDirectory()) {
                    throw new IOException(RB.parent_not_dir.getString(file3.getPath()));
                }
                if (!file3.canWrite()) {
                    throw new IOException(RB.cant_write_parent.getString(file3.getPath()));
                }
            } else if (!file3.mkdirs()) {
                throw new IOException(RB.parent_create_fail.getString(file3.getPath()));
            }
        }
        TarFileOutputStream tarFileOutputStream = this.archive = n == null ? new TarFileOutputStream(file2, n2) : new TarFileOutputStream(file2, n2, n);
        if (n != null && TarFileOutputStream.debug) {
            System.out.println(RB.bpr_write.getString(n));
        }
    }

    public void queueEntry(File file) throws FileNotFoundException, TarMalformatException {
        this.queueEntry(null, file);
    }

    public void queueEntry(String string, File file) throws FileNotFoundException, TarMalformatException {
        this.entryQueue.add(new TarEntrySupplicant(string, file, this.archive, this.paxThreshold));
    }

    public void queueEntry(String string, InputStreamInterface inputStreamInterface) throws FileNotFoundException, TarMalformatException {
        this.entryQueue.add(new TarEntrySupplicant(string, inputStreamInterface, this.archive, this.paxThreshold));
    }

    public void queueEntry(String string, InputStream inputStream, int n) throws IOException, TarMalformatException {
        this.entryQueue.add(new TarEntrySupplicant(string, inputStream, n, '0', this.archive));
    }

    public void write() throws IOException, TarMalformatException {
        if (TarFileOutputStream.debug) {
            System.out.println(RB.write_queue_report.getString(this.entryQueue.size()));
        }
        try {
            for (int i = 0; i < this.entryQueue.size(); ++i) {
                System.err.print(Integer.toString(i + 1) + " / " + this.entryQueue.size() + ' ');
                TarEntrySupplicant tarEntrySupplicant = this.entryQueue.get(i);
                System.err.print(tarEntrySupplicant.getPath() + "... ");
                tarEntrySupplicant.write();
                this.archive.assertAtBlockBoundary();
                System.err.println();
            }
            this.archive.finish();
        }
        catch (IOException iOException) {
            System.err.println();
            try {
                for (TarEntrySupplicant tarEntrySupplicant : this.entryQueue) {
                    tarEntrySupplicant.close();
                }
                this.archive.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    protected static class TarEntrySupplicant {
        static final byte[] HEADER_TEMPLATE = (byte[])TarFileOutputStream.ZERO_BLOCK.clone();
        static Character swapOutDelim = null;
        static final byte[] ustarBytes = new byte[]{117, 115, 116, 97, 114};
        protected byte[] rawHeader = (byte[])HEADER_TEMPLATE.clone();
        protected String fileMode = "600";
        protected InputStreamInterface inputStream;
        protected String path;
        protected long modTime;
        protected TarFileOutputStream tarStream;
        protected long dataSize;
        protected boolean paxSized = false;
        protected final long paxThreshold;
        public static final String DEFAULT_FILE_MODES = "600";

        protected static void writeField(TarHeaderField tarHeaderField, String string, byte[] byArray) throws TarMalformatException {
            byte[] byArray2;
            int n = tarHeaderField.getStart();
            int n2 = tarHeaderField.getStop();
            try {
                byArray2 = string.getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            if (byArray2.length > n2 - n) {
                throw new TarMalformatException(RB.tar_field_toobig.getString(tarHeaderField.toString(), string));
            }
            for (int i = 0; i < byArray2.length; ++i) {
                byArray[n + i] = byArray2[i];
            }
        }

        protected static void clearField(TarHeaderField tarHeaderField, byte[] byArray) {
            int n = tarHeaderField.getStart();
            int n2 = tarHeaderField.getStop();
            for (int i = n; i < n2; ++i) {
                byArray[i] = 0;
            }
        }

        protected static void writeField(TarHeaderField tarHeaderField, long l, byte[] byArray) throws TarMalformatException {
            TarEntrySupplicant.writeField(tarHeaderField, TarEntrySupplicant.prePaddedOctalString(l, tarHeaderField.getStop() - tarHeaderField.getStart()), byArray);
        }

        public static String prePaddedOctalString(long l, int n) {
            return StringUtil.toPaddedString(Long.toOctalString(l), n, '0', false);
        }

        public String getPath() {
            return this.path;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        protected TarEntrySupplicant(String string, char c, TarFileOutputStream tarFileOutputStream, long l) throws TarMalformatException {
            this.paxThreshold = l;
            if (string == null) {
                throw new IllegalArgumentException(RB.missing_supp_path.getString());
            }
            this.path = swapOutDelim == null ? string : string.replace(swapOutDelim.charValue(), '/');
            this.tarStream = tarFileOutputStream;
            this.writeField(TarHeaderField.typeflag, c);
            if (c == '\u0000' || c == ' ') {
                TarEntrySupplicant.writeField(TarHeaderField.uname, System.getProperty("user.name"), HEADER_TEMPLATE);
                TarEntrySupplicant.writeField(TarHeaderField.gname, "root", HEADER_TEMPLATE);
            }
        }

        public TarEntrySupplicant makeXentry() throws IOException, TarMalformatException {
            PIFGenerator pIFGenerator = new PIFGenerator(new File(this.path));
            pIFGenerator.addRecord("size", this.dataSize);
            return new TarEntrySupplicant(pIFGenerator.getName(), new ByteArrayInputStream(pIFGenerator.toByteArray()), pIFGenerator.size(), 'x', this.tarStream);
        }

        public TarEntrySupplicant(String string, File file, TarFileOutputStream tarFileOutputStream, long l) throws FileNotFoundException, TarMalformatException {
            this(string == null ? file.getPath() : string, '0', tarFileOutputStream, l);
            if (!file.isFile()) {
                throw new IllegalArgumentException(RB.nonfile_entry.getString());
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException(RB.read_denied.getString(file.getAbsolutePath()));
            }
            this.modTime = file.lastModified() / 1000L;
            this.fileMode = TarEntrySupplicant.getLameMode(file);
            this.dataSize = file.length();
            this.inputStream = new InputStreamWrapper(new FileInputStream(file));
        }

        public TarEntrySupplicant(String string, InputStreamInterface inputStreamInterface, TarFileOutputStream tarFileOutputStream, long l) throws FileNotFoundException, TarMalformatException {
            this(string, '0', tarFileOutputStream, l);
            this.modTime = System.currentTimeMillis() / 1000L;
            this.fileMode = DEFAULT_FILE_MODES;
            this.inputStream = inputStreamInterface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TarEntrySupplicant(String string, InputStream inputStream, int n, char c, TarFileOutputStream tarFileOutputStream) throws IOException, TarMalformatException {
            this(string, c, tarFileOutputStream, 0x200000000L);
            if (n < 1) {
                throw new IllegalArgumentException(RB.read_lt_1.getString());
            }
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            try {
                int n2;
                this.inputStream = new InputStreamWrapper(new PipedInputStream(pipedOutputStream));
                while ((n2 = inputStream.read(tarFileOutputStream.writeBuffer, 0, tarFileOutputStream.writeBuffer.length)) > 0) {
                    pipedOutputStream.write(tarFileOutputStream.writeBuffer, 0, n2);
                }
                pipedOutputStream.flush();
                this.dataSize = this.inputStream.available();
                if (TarFileOutputStream.debug) {
                    System.out.println(RB.stream_buffer_report.getString(Long.toString(this.dataSize)));
                }
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
            finally {
                try {
                    pipedOutputStream.close();
                }
                finally {
                    pipedOutputStream = null;
                }
            }
            this.modTime = new Date().getTime() / 1000L;
        }

        public void close() throws IOException {
            if (this.inputStream == null) {
                return;
            }
            try {
                this.inputStream.close();
            }
            finally {
                this.inputStream = null;
            }
        }

        protected long headerChecksum() {
            long l = 0L;
            for (int i = 0; i < this.rawHeader.length; ++i) {
                boolean bl = i >= TarHeaderField.checksum.getStart() && i < TarHeaderField.checksum.getStop();
                l += bl ? 32L : (long)(0xFF & this.rawHeader[i]);
            }
            return l;
        }

        protected void clearField(TarHeaderField tarHeaderField) {
            TarEntrySupplicant.clearField(tarHeaderField, this.rawHeader);
        }

        protected void writeField(TarHeaderField tarHeaderField, String string) throws TarMalformatException {
            TarEntrySupplicant.writeField(tarHeaderField, string, this.rawHeader);
        }

        protected void writeField(TarHeaderField tarHeaderField, long l) throws TarMalformatException {
            TarEntrySupplicant.writeField(tarHeaderField, l, this.rawHeader);
        }

        protected void writeField(TarHeaderField tarHeaderField, char c) throws TarMalformatException {
            TarEntrySupplicant.writeField(tarHeaderField, Character.toString(c), this.rawHeader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() throws IOException, TarMalformatException {
            try {
                int n;
                long l = this.inputStream.getSizeLimit();
                if (l == 0L) {
                    return;
                }
                if (l > 0L) {
                    this.dataSize = l;
                }
                if (this.dataSize >= this.paxThreshold) {
                    this.paxSized = true;
                    this.makeXentry().write();
                    System.err.print("x... ");
                }
                this.writeField(TarHeaderField.name, this.path);
                this.writeField(TarHeaderField.mode, this.fileMode);
                if (!this.paxSized) {
                    this.writeField(TarHeaderField.size, this.dataSize);
                }
                this.writeField(TarHeaderField.mtime, this.modTime);
                this.writeField(TarHeaderField.checksum, TarEntrySupplicant.prePaddedOctalString(this.headerChecksum(), 6) + "\u0000 ");
                this.tarStream.writeBlock(this.rawHeader);
                long l2 = this.tarStream.getBytesWritten();
                while ((n = this.inputStream.read(this.tarStream.writeBuffer)) > 0) {
                    this.tarStream.write(n);
                }
                if (l2 + this.dataSize != this.tarStream.getBytesWritten()) {
                    throw new IOException(RB.data_changed.getString(Long.toString(this.dataSize), Long.toString(this.tarStream.getBytesWritten() - l2)));
                }
                this.tarStream.padCurrentBlock();
            }
            finally {
                this.close();
            }
        }

        protected static String getLameMode(File file) {
            int n = 0;
            if (file.canExecute()) {
                n = 1;
            }
            if (file.canWrite()) {
                n += 2;
            }
            if (file.canRead()) {
                n += 4;
            }
            return "0" + n + "00";
        }

        static {
            char c = System.getProperty("file.separator").charAt(0);
            if (c != '/') {
                swapOutDelim = Character.valueOf(c);
            }
            try {
                TarEntrySupplicant.writeField(TarHeaderField.uid, 0L, HEADER_TEMPLATE);
                TarEntrySupplicant.writeField(TarHeaderField.gid, 0L, HEADER_TEMPLATE);
            }
            catch (TarMalformatException tarMalformatException) {
                throw new RuntimeException(tarMalformatException);
            }
            int n = TarHeaderField.magic.getStart();
            for (int i = 0; i < ustarBytes.length; ++i) {
                TarEntrySupplicant.HEADER_TEMPLATE[n + i] = ustarBytes[i];
            }
            TarEntrySupplicant.HEADER_TEMPLATE[263] = 48;
            TarEntrySupplicant.HEADER_TEMPLATE[264] = 48;
        }
    }
}

