/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;

public abstract class ObjectIdRef
implements Ref {
    private final String name;
    private final Ref.Storage storage;
    private final ObjectId objectId;

    protected ObjectIdRef(@NonNull Ref.Storage st, @NonNull String name2, @Nullable ObjectId id) {
        this.name = name2;
        this.storage = st;
        this.objectId = id;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isSymbolic() {
        return false;
    }

    @Override
    @NonNull
    public Ref getLeaf() {
        return this;
    }

    @Override
    @NonNull
    public Ref getTarget() {
        return this;
    }

    @Override
    @Nullable
    public ObjectId getObjectId() {
        return this.objectId;
    }

    @Override
    @NonNull
    public Ref.Storage getStorage() {
        return this.storage;
    }

    @NonNull
    public String toString() {
        StringBuilder r = new StringBuilder();
        r.append("Ref[");
        r.append(this.getName());
        r.append('=');
        r.append(ObjectId.toString(this.getObjectId()));
        r.append(']');
        return r.toString();
    }

    public static class PeeledNonTag
    extends ObjectIdRef {
        public PeeledNonTag(@NonNull Ref.Storage st, @NonNull String name2, @Nullable ObjectId id) {
            super(st, name2, id);
        }

        @Override
        @Nullable
        public ObjectId getPeeledObjectId() {
            return null;
        }

        @Override
        public boolean isPeeled() {
            return true;
        }
    }

    public static class PeeledTag
    extends ObjectIdRef {
        private final ObjectId peeledObjectId;

        public PeeledTag(@NonNull Ref.Storage st, @NonNull String name2, @Nullable ObjectId id, @NonNull ObjectId p) {
            super(st, name2, id);
            this.peeledObjectId = p;
        }

        @Override
        @NonNull
        public ObjectId getPeeledObjectId() {
            return this.peeledObjectId;
        }

        @Override
        public boolean isPeeled() {
            return true;
        }
    }

    public static class Unpeeled
    extends ObjectIdRef {
        public Unpeeled(@NonNull Ref.Storage st, @NonNull String name2, @Nullable ObjectId id) {
            super(st, name2, id);
        }

        @Override
        @Nullable
        public ObjectId getPeeledObjectId() {
            return null;
        }

        @Override
        public boolean isPeeled() {
            return false;
        }
    }
}

