/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.blame.BlameGenerator;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.io.AutoLFInputStream;

public class BlameCommand
extends GitCommand<BlameResult> {
    private String path;
    private DiffAlgorithm diffAlgorithm;
    private RawTextComparator textComparator;
    private ObjectId startCommit;
    private Collection<ObjectId> reverseEndCommits;
    private Boolean followFileRenames;

    public BlameCommand(Repository repo) {
        super(repo);
    }

    public BlameCommand setFilePath(String filePath) {
        this.path = filePath;
        return this;
    }

    public BlameCommand setDiffAlgorithm(DiffAlgorithm diffAlgorithm) {
        this.diffAlgorithm = diffAlgorithm;
        return this;
    }

    public BlameCommand setTextComparator(RawTextComparator textComparator) {
        this.textComparator = textComparator;
        return this;
    }

    public BlameCommand setStartCommit(AnyObjectId commit) {
        this.startCommit = commit.toObjectId();
        return this;
    }

    public BlameCommand setFollowFileRenames(boolean follow) {
        this.followFileRenames = follow;
        return this;
    }

    public BlameCommand reverse(AnyObjectId start, AnyObjectId end) throws IOException {
        return this.reverse(start, Collections.singleton(end.toObjectId()));
    }

    public BlameCommand reverse(AnyObjectId start, Collection<ObjectId> end) throws IOException {
        this.startCommit = start.toObjectId();
        this.reverseEndCommits = new ArrayList<ObjectId>(end);
        return this;
    }

    @Override
    public BlameResult call() throws GitAPIException {
        BlameResult blameResult;
        this.checkCallable();
        BlameGenerator gen2 = new BlameGenerator(this.repo, this.path);
        Throwable throwable = null;
        try {
            if (this.diffAlgorithm != null) {
                gen2.setDiffAlgorithm(this.diffAlgorithm);
            }
            if (this.textComparator != null) {
                gen2.setTextComparator(this.textComparator);
            }
            if (this.followFileRenames != null) {
                gen2.setFollowFileRenames(this.followFileRenames);
            }
            if (this.reverseEndCommits != null) {
                gen2.reverse((AnyObjectId)this.startCommit, this.reverseEndCommits);
            } else if (this.startCommit != null) {
                gen2.push(null, this.startCommit);
            } else {
                gen2.push(null, this.repo.resolve("HEAD"));
                if (!this.repo.isBare()) {
                    DirCache dc = this.repo.readDirCache();
                    int entry = dc.findEntry(this.path);
                    if (0 <= entry) {
                        gen2.push(null, dc.getEntry(entry).getObjectId());
                    }
                    File inTree = new File(this.repo.getWorkTree(), this.path);
                    if (this.repo.getFS().isFile(inTree)) {
                        RawText rawText = this.getRawText(inTree);
                        gen2.push(null, rawText);
                    }
                }
            }
            blameResult = gen2.computeBlameResult();
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    BlameCommand.$closeResource(throwable, gen2);
                    throw throwable3;
                }
            }
            catch (IOException e2) {
                throw new JGitInternalException(e2.getMessage(), e2);
            }
        }
        BlameCommand.$closeResource(throwable, gen2);
        return blameResult;
    }

    private RawText getRawText(File inTree) throws IOException, FileNotFoundException {
        RawText rawText;
        WorkingTreeOptions workingTreeOptions = this.getRepository().getConfig().get(WorkingTreeOptions.KEY);
        CoreConfig.AutoCRLF autoCRLF = workingTreeOptions.getAutoCRLF();
        switch (autoCRLF) {
            case FALSE: 
            case INPUT: {
                rawText = new RawText(inTree);
                break;
            }
            case TRUE: {
                try (AutoLFInputStream in = new AutoLFInputStream(new FileInputStream(inTree), true);){
                    rawText = new RawText(BlameCommand.toByteArray(in, (int)inTree.length()));
                    break;
                }
            }
            default: {
                throw new IllegalArgumentException("Unknown autocrlf option " + (Object)((Object)autoCRLF));
            }
        }
        return rawText;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] toByteArray(InputStream source2, int upperSizeLimit) throws IOException {
        byte[] buffer = new byte[upperSizeLimit];
        try {
            int read2 = IO.readFully(source2, buffer, 0);
            if (read2 == upperSizeLimit) {
                byte[] byArray = buffer;
                return byArray;
            }
            byte[] copy2 = new byte[read2];
            System.arraycopy(buffer, 0, copy2, 0, read2);
            byte[] byArray = copy2;
            return byArray;
        }
        finally {
            source2.close();
        }
    }
}

