'\"
'\" Generated from file 'autoproxy\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "autoproxy" n 1\&.7 tcllib "HTTP protocol helper modules"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
autoproxy \- Automatic HTTP proxy usage and authentication
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBhttp  ?2\&.0?\fR
.sp
package require \fBautoproxy  ?1\&.7?\fR
.sp
\fB::autoproxy::init\fR
.sp
\fB::autoproxy::cget\fR \fI-option\fR
.sp
\fB::autoproxy::configure\fR ?-option \fIvalue\fR?
.sp
\fB::autoproxy::tls_connect\fR \fIargs\fR
.sp
\fB::autoproxy::tunnel_connect\fR \fIargs\fR
.sp
\fB::autoproxy::tls_socket\fR \fIargs\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package attempts to automate the use of HTTP proxy servers in Tcl
HTTP client code\&. It tries to initialize the web access settings from
system standard locations and can be configured to negotiate
authentication with the proxy if required\&.
.PP
On Unix the standard for identifying the local HTTP proxy server
seems to be to use the environment variable http_proxy or ftp_proxy and
no_proxy to list those domains to be excluded from proxying\&.
On Windows we can retrieve the Internet Settings values from the registry
to obtain pretty much the same information\&.
With this information we can setup a suitable filter procedure for the
Tcl http package and arrange for automatic use of the proxy\&.
.PP
There seem to be a number of ways that the http_proxy environment
variable may be set up\&. Either a plain host:port or more commonly a
URL and sometimes the URL may contain authentication parameters or
these may be requested from the user or provided via http_proxy_user
and http_proxy_pass\&. This package attempts to deal with all these
schemes\&. It will do it's best to get the required parameters from the
environment or registry and if it fails can be reconfigured\&.
.SH "TLS SECURITY CONSIDERATIONS"
.PP
\fINote\fR This section only applies if TLS support is provided
by the \fBTLS\fR package\&.
It does not apply when \fBautoproxy\fR was configured to use some
other package which can provide the same (i\&.e \fBtwapi\fR), via
the \fB-tls_package\fR configuration option\&.
.PP
This package uses the \fBTLS\fR package to handle the
security for \fBhttps\fR urls and other socket connections\&.
.PP
Policy decisions like the set of protocols to support and what
ciphers to use are not the responsibility of \fBTLS\fR, nor of
this package itself however\&.
Such decisions are the responsibility of whichever application is
using the package, and are likely influenced by the set of servers
the application will talk to as well\&.
.PP
For example, in light of the recent
\fIPOODLE attack\fR [http://googleonlinesecurity\&.blogspot\&.co\&.uk/2014/10/this-poodle-bites-exploiting-ssl-30\&.html] discovered by Google many servers will disable support
for the SSLv3 protocol\&.
To handle this change the applications using \fBTLS\fR must be
patched, and not this package, nor \fBTLS\fR itself\&.
Such a patch may be as simple as generally activating \fBtls1\fR
support, as shown in the example below\&.
.CS


    package require tls
    tls::init -tls1 1 ;# forcibly activate support for the TLS1 protocol

    \&.\&.\&. your own application code \&.\&.\&.

.CE
.SH COMMANDS
.TP
\fB::autoproxy::init\fR
Initialize the autoproxy package from system resources\&. Under unix
this means we look for environment variables\&. Under windows we look
for the same environment variables but also look at the registry
settings used by Internet Explorer\&.
.TP
\fB::autoproxy::cget\fR \fI-option\fR
Retrieve individual package configuration options\&. See \fBOPTIONS\fR\&.
.TP
\fB::autoproxy::configure\fR ?-option \fIvalue\fR?
Configure the autoproxy package\&. Calling \fBconfigure\fR with no
options will return a list of all option names and values\&.
See \fBOPTIONS\fR\&.
.TP
\fB::autoproxy::tls_connect\fR \fIargs\fR
Connect to a secure socket through a proxy\&. HTTP proxy servers permit
the use of the CONNECT HTTP command to open a link through the proxy
to the target machine\&. This function hides the details\&. For use with
the http package see \fBtls_socket\fR\&.
.sp
The \fIargs\fR list may contain any of the options
supported by the specific TLS package that is in use but
must end with the host and port as the last two items\&.
.TP
\fB::autoproxy::tunnel_connect\fR \fIargs\fR
Connect to a target host throught a proxy\&. This uses the same CONNECT
HTTP command as the \fBtls_connect\fR but does not promote the link
security once the connection is established\&.
.sp
The \fIargs\fR list may contain any of the options
supported by the specific TLS package that is in use but
must end with the host and port as the last two items\&.
.sp
Note that many proxy servers will permit CONNECT calls to a limited
set of ports - typically only port 443 (the secure HTTP port)\&.
.TP
\fB::autoproxy::tls_socket\fR \fIargs\fR
This function is to be used to register a proxy-aware secure socket
handler for the https protocol\&. It may only be used with the Tcl http
package and should be registered using the http::register command (see
the examples below)\&. The job of actually creating the tunnelled
connection is done by the tls_connect command and this may be used
when not registering with the http package\&.
.PP
.SH OPTIONS
.TP
\fB-host\fR hostname
.TP
\fB-proxy_host\fR hostname
Set the proxy hostname\&. This is normally set up by \fBinit\fR but may
be configured here as well\&.
.TP
\fB-port\fR number
.TP
\fB-proxy_port\fR number
Set the proxy port number\&. This is normally set up by \fBinit\fR\&.
e\&.g\&. \fBconfigure\fR \fB-port\fR \fI3128\fR
.TP
\fB-no_proxy\fR list
You may manipulate the \fBno_proxy\fR list that was setup by
\fBinit\fR\&. The value of this option is a tcl list of
strings that are matched against the http request host using the tcl
\fBstring match\fR command\&. Therefore glob patterns are permitted\&.
For instance, \fBconfigure\fR \fB-no_proxy\fR \fI*\&.localdomain\fR
.TP
\fB-authProc\fR procedure
This option may be used to set an application defined procedure to be
called when \fBconfigure\fR \fB-basic\fR is called with either no or
insufficient authentication details\&. This can be used to present a
dialog to the user to request the additional information\&.
.TP
\fB-basic\fR
Following options are for configuring the Basic authentication
scheme parameters\&. See \fBBasic Authentication\fR\&.
To unset the proxy authentication information retained from a previous
call of this function either "--" or no additional parameters can be
supplied\&. This will remove the existing authentication information\&.
.TP
\fB-tls_package\fR packagename
This option may be used to configure the Tcl package to use for
TLS support\&. Valid package names are \fBtls\fR (default)
and \fBtwapi\fR\&.
.PP
.SH "BASIC AUTHENTICATION"
Basic is the simplest and most commonly use HTTP proxy authentication
scheme\&. It is described in (1 section 11) and also in (2)\&. It offers
no privacy whatsoever and its use should be discouraged in favour of
more secure alternatives like Digest\&. To perform Basic authentication
the client base64 encodes the username and plaintext password
separated by a colon\&. This encoded text is prefixed with the word
"Basic" and a space\&.
.PP
The following options exists for this scheme:
.TP
\fB-username\fR name
The username required to authenticate with the configured proxy\&.
.TP
\fB-password\fR password
The password required for the username specified\&.
.TP
\fB-realm\fR realm
This option is not used by this package but may be used in requesting
authentication details from the user\&.
.TP
\fB--\fR
The end-of-options indicator may be used alone to unset any
authentication details currently enabled\&.
.PP
.SH EXAMPLES
.PP
.CS


package require autoproxy
autoproxy::init
autoproxy::configure -basic -username ME -password SEKRET
set tok [http::geturl http://wiki\&.tcl\&.tk/]
http::data $tok

.CE
.CS


package require http
package require tls
package require autoproxy
autoproxy::init
http::register https 443 autoproxy::tls_socket
set tok [http::geturl https://www\&.example\&.com/]

.CE
.SH REFERENCES
.IP [1]
Berners-Lee, T\&., Fielding R\&. and Frystyk, H\&.
"Hypertext Transfer Protocol -- HTTP/1\&.0",
RFC 1945, May 1996,
(\fIhttp://www\&.rfc-editor\&.org/rfc/rfc1945\&.txt\fR)
.IP [2]
Franks, J\&. et al\&.
"HTTP Authentication: Basic and Digest Access Authentication",
RFC 2617, June 1999
(\fIhttp://www\&.rfc-editor\&.org/rfc/rfc2617\&.txt\fR)
.PP
.SH BUGS
At this time only Basic authentication (1) (2) is supported\&. It is
planned to add support for Digest (2) and NTLM in the future\&.
.SH AUTHORS
Pat Thoyts
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIhttp :: autoproxy\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH "SEE ALSO"
http(n)
.SH KEYWORDS
authentication, http, proxy
.SH CATEGORY
Networking