#!/usr/bin/perl
#********************************************************************
#
#  loan.pl :  Script computes an amortization of a potential loan.
#
#  G. K. Fenton  1/1997
#
#********************************************************************
#
# Definitions of main variables...
#   $price    = Total Cost of Item.
#   $down_pmt = Down Payment which takes away from Price.
#   $N        = Term of Loan in units of (Months).
#   $I        = Interest Rate divided by 12 for units of Months then
#               divided by 100 to put into a percentage format.
#   $dataout  = Plot file name used by GnuPlot, Default name
#               is 'data'.
#
#********************************************************************
#
# $Id: loan.pl,v 2.2 1997/01/10 19:05:10 curt Exp $
# (Log is kept at end of this file)


  $dataout = "data";


#  Process the Command Line Arguments
# print @ARGV,"\n";
# print $#ARGV+1,"\n";

  if ($#ARGV+1 < 8) {
     print "\n\n loan.pl :  This Script computes an amortization of a potential loan.\n\n";
     print " Usage: loan.pl [-p <price>] [-d <down_pmt>] [-t <term>] [-i <int_rate>] [-o <name>]\n\n";
     print "\n Example: loan -p 100000 -d 10000 -t 360 -i 7.0 \n\n";
     print " Where,  -p --> Price to be financed.\n";
     print "         -d --> Down Payment.\n";
     print "         -t --> Loan Term in Months.\n";
     print "         -i --> Annual Percentage Rate.\n";
     print "         -o --> Output data file name.\n\n";
     exit(1);
  } 

  $i = 0;
  foreach (@ARGV) {
     if ($ARGV[$i] eq "-p") {  # Get the Price or Cost of Loan.
        $price = $ARGV[$i+1];
     }
     if ($ARGV[$i] eq "-d") {  # Get the Down Payment for Loan.
        $down_pmt = $ARGV[$i+1];
     }
     if ($ARGV[$i] eq "-t") {  # Get the Term of the Loan in Months.
        $N = $ARGV[$i+1];
     } 
     if ($ARGV[$i] eq "-i") {  # Get the Interest Rate of the Loan.
        $I = $ARGV[$i+1];
        $I = $I/12.0/100.0;    # Put into Monthly percentage Units.
     }
     if ($ARGV[$i] eq "-o") {  # Get the output data file name.
        $dataout = $ARGV[$i+1];
     } 
     $i++;
  }

  $loan_amt = $price - $down_pmt;
  $tmp_var  = (1.0 + $I)**$N;
  $payment  = $loan_amt * $I * $tmp_var/($tmp_var - 1.0);

  open(FOUT, ">$dataout") || die "\n\n Warning: Can't open output file '$dataout' !\n\n";

  $balance[0]  = $loan_amt;
  for( $i=1 ; $i<=$N ; $i++ ) {
      $balance[$i]   = $balance[$i-1] * (1 + $I) - $payment;
      $interest[$i]  = $balance[$i-1] * $I;
      $principal[$i] = $payment - $interest[$i];
      $equity[$i]    = $price   - $balance[$i];

    print FOUT " $i, $balance[$i], $equity[$i], $interest[$i], $principal[$i]\n";
  }
  close(FOUT);

  $sum_payment   = 0.0;
  $sum_principal = 0.0;
  $sum_interest  = 0.0;
  for( $i=1 ; $i<=$N ; $i++ ) {
      $sum_payment   += $payment;
      $sum_principal += $principal[$i];
      $sum_interest  += $interest[$i];
  }


  printf("\n     Cost Amount     = \$%7.2f\n", $price);
  printf("     Down Payment    = \$%7.2f\n", $down_pmt);
  printf("     Loan Amount     = \$%7.2f\n", $loan_amt);
  printf(" >>> Monthly Payment = \$%7.2f <<<\n\n", $payment);
  printf("------- Data over Life of Loan -------\n");
  printf("     Principal Only  = \$%7.2f\n", $sum_principal);
  printf("     Interest Only   = \$%7.2f\n", $sum_interest);
  printf("     Total Payment   = \$%7.2f\n", $sum_payment);

  printf("\n  Created Plot File < $dataout >!\n");
  printf("    Use GnuPlot to see the curves...\n\n");


  exit(0);


# ----------------------------------------------------------------------------
# $Log: loan.pl,v $
# Revision 2.2  1997/01/10 19:05:10  curt
# Initial revision.
#
