/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.plan.exec.internal;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import org.hibernate.LockOptions;
import org.hibernate.Session;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.loader.plan.exec.internal.AbstractLoadQueryDetails;
import org.hibernate.loader.plan.exec.internal.AliasResolutionContextImpl;
import org.hibernate.loader.plan.exec.process.internal.AbstractRowReader;
import org.hibernate.loader.plan.exec.process.internal.EntityReferenceInitializerImpl;
import org.hibernate.loader.plan.exec.process.internal.EntityReturnReader;
import org.hibernate.loader.plan.exec.process.internal.ResultSetProcessingContextImpl;
import org.hibernate.loader.plan.exec.process.internal.ResultSetProcessorHelper;
import org.hibernate.loader.plan.exec.process.spi.EntityReferenceInitializer;
import org.hibernate.loader.plan.exec.process.spi.ReaderCollector;
import org.hibernate.loader.plan.exec.process.spi.ResultSetProcessingContext;
import org.hibernate.loader.plan.exec.process.spi.RowReader;
import org.hibernate.loader.plan.exec.query.internal.SelectStatementBuilder;
import org.hibernate.loader.plan.exec.query.spi.QueryBuildingParameters;
import org.hibernate.loader.plan.exec.spi.EntityReferenceAliases;
import org.hibernate.loader.plan.spi.EntityReturn;
import org.hibernate.loader.plan.spi.LoadPlan;
import org.hibernate.loader.plan.spi.QuerySpace;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.OuterJoinLoadable;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.ComponentType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class EntityLoadQueryDetails
extends AbstractLoadQueryDetails {
    private static final Logger log = CoreLogging.logger(EntityLoadQueryDetails.class);
    private final EntityReferenceAliases entityReferenceAliases;
    private final ReaderCollector readerCollector;

    protected EntityLoadQueryDetails(LoadPlan loadPlan, String[] keyColumnNames, AliasResolutionContextImpl aliasResolutionContext, EntityReturn rootReturn, QueryBuildingParameters buildingParameters, SessionFactoryImplementor factory) {
        super(loadPlan, aliasResolutionContext, buildingParameters, keyColumnNames, rootReturn, factory);
        this.entityReferenceAliases = aliasResolutionContext.generateEntityReferenceAliases(rootReturn.getQuerySpaceUid(), rootReturn.getEntityPersister());
        this.readerCollector = new EntityLoaderReaderCollectorImpl(new EntityReturnReader(rootReturn), new EntityReferenceInitializerImpl(rootReturn, this.entityReferenceAliases, true));
        this.generate();
    }

    private EntityReturn getRootEntityReturn() {
        return (EntityReturn)this.getRootReturn();
    }

    @Override
    protected void applyRootReturnTableFragments(SelectStatementBuilder select) {
        String fromTableFragment;
        String rootAlias = this.entityReferenceAliases.getTableAlias();
        OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)this.getRootEntityReturn().getEntityPersister();
        if (this.getQueryBuildingParameters().getLockOptions() != null) {
            fromTableFragment = this.getSessionFactory().getDialect().appendLockHint(this.getQueryBuildingParameters().getLockOptions(), outerJoinLoadable.fromTableFragment(rootAlias));
            select.setLockOptions(this.getQueryBuildingParameters().getLockOptions());
        } else if (this.getQueryBuildingParameters().getLockMode() != null) {
            fromTableFragment = this.getSessionFactory().getDialect().appendLockHint(this.getQueryBuildingParameters().getLockMode(), outerJoinLoadable.fromTableFragment(rootAlias));
            select.setLockMode(this.getQueryBuildingParameters().getLockMode());
        } else {
            fromTableFragment = outerJoinLoadable.fromTableFragment(rootAlias);
        }
        select.appendFromClauseFragment(fromTableFragment + outerJoinLoadable.fromJoinFragment(rootAlias, true, true));
    }

    @Override
    protected void applyRootReturnFilterRestrictions(SelectStatementBuilder selectStatementBuilder) {
        Queryable rootQueryable = (Queryable)this.getRootEntityReturn().getEntityPersister();
        selectStatementBuilder.appendRestrictions(rootQueryable.filterFragment(this.entityReferenceAliases.getTableAlias(), Collections.emptyMap()));
    }

    @Override
    protected void applyRootReturnWhereJoinRestrictions(SelectStatementBuilder selectStatementBuilder) {
        OuterJoinLoadable joinable = (OuterJoinLoadable)this.getRootEntityReturn().getEntityPersister();
        selectStatementBuilder.appendRestrictions(joinable.whereJoinFragment(this.entityReferenceAliases.getTableAlias(), true, true));
    }

    @Override
    protected void applyRootReturnOrderByFragments(SelectStatementBuilder selectStatementBuilder) {
    }

    @Override
    protected ReaderCollector getReaderCollector() {
        return this.readerCollector;
    }

    @Override
    protected QuerySpace getRootQuerySpace() {
        return this.getQuerySpace(this.getRootEntityReturn().getQuerySpaceUid());
    }

    @Override
    protected String getRootTableAlias() {
        return this.entityReferenceAliases.getTableAlias();
    }

    @Override
    protected boolean shouldApplyRootReturnFilterBeforeKeyRestriction() {
        return false;
    }

    @Override
    protected void applyRootReturnSelectFragments(SelectStatementBuilder selectStatementBuilder) {
        OuterJoinLoadable outerJoinLoadable = (OuterJoinLoadable)this.getRootEntityReturn().getEntityPersister();
        selectStatementBuilder.appendSelectClauseFragment(outerJoinLoadable.selectFragment(this.entityReferenceAliases.getTableAlias(), this.entityReferenceAliases.getColumnAliases().getSuffix()));
    }

    private static class EntityLoaderRowReader
    extends AbstractRowReader {
        private final EntityReturnReader rootReturnReader;

        public EntityLoaderRowReader(EntityLoaderReaderCollectorImpl entityLoaderReaderCollector) {
            super(entityLoaderReaderCollector);
            this.rootReturnReader = entityLoaderReaderCollector.getReturnReader();
        }

        @Override
        public Object readRow(ResultSet resultSet, ResultSetProcessingContextImpl context) throws SQLException {
            ResultSetProcessingContext.EntityReferenceProcessingState processingState = this.rootReturnReader.getIdentifierResolutionContext(context);
            if (context.shouldUseOptionalEntityInformation() && context.getQueryParameters().getOptionalId() != null) {
                CompositeType identifierType;
                EntityKey entityKey = ResultSetProcessorHelper.getOptionalObjectKey(context.getQueryParameters(), context.getSession());
                processingState.registerIdentifierHydratedForm(entityKey.getIdentifier());
                processingState.registerEntityKey(entityKey);
                EntityPersister entityPersister = processingState.getEntityReference().getEntityPersister();
                if (entityPersister.getIdentifierType().isComponentType() && !(identifierType = (CompositeType)entityPersister.getIdentifierType()).isEmbedded()) {
                    this.addKeyManyToOnesToSession(context, identifierType, entityKey.getIdentifier());
                }
            }
            return super.readRow(resultSet, context);
        }

        private void addKeyManyToOnesToSession(ResultSetProcessingContextImpl context, CompositeType componentType, Object component) {
            for (int i = 0; i < componentType.getSubtypes().length; ++i) {
                Type subType = componentType.getSubtypes()[i];
                Object subValue = componentType.getPropertyValue(component, i, context.getSession());
                if (subType.isEntityType()) {
                    ((Session)((Object)context.getSession())).buildLockRequest(LockOptions.NONE).lock(subValue);
                    continue;
                }
                if (!subType.isComponentType()) continue;
                this.addKeyManyToOnesToSession(context, (ComponentType)subType, subValue);
            }
        }

        @Override
        protected Object readLogicalRow(ResultSet resultSet, ResultSetProcessingContextImpl context) throws SQLException {
            return this.rootReturnReader.read(resultSet, context);
        }
    }

    private static class EntityLoaderReaderCollectorImpl
    extends AbstractLoadQueryDetails.ReaderCollectorImpl {
        private final EntityReturnReader entityReturnReader;

        public EntityLoaderReaderCollectorImpl(EntityReturnReader entityReturnReader, EntityReferenceInitializer entityReferenceInitializer) {
            this.entityReturnReader = entityReturnReader;
            this.add(entityReferenceInitializer);
        }

        @Override
        public RowReader buildRowReader() {
            return new EntityLoaderRowReader(this);
        }

        @Override
        public EntityReturnReader getReturnReader() {
            return this.entityReturnReader;
        }
    }
}

