/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.collection.internal;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

@Deprecated
public class PersistentElementHolder
extends AbstractPersistentCollection {
    protected Element element;

    public PersistentElementHolder(SessionImplementor session, Element element) {
        super(session);
        this.element = element;
        this.setInitialized();
    }

    public PersistentElementHolder(SessionImplementor session, CollectionPersister persister, Serializable key) {
        super(session);
        Element owner = (Element)session.getPersistenceContext().getCollectionOwner(key, persister);
        if (owner == null) {
            throw new AssertionFailure("null owner");
        }
        String nodeName = persister.getNodeName();
        if (".".equals(nodeName)) {
            this.element = owner;
        } else {
            this.element = owner.element(nodeName);
            if (this.element == null) {
                this.element = owner.addElement(nodeName);
            }
        }
    }

    @Override
    public Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        List subElements = this.element.elements(persister.getElementNodeName());
        ArrayList<Object> snapshot = new ArrayList<Object>(subElements.size());
        for (Object subElement : subElements) {
            Element element = (Element)subElement;
            Object value = elementType.fromXMLNode(element, persister.getFactory());
            Object copy = elementType.deepCopy(value, persister.getFactory());
            snapshot.add(copy);
        }
        return snapshot;
    }

    @Override
    public Collection getOrphans(Serializable snapshot, String entityName) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isWrapper(Object collection) {
        return this.element == collection;
    }

    @Override
    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        Type elementType = persister.getElementType();
        ArrayList snapshot = (ArrayList)this.getSnapshot();
        List elements = this.element.elements(persister.getElementNodeName());
        if (snapshot.size() != elements.size()) {
            return false;
        }
        for (int i = 0; i < snapshot.size(); ++i) {
            Element elem;
            Object current;
            Object old = snapshot.get(i);
            if (!elementType.isDirty(old, current = elementType.fromXMLNode(elem = (Element)elements.get(i), persister.getFactory()), this.getSession())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSnapshotEmpty(Serializable snapshot) {
        return ((Collection)((Object)snapshot)).isEmpty();
    }

    @Override
    public boolean empty() {
        return !this.element.elementIterator().hasNext();
    }

    @Override
    public Object readFrom(ResultSet rs, CollectionPersister persister, CollectionAliases descriptor, Object owner) throws HibernateException, SQLException {
        Object object = persister.readElement(rs, owner, descriptor.getSuffixedElementAliases(), this.getSession());
        Type elementType = persister.getElementType();
        Element subElement = this.element.addElement(persister.getElementNodeName());
        elementType.setToXMLNode(subElement, object, persister.getFactory());
        return object;
    }

    @Override
    public Iterator entries(CollectionPersister persister) {
        Type elementType = persister.getElementType();
        List subElements = this.element.elements(persister.getElementNodeName());
        int length = subElements.size();
        ArrayList<Object> result = new ArrayList<Object>(length);
        for (Object subElementO : subElements) {
            Element subElement = (Element)subElementO;
            Object object = elementType.fromXMLNode(subElement, persister.getFactory());
            result.add(object);
        }
        return result.iterator();
    }

    @Override
    public void beforeInitialize(CollectionPersister persister, int anticipatedSize) {
    }

    @Override
    public boolean isDirectlyAccessible() {
        return true;
    }

    @Override
    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        Serializable[] cachedSnapshot;
        Type collectionElementType = persister.getElementType();
        for (Serializable cachedItem : cachedSnapshot = (Serializable[])disassembled) {
            Object object = collectionElementType.assemble(cachedItem, this.getSession(), owner);
            Element subElement = this.element.addElement(persister.getElementNodeName());
            collectionElementType.setToXMLNode(subElement, object, persister.getFactory());
        }
    }

    @Override
    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        Type collectionElementType = persister.getElementType();
        List elements = this.element.elements(persister.getElementNodeName());
        int length = elements.size();
        Serializable[] result = new Serializable[length];
        for (int i = 0; i < length; ++i) {
            Element elem = (Element)elements.get(i);
            Object object = collectionElementType.fromXMLNode(elem, persister.getFactory());
            result[i] = collectionElementType.disassemble(object, this.getSession(), null);
        }
        return result;
    }

    @Override
    public Object getValue() {
        return this.element;
    }

    @Override
    public Iterator getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        Type elementType = persister.getElementType();
        ArrayList snapshot = (ArrayList)this.getSnapshot();
        List elements = this.element.elements(persister.getElementNodeName());
        ArrayList result = new ArrayList();
        for (int i = 0; i < snapshot.size(); ++i) {
            Object old = snapshot.get(i);
            if (i >= elements.size()) {
                result.add(old);
                continue;
            }
            Element elem = (Element)elements.get(i);
            Object object = elementType.fromXMLNode(elem, persister.getFactory());
            if (!elementType.isDirty(old, object, this.getSession())) continue;
            result.add(old);
        }
        return result.iterator();
    }

    @Override
    public boolean needsInserting(Object entry, int i, Type elementType) throws HibernateException {
        ArrayList snapshot = (ArrayList)this.getSnapshot();
        return i >= snapshot.size() || elementType.isDirty(snapshot.get(i), entry, this.getSession());
    }

    @Override
    public boolean needsUpdating(Object entry, int i, Type elementType) throws HibernateException {
        return false;
    }

    @Override
    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getElement(Object entry) {
        return entry;
    }

    @Override
    public Object getSnapshotElement(Object entry, int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean entryExists(Object entry, int i) {
        return entry != null;
    }
}

