/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.script.helper;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.Module;
import onl.netfishers.netshot.device.Network4Address;
import onl.netfishers.netshot.device.Network6Address;
import onl.netfishers.netshot.device.NetworkAddress;
import onl.netfishers.netshot.device.NetworkInterface;
import onl.netfishers.netshot.device.PhysicalAddress;
import onl.netfishers.netshot.device.attribute.AttributeDefinition;
import onl.netfishers.netshot.device.attribute.ConfigAttribute;
import onl.netfishers.netshot.device.attribute.DeviceAttribute;
import onl.netfishers.netshot.device.attribute.DeviceBinaryAttribute;
import onl.netfishers.netshot.device.attribute.DeviceLongTextAttribute;
import onl.netfishers.netshot.device.attribute.DeviceNumericAttribute;
import onl.netfishers.netshot.device.attribute.DeviceTextAttribute;
import onl.netfishers.netshot.diagnostic.DiagnosticResult;
import onl.netfishers.netshot.work.TaskLogger;
import org.hibernate.HibernateException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsDeviceHelper {
    private static Logger logger = LoggerFactory.getLogger(JsDeviceHelper.class);
    private Device device;
    private Session session;
    private TaskLogger taskLogger;
    private boolean readOnly;

    public static Bindings toBindings(Object o, String key) throws IllegalArgumentException {
        Object v = JsDeviceHelper.toObject(o, key);
        if (!(v instanceof Bindings)) {
            throw new IllegalArgumentException(String.format("The value of %s is not a Javascript object.", key));
        }
        return (Bindings)v;
    }

    public static Boolean toBoolean(Object o, String key) throws IllegalArgumentException {
        return JsDeviceHelper.toBoolean(o, key, null);
    }

    public static Boolean toBoolean(Object o, String key, Boolean defaultValue) throws IllegalArgumentException {
        Object v = JsDeviceHelper.toObject(o, key, defaultValue);
        if (!(v instanceof Boolean)) {
            throw new IllegalArgumentException(String.format("The value of %s is not a boolean.", key));
        }
        return (Boolean)v;
    }

    public static Integer toInteger(Object o, String key) throws IllegalArgumentException {
        return JsDeviceHelper.toInteger(o, key, null);
    }

    public static Integer toInteger(Object o, String key, Integer defaultValue) throws IllegalArgumentException {
        Object v = JsDeviceHelper.toObject(o, key, defaultValue);
        if (!(v instanceof Integer)) {
            throw new IllegalArgumentException(String.format("The value of %s is not an integer.", key));
        }
        return (Integer)v;
    }

    public static Object toObject(Object o, String key) throws IllegalArgumentException {
        return JsDeviceHelper.toObject(o, key, null);
    }

    public static Object toObject(Object o, String key, Object defaultValue) throws IllegalArgumentException {
        if (o == null || !(o instanceof Bindings) && !(o instanceof ScriptEngine)) {
            throw new IllegalArgumentException("Invalid object.");
        }
        Object v = null;
        if (o instanceof Bindings) {
            v = ((Bindings)o).get(key);
        }
        if (o instanceof ScriptEngine) {
            v = ((ScriptEngine)o).get(key);
        }
        if (v == null) {
            if (defaultValue == null) {
                throw new IllegalArgumentException(String.format("The key '%s' doesn't exist.", key));
            }
            return defaultValue;
        }
        return v;
    }

    public static String toString(Object o, String key) throws IllegalArgumentException {
        return JsDeviceHelper.toString(o, key, null);
    }

    public static String toString(Object o, String key, String defaultValue) throws IllegalArgumentException {
        Object v = JsDeviceHelper.toObject(o, key, defaultValue);
        if (!(v instanceof String)) {
            throw new IllegalArgumentException(String.format("The value of %s is not a string.", key));
        }
        String s = (String)v;
        if (s.trim().equals("")) {
            throw new IllegalArgumentException(String.format("The value of %s cannot be empty.", key));
        }
        return s;
    }

    public JsDeviceHelper(Device device, Session session, TaskLogger taskLogger, boolean readOnly) throws Device.MissingDeviceDriverException {
        this.device = device;
        this.taskLogger = taskLogger;
        this.readOnly = readOnly;
        this.session = session;
    }

    public void add(String key, Bindings data) {
        if (this.readOnly) {
            logger.warn("Adding key '{}' is forbidden.", (Object)key);
            this.taskLogger.error(String.format("Adding key %s is forbidden", key));
            return;
        }
        if (data == null) {
            return;
        }
        try {
            if ("module".equals(key)) {
                Module module = new Module(data.getOrDefault("slot", ""), data.getOrDefault("partNumber", ""), data.getOrDefault("serialNumber", ""), this.device);
                this.device.getModules().add(module);
            } else if ("networkInterface".equals(key)) {
                Boolean enabled = data.getOrDefault("enabled", true);
                enabled = enabled == null ? Boolean.valueOf(false) : enabled;
                Boolean level3 = data.getOrDefault("level3", true);
                level3 = level3 == null ? Boolean.valueOf(false) : level3;
                NetworkInterface networkInterface = new NetworkInterface(this.device, (String)data.get("name"), data.getOrDefault("virtualDevice", ""), data.getOrDefault("vrf", ""), enabled, level3, data.getOrDefault("description", ""));
                networkInterface.setPhysicalAddress(new PhysicalAddress(data.getOrDefault("mac", "0000.0000.0000")));
                Bindings ipAddresses = (Bindings)data.get("ip");
                if (ipAddresses != null) {
                    for (Object ipAddress : ipAddresses.values()) {
                        Bindings ip = (Bindings)ipAddress;
                        NetworkAddress address = null;
                        address = ip.get("ipv6") != null ? new Network6Address((String)ip.get("ipv6"), ((Number)ip.get("mask")).intValue()) : (ip.get("mask") instanceof Number ? new Network4Address((String)ip.get("ip"), ((Number)ip.get("mask")).intValue()) : new Network4Address((String)ip.get("ip"), (String)ip.get("mask")));
                        Object usage = ip.get("usage");
                        if (usage != null) {
                            address.setAddressUsage(NetworkAddress.AddressUsage.valueOf((String)usage));
                        }
                        networkInterface.addIpAddress(address);
                    }
                }
                this.device.getNetworkInterfaces().add(networkInterface);
            }
        }
        catch (Exception e) {
            logger.warn("Error during snapshot while adding device attribute key '{}'.", (Object)key, (Object)e);
            this.taskLogger.error(String.format("Can't add device attribute %s: %s", key, e.getMessage()));
        }
    }

    public void add(String key, String value) {
        if (this.readOnly) {
            logger.warn("Adding key '{}' is forbidden.", (Object)key);
            this.taskLogger.error(String.format("Adding key %s is forbidden", key));
            return;
        }
        if (value == null) {
            return;
        }
        try {
            if ("vrf".equals(key)) {
                this.device.addVrfInstance(value);
            } else if ("virtualDevice".equals(key)) {
                this.device.addVirtualDevice(value);
            }
        }
        catch (Exception e) {
            logger.warn("Error during snapshot while adding device attribute key '{}'.", (Object)key, (Object)e);
            this.taskLogger.error(String.format("Can't add device attribute %s: %s", key, e.getMessage()));
        }
    }

    public void reset() {
        if (this.readOnly) {
            logger.warn("Resetting device is forbidden.");
            this.taskLogger.error(String.format("Resetting key is forbidden", new Object[0]));
            return;
        }
        this.device.setFamily("");
        this.device.setLocation("");
        this.device.setContact("");
        this.device.setSoftwareVersion("");
        this.device.setNetworkClass(Device.NetworkClass.UNKNOWN);
        this.device.clearAttributes();
        this.device.clearVrfInstance();
        this.device.clearVirtualDevices();
        this.device.getNetworkInterfaces().clear();
        this.device.getModules().clear();
        this.device.setEolModule(null);
        this.device.setEosModule(null);
        this.device.setEolDate(null);
        this.device.setEosDate(null);
    }

    public void set(String key, Boolean value) {
        if (this.readOnly) {
            logger.warn("Setting key '{}' is forbidden.", (Object)key);
            this.taskLogger.error(String.format("Setting key %s is forbidden", key));
            return;
        }
        if (value == null) {
            return;
        }
        try {
            DeviceDriver driver = this.device.getDeviceDriver();
            for (AttributeDefinition attribute : driver.getAttributes()) {
                if (!attribute.getLevel().equals((Object)AttributeDefinition.AttributeLevel.DEVICE) || !attribute.getName().equals(key)) continue;
                switch (attribute.getType()) {
                    case BINARY: {
                        this.device.addAttribute(new DeviceBinaryAttribute(this.device, key, value));
                        break;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.warn("Error during snapshot while setting device attribute key '{}'.", (Object)key);
            this.taskLogger.error(String.format("Can't add device attribute %s: %s", key, e.getMessage()));
        }
    }

    public void set(String key, Double value) {
        if (this.readOnly) {
            logger.warn("Setting key '{}' is forbidden.", (Object)key);
            this.taskLogger.error(String.format("Setting key %s is forbidden", key));
            return;
        }
        if (value == null) {
            return;
        }
        try {
            DeviceDriver driver = this.device.getDeviceDriver();
            for (AttributeDefinition attribute : driver.getAttributes()) {
                if (!attribute.getLevel().equals((Object)AttributeDefinition.AttributeLevel.DEVICE) || !attribute.getName().equals(key)) continue;
                switch (attribute.getType()) {
                    case NUMERIC: {
                        this.device.addAttribute(new DeviceNumericAttribute(this.device, key, value));
                        break;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            logger.warn("Error during snapshot while setting device attribute key '{}'.", (Object)key);
            this.taskLogger.error(String.format("Can't add device attribute %s: %s", key, e.getMessage()));
        }
    }

    public void set(String key, String value) {
        block18: {
            if (this.readOnly) {
                logger.warn("Setting key '{}' is forbidden.", (Object)key);
                this.taskLogger.error(String.format("Setting key %s is forbidden", key));
                return;
            }
            if (value == null) {
                return;
            }
            try {
                if ("name".equals(key)) {
                    this.device.setName(value);
                    break block18;
                }
                if ("family".equals(key)) {
                    this.device.setFamily(value);
                    break block18;
                }
                if ("location".equals(key)) {
                    this.device.setLocation(value);
                    break block18;
                }
                if ("contact".equals(key)) {
                    this.device.setContact(value);
                    break block18;
                }
                if ("softwareVersion".equals(key)) {
                    this.device.setSoftwareVersion(value);
                    break block18;
                }
                if ("serialNumber".equals(key)) {
                    this.device.setSerialNumber(value);
                    break block18;
                }
                if ("comments".equals(key)) {
                    this.device.setComments(value);
                    break block18;
                }
                if ("networkClass".equals(key)) {
                    Device.NetworkClass nc = Device.NetworkClass.valueOf(value);
                    if (nc != null) {
                        this.device.setNetworkClass(nc);
                    }
                    break block18;
                }
                DeviceDriver driver = this.device.getDeviceDriver();
                for (AttributeDefinition attribute : driver.getAttributes()) {
                    if (!attribute.getLevel().equals((Object)AttributeDefinition.AttributeLevel.DEVICE) || !attribute.getName().equals(key)) continue;
                    switch (attribute.getType()) {
                        case LONGTEXT: {
                            this.device.addAttribute(new DeviceLongTextAttribute(this.device, key, value));
                            break;
                        }
                        case TEXT: {
                            this.device.addAttribute(new DeviceTextAttribute(this.device, key, value));
                            break;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                logger.warn("Error during snapshot while setting device attribute key '{}'.", (Object)key);
                this.taskLogger.error(String.format("Can't add device attribute %s: %s", key, e.getMessage()));
            }
        }
    }

    private Object getDeviceItem(Device device, String item) {
        DeviceDriver driver;
        try {
            driver = device.getDeviceDriver();
        }
        catch (Device.MissingDeviceDriverException e) {
            return null;
        }
        if ("type".equals(item)) {
            return driver.getDescription();
        }
        if ("name".equals(item)) {
            return device.getName();
        }
        if ("family".equals(item)) {
            return device.getFamily();
        }
        if ("location".equals(item)) {
            return device.getLocation();
        }
        if ("contact".equals(item)) {
            return device.getContact();
        }
        if ("softwareVersion".equals(item)) {
            return device.getSoftwareVersion();
        }
        if ("serialNumber".equals(item)) {
            return device.getSerialNumber();
        }
        if ("networkClass".equals(item)) {
            return device.getNetworkClass() == null ? null : device.getNetworkClass().toString();
        }
        if ("virtualDevices".equals(item)) {
            return device.getVirtualDevices().toArray();
        }
        if ("vrfs".equals(item)) {
            return device.getVrfInstances().toArray();
        }
        if ("modules".equals(item)) {
            ArrayList modules = new ArrayList();
            for (Module m : device.getModules()) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("slot", m.getSlot());
                hashMap.put("partNumber", m.getPartNumber());
                hashMap.put("serialNumber", m.getSerialNumber());
                modules.add(hashMap);
            }
            return modules.toArray();
        }
        if ("interfaces".equals(item)) {
            ArrayList networkInterfaces = new ArrayList();
            for (NetworkInterface ni : device.getNetworkInterfaces()) {
                HashMap<String, String> ip;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put("name", ni.getInterfaceName());
                hashMap.put("description", ni.getDescription());
                hashMap.put("mac", ni.getMacAddress());
                hashMap.put("virtualDevice", ni.getVirtualDevice());
                hashMap.put("vrf", ni.getVrfInstance());
                hashMap.put("enabled", ni.isEnabled());
                hashMap.put("level3", ni.isLevel3());
                ArrayList ips = new ArrayList();
                for (Network4Address network4Address : ni.getIp4Addresses()) {
                    ip = new HashMap<String, String>();
                    ip.put("ip", network4Address.getIp());
                    ip.put("mask", Integer.toString(network4Address.getPrefixLength()));
                    ip.put("usage", network4Address.getAddressUsage().toString());
                    ips.add(ip);
                }
                for (Network6Address network6Address : ni.getIp6Addresses()) {
                    ip = new HashMap();
                    ip.put("ipv6", network6Address.getIp());
                    ip.put("mask", Integer.toString(network6Address.getPrefixLength()));
                    ip.put("usage", network6Address.getAddressUsage().toString());
                    ips.add(ip);
                }
                hashMap.put("ip", ips.toArray());
                networkInterfaces.add(hashMap);
            }
            return networkInterfaces.toArray();
        }
        for (AttributeDefinition definition : driver.getAttributes()) {
            if (!definition.getName().equals(item) && !definition.getTitle().equals(item) || !definition.isCheckable()) continue;
            if (definition.getLevel() == AttributeDefinition.AttributeLevel.CONFIG && device.getLastConfig() != null) {
                for (ConfigAttribute configAttribute : device.getLastConfig().getAttributes()) {
                    if (!configAttribute.getName().equals(item)) continue;
                    return configAttribute.getData();
                }
                continue;
            }
            if (definition.getLevel() != AttributeDefinition.AttributeLevel.DEVICE) continue;
            for (DeviceAttribute deviceAttribute : device.getAttributes()) {
                if (!deviceAttribute.getName().equals(item)) continue;
                return deviceAttribute.getData();
            }
        }
        for (DiagnosticResult diagnosticResult : device.getDiagnosticResults()) {
            String diagnosticName = diagnosticResult.getDiagnosticName();
            if (diagnosticName == null || !diagnosticName.equals(item)) continue;
            return diagnosticResult.getData();
        }
        return null;
    }

    public Object get(String item) {
        logger.debug("JavaScript request for item {} on current device.", (Object)item);
        return this.getDeviceItem(this.device, item);
    }

    private Device loadDevice(long id) throws HibernateException {
        Device device = (Device)this.session.createQuery("from Device d join fetch d.lastConfig where d.id = :id").setLong("id", id).uniqueResult();
        return device;
    }

    private Device loadDevice(String name) throws HibernateException {
        Device device = (Device)this.session.createQuery("from Device d join fetch d.lastConfig where d.name = :name").setString("name", name).uniqueResult();
        return device;
    }

    public void destroy() {
    }

    public Object get(String item, long deviceId) {
        logger.debug("JavaScript request for item {} on device {}.", (Object)item, (Object)deviceId);
        if (deviceId == this.device.getId()) {
            return this.get(item);
        }
        try {
            this.device = this.loadDevice(deviceId);
            Object result = this.getDeviceItem(this.device, item);
            this.session.evict(this.device);
            return result;
        }
        catch (ObjectNotFoundException e) {
            logger.error("Device not found on JavaScript get, item {}, device {}.", item, deviceId, e);
            this.taskLogger.warn(String.format("Unable to find the device %d.", deviceId));
        }
        catch (Exception e) {
            logger.error("Error on JavaScript get, item {}, device {}.", item, deviceId, e);
            this.taskLogger.warn(String.format("Unable to get data %s for device %d.", deviceId));
        }
        return null;
    }

    public Object get(String item, String deviceName) {
        logger.debug("JavaScript request for item {} on device named {}.", (Object)item, (Object)deviceName);
        try {
            if (this.device.getName().equals(deviceName)) {
                return this.get(item);
            }
            this.device = this.loadDevice(deviceName);
            Object result = this.getDeviceItem(this.device, item);
            this.session.evict(this.device);
            return result;
        }
        catch (ObjectNotFoundException e) {
            logger.error("Device not found on JavaScript get, item {}, device named {}.", item, deviceName, e);
            this.taskLogger.warn(String.format("Unable to find the device named %s.", deviceName));
        }
        catch (Exception e) {
            logger.error("Error on JavaScript get, item {}, device named {}.", item, deviceName, e);
            this.taskLogger.warn(String.format("Unable to get data %s for device named %s.", deviceName));
        }
        return null;
    }

    public void debug(String message) {
        this.taskLogger.debug(message);
    }

    public Object nslookup(String host) {
        String name = "";
        String address = "";
        try {
            InetAddress ip = InetAddress.getByName(host);
            name = ip.getHostName();
            address = ip.getHostAddress();
        }
        catch (UnknownHostException ip) {
            // empty catch block
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("name", name);
        result.put("address", address);
        return result;
    }
}

