/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.access;

import java.io.IOException;
import java.io.PrintStream;
import onl.netfishers.netshot.Netshot;
import onl.netfishers.netshot.device.NetworkAddress;
import onl.netfishers.netshot.device.access.Cli;
import onl.netfishers.netshot.device.access.Ssh;
import onl.netfishers.netshot.work.TaskLogger;
import org.apache.commons.net.telnet.TelnetClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Telnet
extends Cli {
    private static Logger logger = LoggerFactory.getLogger(Ssh.class);
    private static int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private int port = 23;
    private TelnetClient telnet = null;

    public Telnet(NetworkAddress host, TaskLogger taskLogger) {
        super(host, taskLogger);
    }

    public Telnet(NetworkAddress host, int port, TaskLogger taskLogger) {
        this(host, taskLogger);
        if (port != 0) {
            this.port = port;
        }
        this.connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    }

    @Override
    public void connect() throws IOException {
        this.telnet = new TelnetClient("VT100");
        this.telnet.setConnectTimeout(this.connectionTimeout);
        this.telnet.connect(this.host.getInetAddress(), this.port);
        this.telnet.setSoTimeout(this.receiveTimeout);
        this.inStream = this.telnet.getInputStream();
        this.outStream = new PrintStream(this.telnet.getOutputStream());
    }

    @Override
    public void disconnect() {
        try {
            this.telnet.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        int configuredConnectionTimeout = Netshot.getConfig("netshot.cli.telnet.connectiontimeout", DEFAULT_CONNECTION_TIMEOUT);
        if (configuredConnectionTimeout < 1) {
            logger.error("Invalid value {} for {}", (Object)configuredConnectionTimeout, (Object)"netshot.cli.telnet.connectiontimeout");
        } else {
            DEFAULT_CONNECTION_TIMEOUT = configuredConnectionTimeout;
        }
        logger.info("The default connection timeout value for Telnet sessions is {}s", (Object)DEFAULT_CONNECTION_TIMEOUT);
    }
}

