/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.device.access;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import onl.netfishers.netshot.device.NetworkAddress;
import onl.netfishers.netshot.device.access.Poller;
import onl.netfishers.netshot.device.credentials.DeviceSnmpCommunity;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv1Community;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv2cCommunity;
import onl.netfishers.netshot.device.credentials.DeviceSnmpv3Community;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.DefaultPDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeUtils;

public class Snmp
extends Poller {
    private org.snmp4j.Snmp snmp;
    private Target target;
    private static int PORT = 161;
    private OID authProtocol;
    private OID privProtocol;
    private static Logger logger = LoggerFactory.getLogger(Snmp.class);

    public Snmp(NetworkAddress address, DeviceSnmpCommunity community) throws IOException {
        if (community instanceof DeviceSnmpv1Community) {
            this.target = new CommunityTarget(new UdpAddress(address.getInetAddress(), PORT), new OctetString(community.getCommunity()));
            this.target.setVersion(0);
            this.start();
        } else if (community instanceof DeviceSnmpv2cCommunity) {
            this.target = new CommunityTarget(new UdpAddress(address.getInetAddress(), PORT), new OctetString(community.getCommunity()));
            this.target.setVersion(1);
            this.start();
        } else if (community instanceof DeviceSnmpv3Community) {
            DeviceSnmpv3Community v3Credentials = (DeviceSnmpv3Community)community;
            logger.debug("Prepare SNMPv3 context");
            this.target = new UserTarget();
            this.target.setTimeout(5000L);
            this.target.setVersion(3);
            this.target.setAddress(new UdpAddress(address.getInetAddress(), PORT));
            if (v3Credentials.getAuthKey() == null) {
                this.target.setSecurityLevel(1);
            } else if (v3Credentials.getPrivKey() == null) {
                this.target.setSecurityLevel(2);
            } else {
                this.target.setSecurityLevel(3);
            }
            this.target.setSecurityName(new OctetString(v3Credentials.getUsername()));
            logger.debug("Auth Protocol called: {}", (Object)v3Credentials.getAuthType());
            if (v3Credentials.getAuthType().equals("SHA")) {
                this.authProtocol = AuthSHA.ID;
                logger.debug("Using SHA Auth");
            } else {
                this.authProtocol = AuthMD5.ID;
            }
            this.privProtocol = v3Credentials.getAuthType().equals("AES128") ? PrivAES128.ID : (v3Credentials.getAuthType().equals("AES192") ? PrivAES192.ID : (v3Credentials.getAuthType().equals("AES256") ? PrivAES256.ID : Priv3DES.ID));
            USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
            usm.addUser(new OctetString(v3Credentials.getUsername()), new UsmUser(new OctetString(v3Credentials.getUsername()), this.authProtocol, new OctetString(v3Credentials.getAuthKey()), this.privProtocol, new OctetString(v3Credentials.getPrivKey())));
            SecurityModels.getInstance().addSecurityModel(usm);
            this.start();
        }
    }

    public Snmp(NetworkAddress address, String community, boolean v1) throws IOException {
        this.target = new CommunityTarget(new UdpAddress(address.getInetAddress(), PORT), new OctetString(community));
        this.target.setVersion(v1 ? 0 : 1);
        this.start();
    }

    private void start() throws IOException {
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        this.snmp = new org.snmp4j.Snmp(transport);
        transport.listen();
    }

    public void stop() throws IOException {
        this.snmp.close();
    }

    public String getAsString(OID oid) throws IOException {
        ResponseEvent event = this.get(new OID[]{oid});
        PDU response = event.getResponse();
        if (response == null || response.size() == 0) {
            throw new IOException("No SNMP response.");
        }
        if (response.size() < 1) {
            throw new IOException("Empty SNMP response");
        }
        if (response.get(0).isException()) {
            throw new IOException("SNMP error: " + response.get(0).toValueString());
        }
        return response.get(0).getVariable().toString();
    }

    public String getAsString(String oid) throws IOException {
        return this.getAsString(new OID(oid));
    }

    private PDU getPDU(OID[] oids) {
        PDU pdu = new PDU();
        for (OID oid : oids) {
            pdu.add(new VariableBinding(oid));
        }
        pdu.setType(-96);
        return pdu;
    }

    private ScopedPDU getScopedPDU(OID[] oids) {
        ScopedPDU scopedPdu = new ScopedPDU();
        for (OID oid : oids) {
            scopedPdu.add(new VariableBinding(oid));
        }
        scopedPdu.setType(-96);
        return scopedPdu;
    }

    public ResponseEvent get(OID[] oids) throws IOException {
        ResponseEvent event = this.target.getVersion() == 3 ? this.snmp.send(this.getScopedPDU(oids), this.target, null) : this.snmp.send(this.getPDU(oids), this.target, null);
        if (event != null) {
            return event;
        }
        throw new RuntimeException("SNMP Get timed out");
    }

    public Map<String, String> walkAsString(String oid) throws IOException {
        TreeMap<String, String> results = new TreeMap<String, String>();
        TreeUtils treeUtils = new TreeUtils(this.snmp, new DefaultPDUFactory());
        List<TreeEvent> events = treeUtils.getSubtree(this.target, new OID(oid));
        if (events != null) {
            for (TreeEvent event : events) {
                VariableBinding[] varBindings;
                if (event == null || event.isError() || (varBindings = event.getVariableBindings()) == null) continue;
                for (VariableBinding varBinding : varBindings) {
                    if (varBinding == null) continue;
                    results.put(varBinding.getOid().toString(), varBinding.getVariable().toString());
                }
            }
        }
        return results;
    }
}

