/*
 * Decompiled with CFR 0.152.
 */
package onl.netfishers.netshot.compliance;

import java.util.Date;
import java.util.regex.PatternSyntaxException;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import onl.netfishers.netshot.device.Device;
import onl.netfishers.netshot.device.DeviceDriver;
import onl.netfishers.netshot.device.DeviceGroup;
import onl.netfishers.netshot.device.Module;

@Entity
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class HardwareRule {
    private long id;
    private String driver = null;
    private DeviceGroup targetGroup;
    private String family = "";
    private boolean familyRegExp = false;
    private String partNumber;
    private boolean partNumberRegExp = false;
    private Date endOfSale;
    private Date endOfLife;

    protected HardwareRule() {
    }

    public HardwareRule(String driver, DeviceGroup targetGroup, String family, boolean familyRegExp, String partNumber, boolean partNumberRegExp, Date endOfSale, Date endOfLife) {
        this.driver = driver;
        this.targetGroup = targetGroup;
        this.family = family;
        this.familyRegExp = familyRegExp;
        this.partNumber = partNumber;
        this.partNumberRegExp = partNumberRegExp;
        this.endOfSale = endOfSale;
        this.endOfLife = endOfLife;
    }

    @XmlElement
    public String getDriver() {
        return this.driver;
    }

    @Transient
    @XmlElement
    public String getDeviceType() {
        DeviceDriver deviceDriver = DeviceDriver.getDriverByName(this.driver);
        if (deviceDriver == null) {
            return "";
        }
        return deviceDriver.getDescription();
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    @ManyToOne
    @XmlElement
    public DeviceGroup getTargetGroup() {
        return this.targetGroup;
    }

    public void setTargetGroup(DeviceGroup targetGroup) {
        this.targetGroup = targetGroup;
    }

    @XmlElement
    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    @XmlElement
    public String getPartNumber() {
        return this.partNumber;
    }

    public void setPartNumber(String partNumber) {
        this.partNumber = partNumber;
    }

    @XmlElement
    public Date getEndOfSale() {
        return this.endOfSale;
    }

    public void setEndOfSale(Date endOfSale) {
        this.endOfSale = endOfSale;
    }

    @XmlElement
    public Date getEndOfLife() {
        return this.endOfLife;
    }

    public void setEndOfLife(Date endOfLife) {
        this.endOfLife = endOfLife;
    }

    @Id
    @GeneratedValue
    @XmlElement
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void check(Device device) {
        block13: {
            if (this.targetGroup != null && !this.targetGroup.getCachedDevices().contains(device)) {
                return;
            }
            if (this.driver != null && !this.driver.equals(device.getDriver())) {
                return;
            }
            if (this.familyRegExp) {
                try {
                    if (!device.getFamily().matches(this.family)) {
                        return;
                    }
                    break block13;
                }
                catch (PatternSyntaxException e) {
                    return;
                }
            }
            if (!this.family.equals("") && !device.getFamily().equals(this.family)) {
                return;
            }
        }
        for (Module module : device.getModules()) {
            block14: {
                if (this.partNumberRegExp) {
                    try {
                        if (!module.getPartNumber().matches(this.partNumber)) {
                            continue;
                        }
                        break block14;
                    }
                    catch (PatternSyntaxException e) {
                        return;
                    }
                }
                if (!this.partNumber.equals("") && !module.getPartNumber().equals(this.partNumber)) continue;
            }
            if (this.endOfLife != null && (device.getEolDate() == null || this.endOfLife.before(device.getEolDate()))) {
                device.setEolDate(this.endOfLife);
                device.setEolModule(module);
            }
            if (this.endOfSale == null || device.getEosDate() != null && !this.endOfSale.before(device.getEosDate())) continue;
            device.setEosDate(this.endOfSale);
            device.setEosModule(module);
        }
    }

    @XmlElement
    public boolean isFamilyRegExp() {
        return this.familyRegExp;
    }

    public void setFamilyRegExp(boolean familyRegExp) {
        this.familyRegExp = familyRegExp;
    }

    @XmlElement
    public boolean isPartNumberRegExp() {
        return this.partNumberRegExp;
    }

    public void setPartNumberRegExp(boolean partNumberRegExp) {
        this.partNumberRegExp = partNumberRegExp;
    }
}

