/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.search.impl;

import java.util.Collections;
import java.util.List;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import net.sf.ehcache.search.SearchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultsImpl
implements Results {
    private final List<Result> results;
    private final boolean hasKeys;
    private final boolean hasAttributes;
    private final boolean hasAggregators;
    private final boolean hasValues;

    public ResultsImpl(List<Result> results, boolean hasKeys, boolean hasValues, boolean hasAttributes, boolean hasAggregators) {
        this.hasKeys = hasKeys;
        this.hasValues = hasValues;
        this.hasAttributes = hasAttributes;
        this.hasAggregators = hasAggregators;
        this.results = Collections.unmodifiableList(results);
    }

    @Override
    public void discard() {
    }

    @Override
    public List<Result> all() throws SearchException {
        return this.results;
    }

    @Override
    public List<Result> range(int start, int length) throws SearchException {
        if (start < 0) {
            throw new IllegalArgumentException("start: " + start);
        }
        if (length < 0) {
            throw new IllegalArgumentException("length: " + length);
        }
        int size = this.results.size();
        if (start > size - 1 || length == 0) {
            return Collections.EMPTY_LIST;
        }
        int end = start + length;
        if (end > size) {
            end = size;
        }
        return this.results.subList(start, end);
    }

    @Override
    public int size() {
        return this.results.size();
    }

    @Override
    public boolean hasKeys() {
        return this.hasKeys;
    }

    @Override
    public boolean hasValues() {
        return this.hasValues;
    }

    @Override
    public boolean hasAttributes() {
        return this.hasAttributes;
    }

    @Override
    public boolean hasAggregators() {
        return this.hasAggregators;
    }
}

