/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.packet;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.jradius.log.RadiusLog;
import net.jradius.packet.Format;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.packet.attribute.VSAttribute;
import net.jradius.packet.attribute.value.AttributeValue;

public class RadiusFormat
extends Format {
    private static final int HEADER_LENGTH = 2;
    public static final int VSA_HEADER_LENGTH = 8;
    private static final RadiusFormat staticFormat = new RadiusFormat();

    public static RadiusFormat getInstance() {
        return staticFormat;
    }

    public static void setAttributeBytes(RadiusPacket packet, ByteBuffer buffer, int length) {
        staticFormat.unpackAttributes(packet.getAttributes(), buffer, length, packet.isRecyclable());
    }

    public void packPacket(RadiusPacket packet, String sharedSecret, ByteBuffer buffer, boolean onWire) throws IOException {
        if (packet == null) {
            throw new IllegalArgumentException("Packet is null.");
        }
        int initialPosition = buffer.position();
        buffer.position(initialPosition + 20);
        this.packAttributeList(packet.getAttributes(), buffer, onWire);
        int totalLength = buffer.position() - initialPosition;
        int attributesLength = totalLength - 20;
        try {
            buffer.position(initialPosition);
            this.packHeader(buffer, packet, buffer.array(), initialPosition + 20, attributesLength, sharedSecret);
            buffer.position(totalLength + initialPosition);
        }
        catch (Exception e) {
            RadiusLog.warn(e.getMessage(), e);
        }
    }

    public void packHeader(ByteBuffer buffer, RadiusPacket p, byte[] attributeBytes, int offset, int attributesLength, String sharedSecret) throws IOException {
        int length = attributesLength + 20;
        RadiusFormat.putUnsignedByte(buffer, p.getCode());
        RadiusFormat.putUnsignedByte(buffer, p.getIdentifier());
        RadiusFormat.putUnsignedShort(buffer, length);
        buffer.put(p.getAuthenticator(attributeBytes, offset, attributesLength, sharedSecret));
    }

    public void packAttribute(ByteBuffer buffer, RadiusAttribute a) {
        VSAttribute vsa;
        AttributeValue attributeValue = a.getValue();
        if (a instanceof VSAttribute && (vsa = (VSAttribute)a).hasContinuationByte()) {
            int maxLength;
            int headerLength = this.headerLength(vsa);
            int valueLength = attributeValue.getLength();
            if (valueLength > (maxLength = 255 - headerLength)) {
                for (int off = 0; off < valueLength; off += maxLength) {
                    int len = valueLength - off;
                    if (len > maxLength) {
                        len = maxLength;
                        vsa.setContinuation();
                    } else {
                        vsa.unsetContinuation();
                    }
                    this.packHeader(buffer, a, len);
                    attributeValue.getBytes(buffer, off, len);
                }
                return;
            }
        }
        this.packHeader(buffer, a);
        attributeValue.getBytes(buffer);
    }

    public void packHeader(ByteBuffer buffer, RadiusAttribute a) {
        this.packHeader(buffer, a, a.getValue().getLength());
    }

    public void packHeader(ByteBuffer buffer, RadiusAttribute a, int valueLength) {
        if (a instanceof VSAttribute) {
            this.packHeader(buffer, (VSAttribute)a, valueLength);
            return;
        }
        RadiusFormat.putUnsignedByte(buffer, (int)a.getType());
        RadiusFormat.putUnsignedByte(buffer, valueLength + 2);
    }

    public int headerLength(VSAttribute a) {
        int vsaHeader = 6;
        vsaHeader += a.getTypeLength();
        vsaHeader += a.getLengthLength();
        if (a.hasContinuationByte()) {
            ++vsaHeader;
        }
        return vsaHeader;
    }

    public int headerLength(RadiusAttribute a) {
        if (a instanceof VSAttribute) {
            return this.headerLength((VSAttribute)a);
        }
        return 2;
    }

    public void packHeader(ByteBuffer buffer, VSAttribute a) {
        this.packHeader(buffer, a, a.getValue().getLength());
    }

    public void packHeader(ByteBuffer buffer, VSAttribute a, int len) {
        int vsaHeader = this.headerLength(a);
        if (len > 255 - vsaHeader) {
            throw new RuntimeException("RADIUS attribute value too long (" + len + ")");
        }
        RadiusFormat.putUnsignedByte(buffer, (int)a.getType());
        RadiusFormat.putUnsignedByte(buffer, len + vsaHeader);
        RadiusFormat.putUnsignedInt(buffer, a.getVendorId());
        RadiusFormat.putUnsignedByte(buffer, (int)a.getVsaAttributeType());
        len += 2;
        if (a.hasContinuationByte()) {
            ++len;
        }
        switch (a.getLengthLength()) {
            case 1: {
                RadiusFormat.putUnsignedByte(buffer, len);
                break;
            }
            case 2: {
                RadiusFormat.putUnsignedShort(buffer, len);
                break;
            }
            case 4: {
                RadiusFormat.putUnsignedInt(buffer, len);
            }
        }
        if (a.hasContinuationByte()) {
            RadiusFormat.putUnsignedByte(buffer, a.getContinuation());
        }
    }

    public void unpackAttributeHeader(InputStream in, Format.AttributeParseContext ctx) throws IOException {
        ctx.attributeOp = 0L;
        ctx.vendorNumber = -1;
        ctx.padding = 0;
        ctx.attributeType = RadiusFormat.readUnsignedByte(in);
        ctx.attributeLength = RadiusFormat.readUnsignedByte(in);
        ctx.headerLength = 2;
    }

    public void unpackAttributeHeader(ByteBuffer buffer, Format.AttributeParseContext ctx) throws IOException {
        ctx.attributeOp = 0L;
        ctx.vendorNumber = -1;
        ctx.padding = 0;
        ctx.attributeType = RadiusFormat.getUnsignedByte(buffer);
        ctx.attributeLength = RadiusFormat.getUnsignedByte(buffer);
        ctx.headerLength = 2;
    }
}

