/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.log;

import net.jradius.log.RadiusLogger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Log4JRadiusLogger
implements RadiusLogger {
    private static final Log log = LogFactory.getLog(Log4JRadiusLogger.class);

    public boolean isLoggable(int logLevel) {
        switch (logLevel) {
            case 0: {
                return true;
            }
            case 2: {
                return log.isErrorEnabled();
            }
            case 4: {
                return log.isWarnEnabled();
            }
            default: {
                return log.isInfoEnabled();
            }
            case 8: 
        }
        return log.isDebugEnabled();
    }

    public void error(String message) {
        if (message != null) {
            log.error(message);
        }
    }

    public void error(String message, Throwable e) {
        if (message != null) {
            if (e != null) {
                log.error(message, e);
            } else {
                log.error(message);
            }
        } else if (e != null) {
            log.error("", e);
        }
    }

    public void warn(String message) {
        if (message != null) {
            log.warn(message);
        }
    }

    public void warn(String message, Throwable e) {
        if (message != null) {
            if (e != null) {
                log.warn(message, e);
            } else {
                log.warn(message);
            }
        } else if (e != null) {
            log.warn("", e);
        }
    }

    public void info(String message) {
        if (message != null) {
            log.info(message);
        }
    }

    public void info(String message, Throwable e) {
        if (message != null) {
            if (e != null) {
                log.info(message, e);
            } else {
                log.info(message);
            }
        } else if (e != null) {
            log.info("", e);
        }
    }

    public void debug(String message) {
        if (!log.isDebugEnabled()) {
            return;
        }
        if (message != null) {
            log.debug(message);
        }
    }

    public void debug(String message, Throwable e) {
        if (!log.isDebugEnabled()) {
            return;
        }
        if (message != null) {
            if (e != null) {
                log.debug(message, e);
            } else {
                log.debug(message);
            }
        } else if (e != null) {
            log.debug("", e);
        }
    }
}

