/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ctc;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.ctc.ContentValidator;
import com.adobe.epubcheck.ctc.EpubCheckContentFactory;
import com.adobe.epubcheck.ctc.PackageReader;
import com.adobe.epubcheck.ctc.epubpackage.EpubPackage;
import com.adobe.epubcheck.util.EPUBVersion;
import java.util.zip.ZipFile;

public class CheckManager {
    private final EpubPackage epack;
    private final EpubCheckContentFactory factory;
    private Report report;

    public CheckManager(ZipFile zip, Report report) {
        this.setReport(report);
        PackageReader pr = new PackageReader(zip, report);
        this.epack = pr.readPackageData();
        this.factory = EpubCheckContentFactory.getInstance();
    }

    private void setReport(Report report) {
        this.report = report;
    }

    public void checkPackage() {
        if (this.epack == null) {
            return;
        }
        EPUBVersion version = this.epack.getVersion();
        if (version != null && version.equals((Object)EPUBVersion.VERSION_3)) {
            this.factory.newInstance(this.report, ContentValidator.ValidationType.RENDITION, this.epack).validate();
            this.factory.newInstance(this.report, ContentValidator.ValidationType.CFI, this.epack).validate();
            this.factory.newInstance(this.report, ContentValidator.ValidationType.METADATA_V3, this.epack).validate();
            this.factory.newInstance(this.report, ContentValidator.ValidationType.NAV, this.epack).validate();
        } else if (version != null && EPUBVersion.VERSION_2.equals((Object)version)) {
            this.factory.newInstance(this.report, ContentValidator.ValidationType.EPUB3_STRUCTURE, this.epack).validate();
            this.factory.newInstance(this.report, ContentValidator.ValidationType.METADATA_V2, this.epack).validate();
        }
        this.factory.newInstance(this.report, ContentValidator.ValidationType.NCX, this.epack).validate();
        this.factory.newInstance(this.report, ContentValidator.ValidationType.MULTIPLE_CSS, this.epack).validate();
        this.factory.newInstance(this.report, ContentValidator.ValidationType.HTML_STRUCTURE, this.epack).validate();
        this.factory.newInstance(this.report, ContentValidator.ValidationType.LINK, this.epack).validate();
        this.factory.newInstance(this.report, ContentValidator.ValidationType.CSS_SEARCH, this.epack).validate();
        this.factory.newInstance(this.report, ContentValidator.ValidationType.TOC, this.epack).validate();
        this.factory.newInstance(this.report, ContentValidator.ValidationType.LANG, this.epack).validate();
        this.factory.newInstance(this.report, ContentValidator.ValidationType.SPINE, this.epack).validate();
        this.factory.newInstance(this.report, ContentValidator.ValidationType.TEXT, this.epack).validate();
        this.factory.newInstance(this.report, ContentValidator.ValidationType.SCRIPT, this.epack).validate();
        this.factory.newInstance(this.report, ContentValidator.ValidationType.SPAN, this.epack).validate();
        this.factory.newInstance(this.report, ContentValidator.ValidationType.SVG, this.epack).validate();
    }
}

