/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.classfile.Field;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.Annotations;
import org.jd.core.v1.model.classfile.attribute.AttributeCode;
import org.jd.core.v1.model.classfile.attribute.AttributeLocalVariableTable;
import org.jd.core.v1.model.classfile.attribute.AttributeLocalVariableTypeTable;
import org.jd.core.v1.model.classfile.attribute.AttributeParameterAnnotations;
import org.jd.core.v1.model.classfile.attribute.LocalVariable;
import org.jd.core.v1.model.classfile.attribute.LocalVariableType;
import org.jd.core.v1.model.javasyntax.declaration.BaseFormalParameter;
import org.jd.core.v1.model.javasyntax.declaration.FormalParameters;
import org.jd.core.v1.model.javasyntax.reference.BaseAnnotationReference;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFormalParameter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.Frame;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableSet;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.ObjectLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.PrimitiveLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.RootFrame;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.AnnotationConverter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.CreateLocalVariableVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.CreateParameterVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.GenerateParameterSuffixNameVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.PopulateBlackListNamesVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchInTypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.UpdateTypeVisitor;
import org.jd.core.v1.util.DefaultList;

public class LocalVariableMaker {
    protected LocalVariableSet localVariableSet = new LocalVariableSet();
    protected HashSet<String> names = new HashSet();
    protected HashSet<String> blackListNames = new HashSet();
    protected Frame currentFrame = new RootFrame();
    protected AbstractLocalVariable[] localVariableCache;
    protected TypeMaker typeMaker;
    protected Map<String, BaseType> typeBounds;
    protected FormalParameters formalParameters;
    protected PopulateBlackListNamesVisitor populateBlackListNamesVisitor = new PopulateBlackListNamesVisitor(this.blackListNames);
    protected SearchInTypeArgumentVisitor searchInTypeArgumentVisitor = new SearchInTypeArgumentVisitor();
    protected CreateParameterVisitor createParameterVisitor;
    protected CreateLocalVariableVisitor createLocalVariableVisitor;

    public LocalVariableMaker(TypeMaker typeMaker, ClassFileConstructorOrMethodDeclaration comd, boolean constructor, BaseType parameterTypes) {
        ClassFile classFile = comd.getClassFile();
        Method method = comd.getMethod();
        this.typeMaker = typeMaker;
        this.typeBounds = comd.getTypeBounds();
        this.createParameterVisitor = new CreateParameterVisitor(typeMaker);
        this.createLocalVariableVisitor = new CreateLocalVariableVisitor(typeMaker);
        if (classFile.getFields() != null) {
            for (Field field : classFile.getFields()) {
                String descriptor = field.getDescriptor();
                if (descriptor.charAt(descriptor.length() - 1) != ';') continue;
                typeMaker.makeFromDescriptor(descriptor).accept(this.populateBlackListNamesVisitor);
            }
        }
        typeMaker.makeFromInternalTypeName(classFile.getInternalTypeName()).accept(this.populateBlackListNamesVisitor);
        if (classFile.getSuperTypeName() != null) {
            typeMaker.makeFromInternalTypeName(classFile.getSuperTypeName()).accept(this.populateBlackListNamesVisitor);
        }
        if (classFile.getInterfaceTypeNames() != null) {
            for (String interfaceTypeName : classFile.getInterfaceTypeNames()) {
                typeMaker.makeFromInternalTypeName(interfaceTypeName).accept(this.populateBlackListNamesVisitor);
            }
        }
        if (parameterTypes != null) {
            if (parameterTypes.isList()) {
                for (Type type : parameterTypes) {
                    type.accept(this.populateBlackListNamesVisitor);
                }
            } else {
                ((Type)parameterTypes.getFirst()).accept(this.populateBlackListNamesVisitor);
            }
        }
        this.initLocalVariablesFromAttributes(method);
        int firstVariableIndex = 0;
        if ((method.getAccessFlags() & 8) == 0) {
            if (this.localVariableSet.root(0) == null) {
                this.localVariableSet.add(0, new ObjectLocalVariable(typeMaker, 0, 0, typeMaker.makeFromInternalTypeName(classFile.getInternalTypeName()), "this"));
            }
            firstVariableIndex = 1;
        }
        if (constructor) {
            if ((classFile.getAccessFlags() & 0x4000) != 0) {
                if (this.localVariableSet.root(1) == null) {
                    this.localVariableSet.add(1, new ObjectLocalVariable(typeMaker, 1, 0, ObjectType.TYPE_STRING, "this$enum$name"));
                }
                if (this.localVariableSet.root(2) == null) {
                    this.localVariableSet.add(2, new PrimitiveLocalVariable(2, 0, PrimitiveType.TYPE_INT, "this$enum$index"));
                }
            } else if (classFile.getOuterClassFile() != null && (classFile.getAccessFlags() & 8) == 0 && this.localVariableSet.root(1) == null) {
                this.localVariableSet.add(1, new ObjectLocalVariable(typeMaker, 1, 0, typeMaker.makeFromInternalTypeName(classFile.getOuterClassFile().getInternalTypeName()), "this$0"));
            }
        }
        if (parameterTypes != null) {
            int lastParameterIndex = parameterTypes.size() - 1;
            boolean varargs = (method.getAccessFlags() & 0x80) != 0;
            this.initLocalVariablesFromParameterTypes(classFile, parameterTypes, varargs, firstVariableIndex, lastParameterIndex);
            this.formalParameters = new FormalParameters();
            AttributeParameterAnnotations rvpa = (AttributeParameterAnnotations)method.getAttribute("RuntimeVisibleParameterAnnotations");
            AttributeParameterAnnotations ripa = (AttributeParameterAnnotations)method.getAttribute("RuntimeInvisibleParameterAnnotations");
            if (rvpa == null && ripa == null) {
                int parameterIndex = 0;
                int variableIndex = firstVariableIndex;
                while (parameterIndex <= lastParameterIndex) {
                    AbstractLocalVariable lv = this.localVariableSet.root(variableIndex);
                    this.formalParameters.add(new ClassFileFormalParameter(lv, varargs && parameterIndex == lastParameterIndex));
                    if (PrimitiveType.TYPE_LONG.equals(lv.getType()) || PrimitiveType.TYPE_DOUBLE.equals(lv.getType())) {
                        ++variableIndex;
                    }
                    ++parameterIndex;
                    ++variableIndex;
                }
            } else {
                Annotations[] visiblesArray = rvpa == null ? null : rvpa.getParameterAnnotations();
                Annotations[] invisiblesArray = ripa == null ? null : ripa.getParameterAnnotations();
                AnnotationConverter annotationConverter = new AnnotationConverter(typeMaker);
                int parameterIndex = 0;
                int variableIndex = firstVariableIndex;
                while (parameterIndex <= lastParameterIndex) {
                    AbstractLocalVariable lv = this.localVariableSet.root(variableIndex);
                    Annotations visibles = visiblesArray == null || visiblesArray.length <= parameterIndex ? null : visiblesArray[parameterIndex];
                    Annotations invisibles = invisiblesArray == null || invisiblesArray.length <= parameterIndex ? null : invisiblesArray[parameterIndex];
                    BaseAnnotationReference annotationReferences = annotationConverter.convert(visibles, invisibles);
                    this.formalParameters.add(new ClassFileFormalParameter(annotationReferences, lv, varargs && parameterIndex == lastParameterIndex));
                    if (PrimitiveType.TYPE_LONG.equals(lv.getType()) || PrimitiveType.TYPE_DOUBLE.equals(lv.getType())) {
                        ++variableIndex;
                    }
                    ++parameterIndex;
                    ++variableIndex;
                }
            }
        }
        this.localVariableCache = this.localVariableSet.initialize(this.currentFrame);
    }

    protected void initLocalVariablesFromAttributes(Method method) {
        AttributeCode code = (AttributeCode)method.getAttribute("Code");
        if (code != null) {
            AttributeLocalVariableTypeTable localVariableTypeTable;
            AttributeLocalVariableTable localVariableTable = (AttributeLocalVariableTable)code.getAttribute("LocalVariableTable");
            if (localVariableTable != null) {
                boolean staticFlag = (method.getAccessFlags() & 8) != 0;
                for (LocalVariable localVariable : localVariableTable.getLocalVariableTable()) {
                    int dimension;
                    int index = localVariable.getIndex();
                    int startPc = !staticFlag && index == 0 ? 0 : localVariable.getStartPc();
                    String descriptor = localVariable.getDescriptor();
                    String name = localVariable.getName();
                    AbstractLocalVariable lv = descriptor.charAt(descriptor.length() - 1) == ';' ? new ObjectLocalVariable(this.typeMaker, index, startPc, this.typeMaker.makeFromDescriptor(descriptor), name) : ((dimension = TypeMaker.countDimension(descriptor)) == 0 ? new PrimitiveLocalVariable(index, startPc, PrimitiveType.getPrimitiveType(descriptor.charAt(0)), name) : new ObjectLocalVariable(this.typeMaker, index, startPc, this.typeMaker.makeFromSignature(descriptor.substring(dimension)).createType(dimension), name));
                    this.localVariableSet.add(index, lv);
                    this.names.add(name);
                }
            }
            if ((localVariableTypeTable = (AttributeLocalVariableTypeTable)code.getAttribute("LocalVariableTypeTable")) != null) {
                UpdateTypeVisitor updateTypeVisitor = new UpdateTypeVisitor(this.localVariableSet);
                for (LocalVariableType lv : localVariableTypeTable.getLocalVariableTypeTable()) {
                    updateTypeVisitor.setLocalVariableType(lv);
                    this.typeMaker.makeFromSignature(lv.getSignature()).accept(updateTypeVisitor);
                }
            }
        }
    }

    protected void initLocalVariablesFromParameterTypes(ClassFile classFile, BaseType parameterTypes, boolean varargs, int firstVariableIndex, int lastParameterIndex) {
        HashMap<Type, Boolean> typeMap = new HashMap<Type, Boolean>();
        DefaultList t = parameterTypes.getList();
        for (int parameterIndex = 0; parameterIndex <= lastParameterIndex; ++parameterIndex) {
            Type type = (Type)t.get(parameterIndex);
            typeMap.put(type, typeMap.containsKey(type));
        }
        String parameterNamePrefix = "param";
        if (classFile.getOuterClassFile() != null) {
            int innerTypeDepth = 1;
            ObjectType type = this.typeMaker.makeFromInternalTypeName(classFile.getOuterClassFile().getInternalTypeName());
            while (type != null && type.getClass() == InnerObjectType.class) {
                ++innerTypeDepth;
                type = ((InnerObjectType)type).getOuterType();
            }
            parameterNamePrefix = parameterNamePrefix + innerTypeDepth;
        }
        StringBuilder sb = new StringBuilder();
        GenerateParameterSuffixNameVisitor generateParameterSuffixNameVisitor = new GenerateParameterSuffixNameVisitor();
        int parameterIndex = 0;
        int variableIndex = firstVariableIndex;
        while (parameterIndex <= lastParameterIndex) {
            Type type = (Type)t.get(parameterIndex);
            AbstractLocalVariable lv = this.localVariableSet.root(variableIndex);
            if (lv == null) {
                sb.setLength(0);
                sb.append(parameterNamePrefix);
                if (parameterIndex == lastParameterIndex && varargs) {
                    sb.append("VarArgs");
                } else {
                    if (type.getDimension() > 0) {
                        sb.append("ArrayOf");
                    }
                    type.accept(generateParameterSuffixNameVisitor);
                    sb.append(generateParameterSuffixNameVisitor.getSuffix());
                }
                int length = sb.length();
                int counter = 1;
                if (((Boolean)typeMap.get(type)).booleanValue()) {
                    sb.append(counter++);
                }
                String name = sb.toString();
                while (this.names.contains(name)) {
                    sb.setLength(length);
                    sb.append(counter++);
                    name = sb.toString();
                }
                this.names.add(name);
                this.createParameterVisitor.init(variableIndex, name);
                type.accept(this.createParameterVisitor);
                AbstractLocalVariable alv = this.createParameterVisitor.getLocalVariable();
                alv.setDeclared(true);
                this.localVariableSet.add(variableIndex, alv);
            }
            if (PrimitiveType.TYPE_LONG.equals(type) || PrimitiveType.TYPE_DOUBLE.equals(type)) {
                ++variableIndex;
            }
            ++parameterIndex;
            ++variableIndex;
        }
    }

    public AbstractLocalVariable getLocalVariable(int index, int offset) {
        AbstractLocalVariable lv = this.localVariableCache[index];
        if (lv == null) {
            lv = this.currentFrame.getLocalVariable(index);
            if (lv == null) {
                lv = new ObjectLocalVariable(this.typeMaker, index, offset, ObjectType.TYPE_OBJECT, "SYNTHETIC_LOCAL_VARIABLE_" + index, true);
            }
        } else if (lv.getFrame() != this.currentFrame) {
            Frame frame = this.searchCommonParentFrame(lv.getFrame(), this.currentFrame);
            frame.mergeLocalVariable(this.typeBounds, this, lv);
            if (lv.getFrame() != frame) {
                lv.getFrame().removeLocalVariable(lv);
                frame.addLocalVariable(lv);
            }
        }
        lv.setToOffset(offset);
        return lv;
    }

    protected AbstractLocalVariable searchLocalVariable(int index, int offset) {
        AbstractLocalVariable lv = this.localVariableSet.get(index, offset);
        if (lv == null) {
            lv = this.currentFrame.getLocalVariable(index);
        } else {
            AbstractLocalVariable lv2 = this.currentFrame.getLocalVariable(index);
            if (lv2 != null && (lv.getName() == null ? lv2.getName() == null : lv.getName().equals(lv2.getName())) && lv.getType().equals(lv2.getType())) {
                lv = lv2;
            }
            this.localVariableSet.remove(index, offset);
        }
        return lv;
    }

    public boolean isCompatible(AbstractLocalVariable lv, Type valueType) {
        if (valueType == ObjectType.TYPE_UNDEFINED_OBJECT) {
            return true;
        }
        if (valueType.isObject() && lv.getType().getDimension() == valueType.getDimension()) {
            ObjectType valueObjectType = (ObjectType)valueType;
            if (lv.getType().isObject()) {
                ObjectType lvObjectType = (ObjectType)lv.getType();
                BaseTypeArgument lvTypeArguments = lvObjectType.getTypeArguments();
                BaseTypeArgument valueTypeArguments = valueObjectType.getTypeArguments();
                if (lvTypeArguments == null || valueTypeArguments == null || valueTypeArguments == WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT) {
                    return this.typeMaker.isRawTypeAssignable(lvObjectType, valueObjectType);
                }
                this.searchInTypeArgumentVisitor.init();
                lvTypeArguments.accept(this.searchInTypeArgumentVisitor);
                if (!this.searchInTypeArgumentVisitor.containsGeneric()) {
                    this.searchInTypeArgumentVisitor.init();
                    valueTypeArguments.accept(this.searchInTypeArgumentVisitor);
                    if (this.searchInTypeArgumentVisitor.containsGeneric()) {
                        return this.typeMaker.isRawTypeAssignable(lvObjectType, valueObjectType);
                    }
                }
            } else if (lv.getType().isGeneric() && valueObjectType.getInternalName().equals(ObjectType.TYPE_OBJECT.getInternalName())) {
                return true;
            }
        }
        return false;
    }

    public AbstractLocalVariable getLocalVariableInAssignment(Map<String, BaseType> typeBounds, int index, int offset, Type valueType) {
        AbstractLocalVariable lv = this.searchLocalVariable(index, offset);
        if (lv == null) {
            this.createLocalVariableVisitor.init(index, offset);
            valueType.accept(this.createLocalVariableVisitor);
            lv = this.createLocalVariableVisitor.getLocalVariable();
        } else if (lv.isAssignableFrom(typeBounds, valueType) || this.isCompatible(lv, valueType)) {
            lv.typeOnRight(typeBounds, valueType);
        } else if (!lv.getType().isGeneric() || ObjectType.TYPE_OBJECT != valueType) {
            this.createLocalVariableVisitor.init(index, offset);
            valueType.accept(this.createLocalVariableVisitor);
            lv = this.createLocalVariableVisitor.getLocalVariable();
        }
        lv.setToOffset(offset);
        this.store(lv);
        return lv;
    }

    public AbstractLocalVariable getLocalVariableInNullAssignment(int index, int offset, Type valueType) {
        AbstractLocalVariable lv = this.searchLocalVariable(index, offset);
        if (lv == null) {
            this.createLocalVariableVisitor.init(index, offset);
            valueType.accept(this.createLocalVariableVisitor);
            lv = this.createLocalVariableVisitor.getLocalVariable();
        } else {
            Type type = lv.getType();
            if (type.getDimension() == 0 && type.isPrimitive()) {
                this.createLocalVariableVisitor.init(index, offset);
                valueType.accept(this.createLocalVariableVisitor);
                lv = this.createLocalVariableVisitor.getLocalVariable();
            }
        }
        lv.setToOffset(offset);
        this.store(lv);
        return lv;
    }

    public AbstractLocalVariable getLocalVariableInAssignment(Map<String, BaseType> typeBounds, int index, int offset, AbstractLocalVariable valueLocalVariable) {
        AbstractLocalVariable lv = this.searchLocalVariable(index, offset);
        if (lv == null) {
            this.createLocalVariableVisitor.init(index, offset);
            valueLocalVariable.accept(this.createLocalVariableVisitor);
            lv = this.createLocalVariableVisitor.getLocalVariable();
        } else if (!(lv.isAssignableFrom(typeBounds, valueLocalVariable) || this.isCompatible(lv, valueLocalVariable.getType()) || lv.getType().isGeneric() && ObjectType.TYPE_OBJECT == valueLocalVariable.getType())) {
            this.createLocalVariableVisitor.init(index, offset);
            valueLocalVariable.accept(this.createLocalVariableVisitor);
            lv = this.createLocalVariableVisitor.getLocalVariable();
        }
        lv.variableOnRight(typeBounds, valueLocalVariable);
        lv.setToOffset(offset);
        this.store(lv);
        return lv;
    }

    public AbstractLocalVariable getExceptionLocalVariable(int index, int offset, ObjectType type) {
        AbstractLocalVariable lv;
        if (index == -1) {
            lv = new ObjectLocalVariable(this.typeMaker, index, offset, type, null, true);
            this.currentFrame.setExceptionLocalVariable(lv);
        } else {
            lv = this.localVariableSet.remove(index, offset);
            if (lv == null) {
                lv = new ObjectLocalVariable(this.typeMaker, index, offset, type, null, true);
            } else {
                lv.setDeclared(true);
            }
            this.currentFrame.addLocalVariable(lv);
        }
        return lv;
    }

    public void removeLocalVariable(AbstractLocalVariable lv) {
        int index = lv.getIndex();
        if (index < this.localVariableCache.length) {
            this.localVariableCache[index] = null;
            this.currentFrame.removeLocalVariable(lv);
        }
    }

    protected void store(AbstractLocalVariable lv) {
        int index = lv.getIndex();
        if (index >= this.localVariableCache.length) {
            AbstractLocalVariable[] tmp = this.localVariableCache;
            this.localVariableCache = new AbstractLocalVariable[index * 2];
            System.arraycopy(tmp, 0, this.localVariableCache, 0, tmp.length);
        }
        this.localVariableCache[index] = lv;
        if (lv.getFrame() == null) {
            this.currentFrame.addLocalVariable(lv);
        }
    }

    public boolean containsName(String name) {
        return this.names.contains(name);
    }

    public void make() {
        this.currentFrame.createNames(this.blackListNames);
        this.currentFrame.createDeclarations();
    }

    public BaseFormalParameter getFormalParameters() {
        return this.formalParameters;
    }

    public void pushFrame(Statements statements) {
        Frame parent = this.currentFrame;
        this.currentFrame = new Frame(this.currentFrame, statements);
        parent.addChild(this.currentFrame);
    }

    public void popFrame() {
        this.currentFrame.close();
        this.currentFrame = this.currentFrame.getParent();
    }

    protected Frame searchCommonParentFrame(Frame frame1, Frame frame2) {
        HashSet<Frame> set = new HashSet<Frame>();
        while (frame1 != null) {
            set.add(frame1);
            frame1 = frame1.getParent();
        }
        while (frame2 != null) {
            if (set.contains(frame2)) {
                return frame2;
            }
            frame2 = frame2.getParent();
        }
        return null;
    }
}

