/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import org.jd.core.v1.model.classfile.ConstantPool;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.AttributeCode;
import org.jd.core.v1.model.classfile.attribute.AttributeLineNumberTable;
import org.jd.core.v1.model.classfile.attribute.AttributeLocalVariableTable;
import org.jd.core.v1.model.classfile.attribute.AttributeLocalVariableTypeTable;
import org.jd.core.v1.model.classfile.attribute.CodeException;
import org.jd.core.v1.model.classfile.attribute.LineNumber;
import org.jd.core.v1.model.classfile.attribute.LocalVariable;
import org.jd.core.v1.model.classfile.attribute.LocalVariableType;
import org.jd.core.v1.model.classfile.constant.Constant;
import org.jd.core.v1.model.classfile.constant.ConstantClass;
import org.jd.core.v1.model.classfile.constant.ConstantDouble;
import org.jd.core.v1.model.classfile.constant.ConstantFloat;
import org.jd.core.v1.model.classfile.constant.ConstantInteger;
import org.jd.core.v1.model.classfile.constant.ConstantLong;
import org.jd.core.v1.model.classfile.constant.ConstantMemberRef;
import org.jd.core.v1.model.classfile.constant.ConstantNameAndType;
import org.jd.core.v1.model.classfile.constant.ConstantString;
import org.jd.core.v1.model.classfile.constant.ConstantUtf8;

public class ByteCodeWriter {
    protected static final String[] OPCODE_NAMES = new String[]{"nop", "aconst_null", "iconst_m1", "iconst_0", "iconst_1", "iconst_2", "iconst_3", "iconst_4", "iconst_5", "lconst_0", "lconst_1", "fconst_0", "fconst_1", "fconst_2", "dconst_0", "dconst_1", "bipush", "sipush", "ldc", "ldc_w", "ldc2_w", "iload", "lload", "fload", "dload", "aload", "iload_0", "iload_1", "iload_2", "iload_3", "lload_0", "lload_1", "lload_2", "lload_3", "fload_0", "fload_1", "fload_2", "fload_3", "dload_0", "dload_1", "dload_2", "dload_3", "aload_0", "aload_1", "aload_2", "aload_3", "iaload", "laload", "faload", "daload", "aaload", "baload", "caload", "saload", "istore", "lstore", "fstore", "dstore", "astore", "istore_0", "istore_1", "istore_2", "istore_3", "lstore_0", "lstore_1", "lstore_2", "lstore_3", "fstore_0", "fstore_1", "fstore_2", "fstore_3", "dstore_0", "dstore_1", "dstore_2", "dstore_3", "astore_0", "astore_1", "astore_2", "astore_3", "iastore", "lastore", "fastore", "dastore", "aastore", "bastore", "castore", "sastore", "pop", "pop2", "dup", "dup_x1", "dup_x2", "dup2", "dup2_x1", "dup2_x2", "swap", "iadd", "ladd", "fadd", "dadd", "isub", "lsub", "fsub", "dsub", "imul", "lmul", "fmul", "dmul", "idiv", "ldiv", "fdiv", "ddiv", "irem", "lrem", "frem", "drem", "ineg", "lneg", "fneg", "dneg", "ishl", "lshl", "ishr", "lshr", "iushr", "lushr", "iand", "land", "ior", "lor", "ixor", "lxor", "iinc", "i2l", "i2f", "i2d", "l2i", "l2f", "l2d", "f2i", "f2l", "f2d", "d2i", "d2l", "d2f", "i2b", "i2c", "i2s", "lcmp", "fcmpl", "fcmpg", "dcmpl", "dcmpg", "ifeq", "ifne", "iflt", "ifge", "ifgt", "ifle", "if_icmpeq", "if_icmpne", "if_icmplt", "if_icmpge", "if_icmpgt", "if_icmple", "if_acmpeq", "if_acmpne", "goto", "jsr", "ret", "tableswitch", "lookupswitch", "ireturn", "lreturn", "freturn", "dreturn", "areturn", "return", "getstatic", "putstatic", "getfield", "putfield", "invokevirtual", "invokespecial", "invokestatic", "invokeinterface", "<illegal opcode>", "new", "newarray", "anewarray", "arraylength", "athrow", "checkcast", "instanceof", "monitorenter", "monitorexit", "wide", "multianewarray", "ifnull", "ifnonnull", "goto_w", "jsr_w", "breakpoint", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "<illegal opcode>", "impdep1", "impdep2"};

    public static String write(String linePrefix, Method method) {
        AttributeCode attributeCode = (AttributeCode)method.getAttribute("Code");
        if (attributeCode == null) {
            return null;
        }
        ConstantPool constants = method.getConstants();
        StringBuilder sb = new StringBuilder(5120);
        ByteCodeWriter.writeByteCode(linePrefix, sb, constants, attributeCode);
        ByteCodeWriter.writeLineNumberTable(linePrefix, sb, attributeCode);
        ByteCodeWriter.writeLocalVariableTable(linePrefix, sb, attributeCode);
        ByteCodeWriter.writeExceptionTable(linePrefix, sb, constants, attributeCode);
        return sb.toString();
    }

    public static String write(String linePrefix, Method method, int fromOffset, int toOffset) {
        AttributeCode attributeCode = (AttributeCode)method.getAttribute("Code");
        if (attributeCode == null) {
            return null;
        }
        ConstantPool constants = method.getConstants();
        StringBuilder sb = new StringBuilder(1024);
        byte[] code = attributeCode.getCode();
        ByteCodeWriter.writeByteCode(linePrefix, sb, constants, code, fromOffset, toOffset);
        return sb.toString();
    }

    protected static void writeByteCode(String linePrefix, StringBuilder sb, ConstantPool constants, AttributeCode attributeCode) {
        byte[] code = attributeCode.getCode();
        int length = code.length;
        sb.append(linePrefix).append("Byte code:\n");
        ByteCodeWriter.writeByteCode(linePrefix, sb, constants, code, 0, length);
    }

    protected static void writeByteCode(String linePrefix, StringBuilder sb, ConstantPool constants, byte[] code, int fromOffset, int toOffset) {
        for (int offset = fromOffset; offset < toOffset; ++offset) {
            int opcode = code[offset] & 0xFF;
            sb.append(linePrefix).append("  ").append(offset).append(": ").append(OPCODE_NAMES[opcode]);
            switch (opcode) {
                case 16: {
                    sb.append(" #").append((byte)(code[++offset] & 0xFF));
                    break;
                }
                case 17: {
                    sb.append(" #").append((short)((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF));
                    break;
                }
                case 18: {
                    ByteCodeWriter.writeLDC(sb, constants, constants.getConstant(code[++offset] & 0xFF));
                    break;
                }
                case 19: 
                case 20: {
                    ByteCodeWriter.writeLDC(sb, constants, constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF));
                    break;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: {
                    sb.append(" #").append(code[++offset] & 0xFF);
                    break;
                }
                case 132: {
                    sb.append(" #").append(code[++offset] & 0xFF).append(", ").append((byte)(code[++offset] & 0xFF));
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 168: {
                    sb.append(" -> ").append(offset++ + (short)((code[offset] & 0xFF) << 8 | code[++offset] & 0xFF));
                    break;
                }
                case 170: {
                    int i = offset + 4 & 0xFFFC;
                    sb.append(" default").append(" -> ").append(offset + ((code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF));
                    int low = (code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF;
                    int high = (code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF;
                    for (int value = low; value <= high; ++value) {
                        sb.append(", ").append(value).append(" -> ").append(offset + ((code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF));
                    }
                    offset = i - 1;
                    break;
                }
                case 171: {
                    int i = offset + 4 & 0xFFFC;
                    sb.append(" default").append(" -> ").append(offset + ((code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF));
                    int npairs = (code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF;
                    boolean j = false;
                    for (int k = 0; k < npairs; ++k) {
                        sb.append(", ").append((code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF);
                        sb.append(" -> ").append(offset + ((code[i++] & 0xFF) << 24 | (code[i++] & 0xFF) << 16 | (code[i++] & 0xFF) << 8 | code[i++] & 0xFF));
                    }
                    offset = i - 1;
                    break;
                }
                case 178: 
                case 179: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    String typeName = constants.getConstantTypeName(constantMemberRef.getClassIndex());
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String name = constants.getConstantUtf8(constantNameAndType.getNameIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    sb.append(" ").append(typeName).append('.').append(name).append(" : ").append(descriptor);
                    break;
                }
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String name = constants.getConstantUtf8(constantNameAndType.getNameIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    sb.append(" ").append(name).append(" : ").append(descriptor);
                    break;
                }
                case 185: 
                case 186: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String name = constants.getConstantUtf8(constantNameAndType.getNameIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    sb.append(" ").append(name).append(" : ").append(descriptor);
                    offset += 2;
                    break;
                }
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    String typeName = constants.getConstantTypeName((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    sb.append(" ").append(typeName);
                    break;
                }
                case 188: {
                    switch (code[++offset] & 0xFF) {
                        case 4: {
                            sb.append(" boolean");
                            break;
                        }
                        case 5: {
                            sb.append(" char");
                            break;
                        }
                        case 6: {
                            sb.append(" float");
                            break;
                        }
                        case 7: {
                            sb.append(" double");
                            break;
                        }
                        case 8: {
                            sb.append(" byte");
                            break;
                        }
                        case 9: {
                            sb.append(" short");
                            break;
                        }
                        case 10: {
                            sb.append(" int");
                            break;
                        }
                        case 11: {
                            sb.append(" long");
                        }
                    }
                    break;
                }
                case 196: {
                    opcode = code[++offset] & 0xFF;
                    int i = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    if (opcode == 132) {
                        sb.append(" iinc #").append(i).append(' ').append((short)((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF));
                        break;
                    }
                    switch (opcode) {
                        case 21: {
                            sb.append(" iload #").append(i);
                            break;
                        }
                        case 22: {
                            sb.append(" lload #").append(i);
                            break;
                        }
                        case 23: {
                            sb.append(" fload #").append(i);
                            break;
                        }
                        case 24: {
                            sb.append(" dload #").append(i);
                            break;
                        }
                        case 25: {
                            sb.append(" aload #").append(i);
                            break;
                        }
                        case 54: {
                            sb.append(" istore #").append(i);
                            break;
                        }
                        case 55: {
                            sb.append(" lstore #").append(i);
                            break;
                        }
                        case 56: {
                            sb.append(" fstore #").append(i);
                            break;
                        }
                        case 57: {
                            sb.append(" dstore #").append(i);
                            break;
                        }
                        case 58: {
                            sb.append(" astore #").append(i);
                            break;
                        }
                        case 169: {
                            sb.append(" ret #").append(i);
                        }
                    }
                    break;
                }
                case 197: {
                    String typeName = constants.getConstantTypeName((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    sb.append(typeName).append(' ').append(code[++offset] & 0xFF);
                    break;
                }
                case 198: 
                case 199: {
                    sb.append(" -> ").append(offset++ + (short)((code[offset] & 0xFF) << 8 | code[++offset] & 0xFF));
                    break;
                }
                case 200: 
                case 201: {
                    sb.append(" -> ").append(offset++ + ((code[offset] & 0xFF) << 24 | (code[++offset] & 0xFF) << 16 | (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF));
                }
            }
            sb.append('\n');
        }
    }

    protected static void writeLDC(StringBuilder sb, ConstantPool constants, Constant constant) {
        switch (constant.getTag()) {
            case 3: {
                sb.append(' ').append(((ConstantInteger)constant).getValue());
                break;
            }
            case 4: {
                sb.append(' ').append(((ConstantFloat)constant).getValue());
                break;
            }
            case 7: {
                int typeNameIndex = ((ConstantClass)constant).getNameIndex();
                sb.append(' ').append(((ConstantUtf8)constants.getConstant(typeNameIndex)).getValue());
                break;
            }
            case 5: {
                sb.append(' ').append(((ConstantLong)constant).getValue());
                break;
            }
            case 6: {
                sb.append(' ').append(((ConstantDouble)constant).getValue());
                break;
            }
            case 8: {
                sb.append(" '");
                int stringIndex = ((ConstantString)constant).getStringIndex();
                String str = constants.getConstantUtf8(stringIndex);
                block15: for (char c : str.toCharArray()) {
                    switch (c) {
                        case '\b': {
                            sb.append("\\\\b");
                            continue block15;
                        }
                        case '\f': {
                            sb.append("\\\\f");
                            continue block15;
                        }
                        case '\n': {
                            sb.append("\\\\n");
                            continue block15;
                        }
                        case '\r': {
                            sb.append("\\\\r");
                            continue block15;
                        }
                        case '\t': {
                            sb.append("\\\\t");
                            continue block15;
                        }
                        default: {
                            sb.append(c);
                        }
                    }
                }
                sb.append("'");
            }
        }
    }

    protected static void writeLineNumberTable(String linePrefix, StringBuilder sb, AttributeCode attributeCode) {
        AttributeLineNumberTable lineNumberTable = (AttributeLineNumberTable)attributeCode.getAttribute("LineNumberTable");
        if (lineNumberTable != null) {
            sb.append(linePrefix).append("Line number table:\n");
            sb.append(linePrefix).append("  Java source line number -> byte code offset\n");
            for (LineNumber lineNumber : lineNumberTable.getLineNumberTable()) {
                sb.append(linePrefix).append("  #");
                sb.append(lineNumber.getLineNumber()).append("\t-> ");
                sb.append(lineNumber.getStartPc()).append('\n');
            }
        }
    }

    protected static void writeLocalVariableTable(String linePrefix, StringBuilder sb, AttributeCode attributeCode) {
        AttributeLocalVariableTypeTable localVariableTypeTable;
        AttributeLocalVariableTable localVariableTable = (AttributeLocalVariableTable)attributeCode.getAttribute("LocalVariableTable");
        if (localVariableTable != null) {
            sb.append(linePrefix).append("Local variable table:\n");
            sb.append(linePrefix).append("  start\tlength\tslot\tname\tdescriptor\n");
            for (LocalVariable localVariable : localVariableTable.getLocalVariableTable()) {
                sb.append(linePrefix).append("  ");
                sb.append(localVariable.getStartPc()).append('\t');
                sb.append(localVariable.getLength()).append('\t');
                sb.append(localVariable.getIndex()).append('\t');
                sb.append(localVariable.getName()).append('\t');
                sb.append(localVariable.getDescriptor()).append('\n');
            }
        }
        if ((localVariableTypeTable = (AttributeLocalVariableTypeTable)attributeCode.getAttribute("LocalVariableTypeTable")) != null) {
            sb.append(linePrefix).append("Local variable type table:\n");
            sb.append(linePrefix).append("  start\tlength\tslot\tname\tsignature\n");
            for (LocalVariableType localVariable : localVariableTypeTable.getLocalVariableTypeTable()) {
                sb.append(linePrefix).append("  ");
                sb.append(localVariable.getStartPc()).append('\t');
                sb.append(localVariable.getLength()).append('\t');
                sb.append(localVariable.getIndex()).append('\t');
                sb.append(localVariable.getName()).append('\t');
                sb.append(localVariable.getSignature()).append('\n');
            }
        }
    }

    protected static void writeExceptionTable(String linePrefix, StringBuilder sb, ConstantPool constants, AttributeCode attributeCode) {
        CodeException[] codeExceptions = attributeCode.getExceptionTable();
        if (codeExceptions != null) {
            sb.append(linePrefix).append("Exception table:\n");
            sb.append(linePrefix).append("  from\tto\ttarget\ttype\n");
            for (CodeException codeException : codeExceptions) {
                sb.append(linePrefix).append("  ");
                sb.append(codeException.getStartPc()).append('\t');
                sb.append(codeException.getEndPc()).append('\t');
                sb.append(codeException.getHandlerPc()).append('\t');
                if (codeException.getCatchType() == 0) {
                    sb.append("finally");
                } else {
                    sb.append(constants.getConstantTypeName(codeException.getCatchType()));
                }
                sb.append('\n');
            }
        }
    }
}

