/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.ocf;

import com.adobe.epubcheck.api.EPUBLocation;
import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.ocf.EncryptionFilter;
import com.adobe.epubcheck.ocf.OCFData;
import com.adobe.epubcheck.ocf.OCFHandler;
import com.adobe.epubcheck.opf.OPFData;
import com.adobe.epubcheck.opf.OPFPeeker;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.util.GenericResourceProvider;
import com.adobe.epubcheck.util.InvalidVersionException;
import com.adobe.epubcheck.xml.XMLParser;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class OCFPackage
implements GenericResourceProvider {
    final Hashtable<String, EncryptionFilter> enc;
    String uniqueIdentifier;
    private Report reporter;
    private final Supplier<OCFData> ocfData = Suppliers.memoize(new Supplier<OCFData>(){

        @Override
        public OCFData get() {
            Preconditions.checkNotNull(OCFPackage.this.reporter);
            XMLParser containerParser = new XMLParser(new ValidationContext.ValidationContextBuilder().path("META-INF/container.xml").resourceProvider(OCFPackage.this).report(OCFPackage.this.reporter).mimetype("xml").build());
            OCFHandler containerHandler = new OCFHandler(containerParser);
            containerParser.addXMLHandler(containerHandler);
            containerParser.process();
            return containerHandler;
        }
    });
    private final Supplier<Map<String, OPFData>> opfData = Suppliers.memoize(new Supplier<Map<String, OPFData>>(){

        @Override
        public Map<String, OPFData> get() {
            Preconditions.checkNotNull(OCFPackage.this.reporter);
            HashMap<String, OPFData> result = new HashMap<String, OPFData>();
            for (String opfPath : ((OCFData)OCFPackage.this.ocfData.get()).getEntries("application/oebps-package+xml")) {
                OPFPeeker peeker = new OPFPeeker(opfPath, OCFPackage.this.reporter, OCFPackage.this);
                try {
                    result.put(opfPath, peeker.peek());
                }
                catch (InvalidVersionException e) {
                    OCFPackage.this.reporter.message(MessageId.OPF_001, EPUBLocation.create(opfPath), e.getMessage());
                }
                catch (IOException iOException) {}
            }
            return Collections.unmodifiableMap(result);
        }
    });

    public OCFPackage() {
        this.enc = new Hashtable();
    }

    public void setEncryption(String name, EncryptionFilter encryptionFilter) {
        this.enc.put(name, encryptionFilter);
    }

    public abstract boolean hasEntry(String var1);

    public abstract long getTimeEntry(String var1);

    @Override
    public abstract InputStream getInputStream(String var1) throws IOException;

    public abstract List<String> getEntries() throws IOException;

    public abstract Set<String> getFileEntries() throws IOException;

    public abstract Set<String> getDirectoryEntries() throws IOException;

    public boolean canDecrypt(String fileName) {
        EncryptionFilter filter = this.enc.get(fileName);
        return filter == null || filter.canDecrypt();
    }

    public OCFData getOcfData() {
        return this.ocfData.get();
    }

    public Map<String, OPFData> getOpfData() {
        return this.opfData.get();
    }

    public abstract void reportMetadata(String var1, Report var2);

    public abstract String getName();

    public abstract String getPackagePath();

    public void setReport(Report reporter) {
        this.reporter = reporter;
    }
}

