/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.store.jdbc.AbstractJDBCLocker;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaseDatabaseLocker
extends AbstractJDBCLocker {
    private static final Logger LOG = LoggerFactory.getLogger(LeaseDatabaseLocker.class);
    protected int maxAllowableDiffFromDBTime = 0;
    protected long diffFromCurrentTime = Long.MAX_VALUE;
    protected String leaseHolderId;
    protected boolean handleStartException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doStart() throws Exception {
        if (this.lockAcquireSleepInterval < this.lockable.getLockKeepAlivePeriod()) {
            LOG.warn("LockableService keep alive period: " + this.lockable.getLockKeepAlivePeriod() + ", which renews the lease, is greater than lockAcquireSleepInterval: " + this.lockAcquireSleepInterval + ", the lease duration. These values will allow the lease to expire.");
        }
        LOG.info(this.getLeaseHolderId() + " attempting to acquire exclusive lease to become the master");
        String sql = this.getStatements().getLeaseObtainStatement();
        LOG.debug(this.getLeaseHolderId() + " locking Query is " + sql);
        long now = 0L;
        while (!this.isStopping()) {
            PreparedStatement statement;
            Connection connection;
            block9: {
                connection = null;
                statement = null;
                connection = this.getConnection();
                this.initTimeDiff(connection);
                statement = connection.prepareStatement(sql);
                this.setQueryTimeout(statement);
                now = System.currentTimeMillis() + this.diffFromCurrentTime;
                statement.setString(1, this.getLeaseHolderId());
                statement.setLong(2, now + this.lockAcquireSleepInterval);
                statement.setLong(3, now);
                int result = statement.executeUpdate();
                if (result != 1 || !this.keepAlive()) break block9;
                this.close(statement);
                this.close(connection);
                break;
            }
            try {
                this.reportLeasOwnerShipAndDuration(connection);
            }
            catch (Exception e) {
                block10: {
                    try {
                        LOG.warn(this.getLeaseHolderId() + " lease acquire failure: " + e, e);
                        if (this.isStopping()) {
                            throw new Exception("Cannot start broker as being asked to shut down. Interrupted attempt to acquire lock: " + e, e);
                        }
                        if (!this.handleStartException) break block10;
                        this.lockable.getBrokerService().handleIOException(IOExceptionSupport.create(e));
                    }
                    catch (Throwable throwable) {
                        this.close(statement);
                        this.close(connection);
                        throw throwable;
                    }
                }
                this.close(statement);
                this.close(connection);
            }
            this.close(statement);
            this.close(connection);
            LOG.debug(this.getLeaseHolderId() + " failed to acquire lease.  Sleeping for " + this.lockAcquireSleepInterval + " milli(s) before trying again...");
            TimeUnit.MILLISECONDS.sleep(this.lockAcquireSleepInterval);
        }
        if (this.isStopping()) {
            throw new RuntimeException(this.getLeaseHolderId() + " failing lease acquire due to stop");
        }
        LOG.info(this.getLeaseHolderId() + ", becoming master with lease expiry " + new Date(now + this.lockAcquireSleepInterval) + " on dataSource: " + this.dataSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportLeasOwnerShipAndDuration(Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(this.getStatements().getLeaseOwnerStatement());
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                LOG.debug(this.getLeaseHolderId() + " Lease held by " + resultSet.getString(1) + " till " + new Date(resultSet.getLong(2)));
            }
        }
        catch (Throwable throwable) {
            this.close(statement);
            throw throwable;
        }
        this.close(statement);
    }

    protected long initTimeDiff(Connection connection) throws SQLException {
        if (Long.MAX_VALUE == this.diffFromCurrentTime) {
            this.diffFromCurrentTime = this.maxAllowableDiffFromDBTime > 0 ? this.determineTimeDifference(connection) : 0L;
        }
        return this.diffFromCurrentTime;
    }

    protected long determineTimeDifference(Connection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement(this.getStatements().getCurrentDateTime());
        ResultSet resultSet = statement.executeQuery();
        long result = 0L;
        if (resultSet.next()) {
            Timestamp timestamp = resultSet.getTimestamp(1);
            long diff = System.currentTimeMillis() - timestamp.getTime();
            if (Math.abs(diff) > (long)this.maxAllowableDiffFromDBTime) {
                result = -diff;
            }
            LOG.info(this.getLeaseHolderId() + " diff adjust from db: " + result + ", db time: " + timestamp);
        }
        return result;
    }

    @Override
    public void doStop(ServiceStopper stopper) throws Exception {
        if (this.lockable.getBrokerService() != null && this.lockable.getBrokerService().isRestartRequested()) {
            return;
        }
        this.releaseLease();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLease() {
        PreparedStatement statement;
        Connection connection;
        block4: {
            connection = null;
            statement = null;
            try {
                connection = this.getConnection();
                statement = connection.prepareStatement(this.getStatements().getLeaseUpdateStatement());
                statement.setString(1, null);
                statement.setLong(2, 0L);
                statement.setString(3, this.getLeaseHolderId());
                if (statement.executeUpdate() != 1) break block4;
                LOG.info(this.getLeaseHolderId() + ", released lease");
            }
            catch (Exception e) {
                try {
                    LOG.error(this.getLeaseHolderId() + " failed to release lease: " + e, e);
                }
                catch (Throwable throwable) {
                    this.close(statement);
                    this.close(connection);
                    throw throwable;
                }
                this.close(statement);
                this.close(connection);
            }
        }
        this.close(statement);
        this.close(connection);
    }

    @Override
    public boolean keepAlive() throws IOException {
        boolean result = false;
        String sql = this.getStatements().getLeaseUpdateStatement();
        LOG.debug(this.getLeaseHolderId() + ", lease keepAlive Query is " + sql);
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.getConnection();
            this.initTimeDiff(connection);
            statement = connection.prepareStatement(sql);
            this.setQueryTimeout(statement);
            long now = System.currentTimeMillis() + this.diffFromCurrentTime;
            statement.setString(1, this.getLeaseHolderId());
            statement.setLong(2, now + this.lockAcquireSleepInterval);
            statement.setString(3, this.getLeaseHolderId());
            boolean bl = result = statement.executeUpdate() == 1;
            if (!result) {
                this.reportLeasOwnerShipAndDuration(connection);
            }
        }
        catch (Exception e) {
            try {
                LOG.warn(this.getLeaseHolderId() + ", failed to update lease: " + e, e);
                IOException ioe = IOExceptionSupport.create(e);
                this.lockable.getBrokerService().handleIOException(ioe);
                throw ioe;
            }
            catch (Throwable throwable) {
                this.close(statement);
                this.close(connection);
                throw throwable;
            }
        }
        this.close(statement);
        this.close(connection);
        return result;
    }

    public String getLeaseHolderId() {
        if (this.leaseHolderId == null && this.lockable.getBrokerService() != null) {
            this.leaseHolderId = this.lockable.getBrokerService().getBrokerName();
        }
        return this.leaseHolderId;
    }

    public void setLeaseHolderId(String leaseHolderId) {
        this.leaseHolderId = leaseHolderId;
    }

    public int getMaxAllowableDiffFromDBTime() {
        return this.maxAllowableDiffFromDBTime;
    }

    public void setMaxAllowableDiffFromDBTime(int maxAllowableDiffFromDBTime) {
        this.maxAllowableDiffFromDBTime = maxAllowableDiffFromDBTime;
    }

    public boolean isHandleStartException() {
        return this.handleStartException;
    }

    public void setHandleStartException(boolean handleStartException) {
        this.handleStartException = handleStartException;
    }

    public String toString() {
        return "LeaseDatabaseLocker owner:" + this.leaseHolderId + ",duration:" + this.lockAcquireSleepInterval + ",renew:" + this.lockAcquireSleepInterval;
    }
}

