/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RedeliveryPolicyDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.processor.FatalFallbackErrorHandler;
import org.apache.camel.processor.RedeliveryPolicy;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ExpressionToPredicateAdapter;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="error")
@XmlRootElement(name="onException")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnExceptionDefinition
extends ProcessorDefinition<OnExceptionDefinition> {
    @XmlElement(name="exception", required=true)
    private List<String> exceptions = new ArrayList<String>();
    @XmlElement(name="onWhen")
    private WhenDefinition onWhen;
    @XmlElement(name="retryWhile")
    private ExpressionSubElementDefinition retryWhile;
    @XmlElement(name="redeliveryPolicy")
    private RedeliveryPolicyDefinition redeliveryPolicyType;
    @XmlAttribute(name="redeliveryPolicyRef")
    private String redeliveryPolicyRef;
    @XmlElement(name="handled")
    private ExpressionSubElementDefinition handled;
    @XmlElement(name="continued")
    private ExpressionSubElementDefinition continued;
    @XmlAttribute(name="onRedeliveryRef")
    private String onRedeliveryRef;
    @XmlAttribute(name="useOriginalMessage")
    private Boolean useOriginalMessagePolicy;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();
    @XmlTransient
    private List<Class<? extends Throwable>> exceptionClasses;
    @XmlTransient
    private Predicate handledPolicy;
    @XmlTransient
    private Predicate continuedPolicy;
    @XmlTransient
    private Predicate retryWhilePolicy;
    @XmlTransient
    private Processor onRedelivery;
    @XmlTransient
    private Boolean routeScoped;
    @XmlTransient
    private final Map<String, Processor> errorHandlers = new HashMap<String, Processor>();
    @XmlTransient
    private RedeliveryPolicy redeliveryPolicy;

    public OnExceptionDefinition() {
    }

    public OnExceptionDefinition(List<Class<? extends Throwable>> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public OnExceptionDefinition(Class<? extends Throwable> exceptionType) {
        this.exceptionClasses = new ArrayList<Class<? extends Throwable>>();
        this.exceptionClasses.add(exceptionType);
    }

    public void setRouteScoped(boolean routeScoped) {
        this.routeScoped = routeScoped;
    }

    public boolean isRouteScoped() {
        return this.routeScoped != null ? this.routeScoped : false;
    }

    public String toString() {
        return "OnException[" + this.description() + " -> " + this.getOutputs() + "]";
    }

    protected String description() {
        return this.getExceptionClasses() + (this.onWhen != null ? " " + this.onWhen : "");
    }

    @Override
    public String getLabel() {
        return "onException[" + this.description() + "]";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    public RedeliveryPolicy createRedeliveryPolicy(CamelContext context, RedeliveryPolicy parentPolicy) {
        if (this.redeliveryPolicy != null) {
            return this.redeliveryPolicy;
        }
        if (this.redeliveryPolicyRef != null) {
            return CamelContextHelper.mandatoryLookup(context, this.redeliveryPolicyRef, RedeliveryPolicy.class);
        }
        if (this.redeliveryPolicyType != null) {
            return this.redeliveryPolicyType.createRedeliveryPolicy(context, parentPolicy);
        }
        if (!this.outputs.isEmpty() && parentPolicy.getMaximumRedeliveries() != 0) {
            RedeliveryPolicy answer = parentPolicy.copy();
            answer.setMaximumRedeliveries(0);
            return answer;
        }
        return parentPolicy;
    }

    @Override
    public void addRoutes(RouteContext routeContext, Collection<Route> routes) throws Exception {
        if (this.routeScoped == null) {
            this.routeScoped = super.getParent() != null;
        }
        this.setHandledFromExpressionType(routeContext);
        this.setContinuedFromExpressionType(routeContext);
        this.setRetryWhileFromExpressionType(routeContext);
        this.setOnRedeliveryFromRedeliveryRef(routeContext);
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            this.exceptionClasses = this.createExceptionClasses(routeContext.getCamelContext().getClassResolver());
        }
        this.validateConfiguration();
        Processor child = this.createOutputsProcessor(routeContext);
        if (child != null) {
            FatalFallbackErrorHandler errorHandler = new FatalFallbackErrorHandler(child);
            String id = routeContext.getRoute().getId();
            this.errorHandlers.put(id, errorHandler);
        }
        ErrorHandlerBuilder builder = (ErrorHandlerBuilder)routeContext.getRoute().getErrorHandlerBuilder();
        builder.addErrorHandlers(routeContext, this);
    }

    @Override
    public CatchProcessor createProcessor(RouteContext routeContext) throws Exception {
        if (this.exceptions != null && !this.exceptions.isEmpty()) {
            this.exceptionClasses = this.createExceptionClasses(routeContext.getCamelContext().getClassResolver());
        }
        this.validateConfiguration();
        Processor childProcessor = this.createChildProcessor(routeContext, false);
        Predicate when = null;
        if (this.onWhen != null) {
            when = this.onWhen.getExpression().createPredicate(routeContext);
        }
        Predicate handle = null;
        if (this.handled != null) {
            handle = this.handled.createPredicate(routeContext);
        }
        return new CatchProcessor(this.getExceptionClasses(), childProcessor, when, handle);
    }

    protected void validateConfiguration() {
        if (this.isInheritErrorHandler() != null && this.isInheritErrorHandler().booleanValue()) {
            throw new IllegalArgumentException(this + " cannot have the inheritErrorHandler option set to true");
        }
        List<Class<? extends Throwable>> exceptions = this.getExceptionClasses();
        if (exceptions == null || exceptions.isEmpty()) {
            throw new IllegalArgumentException("At least one exception must be configured on " + this);
        }
        if (this.getHandledPolicy() != null && this.getContinuedPolicy() != null) {
            throw new IllegalArgumentException("Only one of handled or continued is allowed to be configured on: " + this);
        }
        if ((this.outputs == null || this.getOutputs().isEmpty()) && this.handledPolicy == null && this.continuedPolicy == null && this.retryWhilePolicy == null && this.redeliveryPolicyType == null && this.useOriginalMessagePolicy == null && this.onRedelivery == null) {
            throw new IllegalArgumentException(this + " is not configured.");
        }
    }

    @Override
    public OnExceptionDefinition onException(Class<? extends Throwable> exceptionType) {
        this.getExceptionClasses().add(exceptionType);
        return this;
    }

    public OnExceptionDefinition handled(boolean handled) {
        Expression expression = ExpressionBuilder.constantExpression(Boolean.toString(handled));
        return this.handled(expression);
    }

    public OnExceptionDefinition handled(Predicate handled) {
        this.setHandledPolicy(handled);
        return this;
    }

    public OnExceptionDefinition handled(Expression handled) {
        this.setHandledPolicy(ExpressionToPredicateAdapter.toPredicate(handled));
        return this;
    }

    public OnExceptionDefinition continued(boolean continued) {
        Expression expression = ExpressionBuilder.constantExpression(Boolean.toString(continued));
        return this.continued(expression);
    }

    public OnExceptionDefinition continued(Predicate continued) {
        this.setContinuedPolicy(continued);
        return this;
    }

    public OnExceptionDefinition continued(Expression continued) {
        this.setContinuedPolicy(ExpressionToPredicateAdapter.toPredicate(continued));
        return this;
    }

    public OnExceptionDefinition onWhen(Predicate predicate) {
        this.setOnWhen(new WhenDefinition(predicate));
        return this;
    }

    public OnExceptionDefinition retryWhile(Predicate retryWhile) {
        this.setRetryWhilePolicy(retryWhile);
        return this;
    }

    @Deprecated
    public OnExceptionDefinition redeliverDelay(long delay) {
        this.getOrCreateRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public OnExceptionDefinition backOffMultiplier(double backOffMultiplier) {
        this.getOrCreateRedeliveryPolicy().useExponentialBackOff();
        this.getOrCreateRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public OnExceptionDefinition backOffMultiplier(String backOffMultiplier) {
        this.getOrCreateRedeliveryPolicy().useExponentialBackOff();
        this.getOrCreateRedeliveryPolicy().backOffMultiplier(backOffMultiplier);
        return this;
    }

    public OnExceptionDefinition collisionAvoidanceFactor(double collisionAvoidanceFactor) {
        this.getOrCreateRedeliveryPolicy().useCollisionAvoidance();
        this.getOrCreateRedeliveryPolicy().collisionAvoidanceFactor(collisionAvoidanceFactor);
        return this;
    }

    public OnExceptionDefinition collisionAvoidanceFactor(String collisionAvoidanceFactor) {
        this.getOrCreateRedeliveryPolicy().useCollisionAvoidance();
        this.getOrCreateRedeliveryPolicy().collisionAvoidanceFactor(collisionAvoidanceFactor);
        return this;
    }

    public OnExceptionDefinition collisionAvoidancePercent(double collisionAvoidancePercent) {
        this.getOrCreateRedeliveryPolicy().useCollisionAvoidance();
        this.getOrCreateRedeliveryPolicy().collisionAvoidancePercent(collisionAvoidancePercent);
        return this;
    }

    public OnExceptionDefinition redeliveryDelay(long delay) {
        this.getOrCreateRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public OnExceptionDefinition redeliveryDelay(String delay) {
        this.getOrCreateRedeliveryPolicy().redeliveryDelay(delay);
        return this;
    }

    public OnExceptionDefinition asyncDelayedRedelivery() {
        this.getOrCreateRedeliveryPolicy().asyncDelayedRedelivery();
        return this;
    }

    public OnExceptionDefinition retriesExhaustedLogLevel(LoggingLevel retriesExhaustedLogLevel) {
        this.getOrCreateRedeliveryPolicy().retriesExhaustedLogLevel(retriesExhaustedLogLevel);
        return this;
    }

    public OnExceptionDefinition retryAttemptedLogLevel(LoggingLevel retryAttemptedLogLevel) {
        this.getOrCreateRedeliveryPolicy().retryAttemptedLogLevel(retryAttemptedLogLevel);
        return this;
    }

    public OnExceptionDefinition logStackTrace(boolean logStackTrace) {
        this.getOrCreateRedeliveryPolicy().logStackTrace(logStackTrace);
        return this;
    }

    public OnExceptionDefinition logStackTrace(String logStackTrace) {
        this.getOrCreateRedeliveryPolicy().logStackTrace(logStackTrace);
        return this;
    }

    public OnExceptionDefinition logRetryStackTrace(boolean logRetryStackTrace) {
        this.getOrCreateRedeliveryPolicy().logRetryStackTrace(logRetryStackTrace);
        return this;
    }

    public OnExceptionDefinition logRetryStackTrace(String logRetryStackTrace) {
        this.getOrCreateRedeliveryPolicy().logRetryStackTrace(logRetryStackTrace);
        return this;
    }

    public OnExceptionDefinition logHandled(boolean logHandled) {
        this.getOrCreateRedeliveryPolicy().logHandled(logHandled);
        return this;
    }

    public OnExceptionDefinition logHandled(String logHandled) {
        this.getOrCreateRedeliveryPolicy().logHandled(logHandled);
        return this;
    }

    public OnExceptionDefinition logNewException(boolean logNewException) {
        this.getOrCreateRedeliveryPolicy().logNewException(logNewException);
        return this;
    }

    public OnExceptionDefinition logNewException(String logNewException) {
        this.getOrCreateRedeliveryPolicy().logNewException(logNewException);
        return this;
    }

    public OnExceptionDefinition logContinued(boolean logContinued) {
        this.getOrCreateRedeliveryPolicy().logContinued(logContinued);
        return this;
    }

    public OnExceptionDefinition logContinued(String logContinued) {
        this.getOrCreateRedeliveryPolicy().logContinued(logContinued);
        return this;
    }

    public OnExceptionDefinition logRetryAttempted(boolean logRetryAttempted) {
        this.getOrCreateRedeliveryPolicy().logRetryAttempted(logRetryAttempted);
        return this;
    }

    public OnExceptionDefinition logRetryAttempted(String logRetryAttempted) {
        this.getOrCreateRedeliveryPolicy().logRetryAttempted(logRetryAttempted);
        return this;
    }

    public OnExceptionDefinition logExhausted(boolean logExhausted) {
        this.getOrCreateRedeliveryPolicy().logExhausted(logExhausted);
        return this;
    }

    public OnExceptionDefinition logExhausted(String logExhausted) {
        this.getOrCreateRedeliveryPolicy().logExhausted(logExhausted);
        return this;
    }

    public OnExceptionDefinition logExhaustedMessageHistory(boolean logExhaustedMessageHistory) {
        this.getOrCreateRedeliveryPolicy().logExhaustedMessageHistory(logExhaustedMessageHistory);
        return this;
    }

    public OnExceptionDefinition logExhaustedMessageHistory(String logExhaustedMessageHistory) {
        this.getOrCreateRedeliveryPolicy().logExhaustedMessageHistory(logExhaustedMessageHistory);
        return this;
    }

    public OnExceptionDefinition maximumRedeliveries(int maximumRedeliveries) {
        this.getOrCreateRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public OnExceptionDefinition maximumRedeliveries(String maximumRedeliveries) {
        this.getOrCreateRedeliveryPolicy().maximumRedeliveries(maximumRedeliveries);
        return this;
    }

    public OnExceptionDefinition useCollisionAvoidance() {
        this.getOrCreateRedeliveryPolicy().useCollisionAvoidance();
        return this;
    }

    public OnExceptionDefinition useExponentialBackOff() {
        this.getOrCreateRedeliveryPolicy().useExponentialBackOff();
        return this;
    }

    public OnExceptionDefinition maximumRedeliveryDelay(long maximumRedeliveryDelay) {
        this.getOrCreateRedeliveryPolicy().maximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public OnExceptionDefinition maximumRedeliveryDelay(String maximumRedeliveryDelay) {
        this.getOrCreateRedeliveryPolicy().maximumRedeliveryDelay(maximumRedeliveryDelay);
        return this;
    }

    public OnExceptionDefinition redeliveryPolicy(RedeliveryPolicy redeliveryPolicy) {
        this.redeliveryPolicy = redeliveryPolicy;
        return this;
    }

    public OnExceptionDefinition redeliveryPolicyRef(String redeliveryPolicyRef) {
        this.setRedeliveryPolicyRef(redeliveryPolicyRef);
        return this;
    }

    public OnExceptionDefinition delayPattern(String delayPattern) {
        this.getOrCreateRedeliveryPolicy().setDelayPattern(delayPattern);
        return this;
    }

    @Deprecated
    public OnExceptionDefinition useOriginalBody() {
        this.setUseOriginalMessagePolicy(Boolean.TRUE);
        return this;
    }

    public OnExceptionDefinition useOriginalMessage() {
        this.setUseOriginalMessagePolicy(Boolean.TRUE);
        return this;
    }

    public OnExceptionDefinition onRedelivery(Processor processor) {
        this.setOnRedelivery(processor);
        return this;
    }

    public OnExceptionDefinition onRedeliveryRef(String ref) {
        this.setOnRedeliveryRef(ref);
        return this;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
    }

    @Override
    public boolean isOutputSupported() {
        return true;
    }

    public List<Class<? extends Throwable>> getExceptionClasses() {
        return this.exceptionClasses;
    }

    public void setExceptionClasses(List<Class<? extends Throwable>> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public Processor getErrorHandler(String routeId) {
        return this.errorHandlers.get(routeId);
    }

    public Collection<Processor> getErrorHandlers() {
        return this.errorHandlers.values();
    }

    public RedeliveryPolicyDefinition getRedeliveryPolicy() {
        return this.redeliveryPolicyType;
    }

    public void setRedeliveryPolicy(RedeliveryPolicyDefinition redeliveryPolicy) {
        this.redeliveryPolicyType = redeliveryPolicy;
    }

    public RedeliveryPolicyDefinition getRedeliveryPolicyType() {
        return this.redeliveryPolicyType;
    }

    public void setRedeliveryPolicyType(RedeliveryPolicyDefinition redeliveryPolicyType) {
        this.redeliveryPolicyType = redeliveryPolicyType;
    }

    public String getRedeliveryPolicyRef() {
        return this.redeliveryPolicyRef;
    }

    public void setRedeliveryPolicyRef(String redeliveryPolicyRef) {
        this.redeliveryPolicyRef = redeliveryPolicyRef;
    }

    public Predicate getHandledPolicy() {
        return this.handledPolicy;
    }

    public void setHandled(ExpressionSubElementDefinition handled) {
        this.handled = handled;
    }

    public ExpressionSubElementDefinition getContinued() {
        return this.continued;
    }

    public void setContinued(ExpressionSubElementDefinition continued) {
        this.continued = continued;
    }

    public ExpressionSubElementDefinition getHandled() {
        return this.handled;
    }

    public void setHandledPolicy(Predicate handledPolicy) {
        this.handledPolicy = handledPolicy;
    }

    public Predicate getContinuedPolicy() {
        return this.continuedPolicy;
    }

    public void setContinuedPolicy(Predicate continuedPolicy) {
        this.continuedPolicy = continuedPolicy;
    }

    public WhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(WhenDefinition onWhen) {
        this.onWhen = onWhen;
    }

    public ExpressionSubElementDefinition getRetryWhile() {
        return this.retryWhile;
    }

    public void setRetryWhile(ExpressionSubElementDefinition retryWhile) {
        this.retryWhile = retryWhile;
    }

    public Predicate getRetryWhilePolicy() {
        return this.retryWhilePolicy;
    }

    public void setRetryWhilePolicy(Predicate retryWhilePolicy) {
        this.retryWhilePolicy = retryWhilePolicy;
    }

    public Processor getOnRedelivery() {
        return this.onRedelivery;
    }

    public void setOnRedelivery(Processor onRedelivery) {
        this.onRedelivery = onRedelivery;
    }

    public String getOnRedeliveryRef() {
        return this.onRedeliveryRef;
    }

    public void setOnRedeliveryRef(String onRedeliveryRef) {
        this.onRedeliveryRef = onRedeliveryRef;
    }

    public Boolean getUseOriginalMessagePolicy() {
        return this.useOriginalMessagePolicy;
    }

    public void setUseOriginalMessagePolicy(Boolean useOriginalMessagePolicy) {
        this.useOriginalMessagePolicy = useOriginalMessagePolicy;
    }

    protected boolean isAsyncDelayedRedelivery(CamelContext context) {
        if (this.getRedeliveryPolicy() != null) {
            return this.getRedeliveryPolicy().isAsyncDelayedRedelivery(context);
        }
        return false;
    }

    protected RedeliveryPolicyDefinition getOrCreateRedeliveryPolicy() {
        if (this.redeliveryPolicyType == null) {
            this.redeliveryPolicyType = new RedeliveryPolicyDefinition();
        }
        return this.redeliveryPolicyType;
    }

    protected List<Class<? extends Throwable>> createExceptionClasses(ClassResolver resolver) throws ClassNotFoundException {
        List<String> list = this.getExceptions();
        ArrayList<Class<? extends Throwable>> answer = new ArrayList<Class<? extends Throwable>>(list.size());
        for (String name : list) {
            Class<Throwable> type = resolver.resolveMandatoryClass(name, Throwable.class);
            answer.add(type);
        }
        return answer;
    }

    private void setHandledFromExpressionType(RouteContext routeContext) {
        if (this.getHandled() != null && this.handledPolicy == null && routeContext != null) {
            this.handled(this.getHandled().createPredicate(routeContext));
        }
    }

    private void setContinuedFromExpressionType(RouteContext routeContext) {
        if (this.getContinued() != null && this.continuedPolicy == null && routeContext != null) {
            this.continued(this.getContinued().createPredicate(routeContext));
        }
    }

    private void setRetryWhileFromExpressionType(RouteContext routeContext) {
        if (this.getRetryWhile() != null && this.retryWhilePolicy == null && routeContext != null) {
            this.retryWhile(this.getRetryWhile().createPredicate(routeContext));
        }
    }

    private void setOnRedeliveryFromRedeliveryRef(RouteContext routeContext) {
        if (ObjectHelper.isNotEmpty(this.onRedeliveryRef)) {
            Processor onRedelivery = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.onRedeliveryRef, Processor.class);
            this.setOnRedelivery(onRedelivery);
        }
    }
}

