/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointConfiguration;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.ParameterConfiguration;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.IntrospectionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriEndpointConfiguration
implements EndpointConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(UriEndpointConfiguration.class);
    private final CamelContext camelContext;
    private final Endpoint endpoint;
    private String uriText;
    private URI uri;
    private SortedMap<String, ParameterConfiguration> propertyMap;

    public UriEndpointConfiguration(CamelContext camelContext, Endpoint endpoint, String uriText) {
        this.camelContext = camelContext;
        this.endpoint = endpoint;
        this.uriText = uriText;
    }

    @Override
    public URI getURI() {
        if (this.uri == null) {
            try {
                this.uri = new URI(this.uriText);
            }
            catch (URISyntaxException e) {
                throw new RuntimeCamelException(e);
            }
        }
        return this.uri;
    }

    public void setURI(URI uri) {
        this.uriText = null;
        this.uri = uri;
    }

    @Override
    public <T> T getParameter(String name) throws RuntimeCamelException {
        ParameterConfiguration config = this.getPropertyConfiguration(name);
        try {
            Object answer = IntrospectionSupport.getProperty(this.endpoint, name);
            if (config == null) {
                this.warnMissingUriParamOnProperty(name);
            }
            return (T)answer;
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to get property '" + name + "' on " + this.endpoint + " due " + e.getMessage(), e);
        }
    }

    protected void warnMissingUriParamOnProperty(String name) {
        LOG.warn("Using property " + name + " on endpoint " + this.getEndpointClass().getName() + " which does not have a @UriParam annotation! " + "Please add the @UriParam annotation to the " + name + " field");
    }

    @Override
    public <T> void setParameter(String name, T value) throws RuntimeCamelException {
        ParameterConfiguration config = this.getPropertyConfiguration(name);
        try {
            IntrospectionSupport.setProperty(this.endpoint, name, value);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Failed to set property '" + name + "' on " + this.endpoint + " to value " + value + " due " + e.getMessage(), e);
        }
        if (config == null) {
            this.warnMissingUriParamOnProperty(name);
        }
    }

    @Override
    public String toUriString(EndpointConfiguration.UriFormat format) {
        return null;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Class<? extends Endpoint> getEndpointClass() {
        return this.endpoint.getClass();
    }

    public ParameterConfiguration getPropertyConfiguration(String name) {
        return (ParameterConfiguration)this.getPropertyConfigurationMap().get(name);
    }

    public SortedMap<String, ParameterConfiguration> getPropertyConfigurationMap() {
        if (this.propertyMap == null) {
            this.propertyMap = UriEndpointComponent.createParameterConfigurationMap(this.getEndpointClass());
        }
        return new TreeMap<String, ParameterConfiguration>(this.propertyMap);
    }
}

