/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.activemq.jaas.CertificateLoginModule;

public class TextFileCertificateLoginModule
extends CertificateLoginModule {
    private static final String USER_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.user";
    private static final String GROUP_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.group";
    private Map<String, Set<String>> groupsByUser;
    private Map<String, String> usersByDn;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.usersByDn = this.load(USER_FILE_PROP_NAME, "", options).invertedPropertiesMap();
        this.groupsByUser = this.load(GROUP_FILE_PROP_NAME, "", options).invertedPropertiesValuesMap();
    }

    @Override
    protected String getUserNameForCertificates(X509Certificate[] certs) throws LoginException {
        if (certs == null) {
            throw new LoginException("Client certificates not found. Cannot authenticate.");
        }
        return this.usersByDn.get(this.getDistinguishedName(certs));
    }

    @Override
    protected Set<String> getUserGroups(String username) throws LoginException {
        Set<String> userGroups = this.groupsByUser.get(username);
        if (userGroups == null) {
            userGroups = Collections.emptySet();
        }
        return userGroups;
    }
}

