/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.sql.DataSourceCollection;
import ca.sqlpower.sql.SPDataSource;
import ca.sqlpower.swingui.Messages;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.db.DatabaseConnectionManager;
import ca.sqlpower.swingui.db.DefaultDataSourceDialogFactory;
import ca.sqlpower.swingui.db.DefaultDataSourceTypeDialogFactory;
import ca.sqlpower.util.UserPrompter;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class DataSourceUserPrompter
implements UserPrompter {
    private SPDataSource selectedDataSource;
    private UserPrompter.UserPromptResponse response;
    private DatabaseConnectionManager connectionManager;
    private JDialog dialog;
    private JFrame owner;

    public DataSourceUserPrompter(String question, UserPrompter.UserPromptOptions optionType, UserPrompter.UserPromptResponse defaultResponseType, SPDataSource defaultResponse, JFrame owner, String questionMessage, DataSourceCollection<SPDataSource> dsCollection, List<Class<? extends SPDataSource>> dsTypes, String ... buttonNames) {
        if (optionType.getButtonCount() != buttonNames.length) {
            throw new IllegalStateException("Expecting " + optionType.getButtonCount() + "arguments for the optionType " + (Object)((Object)optionType) + "Recieved only " + buttonNames.length + "arguments\n" + Arrays.toString(buttonNames));
        }
        this.owner = owner;
        ArrayList<JComponent> additionalComponents = new ArrayList<JComponent>();
        additionalComponents.add(new JSeparator(0));
        if (optionType == UserPrompter.UserPromptOptions.OK_NEW_NOTOK_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_NEW_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_CANCEL) {
            JButton okButton = new JButton();
            okButton.setAction(new AbstractAction(buttonNames[0]){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataSourceUserPrompter.this.selectedDataSource = DataSourceUserPrompter.this.connectionManager.getSelectedConnection();
                    DataSourceUserPrompter.this.response = UserPrompter.UserPromptResponse.OK;
                    DataSourceUserPrompter.this.dialog.setVisible(false);
                }
            });
            additionalComponents.add(okButton);
        }
        if (optionType == UserPrompter.UserPromptOptions.OK_NEW_NOTOK_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL) {
            AbstractAction skipAction = new AbstractAction(optionType == UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL ? buttonNames[1] : buttonNames[2]){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataSourceUserPrompter.this.selectedDataSource = null;
                    DataSourceUserPrompter.this.response = UserPrompter.UserPromptResponse.NOT_OK;
                    DataSourceUserPrompter.this.dialog.setVisible(false);
                }
            };
            JButton skipButton = new JButton(skipAction);
            additionalComponents.add(skipButton);
        }
        if (optionType == UserPrompter.UserPromptOptions.OK_NEW_NOTOK_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_NOTOK_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_NEW_CANCEL || optionType == UserPrompter.UserPromptOptions.OK_CANCEL) {
            JButton cancelButton = new JButton();
            cancelButton.setAction(new AbstractAction(buttonNames[buttonNames.length - 1]){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataSourceUserPrompter.this.selectedDataSource = null;
                    DataSourceUserPrompter.this.response = UserPrompter.UserPromptResponse.CANCEL;
                    DataSourceUserPrompter.this.dialog.setVisible(false);
                }
            });
            additionalComponents.add(cancelButton);
        }
        this.dialog = new JDialog();
        boolean showCloseButton = false;
        ArrayList<Action> additionalActions = new ArrayList<Action>();
        this.connectionManager = new DatabaseConnectionManager(dsCollection, new DefaultDataSourceDialogFactory(), new DefaultDataSourceTypeDialogFactory(dsCollection), additionalActions, additionalComponents, owner, showCloseButton, dsTypes);
        JPanel connectionPanel = this.connectionManager.createPanelStandalone(additionalActions, additionalComponents, showCloseButton, question, this.dialog);
        connectionPanel.setVisible(true);
        this.dialog.add(connectionPanel);
        this.dialog.setTitle("Data Source Replacement Tool");
    }

    @Override
    public Object getUserSelectedResponse() {
        return this.selectedDataSource;
    }

    @Override
    public UserPrompter.UserPromptResponse promptUser(Object ... formatArgs) {
        this.response = UserPrompter.UserPromptResponse.NOT_OK;
        Runnable promptUser = new Runnable(){

            @Override
            public void run() {
                DataSourceUserPrompter.this.dialog.pack();
                DataSourceUserPrompter.this.dialog.invalidate();
                if (DataSourceUserPrompter.this.owner != null) {
                    DataSourceUserPrompter.this.dialog.setLocationRelativeTo(DataSourceUserPrompter.this.owner);
                } else {
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    int x = screenSize.width / 2 - ((DataSourceUserPrompter)DataSourceUserPrompter.this).dialog.getSize().width / 2;
                    int y = screenSize.height / 2 - ((DataSourceUserPrompter)DataSourceUserPrompter.this).dialog.getSize().height / 2;
                    DataSourceUserPrompter.this.dialog.setLocation(x, y);
                }
                DataSourceUserPrompter.this.dialog.setVisible(true);
            }
        };
        this.dialog.setModal(true);
        if (SwingUtilities.isEventDispatchThread()) {
            promptUser.run();
            this.dialog.requestFocusInWindow();
        } else {
            try {
                SwingUtilities.invokeAndWait(promptUser);
            }
            catch (InterruptedException e) {
                SPSUtils.showExceptionDialogNoReport(null, Messages.getString("ModalDialogUserPrompter.showPromptDialogFailed"), e);
            }
            catch (InvocationTargetException e) {
                SPSUtils.showExceptionDialogNoReport(null, Messages.getString("ModalDialogUserPrompter.showPromptDialogFailed"), e);
            }
        }
        return this.response;
    }
}

