/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.transport.jms;

import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFireRuntimeException;
import org.codehaus.xfire.addressing.RandomGUID;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.exchange.OutMessage;
import org.codehaus.xfire.fault.XFireFault;
import org.codehaus.xfire.transport.AbstractChannel;
import org.codehaus.xfire.transport.jms.JMSTransport;
import org.codehaus.xfire.util.STAXUtils;

public class JMSChannel
extends AbstractChannel
implements MessageListener {
    public static final String REPLY_TO = "jms.replyTo";
    public static final String JMS_URI = "urn:codehaus:xfire:jms";
    private static final Log log = LogFactory.getLog((Class)JMSChannel.class);
    private Session session;
    private Connection connection;
    private Destination destination;
    private MessageConsumer consumer;
    private boolean isTopic = false;
    private String selector = "";
    private String destName = "";
    String MyID = new RandomGUID().toString();

    public JMSChannel(String uri, JMSTransport transport) {
        this.setUri(uri);
        this.setTransport(transport);
        this.initialize();
    }

    public void open() throws JMSException {
        if (this.session != null) {
            return;
        }
        JMSTransport transport = (JMSTransport)this.getTransport();
        this.connection = transport.getConnectionFactory().createConnection();
        this.connection.start();
        this.session = this.connection.createSession(false, 1);
        String destinationName = this.getDestinationName();
        this.destination = this.isTopic ? this.session.createTopic(destinationName) : this.session.createQueue(destinationName);
        this.consumer = this.createConsumer();
        this.consumer.setMessageListener((MessageListener)this);
    }

    protected MessageConsumer createConsumer() throws JMSException {
        if (!this.isTopic || this.selector.equals("")) {
            return this.session.createConsumer(this.destination);
        }
        return this.session.createConsumer(this.destination, this.createMessageSelector());
    }

    private String createMessageSelector() {
        System.out.println("JMSType='" + this.selector + "' and Source<>'" + this.MyID + "'");
        return "JMSType='" + this.selector + "' and Source<>'" + this.MyID + "')";
    }

    private String getDestinationName() {
        return this.destName;
    }

    private String getDestinationName(String uri) {
        int i = uri.indexOf("://");
        if (i == -1) {
            throw new XFireRuntimeException("Invalid JMS URI: " + uri);
        }
        String destName = "";
        int posQMark = uri.indexOf("?", i + 4);
        destName = posQMark > 0 ? uri.substring(i + 3, posQMark) : uri.substring(i + 3);
        return destName;
    }

    private void initialize() {
        String uri = this.getUri();
        int i = uri.indexOf("://");
        if (i == -1) {
            throw new XFireRuntimeException("Invalid JMS URI: " + uri);
        }
        int posQMark = uri.indexOf("?", i + 4);
        if (posQMark > 0) {
            this.destName = uri.substring(i + 3, posQMark);
            int posEqual = uri.indexOf("=", posQMark + 1);
            if (posEqual > 0) {
                if (uri.substring(posQMark + 1, posEqual).trim().equalsIgnoreCase("topic")) {
                    this.isTopic = true;
                }
                this.selector = uri.substring(posEqual + 1);
            } else {
                this.selector = uri.substring(posQMark + 1);
            }
            if (this.selector.equals(".")) {
                this.selector = "";
            }
        } else {
            this.destName = uri.substring(i + 3);
            int posEMark = this.destName.indexOf("!");
            if (posEMark > 0) {
                this.selector = this.destName.substring(posEMark + 1);
            }
        }
    }

    public void send(MessageContext context, OutMessage message) throws XFireFault {
        String msgString = this.getMessageAsString(context, message);
        try {
            Destination dest = (Destination)context.getProperty(REPLY_TO);
            String responseUri = message.getUri();
            TextMessage jmsMessage = this.session.createTextMessage();
            jmsMessage.setText(msgString);
            jmsMessage.setJMSCorrelationID(context.getId());
            if (dest == null) {
                if (!this.isTopic) {
                    dest = this.session.createQueue(this.getDestinationName(responseUri));
                    jmsMessage.setJMSReplyTo(this.destination);
                } else {
                    dest = this.session.createTopic(this.getDestinationName());
                    jmsMessage.setJMSReplyTo(dest);
                }
            }
            if (!this.selector.equals("")) {
                jmsMessage.setJMSType(this.selector);
                jmsMessage.setStringProperty("Source", this.MyID);
                String destID = (String)context.getProperty("Destination");
                if (destID == null) {
                    jmsMessage.setStringProperty("Destination", destID);
                }
            }
            this.session.createProducer(null).send(dest, (Message)jmsMessage);
            log.info((Object)("Sent message: Source ID: " + this.MyID + " Destination: " + jmsMessage.getStringProperty("Destination") + " JMSType: " + jmsMessage.getJMSType()));
        }
        catch (JMSException e) {
            throw new XFireFault("Error sending message", e, XFireFault.SENDER);
        }
    }

    private String getMessageAsString(MessageContext context, OutMessage message) throws XFireFault {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLStreamWriter writer = STAXUtils.createXMLStreamWriter(out, message.getEncoding(), context);
        message.getSerializer().writeMessage(message, writer, context);
        try {
            writer.flush();
            writer.close();
            out.close();
        }
        catch (Exception e) {
            log.error((Object)"Error serializing message", (Throwable)e);
        }
        return out.toString();
    }

    public void onMessage(Message message) {
        System.out.println("Received message");
        JMSTransport transport = (JMSTransport)this.getTransport();
        try {
            String text = ((TextMessage)message).getText();
            MessageContext context = new MessageContext();
            context.setId(message.getJMSCorrelationID());
            String destName = this.getDestinationName(this.getUri());
            if (this.selector.equals("")) {
                context.setService(((JMSTransport)this.getTransport()).getXFire().getServiceRegistry().getService(destName));
            } else {
                context.setService(((JMSTransport)this.getTransport()).getXFire().getServiceRegistry().getService(this.selector));
            }
            context.setProperty(REPLY_TO, message.getJMSReplyTo());
            String srcID = message.getStringProperty("Source");
            System.out.println("onMessage -> Source ID: " + srcID + ", Message ID: " + message.getJMSMessageID());
            context.setProperty("Destination", srcID);
            context.setXFire(((JMSTransport)this.getTransport()).getXFire());
            XMLStreamReader reader = STAXUtils.createXMLStreamReader(new StringReader(text), context);
            InMessage in = new InMessage(reader, this.getUri());
            this.receive(context, in);
        }
        catch (JMSException e) {
            log.error((Object)("Error receiving message " + message), (Throwable)e);
        }
    }

    public void close() {
        JMSTransport transport = (JMSTransport)this.getTransport();
        try {
            this.session.close();
            this.connection.close();
        }
        catch (JMSException e) {
            log.error((Object)"Error closing jms connection.", (Throwable)e);
        }
        super.close();
    }
}

