/*
 * This declarations of the PIC16LF1567 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:08 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16LF1567_H__
#define __PIC16LF1567_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PORTD_ADDR              0x000F
#define PORTE_ADDR              0x0010
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TMR2_ADDR               0x001A
#define PR2_ADDR                0x001B
#define T2CON_ADDR              0x001C
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define TRISD_ADDR              0x008F
#define TRISE_ADDR              0x0090
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define ADCON2_ADDR             0x009F
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define LATD_ADDR               0x010F
#define LATE_ADDR               0x0110
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define APFCON_ADDR             0x011D
#define ANSELA_ADDR             0x018C
#define ANSELB_ADDR             0x018D
#define ANSELC_ADDR             0x018E
#define ANSELD_ADDR             0x018F
#define ANSELE_ADDR             0x0190
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define RCREG_ADDR              0x0199
#define TXREG_ADDR              0x019A
#define SPBRG_ADDR              0x019B
#define SPBRGL_ADDR             0x019B
#define SPBRGH_ADDR             0x019C
#define RCSTA_ADDR              0x019D
#define TXSTA_ADDR              0x019E
#define BAUDCON_ADDR            0x019F
#define WPUB_ADDR               0x020D
#define WPUE_ADDR               0x0210
#define SSP1BUF_ADDR            0x0211
#define SSPBUF_ADDR             0x0211
#define SSP1ADD_ADDR            0x0212
#define SSPADD_ADDR             0x0212
#define SSP1MSK_ADDR            0x0213
#define SSPMSK_ADDR             0x0213
#define SSP1STAT_ADDR           0x0214
#define SSPSTAT_ADDR            0x0214
#define SSP1CON_ADDR            0x0215
#define SSP1CON1_ADDR           0x0215
#define SSPCON_ADDR             0x0215
#define SSPCON1_ADDR            0x0215
#define SSP1CON2_ADDR           0x0216
#define SSPCON2_ADDR            0x0216
#define SSP1CON3_ADDR           0x0217
#define SSPCON3_ADDR            0x0217
#define SSPLVL_ADDR             0x0218
#define SSP2BUF_ADDR            0x0219
#define SSP2ADD_ADDR            0x021A
#define SSP2MSK_ADDR            0x021B
#define SSP2STAT_ADDR           0x021C
#define SSP2CON_ADDR            0x021D
#define SSP2CON1_ADDR           0x021D
#define SSP2CON2_ADDR           0x021E
#define SSP2CON3_ADDR           0x021F
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define TMR4_ADDR               0x0415
#define PR4_ADDR                0x0416
#define T4CON_ADDR              0x0417
#define PWM1DCL_ADDR            0x0611
#define PWM1DCH_ADDR            0x0612
#define PWM1CON_ADDR            0x0613
#define PWM1CON0_ADDR           0x0613
#define PWM2DCL_ADDR            0x0614
#define PWM2DCH_ADDR            0x0615
#define PWM2CON_ADDR            0x0616
#define PWM2CON0_ADDR           0x0616
#define PWMTMRS_ADDR            0x061D
#define PWM1AOE_ADDR            0x061E
#define PWM2AOE_ADDR            0x061F
#define ADCTX_ADDR              0x0691
#define AAD1TX_ADDR             0x0692
#define AAD1TX0_ADDR            0x0692
#define AD1TX_ADDR              0x0692
#define AD1TX0_ADDR             0x0692
#define AAD1TX1_ADDR            0x0693
#define AD1TX1_ADDR             0x0693
#define AAD2TX_ADDR             0x0694
#define AAD2TX0_ADDR            0x0694
#define AD2TX_ADDR              0x0694
#define AD2TX0_ADDR             0x0694
#define AAD2TX1_ADDR            0x0695
#define AD2TX1_ADDR             0x0695
#define AAD1CON0_ADDR           0x0711
#define AADCON0_ADDR            0x0711
#define AD1CON0_ADDR            0x0711
#define AADCON1_ADDR            0x0712
#define ADCOMCON_ADDR           0x0712
#define AAD1CON2_ADDR           0x0713
#define AADCON2_ADDR            0x0713
#define AD1CON2_ADDR            0x0713
#define AAD1CON3_ADDR           0x0714
#define AADCON3_ADDR            0x0714
#define AD1CON3_ADDR            0x0714
#define AADSTAT_ADDR            0x0715
#define ADSTAT_ADDR             0x0715
#define AAD1PRE_ADDR            0x0716
#define AADPRE_ADDR             0x0716
#define AD1PRE_ADDR             0x0716
#define AD1PRECON_ADDR          0x0716
#define AAD1ACQ_ADDR            0x0717
#define AADACQ_ADDR             0x0717
#define AD1ACQ_ADDR             0x0717
#define AD1ACQCON_ADDR          0x0717
#define AAD1GRD_ADDR            0x0718
#define AADGRD_ADDR             0x0718
#define AD1GRD_ADDR             0x0718
#define AAD1CAP_ADDR            0x0719
#define AAD1CAPCON_ADDR         0x0719
#define AADCAP_ADDR             0x0719
#define AD1CAPCON_ADDR          0x0719
#define AAD1RES0_ADDR           0x071A
#define AAD1RES0L_ADDR          0x071A
#define AD1RES0_ADDR            0x071A
#define AD1RES0L_ADDR           0x071A
#define ADRES0_ADDR             0x071A
#define AAD1RES0H_ADDR          0x071B
#define AD1RES0H_ADDR           0x071B
#define AAD1RES1_ADDR           0x071C
#define AAD1RES1L_ADDR          0x071C
#define AD1RES1_ADDR            0x071C
#define AD1RES1L_ADDR           0x071C
#define ADRES1_ADDR             0x071C
#define AAD1RES1H_ADDR          0x071D
#define AD1RES1H_ADDR           0x071D
#define AAD1CH_ADDR             0x071E
#define AAD1CH0_ADDR            0x071E
#define AD1CH_ADDR              0x071E
#define AD1CH0_ADDR             0x071E
#define AAD1CH1_ADDR            0x071F
#define AD1CH1_ADDR             0x071F
#define AAD2CON0_ADDR           0x0791
#define AD2CON0_ADDR            0x0791
#define AAD2CON2_ADDR           0x0793
#define AD2CON2_ADDR            0x0793
#define AAD2CON3_ADDR           0x0794
#define AD2CON3_ADDR            0x0794
#define AAD2PRE_ADDR            0x0796
#define AD2PRE_ADDR             0x0796
#define AD2PRECON_ADDR          0x0796
#define AAD2ACQ_ADDR            0x0797
#define AD2ACQ_ADDR             0x0797
#define AD2ACQCON_ADDR          0x0797
#define AAD2GRD_ADDR            0x0798
#define AD2GRD_ADDR             0x0798
#define AAD2CAP_ADDR            0x0799
#define AAD2CAPCON_ADDR         0x0799
#define AD2CAPCON_ADDR          0x0799
#define AAD2RES0_ADDR           0x079A
#define AAD2RES0L_ADDR          0x079A
#define AD2RES0_ADDR            0x079A
#define AAD2RES0H_ADDR          0x079B
#define AAD2RES1_ADDR           0x079C
#define AAD2RES1L_ADDR          0x079C
#define AD2RES1_ADDR            0x079C
#define AAD2RES1H_ADDR          0x079D
#define AAD2CH_ADDR             0x079E
#define AAD2CH0_ADDR            0x079E
#define AD2CH_ADDR              0x079E
#define AD2CH0_ADDR             0x079E
#define AAD2CH1_ADDR            0x079F
#define AD2CH1_ADDR             0x079F
#define ICDIO_ADDR              0x0F8C
#define ICDCON0_ADDR            0x0F8D
#define ICDSTAT_ADDR            0x0F91
#define ICDINSTL_ADDR           0x0F96
#define ICDINSTH_ADDR           0x0F97
#define ICDBK0CON_ADDR          0x0F9C
#define ICDBK0L_ADDR            0x0F9D
#define ICDBK0H_ADDR            0x0F9E
#define BSRICDSHAD_ADDR         0x0FE3
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned RA2                  : 1;
  unsigned RA3                  : 1;
  unsigned RA4                  : 1;
  unsigned RA5                  : 1;
  unsigned RA6                  : 1;
  unsigned RA7                  : 1;
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20
#define _RA6                    0x40
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PORTD Bits

extern __at(0x000F) __sfr PORTD;

typedef struct
  {
  unsigned RD0                  : 1;
  unsigned RD1                  : 1;
  unsigned RD2                  : 1;
  unsigned RD3                  : 1;
  unsigned RD4                  : 1;
  unsigned RD5                  : 1;
  unsigned RD6                  : 1;
  unsigned RD7                  : 1;
  } __PORTDbits_t;

extern __at(0x000F) volatile __PORTDbits_t PORTDbits;

#define _RD0                    0x01
#define _RD1                    0x02
#define _RD2                    0x04
#define _RD3                    0x08
#define _RD4                    0x10
#define _RD5                    0x20
#define _RD6                    0x40
#define _RD7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0010) __sfr PORTE;

typedef union
  {
  struct
    {
    unsigned RE0                : 1;
    unsigned RE1                : 1;
    unsigned RE2                : 1;
    unsigned RE3                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned RE                 : 4;
    unsigned                    : 4;
    };
  } __PORTEbits_t;

extern __at(0x0010) volatile __PORTEbits_t PORTEbits;

#define _RE0                    0x01
#define _RE1                    0x02
#define _RE2                    0x04
#define _RE3                    0x08

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned SSP2IF             : 1;
    unsigned SSP1IF             : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned ADIF               : 1;
    unsigned TMR1GIF            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD1IF              : 1;
    unsigned                    : 1;
    };
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _SSP2IF                 0x04
#define _SSP1IF                 0x08
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _AD1IF                  0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR4IF               : 1;
  unsigned BCL2IF               : 1;
  unsigned BCL1IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned AD2IF                : 1;
  unsigned                      : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _TMR4IF                 0x02
#define _BCL2IF                 0x04
#define _BCL1IF                 0x08
#define _AD2IF                  0x40

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned                    : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS              : 1;
    unsigned                    : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned T1GSS0             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GCON_T1GSS           0x01
#define _T1GCON_T1GSS0          0x01
#define _T1GCON_T1GVAL          0x04
#define _T1GCON_T1GGO_NOT_DONE  0x08
#define _T1GCON_GO              0x08
#define _T1GCON_T1GSPM          0x10
#define _T1GCON_T1GTM           0x20
#define _T1GCON_T1GPOL          0x40
#define _T1GCON_TMR1GE          0x80

//==============================================================================

extern __at(0x001A) __sfr TMR2;
extern __at(0x001B) __sfr PR2;

//==============================================================================
//        T2CON Bits

extern __at(0x001C) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x001C) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================


//==============================================================================
//        TRISD Bits

extern __at(0x008F) __sfr TRISD;

typedef struct
  {
  unsigned TRISD0               : 1;
  unsigned TRISD1               : 1;
  unsigned TRISD2               : 1;
  unsigned TRISD3               : 1;
  unsigned TRISD4               : 1;
  unsigned TRISD5               : 1;
  unsigned TRISD6               : 1;
  unsigned TRISD7               : 1;
  } __TRISDbits_t;

extern __at(0x008F) volatile __TRISDbits_t TRISDbits;

#define _TRISD0                 0x01
#define _TRISD1                 0x02
#define _TRISD2                 0x04
#define _TRISD3                 0x08
#define _TRISD4                 0x10
#define _TRISD5                 0x20
#define _TRISD6                 0x40
#define _TRISD7                 0x80

//==============================================================================


//==============================================================================
//        TRISE Bits

extern __at(0x0090) __sfr TRISE;

typedef union
  {
  struct
    {
    unsigned TRISE0             : 1;
    unsigned TRISE1             : 1;
    unsigned TRISE2             : 1;
    unsigned TRISE3             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned TRISE              : 4;
    unsigned                    : 4;
    };
  } __TRISEbits_t;

extern __at(0x0090) volatile __TRISEbits_t TRISEbits;

#define _TRISE0                 0x01
#define _TRISE1                 0x02
#define _TRISE2                 0x04
#define _TRISE3                 0x08

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned SSP2IE             : 1;
    unsigned SSP1IE             : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned ADIE               : 1;
    unsigned TMR1GIE            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSPIE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD1IE              : 1;
    unsigned                    : 1;
    };
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _SSP2IE                 0x04
#define _SSP1IE                 0x08
#define _SSPIE                  0x08
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _AD1IE                  0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned                      : 1;
  unsigned TMR4IE               : 1;
  unsigned BCL2IE               : 1;
  unsigned BCL1IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned AD2IE                : 1;
  unsigned                      : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _TMR4IE                 0x02
#define _BCL2IE                 0x04
#define _BCL1IE                 0x08
#define _AD2IE                  0x40

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned SPLLEN             : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40
#define _SPLLEN                 0x80

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned HFIOFR               : 1;
  unsigned                      : 1;
  unsigned PLLSR                : 1;
  unsigned                      : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _HFIOFR                 0x10
#define _PLLSR                  0x40

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned CHS5               : 1;
    };

  struct
    {
    unsigned AD1ON              : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 6;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADCON0_ADON            0x01
#define _ADCON0_AD1ON           0x01
#define _ADCON0_GO_NOT_DONE     0x02
#define _ADCON0_ADGO            0x02
#define _ADCON0_GO              0x02
#define _ADCON0_CHS0            0x04
#define _ADCON0_CHS1            0x08
#define _ADCON0_CHS2            0x10
#define _ADCON0_CHS3            0x20
#define _ADCON0_CHS4            0x40
#define _ADCON0_CHS5            0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned GO_NOT_DONE_ALL    : 1;
    unsigned ADNREF             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO_ALL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADCON1_ADPREF0         0x01
#define _ADCON1_ADPREF1         0x02
#define _ADCON1_GO_NOT_DONE_ALL 0x04
#define _ADCON1_GO_ALL          0x04
#define _ADCON1_ADNREF          0x08
#define _ADCON1_ADFM            0x80

//==============================================================================


//==============================================================================
//        ADCON2 Bits

extern __at(0x009F) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __ADCON2bits_t;

extern __at(0x009F) volatile __ADCON2bits_t ADCON2bits;

#define _ADCON2_TRIGSEL0        0x10
#define _ADCON2_TRIGSEL1        0x20
#define _ADCON2_TRIGSEL2        0x40

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        LATD Bits

extern __at(0x010F) __sfr LATD;

typedef struct
  {
  unsigned LATD0                : 1;
  unsigned LATD1                : 1;
  unsigned LATD2                : 1;
  unsigned LATD3                : 1;
  unsigned LATD4                : 1;
  unsigned LATD5                : 1;
  unsigned LATD6                : 1;
  unsigned LATD7                : 1;
  } __LATDbits_t;

extern __at(0x010F) volatile __LATDbits_t LATDbits;

#define _LATD0                  0x01
#define _LATD1                  0x02
#define _LATD2                  0x04
#define _LATD3                  0x08
#define _LATD4                  0x10
#define _LATD5                  0x20
#define _LATD6                  0x40
#define _LATD7                  0x80

//==============================================================================


//==============================================================================
//        LATE Bits

extern __at(0x0110) __sfr LATE;

typedef union
  {
  struct
    {
    unsigned LATE0              : 1;
    unsigned LATE1              : 1;
    unsigned LATE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LATE               : 3;
    unsigned                    : 5;
    };
  } __LATEbits_t;

extern __at(0x0110) volatile __LATEbits_t LATEbits;

#define _LATE0                  0x01
#define _LATE1                  0x02
#define _LATE2                  0x04

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        APFCON Bits

extern __at(0x011D) __sfr APFCON;

typedef struct
  {
  unsigned GRDASEL              : 1;
  unsigned GRDBSEL              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned SSSEL                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __APFCONbits_t;

extern __at(0x011D) volatile __APFCONbits_t APFCONbits;

#define _GRDASEL                0x01
#define _GRDBSEL                0x02
#define _SSSEL                  0x20

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned ANSA3                : 1;
  unsigned ANSA4                : 1;
  unsigned ANSA5                : 1;
  unsigned ANSA6                : 1;
  unsigned ANSA7                : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA3                  0x08
#define _ANSA4                  0x10
#define _ANSA5                  0x20
#define _ANSA6                  0x40
#define _ANSA7                  0x80

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x018D) __sfr ANSELB;

typedef struct
  {
  unsigned ANSB0                : 1;
  unsigned ANSB1                : 1;
  unsigned ANSB2                : 1;
  unsigned ANSB3                : 1;
  unsigned ANSB4                : 1;
  unsigned ANSB5                : 1;
  unsigned ANSB6                : 1;
  unsigned ANSB7                : 1;
  } __ANSELBbits_t;

extern __at(0x018D) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB0                  0x01
#define _ANSB1                  0x02
#define _ANSB2                  0x04
#define _ANSB3                  0x08
#define _ANSB4                  0x10
#define _ANSB5                  0x20
#define _ANSB6                  0x40
#define _ANSB7                  0x80

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x018E) __sfr ANSELC;

typedef struct
  {
  unsigned ANSC0                : 1;
  unsigned ANSC1                : 1;
  unsigned ANSC2                : 1;
  unsigned ANSC3                : 1;
  unsigned ANSC4                : 1;
  unsigned ANSC5                : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x018E) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC0                  0x01
#define _ANSC1                  0x02
#define _ANSC2                  0x04
#define _ANSC3                  0x08
#define _ANSC4                  0x10
#define _ANSC5                  0x20
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================


//==============================================================================
//        ANSELD Bits

extern __at(0x018F) __sfr ANSELD;

typedef struct
  {
  unsigned ANSD0                : 1;
  unsigned ANSD1                : 1;
  unsigned ANSD2                : 1;
  unsigned ANSD3                : 1;
  unsigned ANSD4                : 1;
  unsigned ANSD5                : 1;
  unsigned ANSD6                : 1;
  unsigned ANSD7                : 1;
  } __ANSELDbits_t;

extern __at(0x018F) volatile __ANSELDbits_t ANSELDbits;

#define _ANSD0                  0x01
#define _ANSD1                  0x02
#define _ANSD2                  0x04
#define _ANSD3                  0x08
#define _ANSD4                  0x10
#define _ANSD5                  0x20
#define _ANSD6                  0x40
#define _ANSD7                  0x80

//==============================================================================


//==============================================================================
//        ANSELE Bits

extern __at(0x0190) __sfr ANSELE;

typedef union
  {
  struct
    {
    unsigned ANSE0              : 1;
    unsigned ANSE1              : 1;
    unsigned ANSE2              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSE               : 3;
    unsigned                    : 5;
    };
  } __ANSELEbits_t;

extern __at(0x0190) volatile __ANSELEbits_t ANSELEbits;

#define _ANSE0                  0x01
#define _ANSE1                  0x02
#define _ANSE2                  0x04

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;
extern __at(0x0199) __sfr RCREG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019B) __sfr SPBRG;
extern __at(0x019B) __sfr SPBRGL;
extern __at(0x019C) __sfr SPBRGH;

//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        WPUE Bits

extern __at(0x0210) __sfr WPUE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUE3                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __WPUEbits_t;

extern __at(0x0210) volatile __WPUEbits_t WPUEbits;

#define _WPUE3                  0x08

//==============================================================================


//==============================================================================
//        SSP1BUF Bits

extern __at(0x0211) __sfr SSP1BUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSP1BUFbits_t;

extern __at(0x0211) volatile __SSP1BUFbits_t SSP1BUFbits;

#define _SSP1BUF0               0x01
#define _BUF0                   0x01
#define _SSP1BUF1               0x02
#define _BUF1                   0x02
#define _SSP1BUF2               0x04
#define _BUF2                   0x04
#define _SSP1BUF3               0x08
#define _BUF3                   0x08
#define _SSP1BUF4               0x10
#define _BUF4                   0x10
#define _SSP1BUF5               0x20
#define _BUF5                   0x20
#define _SSP1BUF6               0x40
#define _BUF6                   0x40
#define _SSP1BUF7               0x80
#define _BUF7                   0x80

//==============================================================================


//==============================================================================
//        SSPBUF Bits

extern __at(0x0211) __sfr SSPBUF;

typedef union
  {
  struct
    {
    unsigned SSP1BUF0           : 1;
    unsigned SSP1BUF1           : 1;
    unsigned SSP1BUF2           : 1;
    unsigned SSP1BUF3           : 1;
    unsigned SSP1BUF4           : 1;
    unsigned SSP1BUF5           : 1;
    unsigned SSP1BUF6           : 1;
    unsigned SSP1BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSPBUFbits_t;

extern __at(0x0211) volatile __SSPBUFbits_t SSPBUFbits;

#define _SSPBUF_SSP1BUF0        0x01
#define _SSPBUF_BUF0            0x01
#define _SSPBUF_SSP1BUF1        0x02
#define _SSPBUF_BUF1            0x02
#define _SSPBUF_SSP1BUF2        0x04
#define _SSPBUF_BUF2            0x04
#define _SSPBUF_SSP1BUF3        0x08
#define _SSPBUF_BUF3            0x08
#define _SSPBUF_SSP1BUF4        0x10
#define _SSPBUF_BUF4            0x10
#define _SSPBUF_SSP1BUF5        0x20
#define _SSPBUF_BUF5            0x20
#define _SSPBUF_SSP1BUF6        0x40
#define _SSPBUF_BUF6            0x40
#define _SSPBUF_SSP1BUF7        0x80
#define _SSPBUF_BUF7            0x80

//==============================================================================


//==============================================================================
//        SSP1ADD Bits

extern __at(0x0212) __sfr SSP1ADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSP1ADDbits_t;

extern __at(0x0212) volatile __SSP1ADDbits_t SSP1ADDbits;

#define _SSP1ADD0               0x01
#define _ADD0                   0x01
#define _SSP1ADD1               0x02
#define _ADD1                   0x02
#define _SSP1ADD2               0x04
#define _ADD2                   0x04
#define _SSP1ADD3               0x08
#define _ADD3                   0x08
#define _SSP1ADD4               0x10
#define _ADD4                   0x10
#define _SSP1ADD5               0x20
#define _ADD5                   0x20
#define _SSP1ADD6               0x40
#define _ADD6                   0x40
#define _SSP1ADD7               0x80
#define _ADD7                   0x80

//==============================================================================


//==============================================================================
//        SSPADD Bits

extern __at(0x0212) __sfr SSPADD;

typedef union
  {
  struct
    {
    unsigned SSP1ADD0           : 1;
    unsigned SSP1ADD1           : 1;
    unsigned SSP1ADD2           : 1;
    unsigned SSP1ADD3           : 1;
    unsigned SSP1ADD4           : 1;
    unsigned SSP1ADD5           : 1;
    unsigned SSP1ADD6           : 1;
    unsigned SSP1ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSPADDbits_t;

extern __at(0x0212) volatile __SSPADDbits_t SSPADDbits;

#define _SSPADD_SSP1ADD0        0x01
#define _SSPADD_ADD0            0x01
#define _SSPADD_SSP1ADD1        0x02
#define _SSPADD_ADD1            0x02
#define _SSPADD_SSP1ADD2        0x04
#define _SSPADD_ADD2            0x04
#define _SSPADD_SSP1ADD3        0x08
#define _SSPADD_ADD3            0x08
#define _SSPADD_SSP1ADD4        0x10
#define _SSPADD_ADD4            0x10
#define _SSPADD_SSP1ADD5        0x20
#define _SSPADD_ADD5            0x20
#define _SSPADD_SSP1ADD6        0x40
#define _SSPADD_ADD6            0x40
#define _SSPADD_SSP1ADD7        0x80
#define _SSPADD_ADD7            0x80

//==============================================================================


//==============================================================================
//        SSP1MSK Bits

extern __at(0x0213) __sfr SSP1MSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSP1MSKbits_t;

extern __at(0x0213) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _SSP1MSK0               0x01
#define _MSK0                   0x01
#define _SSP1MSK1               0x02
#define _MSK1                   0x02
#define _SSP1MSK2               0x04
#define _MSK2                   0x04
#define _SSP1MSK3               0x08
#define _MSK3                   0x08
#define _SSP1MSK4               0x10
#define _MSK4                   0x10
#define _SSP1MSK5               0x20
#define _MSK5                   0x20
#define _SSP1MSK6               0x40
#define _MSK6                   0x40
#define _SSP1MSK7               0x80
#define _MSK7                   0x80

//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0213) __sfr SSPMSK;

typedef union
  {
  struct
    {
    unsigned SSP1MSK0           : 1;
    unsigned SSP1MSK1           : 1;
    unsigned SSP1MSK2           : 1;
    unsigned SSP1MSK3           : 1;
    unsigned SSP1MSK4           : 1;
    unsigned SSP1MSK5           : 1;
    unsigned SSP1MSK6           : 1;
    unsigned SSP1MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSPMSKbits_t;

extern __at(0x0213) volatile __SSPMSKbits_t SSPMSKbits;

#define _SSPMSK_SSP1MSK0        0x01
#define _SSPMSK_MSK0            0x01
#define _SSPMSK_SSP1MSK1        0x02
#define _SSPMSK_MSK1            0x02
#define _SSPMSK_SSP1MSK2        0x04
#define _SSPMSK_MSK2            0x04
#define _SSPMSK_SSP1MSK3        0x08
#define _SSPMSK_MSK3            0x08
#define _SSPMSK_SSP1MSK4        0x10
#define _SSPMSK_MSK4            0x10
#define _SSPMSK_SSP1MSK5        0x20
#define _SSPMSK_MSK5            0x20
#define _SSPMSK_SSP1MSK6        0x40
#define _SSPMSK_MSK6            0x40
#define _SSPMSK_SSP1MSK7        0x80
#define _SSPMSK_MSK7            0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0214) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0214) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0214) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0214) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1CON Bits

extern __at(0x0215) __sfr SSP1CON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CONbits_t;

extern __at(0x0215) volatile __SSP1CONbits_t SSP1CONbits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0215) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0215) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSP1CON1_SSPM0         0x01
#define _SSP1CON1_SSPM1         0x02
#define _SSP1CON1_SSPM2         0x04
#define _SSP1CON1_SSPM3         0x08
#define _SSP1CON1_CKP           0x10
#define _SSP1CON1_SSPEN         0x20
#define _SSP1CON1_SSPOV         0x40
#define _SSP1CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0215) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0215) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0215) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0215) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0216) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0216) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0216) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0216) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0217) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0217) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0217) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0217) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        SSPLVL Bits

extern __at(0x0218) __sfr SSPLVL;

typedef struct
  {
  unsigned S1ILS                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned S2ILS                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SSPLVLbits_t;

extern __at(0x0218) volatile __SSPLVLbits_t SSPLVLbits;

#define _S1ILS                  0x01
#define _S2ILS                  0x10

//==============================================================================


//==============================================================================
//        SSP2BUF Bits

extern __at(0x0219) __sfr SSP2BUF;

typedef union
  {
  struct
    {
    unsigned SSP2BUF0           : 1;
    unsigned SSP2BUF1           : 1;
    unsigned SSP2BUF2           : 1;
    unsigned SSP2BUF3           : 1;
    unsigned SSP2BUF4           : 1;
    unsigned SSP2BUF5           : 1;
    unsigned SSP2BUF6           : 1;
    unsigned SSP2BUF7           : 1;
    };

  struct
    {
    unsigned BUF0               : 1;
    unsigned BUF1               : 1;
    unsigned BUF2               : 1;
    unsigned BUF3               : 1;
    unsigned BUF4               : 1;
    unsigned BUF5               : 1;
    unsigned BUF6               : 1;
    unsigned BUF7               : 1;
    };
  } __SSP2BUFbits_t;

extern __at(0x0219) volatile __SSP2BUFbits_t SSP2BUFbits;

#define _SSP2BUF_SSP2BUF0       0x01
#define _SSP2BUF_BUF0           0x01
#define _SSP2BUF_SSP2BUF1       0x02
#define _SSP2BUF_BUF1           0x02
#define _SSP2BUF_SSP2BUF2       0x04
#define _SSP2BUF_BUF2           0x04
#define _SSP2BUF_SSP2BUF3       0x08
#define _SSP2BUF_BUF3           0x08
#define _SSP2BUF_SSP2BUF4       0x10
#define _SSP2BUF_BUF4           0x10
#define _SSP2BUF_SSP2BUF5       0x20
#define _SSP2BUF_BUF5           0x20
#define _SSP2BUF_SSP2BUF6       0x40
#define _SSP2BUF_BUF6           0x40
#define _SSP2BUF_SSP2BUF7       0x80
#define _SSP2BUF_BUF7           0x80

//==============================================================================


//==============================================================================
//        SSP2ADD Bits

extern __at(0x021A) __sfr SSP2ADD;

typedef union
  {
  struct
    {
    unsigned SSP2ADD0           : 1;
    unsigned SSP2ADD1           : 1;
    unsigned SSP2ADD2           : 1;
    unsigned SSP2ADD3           : 1;
    unsigned SSP2ADD4           : 1;
    unsigned SSP2ADD5           : 1;
    unsigned SSP2ADD6           : 1;
    unsigned SSP2ADD7           : 1;
    };

  struct
    {
    unsigned ADD0               : 1;
    unsigned ADD1               : 1;
    unsigned ADD2               : 1;
    unsigned ADD3               : 1;
    unsigned ADD4               : 1;
    unsigned ADD5               : 1;
    unsigned ADD6               : 1;
    unsigned ADD7               : 1;
    };
  } __SSP2ADDbits_t;

extern __at(0x021A) volatile __SSP2ADDbits_t SSP2ADDbits;

#define _SSP2ADD_SSP2ADD0       0x01
#define _SSP2ADD_ADD0           0x01
#define _SSP2ADD_SSP2ADD1       0x02
#define _SSP2ADD_ADD1           0x02
#define _SSP2ADD_SSP2ADD2       0x04
#define _SSP2ADD_ADD2           0x04
#define _SSP2ADD_SSP2ADD3       0x08
#define _SSP2ADD_ADD3           0x08
#define _SSP2ADD_SSP2ADD4       0x10
#define _SSP2ADD_ADD4           0x10
#define _SSP2ADD_SSP2ADD5       0x20
#define _SSP2ADD_ADD5           0x20
#define _SSP2ADD_SSP2ADD6       0x40
#define _SSP2ADD_ADD6           0x40
#define _SSP2ADD_SSP2ADD7       0x80
#define _SSP2ADD_ADD7           0x80

//==============================================================================


//==============================================================================
//        SSP2MSK Bits

extern __at(0x021B) __sfr SSP2MSK;

typedef union
  {
  struct
    {
    unsigned SSP2MSK0           : 1;
    unsigned SSP2MSK1           : 1;
    unsigned SSP2MSK2           : 1;
    unsigned SSP2MSK3           : 1;
    unsigned SSP2MSK4           : 1;
    unsigned SSP2MSK5           : 1;
    unsigned SSP2MSK6           : 1;
    unsigned SSP2MSK7           : 1;
    };

  struct
    {
    unsigned MSK0               : 1;
    unsigned MSK1               : 1;
    unsigned MSK2               : 1;
    unsigned MSK3               : 1;
    unsigned MSK4               : 1;
    unsigned MSK5               : 1;
    unsigned MSK6               : 1;
    unsigned MSK7               : 1;
    };
  } __SSP2MSKbits_t;

extern __at(0x021B) volatile __SSP2MSKbits_t SSP2MSKbits;

#define _SSP2MSK_SSP2MSK0       0x01
#define _SSP2MSK_MSK0           0x01
#define _SSP2MSK_SSP2MSK1       0x02
#define _SSP2MSK_MSK1           0x02
#define _SSP2MSK_SSP2MSK2       0x04
#define _SSP2MSK_MSK2           0x04
#define _SSP2MSK_SSP2MSK3       0x08
#define _SSP2MSK_MSK3           0x08
#define _SSP2MSK_SSP2MSK4       0x10
#define _SSP2MSK_MSK4           0x10
#define _SSP2MSK_SSP2MSK5       0x20
#define _SSP2MSK_MSK5           0x20
#define _SSP2MSK_SSP2MSK6       0x40
#define _SSP2MSK_MSK6           0x40
#define _SSP2MSK_SSP2MSK7       0x80
#define _SSP2MSK_MSK7           0x80

//==============================================================================


//==============================================================================
//        SSP2STAT Bits

extern __at(0x021C) __sfr SSP2STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP2STATbits_t;

extern __at(0x021C) volatile __SSP2STATbits_t SSP2STATbits;

#define _SSP2STAT_BF            0x01
#define _SSP2STAT_UA            0x02
#define _SSP2STAT_R_NOT_W       0x04
#define _SSP2STAT_S             0x08
#define _SSP2STAT_P             0x10
#define _SSP2STAT_D_NOT_A       0x20
#define _SSP2STAT_CKE           0x40
#define _SSP2STAT_SMP           0x80

//==============================================================================


//==============================================================================
//        SSP2CON Bits

extern __at(0x021D) __sfr SSP2CON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP2CONbits_t;

extern __at(0x021D) volatile __SSP2CONbits_t SSP2CONbits;

#define _SSP2CON_SSPM0          0x01
#define _SSP2CON_SSPM1          0x02
#define _SSP2CON_SSPM2          0x04
#define _SSP2CON_SSPM3          0x08
#define _SSP2CON_CKP            0x10
#define _SSP2CON_SSPEN          0x20
#define _SSP2CON_SSPOV          0x40
#define _SSP2CON_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP2CON1 Bits

extern __at(0x021D) __sfr SSP2CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP2CON1bits_t;

extern __at(0x021D) volatile __SSP2CON1bits_t SSP2CON1bits;

#define _SSP2CON1_SSPM0         0x01
#define _SSP2CON1_SSPM1         0x02
#define _SSP2CON1_SSPM2         0x04
#define _SSP2CON1_SSPM3         0x08
#define _SSP2CON1_CKP           0x10
#define _SSP2CON1_SSPEN         0x20
#define _SSP2CON1_SSPOV         0x40
#define _SSP2CON1_WCOL          0x80

//==============================================================================


//==============================================================================
//        SSP2CON2 Bits

extern __at(0x021E) __sfr SSP2CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP2CON2bits_t;

extern __at(0x021E) volatile __SSP2CON2bits_t SSP2CON2bits;

#define _SSP2CON2_SEN           0x01
#define _SSP2CON2_RSEN          0x02
#define _SSP2CON2_PEN           0x04
#define _SSP2CON2_RCEN          0x08
#define _SSP2CON2_ACKEN         0x10
#define _SSP2CON2_ACKDT         0x20
#define _SSP2CON2_ACKSTAT       0x40
#define _SSP2CON2_GCEN          0x80

//==============================================================================


//==============================================================================
//        SSP2CON3 Bits

extern __at(0x021F) __sfr SSP2CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP2CON3bits_t;

extern __at(0x021F) volatile __SSP2CON3bits_t SSP2CON3bits;

#define _SSP2CON3_DHEN          0x01
#define _SSP2CON3_AHEN          0x02
#define _SSP2CON3_SBCDE         0x04
#define _SSP2CON3_SDAHT         0x08
#define _SSP2CON3_BOEN          0x10
#define _SSP2CON3_SCIE          0x20
#define _SSP2CON3_PCIE          0x40
#define _SSP2CON3_ACKTIM        0x80

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned IOCBP0               : 1;
  unsigned IOCBP1               : 1;
  unsigned IOCBP2               : 1;
  unsigned IOCBP3               : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP0                 0x01
#define _IOCBP1                 0x02
#define _IOCBP2                 0x04
#define _IOCBP3                 0x08
#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned IOCBN0               : 1;
  unsigned IOCBN1               : 1;
  unsigned IOCBN2               : 1;
  unsigned IOCBN3               : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN0                 0x01
#define _IOCBN1                 0x02
#define _IOCBN2                 0x04
#define _IOCBN3                 0x08
#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned IOCBF0               : 1;
  unsigned IOCBF1               : 1;
  unsigned IOCBF2               : 1;
  unsigned IOCBF3               : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF0                 0x01
#define _IOCBF1                 0x02
#define _IOCBF2                 0x04
#define _IOCBF3                 0x08
#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================

extern __at(0x0415) __sfr TMR4;
extern __at(0x0416) __sfr PR4;

//==============================================================================
//        T4CON Bits

extern __at(0x0417) __sfr T4CON;

typedef union
  {
  struct
    {
    unsigned T4CKPS0            : 1;
    unsigned T4CKPS1            : 1;
    unsigned TMR4ON             : 1;
    unsigned T4OUTPS0           : 1;
    unsigned T4OUTPS1           : 1;
    unsigned T4OUTPS2           : 1;
    unsigned T4OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T4CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T4OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T4CONbits_t;

extern __at(0x0417) volatile __T4CONbits_t T4CONbits;

#define _T4CKPS0                0x01
#define _T4CKPS1                0x02
#define _TMR4ON                 0x04
#define _T4OUTPS0               0x08
#define _T4OUTPS1               0x10
#define _T4OUTPS2               0x20
#define _T4OUTPS3               0x40

//==============================================================================


//==============================================================================
//        PWM1DCL Bits

extern __at(0x0611) __sfr PWM1DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM1DCL0           : 1;
    unsigned PWM1DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM1DCL            : 2;
    };
  } __PWM1DCLbits_t;

extern __at(0x0611) volatile __PWM1DCLbits_t PWM1DCLbits;

#define _PWM1DCL0               0x40
#define _PWM1DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM1DCH Bits

extern __at(0x0612) __sfr PWM1DCH;

typedef struct
  {
  unsigned PWM1DCH0             : 1;
  unsigned PWM1DCH1             : 1;
  unsigned PWM1DCH2             : 1;
  unsigned PWM1DCH3             : 1;
  unsigned PWM1DCH4             : 1;
  unsigned PWM1DCH5             : 1;
  unsigned PWM1DCH6             : 1;
  unsigned PWM1DCH7             : 1;
  } __PWM1DCHbits_t;

extern __at(0x0612) volatile __PWM1DCHbits_t PWM1DCHbits;

#define _PWM1DCH0               0x01
#define _PWM1DCH1               0x02
#define _PWM1DCH2               0x04
#define _PWM1DCH3               0x08
#define _PWM1DCH4               0x10
#define _PWM1DCH5               0x20
#define _PWM1DCH6               0x40
#define _PWM1DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0613) __sfr PWM1CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1POL              : 1;
  unsigned PWM1OUT              : 1;
  unsigned PWM1OE               : 1;
  unsigned PWM1EN               : 1;
  } __PWM1CONbits_t;

extern __at(0x0613) volatile __PWM1CONbits_t PWM1CONbits;

#define _PWM1POL                0x10
#define _PWM1OUT                0x20
#define _PWM1OE                 0x40
#define _PWM1EN                 0x80

//==============================================================================


//==============================================================================
//        PWM1CON0 Bits

extern __at(0x0613) __sfr PWM1CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM1POL              : 1;
  unsigned PWM1OUT              : 1;
  unsigned PWM1OE               : 1;
  unsigned PWM1EN               : 1;
  } __PWM1CON0bits_t;

extern __at(0x0613) volatile __PWM1CON0bits_t PWM1CON0bits;

#define _PWM1CON0_PWM1POL       0x10
#define _PWM1CON0_PWM1OUT       0x20
#define _PWM1CON0_PWM1OE        0x40
#define _PWM1CON0_PWM1EN        0x80

//==============================================================================


//==============================================================================
//        PWM2DCL Bits

extern __at(0x0614) __sfr PWM2DCL;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PWM2DCL0           : 1;
    unsigned PWM2DCL1           : 1;
    };

  struct
    {
    unsigned                    : 6;
    unsigned PWM2DCL            : 2;
    };
  } __PWM2DCLbits_t;

extern __at(0x0614) volatile __PWM2DCLbits_t PWM2DCLbits;

#define _PWM2DCL0               0x40
#define _PWM2DCL1               0x80

//==============================================================================


//==============================================================================
//        PWM2DCH Bits

extern __at(0x0615) __sfr PWM2DCH;

typedef struct
  {
  unsigned PWM2DCH0             : 1;
  unsigned PWM2DCH1             : 1;
  unsigned PWM2DCH2             : 1;
  unsigned PWM2DCH3             : 1;
  unsigned PWM2DCH4             : 1;
  unsigned PWM2DCH5             : 1;
  unsigned PWM2DCH6             : 1;
  unsigned PWM2DCH7             : 1;
  } __PWM2DCHbits_t;

extern __at(0x0615) volatile __PWM2DCHbits_t PWM2DCHbits;

#define _PWM2DCH0               0x01
#define _PWM2DCH1               0x02
#define _PWM2DCH2               0x04
#define _PWM2DCH3               0x08
#define _PWM2DCH4               0x10
#define _PWM2DCH5               0x20
#define _PWM2DCH6               0x40
#define _PWM2DCH7               0x80

//==============================================================================


//==============================================================================
//        PWM2CON Bits

extern __at(0x0616) __sfr PWM2CON;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM2POL              : 1;
  unsigned PWM2OUT              : 1;
  unsigned PWM2OE               : 1;
  unsigned PWM2EN               : 1;
  } __PWM2CONbits_t;

extern __at(0x0616) volatile __PWM2CONbits_t PWM2CONbits;

#define _PWM2POL                0x10
#define _PWM2OUT                0x20
#define _PWM2OE                 0x40
#define _PWM2EN                 0x80

//==============================================================================


//==============================================================================
//        PWM2CON0 Bits

extern __at(0x0616) __sfr PWM2CON0;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned PWM2POL              : 1;
  unsigned PWM2OUT              : 1;
  unsigned PWM2OE               : 1;
  unsigned PWM2EN               : 1;
  } __PWM2CON0bits_t;

extern __at(0x0616) volatile __PWM2CON0bits_t PWM2CON0bits;

#define _PWM2CON0_PWM2POL       0x10
#define _PWM2CON0_PWM2OUT       0x20
#define _PWM2CON0_PWM2OE        0x40
#define _PWM2CON0_PWM2EN        0x80

//==============================================================================


//==============================================================================
//        PWMTMRS Bits

extern __at(0x061D) __sfr PWMTMRS;

typedef struct
  {
  unsigned P1TSEL               : 1;
  unsigned                      : 1;
  unsigned P2TSEL               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PWMTMRSbits_t;

extern __at(0x061D) volatile __PWMTMRSbits_t PWMTMRSbits;

#define _P1TSEL                 0x01
#define _P2TSEL                 0x04

//==============================================================================


//==============================================================================
//        PWM1AOE Bits

extern __at(0x061E) __sfr PWM1AOE;

typedef union
  {
  struct
    {
    unsigned PWM1OE0            : 1;
    unsigned PWM1OE1            : 1;
    unsigned PWM1OE2            : 1;
    unsigned PWM1OE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM1OE             : 4;
    unsigned                    : 4;
    };
  } __PWM1AOEbits_t;

extern __at(0x061E) volatile __PWM1AOEbits_t PWM1AOEbits;

#define _PWM1OE0                0x01
#define _PWM1OE1                0x02
#define _PWM1OE2                0x04
#define _PWM1OE3                0x08

//==============================================================================


//==============================================================================
//        PWM2AOE Bits

extern __at(0x061F) __sfr PWM2AOE;

typedef union
  {
  struct
    {
    unsigned PWM2OE0            : 1;
    unsigned PWM2OE1            : 1;
    unsigned PWM2OE2            : 1;
    unsigned PWM2OE3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PWM2OE             : 4;
    unsigned                    : 4;
    };
  } __PWM2AOEbits_t;

extern __at(0x061F) volatile __PWM2AOEbits_t PWM2AOEbits;

#define _PWM2OE0                0x01
#define _PWM2OE1                0x02
#define _PWM2OE2                0x04
#define _PWM2OE3                0x08

//==============================================================================


//==============================================================================
//        ADCTX Bits

extern __at(0x0691) __sfr ADCTX;

typedef union
  {
  struct
    {
    unsigned A1TX0              : 1;
    unsigned A1TX1              : 1;
    unsigned A1TX2              : 1;
    unsigned                    : 1;
    unsigned A2TX0              : 1;
    unsigned A2TX1              : 1;
    unsigned A2TX2              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned A1TX               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned A2TX               : 3;
    unsigned                    : 1;
    };
  } __ADCTXbits_t;

extern __at(0x0691) volatile __ADCTXbits_t ADCTXbits;

#define _A1TX0                  0x01
#define _A1TX1                  0x02
#define _A1TX2                  0x04
#define _A2TX0                  0x10
#define _A2TX1                  0x20
#define _A2TX2                  0x40

//==============================================================================

extern __at(0x0692) __sfr AAD1TX;

//==============================================================================
//        AAD1TX0 Bits

extern __at(0x0692) __sfr AAD1TX0;

typedef struct
  {
  unsigned TX10                 : 1;
  unsigned TX11                 : 1;
  unsigned TX12                 : 1;
  unsigned TX13                 : 1;
  unsigned TX14                 : 1;
  unsigned TX15                 : 1;
  unsigned TX16                 : 1;
  unsigned TX17                 : 1;
  } __AAD1TX0bits_t;

extern __at(0x0692) volatile __AAD1TX0bits_t AAD1TX0bits;

#define _TX10                   0x01
#define _TX11                   0x02
#define _TX12                   0x04
#define _TX13                   0x08
#define _TX14                   0x10
#define _TX15                   0x20
#define _TX16                   0x40
#define _TX17                   0x80

//==============================================================================

extern __at(0x0692) __sfr AD1TX;

//==============================================================================
//        AD1TX0 Bits

extern __at(0x0692) __sfr AD1TX0;

typedef struct
  {
  unsigned TX10                 : 1;
  unsigned TX11                 : 1;
  unsigned TX12                 : 1;
  unsigned TX13                 : 1;
  unsigned TX14                 : 1;
  unsigned TX15                 : 1;
  unsigned TX16                 : 1;
  unsigned TX17                 : 1;
  } __AD1TX0bits_t;

extern __at(0x0692) volatile __AD1TX0bits_t AD1TX0bits;

#define _AD1TX0_TX10            0x01
#define _AD1TX0_TX11            0x02
#define _AD1TX0_TX12            0x04
#define _AD1TX0_TX13            0x08
#define _AD1TX0_TX14            0x10
#define _AD1TX0_TX15            0x20
#define _AD1TX0_TX16            0x40
#define _AD1TX0_TX17            0x80

//==============================================================================


//==============================================================================
//        AAD1TX1 Bits

extern __at(0x0693) __sfr AAD1TX1;

typedef struct
  {
  unsigned TX18                 : 1;
  unsigned TX19                 : 1;
  unsigned TX30                 : 1;
  unsigned TX31                 : 1;
  unsigned TX32                 : 1;
  unsigned TX33                 : 1;
  unsigned TX34                 : 1;
  unsigned TX35                 : 1;
  } __AAD1TX1bits_t;

extern __at(0x0693) volatile __AAD1TX1bits_t AAD1TX1bits;

#define _TX18                   0x01
#define _TX19                   0x02
#define _TX30                   0x04
#define _TX31                   0x08
#define _TX32                   0x10
#define _TX33                   0x20
#define _TX34                   0x40
#define _TX35                   0x80

//==============================================================================


//==============================================================================
//        AD1TX1 Bits

extern __at(0x0693) __sfr AD1TX1;

typedef struct
  {
  unsigned TX18                 : 1;
  unsigned TX19                 : 1;
  unsigned TX30                 : 1;
  unsigned TX31                 : 1;
  unsigned TX32                 : 1;
  unsigned TX33                 : 1;
  unsigned TX34                 : 1;
  unsigned TX35                 : 1;
  } __AD1TX1bits_t;

extern __at(0x0693) volatile __AD1TX1bits_t AD1TX1bits;

#define _AD1TX1_TX18            0x01
#define _AD1TX1_TX19            0x02
#define _AD1TX1_TX30            0x04
#define _AD1TX1_TX31            0x08
#define _AD1TX1_TX32            0x10
#define _AD1TX1_TX33            0x20
#define _AD1TX1_TX34            0x40
#define _AD1TX1_TX35            0x80

//==============================================================================

extern __at(0x0694) __sfr AAD2TX;

//==============================================================================
//        AAD2TX0 Bits

extern __at(0x0694) __sfr AAD2TX0;

typedef struct
  {
  unsigned TX20                 : 1;
  unsigned TX21                 : 1;
  unsigned TX22                 : 1;
  unsigned TX23                 : 1;
  unsigned TX24                 : 1;
  unsigned TX25                 : 1;
  unsigned TX26                 : 1;
  unsigned TX27                 : 1;
  } __AAD2TX0bits_t;

extern __at(0x0694) volatile __AAD2TX0bits_t AAD2TX0bits;

#define _TX20                   0x01
#define _TX21                   0x02
#define _TX22                   0x04
#define _TX23                   0x08
#define _TX24                   0x10
#define _TX25                   0x20
#define _TX26                   0x40
#define _TX27                   0x80

//==============================================================================

extern __at(0x0694) __sfr AD2TX;

//==============================================================================
//        AD2TX0 Bits

extern __at(0x0694) __sfr AD2TX0;

typedef struct
  {
  unsigned TX20                 : 1;
  unsigned TX21                 : 1;
  unsigned TX22                 : 1;
  unsigned TX23                 : 1;
  unsigned TX24                 : 1;
  unsigned TX25                 : 1;
  unsigned TX26                 : 1;
  unsigned TX27                 : 1;
  } __AD2TX0bits_t;

extern __at(0x0694) volatile __AD2TX0bits_t AD2TX0bits;

#define _AD2TX0_TX20            0x01
#define _AD2TX0_TX21            0x02
#define _AD2TX0_TX22            0x04
#define _AD2TX0_TX23            0x08
#define _AD2TX0_TX24            0x10
#define _AD2TX0_TX25            0x20
#define _AD2TX0_TX26            0x40
#define _AD2TX0_TX27            0x80

//==============================================================================


//==============================================================================
//        AAD2TX1 Bits

extern __at(0x0695) __sfr AAD2TX1;

typedef struct
  {
  unsigned TX28                 : 1;
  unsigned TX29                 : 1;
  unsigned TX40                 : 1;
  unsigned TX41                 : 1;
  unsigned TX42                 : 1;
  unsigned TX43                 : 1;
  unsigned TX44                 : 1;
  unsigned TX45                 : 1;
  } __AAD2TX1bits_t;

extern __at(0x0695) volatile __AAD2TX1bits_t AAD2TX1bits;

#define _TX28                   0x01
#define _TX29                   0x02
#define _TX40                   0x04
#define _TX41                   0x08
#define _TX42                   0x10
#define _TX43                   0x20
#define _TX44                   0x40
#define _TX45                   0x80

//==============================================================================


//==============================================================================
//        AD2TX1 Bits

extern __at(0x0695) __sfr AD2TX1;

typedef struct
  {
  unsigned TX28                 : 1;
  unsigned TX29                 : 1;
  unsigned TX40                 : 1;
  unsigned TX41                 : 1;
  unsigned TX42                 : 1;
  unsigned TX43                 : 1;
  unsigned TX44                 : 1;
  unsigned TX45                 : 1;
  } __AD2TX1bits_t;

extern __at(0x0695) volatile __AD2TX1bits_t AD2TX1bits;

#define _AD2TX1_TX28            0x01
#define _AD2TX1_TX29            0x02
#define _AD2TX1_TX40            0x04
#define _AD2TX1_TX41            0x08
#define _AD2TX1_TX42            0x10
#define _AD2TX1_TX43            0x20
#define _AD2TX1_TX44            0x40
#define _AD2TX1_TX45            0x80

//==============================================================================


//==============================================================================
//        AAD1CON0 Bits

extern __at(0x0711) __sfr AAD1CON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO                 : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned CHS5               : 1;
    };

  struct
    {
    unsigned AD1ON              : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE1       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 6;
    };
  } __AAD1CON0bits_t;

extern __at(0x0711) volatile __AAD1CON0bits_t AAD1CON0bits;

#define _ADON                   0x01
#define _AD1ON                  0x01
#define _GO                     0x02
#define _GO_NOT_DONE            0x02
#define _GO_NOT_DONE1           0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40
#define _CHS5                   0x80

//==============================================================================


//==============================================================================
//        AADCON0 Bits

extern __at(0x0711) __sfr AADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO                 : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned CHS5               : 1;
    };

  struct
    {
    unsigned AD1ON              : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE1       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 6;
    };
  } __AADCON0bits_t;

extern __at(0x0711) volatile __AADCON0bits_t AADCON0bits;

#define _AADCON0_ADON           0x01
#define _AADCON0_AD1ON          0x01
#define _AADCON0_GO             0x02
#define _AADCON0_GO_NOT_DONE    0x02
#define _AADCON0_GO_NOT_DONE1   0x02
#define _AADCON0_CHS0           0x04
#define _AADCON0_CHS1           0x08
#define _AADCON0_CHS2           0x10
#define _AADCON0_CHS3           0x20
#define _AADCON0_CHS4           0x40
#define _AADCON0_CHS5           0x80

//==============================================================================


//==============================================================================
//        AD1CON0 Bits

extern __at(0x0711) __sfr AD1CON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO                 : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned CHS5               : 1;
    };

  struct
    {
    unsigned AD1ON              : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE1       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 6;
    };
  } __AD1CON0bits_t;

extern __at(0x0711) volatile __AD1CON0bits_t AD1CON0bits;

#define _AD1CON0_ADON           0x01
#define _AD1CON0_AD1ON          0x01
#define _AD1CON0_GO             0x02
#define _AD1CON0_GO_NOT_DONE    0x02
#define _AD1CON0_GO_NOT_DONE1   0x02
#define _AD1CON0_CHS0           0x04
#define _AD1CON0_CHS1           0x08
#define _AD1CON0_CHS2           0x10
#define _AD1CON0_CHS3           0x20
#define _AD1CON0_CHS4           0x40
#define _AD1CON0_CHS5           0x80

//==============================================================================


//==============================================================================
//        AADCON1 Bits

extern __at(0x0712) __sfr AADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned GO_NOT_DONE_ALL    : 1;
    unsigned ADNREF             : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO_ALL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __AADCON1bits_t;

extern __at(0x0712) volatile __AADCON1bits_t AADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _GO_NOT_DONE_ALL        0x04
#define _GO_ALL                 0x04
#define _ADNREF                 0x08
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCOMCON Bits

extern __at(0x0712) __sfr ADCOMCON;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned GO_NOT_DONE_ALL    : 1;
    unsigned ADNREF             : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GO_ALL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCOMCONbits_t;

extern __at(0x0712) volatile __ADCOMCONbits_t ADCOMCONbits;

#define _ADCOMCON_ADPREF0       0x01
#define _ADCOMCON_ADPREF1       0x02
#define _ADCOMCON_GO_NOT_DONE_ALL 0x04
#define _ADCOMCON_GO_ALL        0x04
#define _ADCOMCON_ADNREF        0x08
#define _ADCOMCON_ADCS0         0x10
#define _ADCOMCON_ADCS1         0x20
#define _ADCOMCON_ADCS2         0x40
#define _ADCOMCON_ADFM          0x80

//==============================================================================


//==============================================================================
//        AAD1CON2 Bits

extern __at(0x0713) __sfr AAD1CON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __AAD1CON2bits_t;

extern __at(0x0713) volatile __AAD1CON2bits_t AAD1CON2bits;

#define _TRIGSEL0               0x10
#define _TRIGSEL1               0x20
#define _TRIGSEL2               0x40

//==============================================================================


//==============================================================================
//        AADCON2 Bits

extern __at(0x0713) __sfr AADCON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __AADCON2bits_t;

extern __at(0x0713) volatile __AADCON2bits_t AADCON2bits;

#define _AADCON2_TRIGSEL0       0x10
#define _AADCON2_TRIGSEL1       0x20
#define _AADCON2_TRIGSEL2       0x40

//==============================================================================


//==============================================================================
//        AD1CON2 Bits

extern __at(0x0713) __sfr AD1CON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __AD1CON2bits_t;

extern __at(0x0713) volatile __AD1CON2bits_t AD1CON2bits;

#define _AD1CON2_TRIGSEL0       0x10
#define _AD1CON2_TRIGSEL1       0x20
#define _AD1CON2_TRIGSEL2       0x40

//==============================================================================


//==============================================================================
//        AAD1CON3 Bits

extern __at(0x0714) __sfr AAD1CON3;

typedef union
  {
  struct
    {
    unsigned AD1DSEN            : 1;
    unsigned AD1IPEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD1IPPOL           : 1;
    unsigned AD1EPPOL           : 1;
    };

  struct
    {
    unsigned ADDSEN             : 1;
    unsigned ADIPEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIPPOL            : 1;
    unsigned ADEPPOL            : 1;
    };
  } __AAD1CON3bits_t;

extern __at(0x0714) volatile __AAD1CON3bits_t AAD1CON3bits;

#define _AD1DSEN                0x01
#define _ADDSEN                 0x01
#define _AD1IPEN                0x02
#define _ADIPEN                 0x02
#define _AD1IPPOL               0x40
#define _ADIPPOL                0x40
#define _AD1EPPOL               0x80
#define _ADEPPOL                0x80

//==============================================================================


//==============================================================================
//        AADCON3 Bits

extern __at(0x0714) __sfr AADCON3;

typedef union
  {
  struct
    {
    unsigned AD1DSEN            : 1;
    unsigned AD1IPEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD1IPPOL           : 1;
    unsigned AD1EPPOL           : 1;
    };

  struct
    {
    unsigned ADDSEN             : 1;
    unsigned ADIPEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIPPOL            : 1;
    unsigned ADEPPOL            : 1;
    };
  } __AADCON3bits_t;

extern __at(0x0714) volatile __AADCON3bits_t AADCON3bits;

#define _AADCON3_AD1DSEN        0x01
#define _AADCON3_ADDSEN         0x01
#define _AADCON3_AD1IPEN        0x02
#define _AADCON3_ADIPEN         0x02
#define _AADCON3_AD1IPPOL       0x40
#define _AADCON3_ADIPPOL        0x40
#define _AADCON3_AD1EPPOL       0x80
#define _AADCON3_ADEPPOL        0x80

//==============================================================================


//==============================================================================
//        AD1CON3 Bits

extern __at(0x0714) __sfr AD1CON3;

typedef union
  {
  struct
    {
    unsigned AD1DSEN            : 1;
    unsigned AD1IPEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD1IPPOL           : 1;
    unsigned AD1EPPOL           : 1;
    };

  struct
    {
    unsigned ADDSEN             : 1;
    unsigned ADIPEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIPPOL            : 1;
    unsigned ADEPPOL            : 1;
    };
  } __AD1CON3bits_t;

extern __at(0x0714) volatile __AD1CON3bits_t AD1CON3bits;

#define _AD1CON3_AD1DSEN        0x01
#define _AD1CON3_ADDSEN         0x01
#define _AD1CON3_AD1IPEN        0x02
#define _AD1CON3_ADIPEN         0x02
#define _AD1CON3_AD1IPPOL       0x40
#define _AD1CON3_ADIPPOL        0x40
#define _AD1CON3_AD1EPPOL       0x80
#define _AD1CON3_ADEPPOL        0x80

//==============================================================================


//==============================================================================
//        AADSTAT Bits

extern __at(0x0715) __sfr AADSTAT;

typedef union
  {
  struct
    {
    unsigned AD1STG0            : 1;
    unsigned AD1STG1            : 1;
    unsigned AD1CONV            : 1;
    unsigned                    : 1;
    unsigned AD2STG0            : 1;
    unsigned AD2STG1            : 1;
    unsigned AD2CONV            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCONV             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AD1STG             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned AD2STG             : 2;
    unsigned                    : 2;
    };
  } __AADSTATbits_t;

extern __at(0x0715) volatile __AADSTATbits_t AADSTATbits;

#define _AD1STG0                0x01
#define _AD1STG1                0x02
#define _AD1CONV                0x04
#define _ADCONV                 0x04
#define _AD2STG0                0x10
#define _AD2STG1                0x20
#define _AD2CONV                0x40

//==============================================================================


//==============================================================================
//        ADSTAT Bits

extern __at(0x0715) __sfr ADSTAT;

typedef union
  {
  struct
    {
    unsigned AD1STG0            : 1;
    unsigned AD1STG1            : 1;
    unsigned AD1CONV            : 1;
    unsigned                    : 1;
    unsigned AD2STG0            : 1;
    unsigned AD2STG1            : 1;
    unsigned AD2CONV            : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCONV             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned AD1STG             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned AD2STG             : 2;
    unsigned                    : 2;
    };
  } __ADSTATbits_t;

extern __at(0x0715) volatile __ADSTATbits_t ADSTATbits;

#define _ADSTAT_AD1STG0         0x01
#define _ADSTAT_AD1STG1         0x02
#define _ADSTAT_AD1CONV         0x04
#define _ADSTAT_ADCONV          0x04
#define _ADSTAT_AD2STG0         0x10
#define _ADSTAT_AD2STG1         0x20
#define _ADSTAT_AD2CONV         0x40

//==============================================================================


//==============================================================================
//        AAD1PRE Bits

extern __at(0x0716) __sfr AAD1PRE;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AAD1PREbits_t;

extern __at(0x0716) volatile __AAD1PREbits_t AAD1PREbits;

#define _ADPRE0                 0x01
#define _ADPRE1                 0x02
#define _ADPRE2                 0x04
#define _ADPRE3                 0x08
#define _ADPRE4                 0x10
#define _ADPRE5                 0x20
#define _ADPRE6                 0x40

//==============================================================================


//==============================================================================
//        AADPRE Bits

extern __at(0x0716) __sfr AADPRE;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AADPREbits_t;

extern __at(0x0716) volatile __AADPREbits_t AADPREbits;

#define _AADPRE_ADPRE0          0x01
#define _AADPRE_ADPRE1          0x02
#define _AADPRE_ADPRE2          0x04
#define _AADPRE_ADPRE3          0x08
#define _AADPRE_ADPRE4          0x10
#define _AADPRE_ADPRE5          0x20
#define _AADPRE_ADPRE6          0x40

//==============================================================================


//==============================================================================
//        AD1PRE Bits

extern __at(0x0716) __sfr AD1PRE;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AD1PREbits_t;

extern __at(0x0716) volatile __AD1PREbits_t AD1PREbits;

#define _AD1PRE_ADPRE0          0x01
#define _AD1PRE_ADPRE1          0x02
#define _AD1PRE_ADPRE2          0x04
#define _AD1PRE_ADPRE3          0x08
#define _AD1PRE_ADPRE4          0x10
#define _AD1PRE_ADPRE5          0x20
#define _AD1PRE_ADPRE6          0x40

//==============================================================================


//==============================================================================
//        AD1PRECON Bits

extern __at(0x0716) __sfr AD1PRECON;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AD1PRECONbits_t;

extern __at(0x0716) volatile __AD1PRECONbits_t AD1PRECONbits;

#define _AD1PRECON_ADPRE0       0x01
#define _AD1PRECON_ADPRE1       0x02
#define _AD1PRECON_ADPRE2       0x04
#define _AD1PRECON_ADPRE3       0x08
#define _AD1PRECON_ADPRE4       0x10
#define _AD1PRECON_ADPRE5       0x20
#define _AD1PRECON_ADPRE6       0x40

//==============================================================================


//==============================================================================
//        AAD1ACQ Bits

extern __at(0x0717) __sfr AAD1ACQ;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AAD1ACQbits_t;

extern __at(0x0717) volatile __AAD1ACQbits_t AAD1ACQbits;

#define _ADACQ0                 0x01
#define _ADACQ1                 0x02
#define _ADACQ2                 0x04
#define _ADACQ3                 0x08
#define _ADACQ4                 0x10
#define _ADACQ5                 0x20
#define _ADACQ6                 0x40

//==============================================================================


//==============================================================================
//        AADACQ Bits

extern __at(0x0717) __sfr AADACQ;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AADACQbits_t;

extern __at(0x0717) volatile __AADACQbits_t AADACQbits;

#define _AADACQ_ADACQ0          0x01
#define _AADACQ_ADACQ1          0x02
#define _AADACQ_ADACQ2          0x04
#define _AADACQ_ADACQ3          0x08
#define _AADACQ_ADACQ4          0x10
#define _AADACQ_ADACQ5          0x20
#define _AADACQ_ADACQ6          0x40

//==============================================================================


//==============================================================================
//        AD1ACQ Bits

extern __at(0x0717) __sfr AD1ACQ;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AD1ACQbits_t;

extern __at(0x0717) volatile __AD1ACQbits_t AD1ACQbits;

#define _AD1ACQ_ADACQ0          0x01
#define _AD1ACQ_ADACQ1          0x02
#define _AD1ACQ_ADACQ2          0x04
#define _AD1ACQ_ADACQ3          0x08
#define _AD1ACQ_ADACQ4          0x10
#define _AD1ACQ_ADACQ5          0x20
#define _AD1ACQ_ADACQ6          0x40

//==============================================================================


//==============================================================================
//        AD1ACQCON Bits

extern __at(0x0717) __sfr AD1ACQCON;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AD1ACQCONbits_t;

extern __at(0x0717) volatile __AD1ACQCONbits_t AD1ACQCONbits;

#define _AD1ACQCON_ADACQ0       0x01
#define _AD1ACQCON_ADACQ1       0x02
#define _AD1ACQCON_ADACQ2       0x04
#define _AD1ACQCON_ADACQ3       0x08
#define _AD1ACQCON_ADACQ4       0x10
#define _AD1ACQCON_ADACQ5       0x20
#define _AD1ACQCON_ADACQ6       0x40

//==============================================================================


//==============================================================================
//        AAD1GRD Bits

extern __at(0x0718) __sfr AAD1GRD;

typedef union
  {
  struct
    {
    unsigned TX1POL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRD1POL            : 1;
    unsigned GRD1AOE            : 1;
    unsigned GRD1BOE            : 1;
    };

  struct
    {
    unsigned TXPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRDPOL             : 1;
    unsigned GRDAOE             : 1;
    unsigned GRDBOE             : 1;
    };
  } __AAD1GRDbits_t;

extern __at(0x0718) volatile __AAD1GRDbits_t AAD1GRDbits;

#define _TX1POL                 0x01
#define _TXPOL                  0x01
#define _GRD1POL                0x20
#define _GRDPOL                 0x20
#define _GRD1AOE                0x40
#define _GRDAOE                 0x40
#define _GRD1BOE                0x80
#define _GRDBOE                 0x80

//==============================================================================


//==============================================================================
//        AADGRD Bits

extern __at(0x0718) __sfr AADGRD;

typedef union
  {
  struct
    {
    unsigned TX1POL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRD1POL            : 1;
    unsigned GRD1AOE            : 1;
    unsigned GRD1BOE            : 1;
    };

  struct
    {
    unsigned TXPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRDPOL             : 1;
    unsigned GRDAOE             : 1;
    unsigned GRDBOE             : 1;
    };
  } __AADGRDbits_t;

extern __at(0x0718) volatile __AADGRDbits_t AADGRDbits;

#define _AADGRD_TX1POL          0x01
#define _AADGRD_TXPOL           0x01
#define _AADGRD_GRD1POL         0x20
#define _AADGRD_GRDPOL          0x20
#define _AADGRD_GRD1AOE         0x40
#define _AADGRD_GRDAOE          0x40
#define _AADGRD_GRD1BOE         0x80
#define _AADGRD_GRDBOE          0x80

//==============================================================================


//==============================================================================
//        AD1GRD Bits

extern __at(0x0718) __sfr AD1GRD;

typedef union
  {
  struct
    {
    unsigned TX1POL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRD1POL            : 1;
    unsigned GRD1AOE            : 1;
    unsigned GRD1BOE            : 1;
    };

  struct
    {
    unsigned TXPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRDPOL             : 1;
    unsigned GRDAOE             : 1;
    unsigned GRDBOE             : 1;
    };
  } __AD1GRDbits_t;

extern __at(0x0718) volatile __AD1GRDbits_t AD1GRDbits;

#define _AD1GRD_TX1POL          0x01
#define _AD1GRD_TXPOL           0x01
#define _AD1GRD_GRD1POL         0x20
#define _AD1GRD_GRDPOL          0x20
#define _AD1GRD_GRD1AOE         0x40
#define _AD1GRD_GRDAOE          0x40
#define _AD1GRD_GRD1BOE         0x80
#define _AD1GRD_GRDBOE          0x80

//==============================================================================


//==============================================================================
//        AAD1CAP Bits

extern __at(0x0719) __sfr AAD1CAP;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AAD1CAPbits_t;

extern __at(0x0719) volatile __AAD1CAPbits_t AAD1CAPbits;

#define _ADDCAP0                0x01
#define _ADDCAP1                0x02
#define _ADDCAP2                0x04
#define _ADDCAP3                0x08

//==============================================================================


//==============================================================================
//        AAD1CAPCON Bits

extern __at(0x0719) __sfr AAD1CAPCON;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AAD1CAPCONbits_t;

extern __at(0x0719) volatile __AAD1CAPCONbits_t AAD1CAPCONbits;

#define _AAD1CAPCON_ADDCAP0     0x01
#define _AAD1CAPCON_ADDCAP1     0x02
#define _AAD1CAPCON_ADDCAP2     0x04
#define _AAD1CAPCON_ADDCAP3     0x08

//==============================================================================


//==============================================================================
//        AADCAP Bits

extern __at(0x0719) __sfr AADCAP;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AADCAPbits_t;

extern __at(0x0719) volatile __AADCAPbits_t AADCAPbits;

#define _AADCAP_ADDCAP0         0x01
#define _AADCAP_ADDCAP1         0x02
#define _AADCAP_ADDCAP2         0x04
#define _AADCAP_ADDCAP3         0x08

//==============================================================================


//==============================================================================
//        AD1CAPCON Bits

extern __at(0x0719) __sfr AD1CAPCON;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AD1CAPCONbits_t;

extern __at(0x0719) volatile __AD1CAPCONbits_t AD1CAPCONbits;

#define _AD1CAPCON_ADDCAP0      0x01
#define _AD1CAPCON_ADDCAP1      0x02
#define _AD1CAPCON_ADDCAP2      0x04
#define _AD1CAPCON_ADDCAP3      0x08

//==============================================================================

extern __at(0x071A) __sfr AAD1RES0;
extern __at(0x071A) __sfr AAD1RES0L;
extern __at(0x071A) __sfr AD1RES0;
extern __at(0x071A) __sfr AD1RES0L;
extern __at(0x071A) __sfr ADRES0;
extern __at(0x071B) __sfr AAD1RES0H;
extern __at(0x071B) __sfr AD1RES0H;
extern __at(0x071C) __sfr AAD1RES1;
extern __at(0x071C) __sfr AAD1RES1L;
extern __at(0x071C) __sfr AD1RES1;
extern __at(0x071C) __sfr AD1RES1L;
extern __at(0x071C) __sfr ADRES1;
extern __at(0x071D) __sfr AAD1RES1H;
extern __at(0x071D) __sfr AD1RES1H;
extern __at(0x071E) __sfr AAD1CH;

//==============================================================================
//        AAD1CH0 Bits

extern __at(0x071E) __sfr AAD1CH0;

typedef struct
  {
  unsigned CH10                 : 1;
  unsigned CH11                 : 1;
  unsigned CH12                 : 1;
  unsigned CH13                 : 1;
  unsigned CH14                 : 1;
  unsigned CH15                 : 1;
  unsigned CH16                 : 1;
  unsigned CHS17                : 1;
  } __AAD1CH0bits_t;

extern __at(0x071E) volatile __AAD1CH0bits_t AAD1CH0bits;

#define _CH10                   0x01
#define _CH11                   0x02
#define _CH12                   0x04
#define _CH13                   0x08
#define _CH14                   0x10
#define _CH15                   0x20
#define _CH16                   0x40
#define _CHS17                  0x80

//==============================================================================

extern __at(0x071E) __sfr AD1CH;

//==============================================================================
//        AD1CH0 Bits

extern __at(0x071E) __sfr AD1CH0;

typedef struct
  {
  unsigned CH10                 : 1;
  unsigned CH11                 : 1;
  unsigned CH12                 : 1;
  unsigned CH13                 : 1;
  unsigned CH14                 : 1;
  unsigned CH15                 : 1;
  unsigned CH16                 : 1;
  unsigned CHS17                : 1;
  } __AD1CH0bits_t;

extern __at(0x071E) volatile __AD1CH0bits_t AD1CH0bits;

#define _AD1CH0_CH10            0x01
#define _AD1CH0_CH11            0x02
#define _AD1CH0_CH12            0x04
#define _AD1CH0_CH13            0x08
#define _AD1CH0_CH14            0x10
#define _AD1CH0_CH15            0x20
#define _AD1CH0_CH16            0x40
#define _AD1CH0_CHS17           0x80

//==============================================================================


//==============================================================================
//        AAD1CH1 Bits

extern __at(0x071F) __sfr AAD1CH1;

typedef struct
  {
  unsigned CH18                 : 1;
  unsigned CH19                 : 1;
  unsigned CH30                 : 1;
  unsigned CH31                 : 1;
  unsigned CH32                 : 1;
  unsigned CH33                 : 1;
  unsigned CH34                 : 1;
  unsigned CH35                 : 1;
  } __AAD1CH1bits_t;

extern __at(0x071F) volatile __AAD1CH1bits_t AAD1CH1bits;

#define _CH18                   0x01
#define _CH19                   0x02
#define _CH30                   0x04
#define _CH31                   0x08
#define _CH32                   0x10
#define _CH33                   0x20
#define _CH34                   0x40
#define _CH35                   0x80

//==============================================================================


//==============================================================================
//        AD1CH1 Bits

extern __at(0x071F) __sfr AD1CH1;

typedef struct
  {
  unsigned CH18                 : 1;
  unsigned CH19                 : 1;
  unsigned CH30                 : 1;
  unsigned CH31                 : 1;
  unsigned CH32                 : 1;
  unsigned CH33                 : 1;
  unsigned CH34                 : 1;
  unsigned CH35                 : 1;
  } __AD1CH1bits_t;

extern __at(0x071F) volatile __AD1CH1bits_t AD1CH1bits;

#define _AD1CH1_CH18            0x01
#define _AD1CH1_CH19            0x02
#define _AD1CH1_CH30            0x04
#define _AD1CH1_CH31            0x08
#define _AD1CH1_CH32            0x10
#define _AD1CH1_CH33            0x20
#define _AD1CH1_CH34            0x40
#define _AD1CH1_CH35            0x80

//==============================================================================


//==============================================================================
//        AAD2CON0 Bits

extern __at(0x0791) __sfr AAD2CON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO                 : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned CHS5               : 1;
    };

  struct
    {
    unsigned AD2ON              : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE2       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 6;
    };
  } __AAD2CON0bits_t;

extern __at(0x0791) volatile __AAD2CON0bits_t AAD2CON0bits;

#define _AAD2CON0_ADON          0x01
#define _AAD2CON0_AD2ON         0x01
#define _AAD2CON0_GO            0x02
#define _AAD2CON0_GO_NOT_DONE   0x02
#define _AAD2CON0_GO_NOT_DONE2  0x02
#define _AAD2CON0_CHS0          0x04
#define _AAD2CON0_CHS1          0x08
#define _AAD2CON0_CHS2          0x10
#define _AAD2CON0_CHS3          0x20
#define _AAD2CON0_CHS4          0x40
#define _AAD2CON0_CHS5          0x80

//==============================================================================


//==============================================================================
//        AD2CON0 Bits

extern __at(0x0791) __sfr AD2CON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO                 : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned CHS5               : 1;
    };

  struct
    {
    unsigned AD2ON              : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO_NOT_DONE2       : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 6;
    };
  } __AD2CON0bits_t;

extern __at(0x0791) volatile __AD2CON0bits_t AD2CON0bits;

#define _AD2CON0_ADON           0x01
#define _AD2CON0_AD2ON          0x01
#define _AD2CON0_GO             0x02
#define _AD2CON0_GO_NOT_DONE    0x02
#define _AD2CON0_GO_NOT_DONE2   0x02
#define _AD2CON0_CHS0           0x04
#define _AD2CON0_CHS1           0x08
#define _AD2CON0_CHS2           0x10
#define _AD2CON0_CHS3           0x20
#define _AD2CON0_CHS4           0x40
#define _AD2CON0_CHS5           0x80

//==============================================================================


//==============================================================================
//        AAD2CON2 Bits

extern __at(0x0793) __sfr AAD2CON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __AAD2CON2bits_t;

extern __at(0x0793) volatile __AAD2CON2bits_t AAD2CON2bits;

#define _AAD2CON2_TRIGSEL0      0x10
#define _AAD2CON2_TRIGSEL1      0x20
#define _AAD2CON2_TRIGSEL2      0x40

//==============================================================================


//==============================================================================
//        AD2CON2 Bits

extern __at(0x0793) __sfr AD2CON2;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL0           : 1;
    unsigned TRIGSEL1           : 1;
    unsigned TRIGSEL2           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned TRIGSEL            : 3;
    unsigned                    : 1;
    };
  } __AD2CON2bits_t;

extern __at(0x0793) volatile __AD2CON2bits_t AD2CON2bits;

#define _AD2CON2_TRIGSEL0       0x10
#define _AD2CON2_TRIGSEL1       0x20
#define _AD2CON2_TRIGSEL2       0x40

//==============================================================================


//==============================================================================
//        AAD2CON3 Bits

extern __at(0x0794) __sfr AAD2CON3;

typedef union
  {
  struct
    {
    unsigned AD2DSEN            : 1;
    unsigned AD2IPEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD2IPPOL           : 1;
    unsigned AD2EPPOL           : 1;
    };

  struct
    {
    unsigned ADDSEN             : 1;
    unsigned ADIPEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIPPOL            : 1;
    unsigned ADEPPOL            : 1;
    };
  } __AAD2CON3bits_t;

extern __at(0x0794) volatile __AAD2CON3bits_t AAD2CON3bits;

#define _AAD2CON3_AD2DSEN       0x01
#define _AAD2CON3_ADDSEN        0x01
#define _AAD2CON3_AD2IPEN       0x02
#define _AAD2CON3_ADIPEN        0x02
#define _AAD2CON3_AD2IPPOL      0x40
#define _AAD2CON3_ADIPPOL       0x40
#define _AAD2CON3_AD2EPPOL      0x80
#define _AAD2CON3_ADEPPOL       0x80

//==============================================================================


//==============================================================================
//        AD2CON3 Bits

extern __at(0x0794) __sfr AD2CON3;

typedef union
  {
  struct
    {
    unsigned AD2DSEN            : 1;
    unsigned AD2IPEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned AD2IPPOL           : 1;
    unsigned AD2EPPOL           : 1;
    };

  struct
    {
    unsigned ADDSEN             : 1;
    unsigned ADIPEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADIPPOL            : 1;
    unsigned ADEPPOL            : 1;
    };
  } __AD2CON3bits_t;

extern __at(0x0794) volatile __AD2CON3bits_t AD2CON3bits;

#define _AD2CON3_AD2DSEN        0x01
#define _AD2CON3_ADDSEN         0x01
#define _AD2CON3_AD2IPEN        0x02
#define _AD2CON3_ADIPEN         0x02
#define _AD2CON3_AD2IPPOL       0x40
#define _AD2CON3_ADIPPOL        0x40
#define _AD2CON3_AD2EPPOL       0x80
#define _AD2CON3_ADEPPOL        0x80

//==============================================================================


//==============================================================================
//        AAD2PRE Bits

extern __at(0x0796) __sfr AAD2PRE;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AAD2PREbits_t;

extern __at(0x0796) volatile __AAD2PREbits_t AAD2PREbits;

#define _AAD2PRE_ADPRE0         0x01
#define _AAD2PRE_ADPRE1         0x02
#define _AAD2PRE_ADPRE2         0x04
#define _AAD2PRE_ADPRE3         0x08
#define _AAD2PRE_ADPRE4         0x10
#define _AAD2PRE_ADPRE5         0x20
#define _AAD2PRE_ADPRE6         0x40

//==============================================================================


//==============================================================================
//        AD2PRE Bits

extern __at(0x0796) __sfr AD2PRE;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AD2PREbits_t;

extern __at(0x0796) volatile __AD2PREbits_t AD2PREbits;

#define _AD2PRE_ADPRE0          0x01
#define _AD2PRE_ADPRE1          0x02
#define _AD2PRE_ADPRE2          0x04
#define _AD2PRE_ADPRE3          0x08
#define _AD2PRE_ADPRE4          0x10
#define _AD2PRE_ADPRE5          0x20
#define _AD2PRE_ADPRE6          0x40

//==============================================================================


//==============================================================================
//        AD2PRECON Bits

extern __at(0x0796) __sfr AD2PRECON;

typedef union
  {
  struct
    {
    unsigned ADPRE0             : 1;
    unsigned ADPRE1             : 1;
    unsigned ADPRE2             : 1;
    unsigned ADPRE3             : 1;
    unsigned ADPRE4             : 1;
    unsigned ADPRE5             : 1;
    unsigned ADPRE6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADPRE              : 7;
    unsigned                    : 1;
    };
  } __AD2PRECONbits_t;

extern __at(0x0796) volatile __AD2PRECONbits_t AD2PRECONbits;

#define _AD2PRECON_ADPRE0       0x01
#define _AD2PRECON_ADPRE1       0x02
#define _AD2PRECON_ADPRE2       0x04
#define _AD2PRECON_ADPRE3       0x08
#define _AD2PRECON_ADPRE4       0x10
#define _AD2PRECON_ADPRE5       0x20
#define _AD2PRECON_ADPRE6       0x40

//==============================================================================


//==============================================================================
//        AAD2ACQ Bits

extern __at(0x0797) __sfr AAD2ACQ;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AAD2ACQbits_t;

extern __at(0x0797) volatile __AAD2ACQbits_t AAD2ACQbits;

#define _AAD2ACQ_ADACQ0         0x01
#define _AAD2ACQ_ADACQ1         0x02
#define _AAD2ACQ_ADACQ2         0x04
#define _AAD2ACQ_ADACQ3         0x08
#define _AAD2ACQ_ADACQ4         0x10
#define _AAD2ACQ_ADACQ5         0x20
#define _AAD2ACQ_ADACQ6         0x40

//==============================================================================


//==============================================================================
//        AD2ACQ Bits

extern __at(0x0797) __sfr AD2ACQ;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AD2ACQbits_t;

extern __at(0x0797) volatile __AD2ACQbits_t AD2ACQbits;

#define _AD2ACQ_ADACQ0          0x01
#define _AD2ACQ_ADACQ1          0x02
#define _AD2ACQ_ADACQ2          0x04
#define _AD2ACQ_ADACQ3          0x08
#define _AD2ACQ_ADACQ4          0x10
#define _AD2ACQ_ADACQ5          0x20
#define _AD2ACQ_ADACQ6          0x40

//==============================================================================


//==============================================================================
//        AD2ACQCON Bits

extern __at(0x0797) __sfr AD2ACQCON;

typedef union
  {
  struct
    {
    unsigned ADACQ0             : 1;
    unsigned ADACQ1             : 1;
    unsigned ADACQ2             : 1;
    unsigned ADACQ3             : 1;
    unsigned ADACQ4             : 1;
    unsigned ADACQ5             : 1;
    unsigned ADACQ6             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADACQ              : 7;
    unsigned                    : 1;
    };
  } __AD2ACQCONbits_t;

extern __at(0x0797) volatile __AD2ACQCONbits_t AD2ACQCONbits;

#define _AD2ACQCON_ADACQ0       0x01
#define _AD2ACQCON_ADACQ1       0x02
#define _AD2ACQCON_ADACQ2       0x04
#define _AD2ACQCON_ADACQ3       0x08
#define _AD2ACQCON_ADACQ4       0x10
#define _AD2ACQCON_ADACQ5       0x20
#define _AD2ACQCON_ADACQ6       0x40

//==============================================================================


//==============================================================================
//        AAD2GRD Bits

extern __at(0x0798) __sfr AAD2GRD;

typedef union
  {
  struct
    {
    unsigned TX2POL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRD2POL            : 1;
    unsigned GRD2AOE            : 1;
    unsigned GRD2BOE            : 1;
    };

  struct
    {
    unsigned TXPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRDPOL             : 1;
    unsigned GRDAOE             : 1;
    unsigned GRDBOE             : 1;
    };
  } __AAD2GRDbits_t;

extern __at(0x0798) volatile __AAD2GRDbits_t AAD2GRDbits;

#define _AAD2GRD_TX2POL         0x01
#define _AAD2GRD_TXPOL          0x01
#define _AAD2GRD_GRD2POL        0x20
#define _AAD2GRD_GRDPOL         0x20
#define _AAD2GRD_GRD2AOE        0x40
#define _AAD2GRD_GRDAOE         0x40
#define _AAD2GRD_GRD2BOE        0x80
#define _AAD2GRD_GRDBOE         0x80

//==============================================================================


//==============================================================================
//        AD2GRD Bits

extern __at(0x0798) __sfr AD2GRD;

typedef union
  {
  struct
    {
    unsigned TX2POL             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRD2POL            : 1;
    unsigned GRD2AOE            : 1;
    unsigned GRD2BOE            : 1;
    };

  struct
    {
    unsigned TXPOL              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GRDPOL             : 1;
    unsigned GRDAOE             : 1;
    unsigned GRDBOE             : 1;
    };
  } __AD2GRDbits_t;

extern __at(0x0798) volatile __AD2GRDbits_t AD2GRDbits;

#define _AD2GRD_TX2POL          0x01
#define _AD2GRD_TXPOL           0x01
#define _AD2GRD_GRD2POL         0x20
#define _AD2GRD_GRDPOL          0x20
#define _AD2GRD_GRD2AOE         0x40
#define _AD2GRD_GRDAOE          0x40
#define _AD2GRD_GRD2BOE         0x80
#define _AD2GRD_GRDBOE          0x80

//==============================================================================


//==============================================================================
//        AAD2CAP Bits

extern __at(0x0799) __sfr AAD2CAP;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AAD2CAPbits_t;

extern __at(0x0799) volatile __AAD2CAPbits_t AAD2CAPbits;

#define _AAD2CAP_ADDCAP0        0x01
#define _AAD2CAP_ADDCAP1        0x02
#define _AAD2CAP_ADDCAP2        0x04
#define _AAD2CAP_ADDCAP3        0x08

//==============================================================================


//==============================================================================
//        AAD2CAPCON Bits

extern __at(0x0799) __sfr AAD2CAPCON;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AAD2CAPCONbits_t;

extern __at(0x0799) volatile __AAD2CAPCONbits_t AAD2CAPCONbits;

#define _AAD2CAPCON_ADDCAP0     0x01
#define _AAD2CAPCON_ADDCAP1     0x02
#define _AAD2CAPCON_ADDCAP2     0x04
#define _AAD2CAPCON_ADDCAP3     0x08

//==============================================================================


//==============================================================================
//        AD2CAPCON Bits

extern __at(0x0799) __sfr AD2CAPCON;

typedef union
  {
  struct
    {
    unsigned ADDCAP0            : 1;
    unsigned ADDCAP1            : 1;
    unsigned ADDCAP2            : 1;
    unsigned ADDCAP3            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDCAP             : 4;
    unsigned                    : 4;
    };
  } __AD2CAPCONbits_t;

extern __at(0x0799) volatile __AD2CAPCONbits_t AD2CAPCONbits;

#define _AD2CAPCON_ADDCAP0      0x01
#define _AD2CAPCON_ADDCAP1      0x02
#define _AD2CAPCON_ADDCAP2      0x04
#define _AD2CAPCON_ADDCAP3      0x08

//==============================================================================

extern __at(0x079A) __sfr AAD2RES0;
extern __at(0x079A) __sfr AAD2RES0L;
extern __at(0x079A) __sfr AD2RES0;
extern __at(0x079B) __sfr AAD2RES0H;
extern __at(0x079C) __sfr AAD2RES1;
extern __at(0x079C) __sfr AAD2RES1L;
extern __at(0x079C) __sfr AD2RES1;
extern __at(0x079D) __sfr AAD2RES1H;
extern __at(0x079E) __sfr AAD2CH;

//==============================================================================
//        AAD2CH0 Bits

extern __at(0x079E) __sfr AAD2CH0;

typedef struct
  {
  unsigned CH20                 : 1;
  unsigned CH21                 : 1;
  unsigned CH22                 : 1;
  unsigned CH23                 : 1;
  unsigned CH24                 : 1;
  unsigned CH25                 : 1;
  unsigned CH26                 : 1;
  unsigned CH27                 : 1;
  } __AAD2CH0bits_t;

extern __at(0x079E) volatile __AAD2CH0bits_t AAD2CH0bits;

#define _CH20                   0x01
#define _CH21                   0x02
#define _CH22                   0x04
#define _CH23                   0x08
#define _CH24                   0x10
#define _CH25                   0x20
#define _CH26                   0x40
#define _CH27                   0x80

//==============================================================================

extern __at(0x079E) __sfr AD2CH;

//==============================================================================
//        AD2CH0 Bits

extern __at(0x079E) __sfr AD2CH0;

typedef struct
  {
  unsigned CH20                 : 1;
  unsigned CH21                 : 1;
  unsigned CH22                 : 1;
  unsigned CH23                 : 1;
  unsigned CH24                 : 1;
  unsigned CH25                 : 1;
  unsigned CH26                 : 1;
  unsigned CH27                 : 1;
  } __AD2CH0bits_t;

extern __at(0x079E) volatile __AD2CH0bits_t AD2CH0bits;

#define _AD2CH0_CH20            0x01
#define _AD2CH0_CH21            0x02
#define _AD2CH0_CH22            0x04
#define _AD2CH0_CH23            0x08
#define _AD2CH0_CH24            0x10
#define _AD2CH0_CH25            0x20
#define _AD2CH0_CH26            0x40
#define _AD2CH0_CH27            0x80

//==============================================================================


//==============================================================================
//        AAD2CH1 Bits

extern __at(0x079F) __sfr AAD2CH1;

typedef struct
  {
  unsigned CH28                 : 1;
  unsigned CH29                 : 1;
  unsigned CH40                 : 1;
  unsigned CH41                 : 1;
  unsigned CH42                 : 1;
  unsigned CH43                 : 1;
  unsigned CH44                 : 1;
  unsigned CH45                 : 1;
  } __AAD2CH1bits_t;

extern __at(0x079F) volatile __AAD2CH1bits_t AAD2CH1bits;

#define _CH28                   0x01
#define _CH29                   0x02
#define _CH40                   0x04
#define _CH41                   0x08
#define _CH42                   0x10
#define _CH43                   0x20
#define _CH44                   0x40
#define _CH45                   0x80

//==============================================================================


//==============================================================================
//        AD2CH1 Bits

extern __at(0x079F) __sfr AD2CH1;

typedef struct
  {
  unsigned CH28                 : 1;
  unsigned CH29                 : 1;
  unsigned CH40                 : 1;
  unsigned CH41                 : 1;
  unsigned CH42                 : 1;
  unsigned CH43                 : 1;
  unsigned CH44                 : 1;
  unsigned CH45                 : 1;
  } __AD2CH1bits_t;

extern __at(0x079F) volatile __AD2CH1bits_t AD2CH1bits;

#define _AD2CH1_CH28            0x01
#define _AD2CH1_CH29            0x02
#define _AD2CH1_CH40            0x04
#define _AD2CH1_CH41            0x08
#define _AD2CH1_CH42            0x10
#define _AD2CH1_CH43            0x20
#define _AD2CH1_CH44            0x40
#define _AD2CH1_CH45            0x80

//==============================================================================


//==============================================================================
//        ICDIO Bits

extern __at(0x0F8C) __sfr ICDIO;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRIS_ICDCLK          : 1;
  unsigned TRIS_ICDDAT          : 1;
  unsigned LAT_ICDCLK           : 1;
  unsigned LAT_ICDDAT           : 1;
  unsigned PORT_ICDCLK          : 1;
  unsigned PORT_ICDDAT          : 1;
  } __ICDIObits_t;

extern __at(0x0F8C) volatile __ICDIObits_t ICDIObits;

#define _TRIS_ICDCLK            0x04
#define _TRIS_ICDDAT            0x08
#define _LAT_ICDCLK             0x10
#define _LAT_ICDDAT             0x20
#define _PORT_ICDCLK            0x40
#define _PORT_ICDDAT            0x80

//==============================================================================


//==============================================================================
//        ICDCON0 Bits

extern __at(0x0F8D) __sfr ICDCON0;

typedef struct
  {
  unsigned RSTVEC               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned DBGINEX              : 1;
  unsigned                      : 1;
  unsigned SSTEP                : 1;
  unsigned FREEZ                : 1;
  unsigned INBUG                : 1;
  } __ICDCON0bits_t;

extern __at(0x0F8D) volatile __ICDCON0bits_t ICDCON0bits;

#define _RSTVEC                 0x01
#define _DBGINEX                0x08
#define _SSTEP                  0x20
#define _FREEZ                  0x40
#define _INBUG                  0x80

//==============================================================================


//==============================================================================
//        ICDSTAT Bits

extern __at(0x0F91) __sfr ICDSTAT;

typedef struct
  {
  unsigned                      : 1;
  unsigned USRHLTF              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TRP0HLTF             : 1;
  unsigned TRP1HLTF             : 1;
  } __ICDSTATbits_t;

extern __at(0x0F91) volatile __ICDSTATbits_t ICDSTATbits;

#define _USRHLTF                0x02
#define _TRP0HLTF               0x40
#define _TRP1HLTF               0x80

//==============================================================================


//==============================================================================
//        ICDINSTL Bits

extern __at(0x0F96) __sfr ICDINSTL;

typedef struct
  {
  unsigned DBGIN0               : 1;
  unsigned DBGIN1               : 1;
  unsigned DBGIN2               : 1;
  unsigned DBGIN3               : 1;
  unsigned DBGIN4               : 1;
  unsigned DBGIN5               : 1;
  unsigned DBGIN6               : 1;
  unsigned DBGIN7               : 1;
  } __ICDINSTLbits_t;

extern __at(0x0F96) volatile __ICDINSTLbits_t ICDINSTLbits;

#define _DBGIN0                 0x01
#define _DBGIN1                 0x02
#define _DBGIN2                 0x04
#define _DBGIN3                 0x08
#define _DBGIN4                 0x10
#define _DBGIN5                 0x20
#define _DBGIN6                 0x40
#define _DBGIN7                 0x80

//==============================================================================


//==============================================================================
//        ICDINSTH Bits

extern __at(0x0F97) __sfr ICDINSTH;

typedef struct
  {
  unsigned DBGIN8               : 1;
  unsigned DBGIN9               : 1;
  unsigned DBGIN10              : 1;
  unsigned DBGIN11              : 1;
  unsigned DBGIN12              : 1;
  unsigned DBGIN13              : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ICDINSTHbits_t;

extern __at(0x0F97) volatile __ICDINSTHbits_t ICDINSTHbits;

#define _DBGIN8                 0x01
#define _DBGIN9                 0x02
#define _DBGIN10                0x04
#define _DBGIN11                0x08
#define _DBGIN12                0x10
#define _DBGIN13                0x20

//==============================================================================


//==============================================================================
//        ICDBK0CON Bits

extern __at(0x0F9C) __sfr ICDBK0CON;

typedef struct
  {
  unsigned BKHLT                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BKEN                 : 1;
  } __ICDBK0CONbits_t;

extern __at(0x0F9C) volatile __ICDBK0CONbits_t ICDBK0CONbits;

#define _BKHLT                  0x01
#define _BKEN                   0x80

//==============================================================================


//==============================================================================
//        ICDBK0L Bits

extern __at(0x0F9D) __sfr ICDBK0L;

typedef struct
  {
  unsigned BKA0                 : 1;
  unsigned BKA1                 : 1;
  unsigned BKA2                 : 1;
  unsigned BKA3                 : 1;
  unsigned BKA4                 : 1;
  unsigned BKA5                 : 1;
  unsigned BKA6                 : 1;
  unsigned BKA7                 : 1;
  } __ICDBK0Lbits_t;

extern __at(0x0F9D) volatile __ICDBK0Lbits_t ICDBK0Lbits;

#define _BKA0                   0x01
#define _BKA1                   0x02
#define _BKA2                   0x04
#define _BKA3                   0x08
#define _BKA4                   0x10
#define _BKA5                   0x20
#define _BKA6                   0x40
#define _BKA7                   0x80

//==============================================================================


//==============================================================================
//        ICDBK0H Bits

extern __at(0x0F9E) __sfr ICDBK0H;

typedef struct
  {
  unsigned BKA8                 : 1;
  unsigned BKA9                 : 1;
  unsigned BKA10                : 1;
  unsigned BKA11                : 1;
  unsigned BKA12                : 1;
  unsigned BKA13                : 1;
  unsigned BKA14                : 1;
  unsigned                      : 1;
  } __ICDBK0Hbits_t;

extern __at(0x0F9E) volatile __ICDBK0Hbits_t ICDBK0Hbits;

#define _BKA8                   0x01
#define _BKA9                   0x02
#define _BKA10                  0x04
#define _BKA11                  0x08
#define _BKA12                  0x10
#define _BKA13                  0x20
#define _BKA14                  0x40

//==============================================================================

extern __at(0x0FE3) __sfr BSRICDSHAD;

//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_INTOSC            0x3FFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0x3FFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECM               0x3FFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pins.
#define _FOSC_ECH               0x3FFF  // ECH, External Clock, High Power Mode (4-20 MHz): device clock supplied to CLKIN pins.
#define _WDTE_OFF               0x3FE7  // WDT disabled. SWDTEN bit is ignored.
#define _WDTE_SWDTEN            0x3FEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0x3FF7  // WDT enabled while running and disabled in Sleep. SWDTEN bit is ignored.
#define _WDTE_ON                0x3FFF  // WDT enabled. SWDTEN bit is ignored.
#define _PWRTE_ON               0x3FDF  // PWRT enabled.
#define _PWRTE_OFF              0x3FFF  // PWRT disabled.
#define _MCLRE_OFF              0x3FBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0x3FFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0x3F7F  // Program memory code protection is enabled.
#define _CP_OFF                 0x3FFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0x39FF  // Brown-out Reset disabled. SBOREN bit is ignored.
#define _BOREN_SBODEN           0x3BFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0x3DFF  // Brown-out Reset enabled while running and disabled in Sleep. SBOREN bit is ignored.
#define _BOREN_ON               0x3FFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0x37FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0x3FFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0x3FFC  // 000h to FFFh write protected, no addresses may be modified by PMCON control.
#define _WRT_HALF               0x3FFD  // 000h to 7FFh write protected, 800h to FFFh may be modified by PMCON control.
#define _WRT_BOOT               0x3FFE  // 000h to 1FFh write protected, 200h to FFFh may be modified by PMCON control.
#define _WRT_OFF                0x3FFF  // Write protection off.
#define _STVREN_OFF             0x3DFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0x3FFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0x3BFF  // Brown-out Reset Voltage (Vbor), 2.7V trip point selected.
#define _BORV_LO                0x3FFF  // Brown-out Reset Voltage (Vbor), 1.9V trip point selected.
#define _LPBOR_ON               0x37FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0x3FFF  // Low-Power BOR is disabled.
#define _LVP_OFF                0x1FFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0x3FFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADACQ0                  AAD1ACQbits.ADACQ0              // bit 0
#define ADACQ1                  AAD1ACQbits.ADACQ1              // bit 1
#define ADACQ2                  AAD1ACQbits.ADACQ2              // bit 2
#define ADACQ3                  AAD1ACQbits.ADACQ3              // bit 3
#define ADACQ4                  AAD1ACQbits.ADACQ4              // bit 4
#define ADACQ5                  AAD1ACQbits.ADACQ5              // bit 5
#define ADACQ6                  AAD1ACQbits.ADACQ6              // bit 6

#define ADDCAP0                 AAD1CAPbits.ADDCAP0             // bit 0
#define ADDCAP1                 AAD1CAPbits.ADDCAP1             // bit 1
#define ADDCAP2                 AAD1CAPbits.ADDCAP2             // bit 2
#define ADDCAP3                 AAD1CAPbits.ADDCAP3             // bit 3

#define CH10                    AAD1CH0bits.CH10                // bit 0
#define CH11                    AAD1CH0bits.CH11                // bit 1
#define CH12                    AAD1CH0bits.CH12                // bit 2
#define CH13                    AAD1CH0bits.CH13                // bit 3
#define CH14                    AAD1CH0bits.CH14                // bit 4
#define CH15                    AAD1CH0bits.CH15                // bit 5
#define CH16                    AAD1CH0bits.CH16                // bit 6
#define CHS17                   AAD1CH0bits.CHS17               // bit 7

#define CH18                    AAD1CH1bits.CH18                // bit 0
#define CH19                    AAD1CH1bits.CH19                // bit 1
#define CH30                    AAD1CH1bits.CH30                // bit 2
#define CH31                    AAD1CH1bits.CH31                // bit 3
#define CH32                    AAD1CH1bits.CH32                // bit 4
#define CH33                    AAD1CH1bits.CH33                // bit 5
#define CH34                    AAD1CH1bits.CH34                // bit 6
#define CH35                    AAD1CH1bits.CH35                // bit 7

#define ADON                    AAD1CON0bits.ADON               // bit 0, shadows bit in AAD1CON0bits
#define AD1ON                   AAD1CON0bits.AD1ON              // bit 0, shadows bit in AAD1CON0bits
#define GO                      AAD1CON0bits.GO                 // bit 1, shadows bit in AAD1CON0bits
#define GO_NOT_DONE             AAD1CON0bits.GO_NOT_DONE        // bit 1, shadows bit in AAD1CON0bits
#define GO_NOT_DONE1            AAD1CON0bits.GO_NOT_DONE1       // bit 1, shadows bit in AAD1CON0bits
#define CHS0                    AAD1CON0bits.CHS0               // bit 2
#define CHS1                    AAD1CON0bits.CHS1               // bit 3
#define CHS2                    AAD1CON0bits.CHS2               // bit 4
#define CHS3                    AAD1CON0bits.CHS3               // bit 5
#define CHS4                    AAD1CON0bits.CHS4               // bit 6
#define CHS5                    AAD1CON0bits.CHS5               // bit 7

#define TRIGSEL0                AAD1CON2bits.TRIGSEL0           // bit 4
#define TRIGSEL1                AAD1CON2bits.TRIGSEL1           // bit 5
#define TRIGSEL2                AAD1CON2bits.TRIGSEL2           // bit 6

#define AD1DSEN                 AAD1CON3bits.AD1DSEN            // bit 0, shadows bit in AAD1CON3bits
#define ADDSEN                  AAD1CON3bits.ADDSEN             // bit 0, shadows bit in AAD1CON3bits
#define AD1IPEN                 AAD1CON3bits.AD1IPEN            // bit 1, shadows bit in AAD1CON3bits
#define ADIPEN                  AAD1CON3bits.ADIPEN             // bit 1, shadows bit in AAD1CON3bits
#define AD1IPPOL                AAD1CON3bits.AD1IPPOL           // bit 6, shadows bit in AAD1CON3bits
#define ADIPPOL                 AAD1CON3bits.ADIPPOL            // bit 6, shadows bit in AAD1CON3bits
#define AD1EPPOL                AAD1CON3bits.AD1EPPOL           // bit 7, shadows bit in AAD1CON3bits
#define ADEPPOL                 AAD1CON3bits.ADEPPOL            // bit 7, shadows bit in AAD1CON3bits

#define TX1POL                  AAD1GRDbits.TX1POL              // bit 0, shadows bit in AAD1GRDbits
#define TXPOL                   AAD1GRDbits.TXPOL               // bit 0, shadows bit in AAD1GRDbits
#define GRD1POL                 AAD1GRDbits.GRD1POL             // bit 5, shadows bit in AAD1GRDbits
#define GRDPOL                  AAD1GRDbits.GRDPOL              // bit 5, shadows bit in AAD1GRDbits
#define GRD1AOE                 AAD1GRDbits.GRD1AOE             // bit 6, shadows bit in AAD1GRDbits
#define GRDAOE                  AAD1GRDbits.GRDAOE              // bit 6, shadows bit in AAD1GRDbits
#define GRD1BOE                 AAD1GRDbits.GRD1BOE             // bit 7, shadows bit in AAD1GRDbits
#define GRDBOE                  AAD1GRDbits.GRDBOE              // bit 7, shadows bit in AAD1GRDbits

#define ADPRE0                  AAD1PREbits.ADPRE0              // bit 0
#define ADPRE1                  AAD1PREbits.ADPRE1              // bit 1
#define ADPRE2                  AAD1PREbits.ADPRE2              // bit 2
#define ADPRE3                  AAD1PREbits.ADPRE3              // bit 3
#define ADPRE4                  AAD1PREbits.ADPRE4              // bit 4
#define ADPRE5                  AAD1PREbits.ADPRE5              // bit 5
#define ADPRE6                  AAD1PREbits.ADPRE6              // bit 6

#define TX10                    AAD1TX0bits.TX10                // bit 0
#define TX11                    AAD1TX0bits.TX11                // bit 1
#define TX12                    AAD1TX0bits.TX12                // bit 2
#define TX13                    AAD1TX0bits.TX13                // bit 3
#define TX14                    AAD1TX0bits.TX14                // bit 4
#define TX15                    AAD1TX0bits.TX15                // bit 5
#define TX16                    AAD1TX0bits.TX16                // bit 6
#define TX17                    AAD1TX0bits.TX17                // bit 7

#define TX18                    AAD1TX1bits.TX18                // bit 0
#define TX19                    AAD1TX1bits.TX19                // bit 1
#define TX30                    AAD1TX1bits.TX30                // bit 2
#define TX31                    AAD1TX1bits.TX31                // bit 3
#define TX32                    AAD1TX1bits.TX32                // bit 4
#define TX33                    AAD1TX1bits.TX33                // bit 5
#define TX34                    AAD1TX1bits.TX34                // bit 6
#define TX35                    AAD1TX1bits.TX35                // bit 7

#define CH20                    AAD2CH0bits.CH20                // bit 0
#define CH21                    AAD2CH0bits.CH21                // bit 1
#define CH22                    AAD2CH0bits.CH22                // bit 2
#define CH23                    AAD2CH0bits.CH23                // bit 3
#define CH24                    AAD2CH0bits.CH24                // bit 4
#define CH25                    AAD2CH0bits.CH25                // bit 5
#define CH26                    AAD2CH0bits.CH26                // bit 6
#define CH27                    AAD2CH0bits.CH27                // bit 7

#define CH28                    AAD2CH1bits.CH28                // bit 0
#define CH29                    AAD2CH1bits.CH29                // bit 1
#define CH40                    AAD2CH1bits.CH40                // bit 2
#define CH41                    AAD2CH1bits.CH41                // bit 3
#define CH42                    AAD2CH1bits.CH42                // bit 4
#define CH43                    AAD2CH1bits.CH43                // bit 5
#define CH44                    AAD2CH1bits.CH44                // bit 6
#define CH45                    AAD2CH1bits.CH45                // bit 7

#define TX20                    AAD2TX0bits.TX20                // bit 0
#define TX21                    AAD2TX0bits.TX21                // bit 1
#define TX22                    AAD2TX0bits.TX22                // bit 2
#define TX23                    AAD2TX0bits.TX23                // bit 3
#define TX24                    AAD2TX0bits.TX24                // bit 4
#define TX25                    AAD2TX0bits.TX25                // bit 5
#define TX26                    AAD2TX0bits.TX26                // bit 6
#define TX27                    AAD2TX0bits.TX27                // bit 7

#define TX28                    AAD2TX1bits.TX28                // bit 0
#define TX29                    AAD2TX1bits.TX29                // bit 1
#define TX40                    AAD2TX1bits.TX40                // bit 2
#define TX41                    AAD2TX1bits.TX41                // bit 3
#define TX42                    AAD2TX1bits.TX42                // bit 4
#define TX43                    AAD2TX1bits.TX43                // bit 5
#define TX44                    AAD2TX1bits.TX44                // bit 6
#define TX45                    AAD2TX1bits.TX45                // bit 7

#define ADPREF0                 AADCON1bits.ADPREF0             // bit 0
#define ADPREF1                 AADCON1bits.ADPREF1             // bit 1
#define GO_NOT_DONE_ALL         AADCON1bits.GO_NOT_DONE_ALL     // bit 2, shadows bit in AADCON1bits
#define GO_ALL                  AADCON1bits.GO_ALL              // bit 2, shadows bit in AADCON1bits
#define ADNREF                  AADCON1bits.ADNREF              // bit 3
#define ADCS0                   AADCON1bits.ADCS0               // bit 4
#define ADCS1                   AADCON1bits.ADCS1               // bit 5
#define ADCS2                   AADCON1bits.ADCS2               // bit 6
#define ADFM                    AADCON1bits.ADFM                // bit 7

#define AD1STG0                 AADSTATbits.AD1STG0             // bit 0
#define AD1STG1                 AADSTATbits.AD1STG1             // bit 1
#define AD1CONV                 AADSTATbits.AD1CONV             // bit 2, shadows bit in AADSTATbits
#define ADCONV                  AADSTATbits.ADCONV              // bit 2, shadows bit in AADSTATbits
#define AD2STG0                 AADSTATbits.AD2STG0             // bit 4
#define AD2STG1                 AADSTATbits.AD2STG1             // bit 5
#define AD2CONV                 AADSTATbits.AD2CONV             // bit 6

#define A1TX0                   ADCTXbits.A1TX0                 // bit 0
#define A1TX1                   ADCTXbits.A1TX1                 // bit 1
#define A1TX2                   ADCTXbits.A1TX2                 // bit 2
#define A2TX0                   ADCTXbits.A2TX0                 // bit 4
#define A2TX1                   ADCTXbits.A2TX1                 // bit 5
#define A2TX2                   ADCTXbits.A2TX2                 // bit 6

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA3                   ANSELAbits.ANSA3                // bit 3
#define ANSA4                   ANSELAbits.ANSA4                // bit 4
#define ANSA5                   ANSELAbits.ANSA5                // bit 5
#define ANSA6                   ANSELAbits.ANSA6                // bit 6
#define ANSA7                   ANSELAbits.ANSA7                // bit 7

#define ANSB0                   ANSELBbits.ANSB0                // bit 0
#define ANSB1                   ANSELBbits.ANSB1                // bit 1
#define ANSB2                   ANSELBbits.ANSB2                // bit 2
#define ANSB3                   ANSELBbits.ANSB3                // bit 3
#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5
#define ANSB6                   ANSELBbits.ANSB6                // bit 6
#define ANSB7                   ANSELBbits.ANSB7                // bit 7

#define ANSC0                   ANSELCbits.ANSC0                // bit 0
#define ANSC1                   ANSELCbits.ANSC1                // bit 1
#define ANSC2                   ANSELCbits.ANSC2                // bit 2
#define ANSC3                   ANSELCbits.ANSC3                // bit 3
#define ANSC4                   ANSELCbits.ANSC4                // bit 4
#define ANSC5                   ANSELCbits.ANSC5                // bit 5
#define ANSC6                   ANSELCbits.ANSC6                // bit 6
#define ANSC7                   ANSELCbits.ANSC7                // bit 7

#define ANSD0                   ANSELDbits.ANSD0                // bit 0
#define ANSD1                   ANSELDbits.ANSD1                // bit 1
#define ANSD2                   ANSELDbits.ANSD2                // bit 2
#define ANSD3                   ANSELDbits.ANSD3                // bit 3
#define ANSD4                   ANSELDbits.ANSD4                // bit 4
#define ANSD5                   ANSELDbits.ANSD5                // bit 5
#define ANSD6                   ANSELDbits.ANSD6                // bit 6
#define ANSD7                   ANSELDbits.ANSD7                // bit 7

#define ANSE0                   ANSELEbits.ANSE0                // bit 0
#define ANSE1                   ANSELEbits.ANSE1                // bit 1
#define ANSE2                   ANSELEbits.ANSE2                // bit 2

#define GRDASEL                 APFCONbits.GRDASEL              // bit 0
#define GRDBSEL                 APFCONbits.GRDBSEL              // bit 1
#define SSSEL                   APFCONbits.SSSEL                // bit 5

#define ABDEN                   BAUDCONbits.ABDEN               // bit 0
#define WUE                     BAUDCONbits.WUE                 // bit 1
#define BRG16                   BAUDCONbits.BRG16               // bit 3
#define SCKP                    BAUDCONbits.SCKP                // bit 4
#define RCIDL                   BAUDCONbits.RCIDL               // bit 6
#define ABDOVF                  BAUDCONbits.ABDOVF              // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define BKHLT                   ICDBK0CONbits.BKHLT             // bit 0
#define BKEN                    ICDBK0CONbits.BKEN              // bit 7

#define BKA8                    ICDBK0Hbits.BKA8                // bit 0
#define BKA9                    ICDBK0Hbits.BKA9                // bit 1
#define BKA10                   ICDBK0Hbits.BKA10               // bit 2
#define BKA11                   ICDBK0Hbits.BKA11               // bit 3
#define BKA12                   ICDBK0Hbits.BKA12               // bit 4
#define BKA13                   ICDBK0Hbits.BKA13               // bit 5
#define BKA14                   ICDBK0Hbits.BKA14               // bit 6

#define BKA0                    ICDBK0Lbits.BKA0                // bit 0
#define BKA1                    ICDBK0Lbits.BKA1                // bit 1
#define BKA2                    ICDBK0Lbits.BKA2                // bit 2
#define BKA3                    ICDBK0Lbits.BKA3                // bit 3
#define BKA4                    ICDBK0Lbits.BKA4                // bit 4
#define BKA5                    ICDBK0Lbits.BKA5                // bit 5
#define BKA6                    ICDBK0Lbits.BKA6                // bit 6
#define BKA7                    ICDBK0Lbits.BKA7                // bit 7

#define RSTVEC                  ICDCON0bits.RSTVEC              // bit 0
#define DBGINEX                 ICDCON0bits.DBGINEX             // bit 3
#define SSTEP                   ICDCON0bits.SSTEP               // bit 5
#define FREEZ                   ICDCON0bits.FREEZ               // bit 6
#define INBUG                   ICDCON0bits.INBUG               // bit 7

#define DBGIN8                  ICDINSTHbits.DBGIN8             // bit 0
#define DBGIN9                  ICDINSTHbits.DBGIN9             // bit 1
#define DBGIN10                 ICDINSTHbits.DBGIN10            // bit 2
#define DBGIN11                 ICDINSTHbits.DBGIN11            // bit 3
#define DBGIN12                 ICDINSTHbits.DBGIN12            // bit 4
#define DBGIN13                 ICDINSTHbits.DBGIN13            // bit 5

#define DBGIN0                  ICDINSTLbits.DBGIN0             // bit 0
#define DBGIN1                  ICDINSTLbits.DBGIN1             // bit 1
#define DBGIN2                  ICDINSTLbits.DBGIN2             // bit 2
#define DBGIN3                  ICDINSTLbits.DBGIN3             // bit 3
#define DBGIN4                  ICDINSTLbits.DBGIN4             // bit 4
#define DBGIN5                  ICDINSTLbits.DBGIN5             // bit 5
#define DBGIN6                  ICDINSTLbits.DBGIN6             // bit 6
#define DBGIN7                  ICDINSTLbits.DBGIN7             // bit 7

#define TRIS_ICDCLK             ICDIObits.TRIS_ICDCLK           // bit 2
#define TRIS_ICDDAT             ICDIObits.TRIS_ICDDAT           // bit 3
#define LAT_ICDCLK              ICDIObits.LAT_ICDCLK            // bit 4
#define LAT_ICDDAT              ICDIObits.LAT_ICDDAT            // bit 5
#define PORT_ICDCLK             ICDIObits.PORT_ICDCLK           // bit 6
#define PORT_ICDDAT             ICDIObits.PORT_ICDDAT           // bit 7

#define USRHLTF                 ICDSTATbits.USRHLTF             // bit 1
#define TRP0HLTF                ICDSTATbits.TRP0HLTF            // bit 6
#define TRP1HLTF                ICDSTATbits.TRP1HLTF            // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCBF0                  IOCBFbits.IOCBF0                // bit 0
#define IOCBF1                  IOCBFbits.IOCBF1                // bit 1
#define IOCBF2                  IOCBFbits.IOCBF2                // bit 2
#define IOCBF3                  IOCBFbits.IOCBF3                // bit 3
#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN0                  IOCBNbits.IOCBN0                // bit 0
#define IOCBN1                  IOCBNbits.IOCBN1                // bit 1
#define IOCBN2                  IOCBNbits.IOCBN2                // bit 2
#define IOCBN3                  IOCBNbits.IOCBN3                // bit 3
#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP0                  IOCBPbits.IOCBP0                // bit 0
#define IOCBP1                  IOCBPbits.IOCBP1                // bit 1
#define IOCBP2                  IOCBPbits.IOCBP2                // bit 2
#define IOCBP3                  IOCBPbits.IOCBP3                // bit 3
#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA3                   LATAbits.LATA3                  // bit 3
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5
#define LATA6                   LATAbits.LATA6                  // bit 6
#define LATA7                   LATAbits.LATA7                  // bit 7

#define LATB0                   LATBbits.LATB0                  // bit 0
#define LATB1                   LATBbits.LATB1                  // bit 1
#define LATB2                   LATBbits.LATB2                  // bit 2
#define LATB3                   LATBbits.LATB3                  // bit 3
#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define LATD0                   LATDbits.LATD0                  // bit 0
#define LATD1                   LATDbits.LATD1                  // bit 1
#define LATD2                   LATDbits.LATD2                  // bit 2
#define LATD3                   LATDbits.LATD3                  // bit 3
#define LATD4                   LATDbits.LATD4                  // bit 4
#define LATD5                   LATDbits.LATD5                  // bit 5
#define LATD6                   LATDbits.LATD6                  // bit 6
#define LATD7                   LATDbits.LATD7                  // bit 7

#define LATE0                   LATEbits.LATE0                  // bit 0
#define LATE1                   LATEbits.LATE1                  // bit 1
#define LATE2                   LATEbits.LATE2                  // bit 2

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6
#define SPLLEN                  OSCCONbits.SPLLEN               // bit 7

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define PLLSR                   OSCSTATbits.PLLSR               // bit 6

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TMR2IE                  PIE1bits.TMR2IE                 // bit 1
#define SSP2IE                  PIE1bits.SSP2IE                 // bit 2
#define SSP1IE                  PIE1bits.SSP1IE                 // bit 3, shadows bit in PIE1bits
#define SSPIE                   PIE1bits.SSPIE                  // bit 3, shadows bit in PIE1bits
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6, shadows bit in PIE1bits
#define AD1IE                   PIE1bits.AD1IE                  // bit 6, shadows bit in PIE1bits
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define TMR4IE                  PIE2bits.TMR4IE                 // bit 1
#define BCL2IE                  PIE2bits.BCL2IE                 // bit 2
#define BCL1IE                  PIE2bits.BCL1IE                 // bit 3
#define AD2IE                   PIE2bits.AD2IE                  // bit 6

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TMR2IF                  PIR1bits.TMR2IF                 // bit 1
#define SSP2IF                  PIR1bits.SSP2IF                 // bit 2
#define SSP1IF                  PIR1bits.SSP1IF                 // bit 3
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6, shadows bit in PIR1bits
#define AD1IF                   PIR1bits.AD1IF                  // bit 6, shadows bit in PIR1bits
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define TMR4IF                  PIR2bits.TMR4IF                 // bit 1
#define BCL2IF                  PIR2bits.BCL2IF                 // bit 2
#define BCL1IF                  PIR2bits.BCL1IF                 // bit 3
#define AD2IF                   PIR2bits.AD2IF                  // bit 6

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5
#define RA6                     PORTAbits.RA6                   // bit 6
#define RA7                     PORTAbits.RA7                   // bit 7

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define RD0                     PORTDbits.RD0                   // bit 0
#define RD1                     PORTDbits.RD1                   // bit 1
#define RD2                     PORTDbits.RD2                   // bit 2
#define RD3                     PORTDbits.RD3                   // bit 3
#define RD4                     PORTDbits.RD4                   // bit 4
#define RD5                     PORTDbits.RD5                   // bit 5
#define RD6                     PORTDbits.RD6                   // bit 6
#define RD7                     PORTDbits.RD7                   // bit 7

#define RE0                     PORTEbits.RE0                   // bit 0
#define RE1                     PORTEbits.RE1                   // bit 1
#define RE2                     PORTEbits.RE2                   // bit 2
#define RE3                     PORTEbits.RE3                   // bit 3

#define PWM1OE0                 PWM1AOEbits.PWM1OE0             // bit 0
#define PWM1OE1                 PWM1AOEbits.PWM1OE1             // bit 1
#define PWM1OE2                 PWM1AOEbits.PWM1OE2             // bit 2
#define PWM1OE3                 PWM1AOEbits.PWM1OE3             // bit 3

#define PWM1POL                 PWM1CONbits.PWM1POL             // bit 4
#define PWM1OUT                 PWM1CONbits.PWM1OUT             // bit 5
#define PWM1OE                  PWM1CONbits.PWM1OE              // bit 6
#define PWM1EN                  PWM1CONbits.PWM1EN              // bit 7

#define PWM1DCH0                PWM1DCHbits.PWM1DCH0            // bit 0
#define PWM1DCH1                PWM1DCHbits.PWM1DCH1            // bit 1
#define PWM1DCH2                PWM1DCHbits.PWM1DCH2            // bit 2
#define PWM1DCH3                PWM1DCHbits.PWM1DCH3            // bit 3
#define PWM1DCH4                PWM1DCHbits.PWM1DCH4            // bit 4
#define PWM1DCH5                PWM1DCHbits.PWM1DCH5            // bit 5
#define PWM1DCH6                PWM1DCHbits.PWM1DCH6            // bit 6
#define PWM1DCH7                PWM1DCHbits.PWM1DCH7            // bit 7

#define PWM1DCL0                PWM1DCLbits.PWM1DCL0            // bit 6
#define PWM1DCL1                PWM1DCLbits.PWM1DCL1            // bit 7

#define PWM2OE0                 PWM2AOEbits.PWM2OE0             // bit 0
#define PWM2OE1                 PWM2AOEbits.PWM2OE1             // bit 1
#define PWM2OE2                 PWM2AOEbits.PWM2OE2             // bit 2
#define PWM2OE3                 PWM2AOEbits.PWM2OE3             // bit 3

#define PWM2POL                 PWM2CONbits.PWM2POL             // bit 4
#define PWM2OUT                 PWM2CONbits.PWM2OUT             // bit 5
#define PWM2OE                  PWM2CONbits.PWM2OE              // bit 6
#define PWM2EN                  PWM2CONbits.PWM2EN              // bit 7

#define PWM2DCH0                PWM2DCHbits.PWM2DCH0            // bit 0
#define PWM2DCH1                PWM2DCHbits.PWM2DCH1            // bit 1
#define PWM2DCH2                PWM2DCHbits.PWM2DCH2            // bit 2
#define PWM2DCH3                PWM2DCHbits.PWM2DCH3            // bit 3
#define PWM2DCH4                PWM2DCHbits.PWM2DCH4            // bit 4
#define PWM2DCH5                PWM2DCHbits.PWM2DCH5            // bit 5
#define PWM2DCH6                PWM2DCHbits.PWM2DCH6            // bit 6
#define PWM2DCH7                PWM2DCHbits.PWM2DCH7            // bit 7

#define PWM2DCL0                PWM2DCLbits.PWM2DCL0            // bit 6
#define PWM2DCL1                PWM2DCLbits.PWM2DCL1            // bit 7

#define P1TSEL                  PWMTMRSbits.P1TSEL              // bit 0
#define P2TSEL                  PWMTMRSbits.P2TSEL              // bit 2

#define RX9D                    RCSTAbits.RX9D                  // bit 0
#define OERR                    RCSTAbits.OERR                  // bit 1
#define FERR                    RCSTAbits.FERR                  // bit 2
#define ADDEN                   RCSTAbits.ADDEN                 // bit 3
#define CREN                    RCSTAbits.CREN                  // bit 4
#define SREN                    RCSTAbits.SREN                  // bit 5
#define RX9                     RCSTAbits.RX9                   // bit 6
#define SPEN                    RCSTAbits.SPEN                  // bit 7

#define SSP1ADD0                SSP1ADDbits.SSP1ADD0            // bit 0, shadows bit in SSP1ADDbits
#define ADD0                    SSP1ADDbits.ADD0                // bit 0, shadows bit in SSP1ADDbits
#define SSP1ADD1                SSP1ADDbits.SSP1ADD1            // bit 1, shadows bit in SSP1ADDbits
#define ADD1                    SSP1ADDbits.ADD1                // bit 1, shadows bit in SSP1ADDbits
#define SSP1ADD2                SSP1ADDbits.SSP1ADD2            // bit 2, shadows bit in SSP1ADDbits
#define ADD2                    SSP1ADDbits.ADD2                // bit 2, shadows bit in SSP1ADDbits
#define SSP1ADD3                SSP1ADDbits.SSP1ADD3            // bit 3, shadows bit in SSP1ADDbits
#define ADD3                    SSP1ADDbits.ADD3                // bit 3, shadows bit in SSP1ADDbits
#define SSP1ADD4                SSP1ADDbits.SSP1ADD4            // bit 4, shadows bit in SSP1ADDbits
#define ADD4                    SSP1ADDbits.ADD4                // bit 4, shadows bit in SSP1ADDbits
#define SSP1ADD5                SSP1ADDbits.SSP1ADD5            // bit 5, shadows bit in SSP1ADDbits
#define ADD5                    SSP1ADDbits.ADD5                // bit 5, shadows bit in SSP1ADDbits
#define SSP1ADD6                SSP1ADDbits.SSP1ADD6            // bit 6, shadows bit in SSP1ADDbits
#define ADD6                    SSP1ADDbits.ADD6                // bit 6, shadows bit in SSP1ADDbits
#define SSP1ADD7                SSP1ADDbits.SSP1ADD7            // bit 7, shadows bit in SSP1ADDbits
#define ADD7                    SSP1ADDbits.ADD7                // bit 7, shadows bit in SSP1ADDbits

#define SSP1BUF0                SSP1BUFbits.SSP1BUF0            // bit 0, shadows bit in SSP1BUFbits
#define BUF0                    SSP1BUFbits.BUF0                // bit 0, shadows bit in SSP1BUFbits
#define SSP1BUF1                SSP1BUFbits.SSP1BUF1            // bit 1, shadows bit in SSP1BUFbits
#define BUF1                    SSP1BUFbits.BUF1                // bit 1, shadows bit in SSP1BUFbits
#define SSP1BUF2                SSP1BUFbits.SSP1BUF2            // bit 2, shadows bit in SSP1BUFbits
#define BUF2                    SSP1BUFbits.BUF2                // bit 2, shadows bit in SSP1BUFbits
#define SSP1BUF3                SSP1BUFbits.SSP1BUF3            // bit 3, shadows bit in SSP1BUFbits
#define BUF3                    SSP1BUFbits.BUF3                // bit 3, shadows bit in SSP1BUFbits
#define SSP1BUF4                SSP1BUFbits.SSP1BUF4            // bit 4, shadows bit in SSP1BUFbits
#define BUF4                    SSP1BUFbits.BUF4                // bit 4, shadows bit in SSP1BUFbits
#define SSP1BUF5                SSP1BUFbits.SSP1BUF5            // bit 5, shadows bit in SSP1BUFbits
#define BUF5                    SSP1BUFbits.BUF5                // bit 5, shadows bit in SSP1BUFbits
#define SSP1BUF6                SSP1BUFbits.SSP1BUF6            // bit 6, shadows bit in SSP1BUFbits
#define BUF6                    SSP1BUFbits.BUF6                // bit 6, shadows bit in SSP1BUFbits
#define SSP1BUF7                SSP1BUFbits.SSP1BUF7            // bit 7, shadows bit in SSP1BUFbits
#define BUF7                    SSP1BUFbits.BUF7                // bit 7, shadows bit in SSP1BUFbits

#define SSPM0                   SSP1CONbits.SSPM0               // bit 0
#define SSPM1                   SSP1CONbits.SSPM1               // bit 1
#define SSPM2                   SSP1CONbits.SSPM2               // bit 2
#define SSPM3                   SSP1CONbits.SSPM3               // bit 3
#define CKP                     SSP1CONbits.CKP                 // bit 4
#define SSPEN                   SSP1CONbits.SSPEN               // bit 5
#define SSPOV                   SSP1CONbits.SSPOV               // bit 6
#define WCOL                    SSP1CONbits.WCOL                // bit 7

#define SEN                     SSP1CON2bits.SEN                // bit 0
#define RSEN                    SSP1CON2bits.RSEN               // bit 1
#define PEN                     SSP1CON2bits.PEN                // bit 2
#define RCEN                    SSP1CON2bits.RCEN               // bit 3
#define ACKEN                   SSP1CON2bits.ACKEN              // bit 4
#define ACKDT                   SSP1CON2bits.ACKDT              // bit 5
#define ACKSTAT                 SSP1CON2bits.ACKSTAT            // bit 6
#define GCEN                    SSP1CON2bits.GCEN               // bit 7

#define DHEN                    SSP1CON3bits.DHEN               // bit 0
#define AHEN                    SSP1CON3bits.AHEN               // bit 1
#define SBCDE                   SSP1CON3bits.SBCDE              // bit 2
#define SDAHT                   SSP1CON3bits.SDAHT              // bit 3
#define BOEN                    SSP1CON3bits.BOEN               // bit 4
#define SCIE                    SSP1CON3bits.SCIE               // bit 5
#define PCIE                    SSP1CON3bits.PCIE               // bit 6
#define ACKTIM                  SSP1CON3bits.ACKTIM             // bit 7

#define SSP1MSK0                SSP1MSKbits.SSP1MSK0            // bit 0, shadows bit in SSP1MSKbits
#define MSK0                    SSP1MSKbits.MSK0                // bit 0, shadows bit in SSP1MSKbits
#define SSP1MSK1                SSP1MSKbits.SSP1MSK1            // bit 1, shadows bit in SSP1MSKbits
#define MSK1                    SSP1MSKbits.MSK1                // bit 1, shadows bit in SSP1MSKbits
#define SSP1MSK2                SSP1MSKbits.SSP1MSK2            // bit 2, shadows bit in SSP1MSKbits
#define MSK2                    SSP1MSKbits.MSK2                // bit 2, shadows bit in SSP1MSKbits
#define SSP1MSK3                SSP1MSKbits.SSP1MSK3            // bit 3, shadows bit in SSP1MSKbits
#define MSK3                    SSP1MSKbits.MSK3                // bit 3, shadows bit in SSP1MSKbits
#define SSP1MSK4                SSP1MSKbits.SSP1MSK4            // bit 4, shadows bit in SSP1MSKbits
#define MSK4                    SSP1MSKbits.MSK4                // bit 4, shadows bit in SSP1MSKbits
#define SSP1MSK5                SSP1MSKbits.SSP1MSK5            // bit 5, shadows bit in SSP1MSKbits
#define MSK5                    SSP1MSKbits.MSK5                // bit 5, shadows bit in SSP1MSKbits
#define SSP1MSK6                SSP1MSKbits.SSP1MSK6            // bit 6, shadows bit in SSP1MSKbits
#define MSK6                    SSP1MSKbits.MSK6                // bit 6, shadows bit in SSP1MSKbits
#define SSP1MSK7                SSP1MSKbits.SSP1MSK7            // bit 7, shadows bit in SSP1MSKbits
#define MSK7                    SSP1MSKbits.MSK7                // bit 7, shadows bit in SSP1MSKbits

#define BF                      SSP1STATbits.BF                 // bit 0
#define UA                      SSP1STATbits.UA                 // bit 1
#define R_NOT_W                 SSP1STATbits.R_NOT_W            // bit 2
#define S                       SSP1STATbits.S                  // bit 3
#define P                       SSP1STATbits.P                  // bit 4
#define D_NOT_A                 SSP1STATbits.D_NOT_A            // bit 5
#define CKE                     SSP1STATbits.CKE                // bit 6
#define SMP                     SSP1STATbits.SMP                // bit 7

#define S1ILS                   SSPLVLbits.S1ILS                // bit 0
#define S2ILS                   SSPLVLbits.S2ILS                // bit 4

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T2CKPS0                 T2CONbits.T2CKPS0               // bit 0
#define T2CKPS1                 T2CONbits.T2CKPS1               // bit 1
#define TMR2ON                  T2CONbits.TMR2ON                // bit 2
#define T2OUTPS0                T2CONbits.T2OUTPS0              // bit 3
#define T2OUTPS1                T2CONbits.T2OUTPS1              // bit 4
#define T2OUTPS2                T2CONbits.T2OUTPS2              // bit 5
#define T2OUTPS3                T2CONbits.T2OUTPS3              // bit 6

#define T4CKPS0                 T4CONbits.T4CKPS0               // bit 0
#define T4CKPS1                 T4CONbits.T4CKPS1               // bit 1
#define TMR4ON                  T4CONbits.TMR4ON                // bit 2
#define T4OUTPS0                T4CONbits.T4OUTPS0              // bit 3
#define T4OUTPS1                T4CONbits.T4OUTPS1              // bit 4
#define T4OUTPS2                T4CONbits.T4OUTPS2              // bit 5
#define T4OUTPS3                T4CONbits.T4OUTPS3              // bit 6

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TRISD0                  TRISDbits.TRISD0                // bit 0
#define TRISD1                  TRISDbits.TRISD1                // bit 1
#define TRISD2                  TRISDbits.TRISD2                // bit 2
#define TRISD3                  TRISDbits.TRISD3                // bit 3
#define TRISD4                  TRISDbits.TRISD4                // bit 4
#define TRISD5                  TRISDbits.TRISD5                // bit 5
#define TRISD6                  TRISDbits.TRISD6                // bit 6
#define TRISD7                  TRISDbits.TRISD7                // bit 7

#define TRISE0                  TRISEbits.TRISE0                // bit 0
#define TRISE1                  TRISEbits.TRISE1                // bit 1
#define TRISE2                  TRISEbits.TRISE2                // bit 2
#define TRISE3                  TRISEbits.TRISE3                // bit 3

#define TX9D                    TXSTAbits.TX9D                  // bit 0
#define TRMT                    TXSTAbits.TRMT                  // bit 1
#define BRGH                    TXSTAbits.BRGH                  // bit 2
#define SENDB                   TXSTAbits.SENDB                 // bit 3
#define SYNC                    TXSTAbits.SYNC                  // bit 4
#define TXEN                    TXSTAbits.TXEN                  // bit 5
#define TX9                     TXSTAbits.TX9                   // bit 6
#define CSRC                    TXSTAbits.CSRC                  // bit 7

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUB0                   WPUBbits.WPUB0                  // bit 0
#define WPUB1                   WPUBbits.WPUB1                  // bit 1
#define WPUB2                   WPUBbits.WPUB2                  // bit 2
#define WPUB3                   WPUBbits.WPUB3                  // bit 3
#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#define WPUE3                   WPUEbits.WPUE3                  // bit 3

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16LF1567_H__
