%%
%% %CopyrightBegin%
%% 
%% Copyright Ericsson AB 2009. All Rights Reserved.
%% 
%% The contents of this file are subject to the Erlang Public License,
%% Version 1.1, (the "License"); you may not use this file except in
%% compliance with the License. You should have received a copy of the
%% Erlang Public License along with this software. If not, it can be
%% retrieved online at http://www.erlang.org/.
%% 
%% Software distributed under the License is distributed on an "AS IS"
%% basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
%% the License for the specific language governing rights and limitations
%% under the License.
%% 
%% %CopyrightEnd%
%% Contributor(s):
%%    <michael.remond@IDEALX.com>: suggested #xmlDocument{}
%%
%%----------------------------------------------------------------------
%% #0.    BASIC INFORMATION
%%----------------------------------------------------------------------
%% File:       xmerl.hrl
%% Author       : Ulf Wiger <ulf.wiger@ericsson.com>
%% Date         : 00-09-22
%% Description  : Record and macro definitions for xmerl
%%----------------------------------------------------------------------



%% records generated by the scanner
%% --------------------------------

%% XML declaration
-record(xmlDecl,{
	  vsn,        % string() XML version
	  encoding,   % string() Character encoding 
	  standalone, % (yes | no)
	  attributes  % [#xmlAttribute()] Other attributes than above
	 }).

%% Attribute
-record(xmlAttribute,{
	  name,		   % atom()
	  expanded_name=[],% atom() | {string(),atom()}
	  nsinfo = [],	   % {Prefix, Local} | []
	  namespace = [],  % inherits the element's namespace
	  parents = [],	   % [{atom(),integer()}]
	  pos,		   % integer()
	  language = [],   % inherits the element's language
	  value,	   % IOlist() | atom() | integer()
	  normalized       % atom() one of (true | false)
	 }).

%% namespace record
-record(xmlNamespace,{
	  default = [],
	  nodes = []
	 }).

%% namespace node - i.e. a {Prefix, URI} pair
%% TODO: these are not currently used?? /RC
-record(xmlNsNode,{
	  prefix,
	  uri = []
	 }).

%% XML Element
%% content = [#xmlElement()|#xmlText()|#xmlPI()|#xmlComment()|#xmlDecl()]
-record(xmlElement,{
	  name,			% atom()
	  expanded_name = [],	% string() | {URI,Local} | {"xmlns",Local}
	  nsinfo = [],	        % {Prefix, Local} | []
	  namespace=#xmlNamespace{},
	  parents = [],		% [{atom(),integer()}]
	  pos,			% integer()
	  attributes = [],	% [#xmlAttribute()]
	  content = [],
	  language = "",	% string()
	  xmlbase="",           % string() XML Base path, for relative URI:s
	  elementdef=undeclared % atom(), one of [undeclared | prolog | external | element]
	 }).

%% plain text
%% IOlist = [char() | binary () | IOlist]
-record(xmlText,{
	  parents = [],	% [{atom(),integer()}]
	  pos,		% integer()
	  language = [],% inherits the element's language
	  value,	% IOlist()
	  type = text   % atom() one of (text|cdata)
	 }).

%% plain text
-record(xmlComment,{
	  parents = [],  % [{atom(),integer()}]
	  pos,	         % integer()
	  language = [], % inherits the element's language
	  value	         % IOlist()
	 }).

%% processing instruction
-record(xmlPI,{
	  name,	% atom()
	  pos,	% integer()
	  value	% IOlist()
	 }).

-record(xmlDocument,{
	  content
	 }).


%% XPATH (xmerl_xpath, xmerl_pred_funcs) records

-record(xmlContext, {
		     axis_type = forward,
		     context_node,
		     context_position = 1,
		     nodeset = [],
		     bindings = [],
		     functions = [],
		     namespace = [],
		     whole_document
		    }).

-record(xmlNode, {
		  type = element,
		  node,
		  parents = [],
		  pos = 1
		 }).

-record(xmlObj, {
		 type,
		 value
		 }).
