untrusted comment: verify with openbsd-77-base.pub
RWSbCCUoGpcxVTVUF29BXMvO3bSpiof/CCfwcFQrzFbKRoxrmAq066Tu/4YtPfoUDULRz02kO1Ifrfph9mlL9kYLvBZpzhmDfA0=

OpenBSD 7.7 errata 021, February 27, 2026:

Stop userland from using pledge(2) "tmppath" because the kernel feature
will be removed soon.

Apply by doing:
    signify -Vep /etc/signify/openbsd-77-base.pub -x 021_tmppath.patch.sig \
        -m - | (cd /usr/src && patch -p0)

And then rebuild and install all these programs:
    cd /usr/src/gnu/usr.bin/binutils-2.17
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper
    make -f Makefile.bsd-wrapper install
    cd /usr/src/gnu/usr.bin/texinfo
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper
    make -f Makefile.bsd-wrapper install
    cd /usr/src/usr.bin/calendar
    make obj
    make
    make install
    cd /usr/src/usr.bin/diff
    make obj
    make
    make install
    cd /usr/src/usr.bin/htpasswd
    make obj
    make
    make install
    cd /usr/src/usr.bin/m4
    make obj
    make
    make install
    cd /usr/src/usr.bin/mail
    make obj
    make
    make install
    cd /usr/src/usr.bin/mandoc
    make obj
    make
    make install
    cd /usr/src/usr.bin/nc
    make obj
    make
    make install
    cd /usr/src/usr.bin/patch
    make obj
    make
    make install
    cd /usr/src/usr.bin/sendbug
    make obj
    make
    make install
    cd /usr/src/usr.sbin/smtpd
    make obj
    make
    make install

Index: gnu/usr.bin/binutils-2.17/binutils/objdump.c
===================================================================
RCS file: /cvs/src/gnu/usr.bin/binutils-2.17/binutils/objdump.c,v
diff -u -p -u -r1.2 objdump.c
--- gnu/usr.bin/binutils-2.17/binutils/objdump.c	22 Oct 2015 14:53:00 -0000	1.2
+++ gnu/usr.bin/binutils-2.17/binutils/objdump.c	23 Feb 2026 18:22:33 -0000
@@ -2962,7 +2962,11 @@ main (int argc, char **argv)
   bindtextdomain (PACKAGE, LOCALEDIR);
   textdomain (PACKAGE);
 
-  if (pledge ("stdio rpath tmppath", NULL) == -1)
+  if (unveil ("/tmp", "rwc") == -1)
+    fatal (_("Failed to unveil /tmp"));
+  if (unveil ("/", "r") == -1)
+    fatal (_("Failed to unveil /"));
+  if (pledge ("stdio rpath wpath cpath", NULL) == -1)
     fatal (_("Failed to pledge"));
 
   program_name = *argv;
Index: gnu/usr.bin/texinfo/util/texindex.c
===================================================================
RCS file: /cvs/src/gnu/usr.bin/texinfo/util/texindex.c,v
diff -u -p -u -r1.7 texindex.c
--- gnu/usr.bin/texinfo/util/texindex.c	16 Aug 2024 22:58:54 -0000	1.7
+++ gnu/usr.bin/texinfo/util/texindex.c	23 Feb 2026 18:22:33 -0000
@@ -161,7 +161,7 @@ main (int argc, char **argv)
   setlocale (LC_ALL, "");
 #endif
 
-  if (pledge ("stdio rpath wpath cpath tmppath", NULL) == -1)
+  if (pledge ("stdio rpath wpath cpath", NULL) == -1)
     pfatal_with_name ("pledge");
 
   /* Set the text message domain.  */
Index: usr.bin/calendar/calendar.c
===================================================================
RCS file: /cvs/src/usr.bin/calendar/calendar.c,v
diff -u -p -u -r1.37 calendar.c
--- usr.bin/calendar/calendar.c	1 Feb 2019 16:22:53 -0000	1.37
+++ usr.bin/calendar/calendar.c	23 Feb 2026 18:22:33 -0000
@@ -126,8 +126,12 @@ main(int argc, char *argv[])
 		usage();
 
 	if (doall) {
-		if (pledge("stdio rpath tmppath fattr getpw id proc exec", NULL)
-		    == -1)
+		if (unveil("/tmp", "rwc") == -1)
+			err(1, "unveil /tmp");
+		if (unveil("/", "r") == -1)
+			err(1, "unveil /");
+		if (pledge("stdio rpath wpath cpath fattr getpw id proc exec",
+		    NULL) == -1)
 			err(1, "pledge");
 	} else {
 		if (pledge("stdio rpath proc exec", NULL) == -1)
Index: usr.bin/diff/diff.c
===================================================================
RCS file: /cvs/src/usr.bin/diff/diff.c,v
diff -u -p -u -r1.68 diff.c
--- usr.bin/diff/diff.c	5 Jan 2023 00:00:44 -0000	1.68
+++ usr.bin/diff/diff.c	23 Feb 2026 18:22:33 -0000
@@ -211,7 +211,11 @@ main(int argc, char **argv)
 	argc -= optind;
 	argv += optind;
 
-	if (pledge("stdio rpath tmppath", NULL) == -1)
+	if (unveil("/tmp", "rwc") == -1)
+		err(2, "unveil /tmp");
+	if (unveil("/", "r") == -1)
+		err(2, "unveil /");
+	if (pledge("stdio rpath wpath cpath", NULL) == -1)
 		err(2, "pledge");
 
 	/*
Index: usr.bin/htpasswd/htpasswd.c
===================================================================
RCS file: /cvs/src/usr.bin/htpasswd/htpasswd.c,v
diff -u -p -u -r1.18 htpasswd.c
--- usr.bin/htpasswd/htpasswd.c	12 Jul 2021 15:09:19 -0000	1.18
+++ usr.bin/htpasswd/htpasswd.c	23 Feb 2026 18:22:33 -0000
@@ -78,7 +78,7 @@ main(int argc, char** argv)
 		if (unveil("/tmp", "rwc") == -1)
 			err(1, "unveil /tmp");
 	}
-	if (pledge("stdio rpath wpath cpath flock tmppath tty", NULL) == -1)
+	if (pledge("stdio rpath wpath cpath flock tty", NULL) == -1)
 		err(1, "pledge");
 
 	if (batch) {
Index: usr.bin/m4/main.c
===================================================================
RCS file: /cvs/src/usr.bin/m4/main.c,v
diff -u -p -u -r1.88 main.c
--- usr.bin/m4/main.c	4 Dec 2022 23:50:48 -0000	1.88
+++ usr.bin/m4/main.c	23 Feb 2026 18:22:33 -0000
@@ -170,7 +170,7 @@ main(int argc, char *argv[])
 	int n;
 	char *p;
 
-	if (pledge("stdio rpath wpath cpath tmppath proc exec", NULL) == -1)
+	if (pledge("stdio rpath wpath cpath proc exec", NULL) == -1)
 		err(1, "pledge");
 
 	if (signal(SIGINT, SIG_IGN) != SIG_IGN)
Index: usr.bin/mail/main.c
===================================================================
RCS file: /cvs/src/usr.bin/mail/main.c,v
diff -u -p -u -r1.36 main.c
--- usr.bin/mail/main.c	5 Nov 2024 16:14:39 -0000	1.36
+++ usr.bin/mail/main.c	23 Feb 2026 18:22:33 -0000
@@ -108,7 +108,7 @@ main(int argc, char **argv)
 	char *rc;
 	extern const char version[];
 
-	if (pledge("stdio rpath wpath cpath getpw tmppath fattr tty flock proc exec",
+	if (pledge("stdio rpath wpath cpath getpw fattr tty flock proc exec",
 	    NULL) == -1)
 		err(1, "pledge");
 
Index: usr.bin/mandoc/main.c
===================================================================
RCS file: /cvs/src/usr.bin/mandoc/main.c,v
diff -u -p -u -r1.265 main.c
--- usr.bin/mandoc/main.c	29 Mar 2024 01:16:30 -0000	1.265
+++ usr.bin/mandoc/main.c	23 Feb 2026 18:46:59 -0000
@@ -154,11 +154,6 @@ main(int argc, char *argv[])
 	    strcmp(progname, BINM_MAKEWHATIS) == 0)
 		return mandocdb(argc, argv);
 
-	if (pledge("stdio rpath wpath cpath tmppath tty proc exec", NULL) == -1) {
-		mandoc_msg(MANDOCERR_PLEDGE, 0, 0, "%s", strerror(errno));
-		return mandoc_msg_getrc();
-	}
-
 	/* Search options. */
 
 	memset(&conf, 0, sizeof(conf));
@@ -362,6 +357,39 @@ main(int argc, char *argv[])
 	     isatty(STDOUT_FILENO) == 0))
 		outst.use_pager = 0;
 
+	if (unveil("/tmp", "rwc") == -1) {
+		mandoc_msg(MANDOCERR_PLEDGE, 0, 0, "%s", strerror(errno));
+		return mandoc_msg_getrc();
+	}
+	if (conf.output.outfilename) {
+		if (unveil(".", "rwc") == -1) {
+			mandoc_msg(MANDOCERR_PLEDGE, 0, 0, "%s", strerror(errno));
+			return mandoc_msg_getrc();
+		}
+		if (unveil(conf.output.outfilename, "rwc") == -1) {
+			mandoc_msg(MANDOCERR_PLEDGE, 0, 0, "%s", strerror(errno));
+			return mandoc_msg_getrc();
+		}
+	}
+	if (conf.output.tagfilename) {
+		if (unveil(".", "rwc") == -1) {
+			mandoc_msg(MANDOCERR_PLEDGE, 0, 0, "%s", strerror(errno));
+			return mandoc_msg_getrc();
+		}
+		if (unveil(conf.output.tagfilename, "rwc") == -1) {
+			mandoc_msg(MANDOCERR_PLEDGE, 0, 0, "%s", strerror(errno));
+			return mandoc_msg_getrc();
+		}
+	}
+	if (unveil("/", "rx") == -1) {
+		mandoc_msg(MANDOCERR_PLEDGE, 0, 0, "%s", strerror(errno));
+		return mandoc_msg_getrc();
+	}
+	if (pledge("stdio rpath wpath cpath tty proc exec", NULL) == -1) {
+		mandoc_msg(MANDOCERR_PLEDGE, 0, 0, "%s", strerror(errno));
+		return mandoc_msg_getrc();
+	}
+
 	if (outst.use_pager &&
 	    (conf.output.width == 0 || conf.output.indent == 0) &&
 	    ioctl(STDOUT_FILENO, TIOCGWINSZ, &ws) != -1 &&
@@ -378,7 +406,7 @@ main(int argc, char *argv[])
 	    conf.output.tagfilename != NULL)
 		c = pledge("stdio rpath wpath cpath", NULL);
 	else
-		c = pledge("stdio rpath tmppath tty proc exec", NULL);
+		c = pledge("stdio rpath wpath cpath tty proc exec", NULL);
 	if (c == -1) {
 		mandoc_msg(MANDOCERR_PLEDGE, 0, 0, "%s", strerror(errno));
 		return mandoc_msg_getrc();
@@ -886,7 +914,7 @@ process_onefile(struct mparse *mp, struc
 		    conf->output.tagfilename);
 		if ((conf->output.outfilename != NULL ||
 		     conf->output.tagfilename != NULL) &&
-		    pledge("stdio rpath cpath", NULL) == -1) {
+		    pledge("stdio rpath wpath cpath", NULL) == -1) {
 			mandoc_msg(MANDOCERR_PLEDGE, 0, 0,
 			    "%s", strerror(errno));
 			exit(mandoc_msg_getrc());
@@ -1328,7 +1356,7 @@ spawn_pager(struct outstate *outst, char
 			free(argv[--argc]);
 		(void)setpgid(pager_pid, 0);
 		(void)tcsetpgrp(STDOUT_FILENO, pager_pid);
-		if (pledge("stdio rpath tmppath tty proc", NULL) == -1) {
+		if (pledge("stdio rpath wpath cpath tty proc", NULL) == -1) {
 			mandoc_msg(MANDOCERR_PLEDGE, 0, 0,
 			    "%s", strerror(errno));
 			exit(mandoc_msg_getrc());
Index: usr.bin/nc/netcat.c
===================================================================
RCS file: /cvs/src/usr.bin/nc/netcat.c,v
diff -u -p -u -r1.229 netcat.c
--- usr.bin/nc/netcat.c	2 Nov 2024 17:19:27 -0000	1.229
+++ usr.bin/nc/netcat.c	23 Feb 2026 18:22:33 -0000
@@ -378,6 +378,8 @@ main(int argc, char *argv[])
 		 */
 	} else {
 		if (family == AF_UNIX) {
+			if (unveil("/tmp", "rwc") == -1)
+				err(1, "unveil /tmp");
 			if (unveil(host, "rwc") == -1)
 				err(1, "unveil %s", host);
 			if (uflag && !kflag) {
@@ -397,7 +399,7 @@ main(int argc, char *argv[])
 	}
 
 	if (family == AF_UNIX) {
-		if (pledge("stdio rpath wpath cpath tmppath unix", NULL) == -1)
+		if (pledge("stdio rpath wpath cpath unix", NULL) == -1)
 			err(1, "pledge");
 	} else if (Fflag && Pflag) {
 		if (pledge("stdio inet dns sendfd tty", NULL) == -1)
Index: usr.bin/patch/patch.c
===================================================================
RCS file: /cvs/src/usr.bin/patch/patch.c,v
diff -u -p -u -r1.77 patch.c
--- usr.bin/patch/patch.c	30 Aug 2024 07:11:02 -0000	1.77
+++ usr.bin/patch/patch.c	23 Feb 2026 18:22:33 -0000
@@ -152,7 +152,7 @@ main(int argc, char *argv[])
 	const	char *tmpdir;
 	char	*v;
 
-	if (pledge("stdio rpath wpath cpath tmppath fattr unveil", NULL) == -1) {
+	if (pledge("stdio rpath wpath cpath fattr unveil", NULL) == -1) {
 		perror("pledge");
 		my_exit(2);
 	}
@@ -252,7 +252,7 @@ main(int argc, char *argv[])
 			perror("unveil");
 			my_exit(2);
 		}
-	if (pledge("stdio rpath wpath cpath tmppath fattr", NULL) == -1) {
+	if (pledge("stdio rpath wpath cpath fattr", NULL) == -1) {
 		perror("pledge");
 		my_exit(2);
 	}
Index: usr.bin/sendbug/sendbug.c
===================================================================
RCS file: /cvs/src/usr.bin/sendbug/sendbug.c,v
diff -u -p -u -r1.80 sendbug.c
--- usr.bin/sendbug/sendbug.c	10 Apr 2022 17:47:54 -0000	1.80
+++ usr.bin/sendbug/sendbug.c	23 Feb 2026 18:22:33 -0000
@@ -86,7 +86,7 @@ main(int argc, char *argv[])
 	time_t mtime;
 	FILE *fp;
 
-	if (pledge("stdio rpath wpath cpath tmppath getpw proc exec", NULL) == -1)
+	if (pledge("stdio rpath wpath cpath getpw proc exec", NULL) == -1)
 		err(1, "pledge");
 
 	while ((ch = getopt(argc, argv, "DEP")) != -1)
Index: usr.sbin/smtpd/smtpc.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/smtpc.c,v
diff -u -p -u -r1.21 smtpc.c
--- usr.sbin/smtpd/smtpc.c	13 May 2024 06:48:26 -0000	1.21
+++ usr.sbin/smtpd/smtpc.c	23 Feb 2026 18:22:33 -0000
@@ -245,7 +245,9 @@ main(int argc, char **argv)
 	} else
 		tls_config_verify(tls_config);
 
-	if (pledge("stdio inet dns tmppath", NULL) == -1)
+	if (unveil("/tmp", "rwc") == -1)
+		fatal("unveil /tmp");
+	if (pledge("stdio inet dns rpath wpath cpath", NULL) == -1)
 		fatal("pledge");
 
 	if (!noaction)
Index: usr.sbin/smtpd/smtpctl.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/smtpctl.c,v
diff -u -p -u -r1.176 smtpctl.c
--- usr.sbin/smtpd/smtpctl.c	21 Nov 2024 13:42:22 -0000	1.176
+++ usr.sbin/smtpd/smtpctl.c	23 Feb 2026 18:22:33 -0000
@@ -1128,7 +1128,7 @@ sendmail_compat(int argc, char **argv)
 			err(1, "setresgid");
 
 		/* we'll reduce further down the road */
-		if (pledge("stdio rpath wpath cpath tmppath flock "
+		if (pledge("stdio rpath wpath cpath flock "
 			"dns getpw recvfd", NULL) == -1)
 			err(1, "pledge");
 
Index: usr.sbin/smtpd/smtpd.c
===================================================================
RCS file: /cvs/src/usr.sbin/smtpd/smtpd.c,v
diff -u -p -u -r1.354 smtpd.c
--- usr.sbin/smtpd/smtpd.c	21 Nov 2024 13:22:21 -0000	1.354
+++ usr.sbin/smtpd/smtpd.c	23 Feb 2026 18:22:33 -0000
@@ -1069,7 +1069,7 @@ smtpd(void) {
 
 	purge_task();
 
-	if (pledge("stdio rpath wpath cpath fattr tmppath "
+	if (pledge("stdio rpath wpath cpath fattr "
 	    "getpw sendfd proc exec id inet chown unix", NULL) == -1)
 		fatal("pledge");
 
