/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CancelSpotInstanceRequestsRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Boolean dryRun;
    private ListWithAutoConstructFlag<String> spotInstanceRequestIds;

    public CancelSpotInstanceRequestsRequest() {
    }

    public CancelSpotInstanceRequestsRequest(List<String> spotInstanceRequestIds) {
        this.setSpotInstanceRequestIds(spotInstanceRequestIds);
    }

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public CancelSpotInstanceRequestsRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public List<String> getSpotInstanceRequestIds() {
        if (this.spotInstanceRequestIds == null) {
            this.spotInstanceRequestIds = new ListWithAutoConstructFlag();
            this.spotInstanceRequestIds.setAutoConstruct(true);
        }
        return this.spotInstanceRequestIds;
    }

    public void setSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
        if (spotInstanceRequestIds == null) {
            this.spotInstanceRequestIds = null;
            return;
        }
        ListWithAutoConstructFlag spotInstanceRequestIdsCopy = new ListWithAutoConstructFlag(spotInstanceRequestIds.size());
        spotInstanceRequestIdsCopy.addAll(spotInstanceRequestIds);
        this.spotInstanceRequestIds = spotInstanceRequestIdsCopy;
    }

    public CancelSpotInstanceRequestsRequest withSpotInstanceRequestIds(String ... spotInstanceRequestIds) {
        if (this.getSpotInstanceRequestIds() == null) {
            this.setSpotInstanceRequestIds(new ArrayList<String>(spotInstanceRequestIds.length));
        }
        for (String value : spotInstanceRequestIds) {
            this.getSpotInstanceRequestIds().add(value);
        }
        return this;
    }

    public CancelSpotInstanceRequestsRequest withSpotInstanceRequestIds(Collection<String> spotInstanceRequestIds) {
        if (spotInstanceRequestIds == null) {
            this.spotInstanceRequestIds = null;
        } else {
            ListWithAutoConstructFlag spotInstanceRequestIdsCopy = new ListWithAutoConstructFlag(spotInstanceRequestIds.size());
            spotInstanceRequestIdsCopy.addAll(spotInstanceRequestIds);
            this.spotInstanceRequestIds = spotInstanceRequestIdsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.isDryRun() != null) {
            sb.append("DryRun: " + this.isDryRun() + ",");
        }
        if (this.getSpotInstanceRequestIds() != null) {
            sb.append("SpotInstanceRequestIds: " + this.getSpotInstanceRequestIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getSpotInstanceRequestIds() == null ? 0 : ((Object)this.getSpotInstanceRequestIds()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelSpotInstanceRequestsRequest)) {
            return false;
        }
        CancelSpotInstanceRequestsRequest other = (CancelSpotInstanceRequestsRequest)obj;
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getSpotInstanceRequestIds() == null ^ this.getSpotInstanceRequestIds() == null) {
            return false;
        }
        return other.getSpotInstanceRequestIds() == null || ((Object)other.getSpotInstanceRequestIds()).equals(this.getSpotInstanceRequestIds());
    }
}

