"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.detectIndexType = detectIndexType;
var _lodash = require("lodash");
var _index_cache = require("./index_cache");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const INDEX_TYPE_DETECT_AGENT_CONFIG_ID = 'os_index_type_detect';
async function searchQuery(client, path, method, query) {
  return await client.request({
    path,
    method,
    body: query
  });
}
async function searchSampleData(client, indexName) {
  const query = {
    size: 5,
    query: {
      match_all: {}
    }
  };
  const response = await searchQuery(client, `/${encodeURIComponent(indexName)}/_search`, 'POST', query);
  const sourceArray = response.body.hits.hits.map(hit => hit._source);
  return sourceArray;
}
async function searchIndexMapping(client, indexName) {
  const response = await searchQuery(client, `/${encodeURIComponent(indexName)}/_mapping`, 'GET', undefined);
  return response.body;
}
async function detectIndexType(client, assistantClient, indexName, dataSourceId) {
  const indexCache = (0, _index_cache.getIndexCache)(indexName, dataSourceId ? dataSourceId : '');
  if (indexCache) {
    return indexCache.isLogRelated;
  }
  try {
    const indexMapping = (0, _lodash.escape)(JSON.stringify(await searchIndexMapping(client, indexName)));
    const sampleData = (0, _lodash.escape)(JSON.stringify(await searchSampleData(client, indexName)));
    const response = await assistantClient.executeAgentByConfigName(INDEX_TYPE_DETECT_AGENT_CONFIG_ID, {
      sampleData,
      schema: indexMapping
    });
    const detectResult = JSON.parse(response.body.inference_results[0].output[0].result);
    if (detectResult) {
      (0, _index_cache.setIndexCache)(new _index_cache.IndexCacheData(detectResult.isRelated, detectResult.reason), indexName, dataSourceId ? dataSourceId : '');
      return detectResult.isRelated;
    }
    return false;
  } catch (error) {
    console.error('Error detecting index type:', error);
    // Can not detect index type and return default as is not log related
    return false;
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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