/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.keys;

import java.util.List;
import org.jboss.logging.Logger;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.crypto.KeyUse;
import org.keycloak.keys.AbstractGeneratedSecretKeyProvider;
import org.keycloak.keys.AbstractGeneratedSecretKeyProviderFactory;
import org.keycloak.keys.GeneratedAesKeyProvider;
import org.keycloak.keys.KeyProvider;
import org.keycloak.keys.SecretKeyProviderUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.provider.ProviderConfigProperty;

public class GeneratedAesKeyProviderFactory
extends AbstractGeneratedSecretKeyProviderFactory<AbstractGeneratedSecretKeyProvider> {
    private static final Logger logger = Logger.getLogger(GeneratedAesKeyProviderFactory.class);
    public static final String ID = "aes-generated";
    private static final String HELP_TEXT = "Generates AES secret key";
    private static final ProviderConfigProperty AES_KEY_SIZE_PROPERTY = new ProviderConfigProperty("secretSize", "AES Key size", "Size in bytes for the generated AES Key. Size 16 is for AES-128, Size 24 for AES-192 and Size 32 for AES-256. WARN: Bigger keys then 128 bits are not allowed on some JDK implementations", "List", (Object)String.valueOf(16), new String[]{"16", "24", "32"});
    private static final int DEFAULT_AES_KEY_SIZE = 16;
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = SecretKeyProviderUtils.configurationBuilder().property(AES_KEY_SIZE_PROPERTY).build();

    public GeneratedAesKeyProvider create(KeycloakSession session, ComponentModel model) {
        return new GeneratedAesKeyProvider(model);
    }

    public boolean createFallbackKeys(KeycloakSession session, KeyUse keyUse, String algorithm) {
        if (keyUse.equals((Object)KeyUse.ENC) && algorithm.equals("AES")) {
            RealmModel realm = session.getContext().getRealm();
            ComponentModel generated = new ComponentModel();
            generated.setName("fallback-" + algorithm);
            generated.setParentId(realm.getId());
            generated.setProviderId(ID);
            generated.setProviderType(KeyProvider.class.getName());
            MultivaluedHashMap config = new MultivaluedHashMap();
            config.putSingle((Object)"priority", (Object)"-100");
            generated.setConfig(config);
            realm.addComponentModel(generated);
            return true;
        }
        return false;
    }

    public String getHelpText() {
        return HELP_TEXT;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    public String getId() {
        return ID;
    }

    @Override
    protected Logger logger() {
        return logger;
    }

    @Override
    protected int getDefaultKeySize() {
        return 16;
    }
}

