/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import org.hibernate.cache.MutableCacheKeyBuilder;
import org.hibernate.engine.internal.CacheHelper;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SqlExpressible;
import org.hibernate.metamodel.mapping.ValueMapping;

public interface BasicValuedMapping
extends ValueMapping,
SqlExpressible {
    @Override
    default public int getJdbcTypeCount() {
        return 1;
    }

    @Override
    default public JdbcMapping getJdbcMapping(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.getJdbcMapping();
    }

    @Override
    default public JdbcMapping getSingleJdbcMapping() {
        return this.getJdbcMapping();
    }

    @Override
    public JdbcMapping getJdbcMapping();

    @Override
    default public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.getJdbcMapping().convertToRelationalValue(value);
    }

    @Override
    default public void addToCacheKey(MutableCacheKeyBuilder cacheKey, Object value, SharedSessionContractImplementor session) {
        CacheHelper.addBasicValueToCacheKey(cacheKey, value, this.getJdbcMapping(), session);
    }
}

