/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server.embedder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.DefaultPluginDescriptorCache;
import org.apache.maven.plugin.PluginDescriptorCache;
import org.apache.maven.plugin.descriptor.PluginDescriptor;

public class CustomPluginDescriptorCache
extends DefaultPluginDescriptorCache {
    private final Map<PluginDescriptorCache.Key, PluginDescriptor> descriptors = new HashMap<PluginDescriptorCache.Key, PluginDescriptor>(128);

    public void flush() {
        this.descriptors.clear();
    }

    public PluginDescriptor get(PluginDescriptorCache.Key cacheKey) {
        return CustomPluginDescriptorCache.patchedClone(this.descriptors.get(cacheKey));
    }

    public void put(PluginDescriptorCache.Key cacheKey, PluginDescriptor pluginDescriptor) {
        this.descriptors.put(cacheKey, CustomPluginDescriptorCache.patchedClone(pluginDescriptor));
    }

    private static PluginDescriptor patchedClone(PluginDescriptor pluginDescriptor) {
        if (pluginDescriptor == null) {
            return null;
        }
        PluginDescriptor clone = CustomPluginDescriptorCache.clone((PluginDescriptor)pluginDescriptor);
        clone.setDependencies(new ArrayList(pluginDescriptor.getDependencies()));
        return clone;
    }
}

