/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.CommonBundle;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.ContainingBranchesGetter;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.graph.impl.permanent.PermanentCommitsInfoImpl;
import com.intellij.vcs.log.graph.utils.DfsWalk;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import com.intellij.vcs.log.ui.table.VcsLogCommitSelectionUtils;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\b&\u0018\u0000 -*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0004-./0B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH%J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H$J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001d\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u001c\u0010\u001e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u001f2\u0006\u0010\f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u001f2\u0006\u0010\f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 J\u0015\u0010\"\u001a\u00020#2\u0006\u0010\f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010$J\u001c\u0010%\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u001f2\u0006\u0010\f\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010 J\u001c\u0010&\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u001f2\u0006\u0010\f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 J\u001c\u0010'\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u001f2\u0006\u0010\f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010 J\u000e\u0010(\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0017\u0010)\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00028\u0000H\u0015\u00a2\u0006\u0002\u0010 J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J&\u0010*\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u001f2\u0006\u0010\f\u001a\u00028\u00002\b\b\u0001\u0010+\u001a\u00020\u000fH\u0014\u00a2\u0006\u0002\u0010,R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00061"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "prohibitRebaseDuringRebasePolicy", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "getProhibitRebaseDuringRebasePolicy", "()Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "actionPerformedAfterChecks", "", "commitEditingData", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)V", "getFailureTitle", "", "createCommitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "repository", "Lgit4idea/repo/GitRepository;", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)V", "checkCommitsEditingAvailability", "Lorg/jetbrains/annotations/Nls;", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)Ljava/lang/String;", "checkIsHeadBranch", "checkNotInitialCommit", "", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)Z", "checkNotMergeCommit", "checkCommitsCanBeEdited", "checkNotRebaseDuringRebase", "actionPerformed", "lastCheckCommitsEditingAvailability", "getProhibitedStateMessage", "operation", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;Ljava/lang/String;)Ljava/lang/String;", "Companion", "MultipleCommitEditingData", "ProhibitRebaseDuringRebasePolicy", "CommitEditingDataCreationResult", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitCommitEditingActionBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommitEditingActionBase.kt\ngit4idea/rebase/log/GitCommitEditingActionBase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,344:1\n1869#2,2:345\n1869#2,2:347\n1869#2,2:349\n1563#2:352\n1634#2,3:353\n1#3:351\n*S KotlinDebug\n*F\n+ 1 GitCommitEditingActionBase.kt\ngit4idea/rebase/log/GitCommitEditingActionBase\n*L\n186#1:345,2\n196#1:347,2\n210#1:349,2\n302#1:352\n302#1:353,3\n*E\n"})
public abstract class GitCommitEditingActionBase<T extends MultipleCommitEditingData>
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProhibitRebaseDuringRebasePolicy prohibitRebaseDuringRebasePolicy = ProhibitRebaseDuringRebasePolicy.Allow.INSTANCE;

    @NotNull
    protected ProhibitRebaseDuringRebasePolicy getProhibitRebaseDuringRebasePolicy() {
        return this.prohibitRebaseDuringRebasePolicy;
    }

    protected abstract void actionPerformedAfterChecks(@NotNull T var1);

    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    protected abstract String getFailureTitle();

    @NotNull
    protected abstract CommitEditingDataCreationResult<T> createCommitEditingData(@NotNull GitRepository var1, @NotNull VcsLogCommitSelection var2, @NotNull VcsLogData var3);

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected void update(@NotNull AnActionEvent e, @NotNull T commitEditingData) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(true);
        e.getPresentation().setDescription(this.getTemplatePresentation().getDescription());
        CommitEditingDataCreationResult<T> commitEditingDataCreationResult = this.createCommitEditingData(e);
        if (commitEditingDataCreationResult instanceof CommitEditingDataCreationResult.Prohibited) {
            String description = ((CommitEditingDataCreationResult.Prohibited)commitEditingDataCreationResult).getDescription();
            if (description != null) {
                e.getPresentation().setDescription(description);
            } else {
                e.getPresentation().setVisible(false);
            }
            e.getPresentation().setEnabled(false);
            return;
        }
        Intrinsics.checkNotNull(commitEditingDataCreationResult, (String)"null cannot be cast to non-null type git4idea.rebase.log.GitCommitEditingActionBase.CommitEditingDataCreationResult.Created<T of git4idea.rebase.log.GitCommitEditingActionBase>");
        Object commitEditingData = ((CommitEditingDataCreationResult.Created)commitEditingDataCreationResult).getData();
        String errorDescription = this.checkCommitsEditingAvailability(commitEditingData);
        if (errorDescription != null) {
            e.getPresentation().setDescription(errorDescription);
            e.getPresentation().setEnabled(false);
            return;
        }
        this.update(e, commitEditingData);
    }

    private final String checkCommitsEditingAvailability(T commitEditingData) {
        String string = this.checkIsHeadBranch(commitEditingData);
        if (string == null && (string = this.checkNotMergeCommit(commitEditingData)) == null && (string = this.checkCommitsCanBeEdited(commitEditingData)) == null) {
            string = this.checkNotRebaseDuringRebase(commitEditingData);
        }
        return string;
    }

    private final String checkIsHeadBranch(T commitEditingData) {
        GitRepository repository2 = ((MultipleCommitEditingData)commitEditingData).getRepository();
        if (VcsLogUtil.findBranch((RefsModel)((MultipleCommitEditingData)commitEditingData).getLogData().getDataPack().getRefsModel(), (VirtualFile)repository2.getRoot(), (String)"HEAD") == null) {
            Object[] objectArray = new Object[]{VcsLogCommitSelectionUtils.getSize((VcsLogCommitSelection)((MultipleCommitEditingData)commitEditingData).getSelection())};
            return GitBundle.message((String)"rebase.log.multiple.commit.editing.action.cant.find.head", (Object[])objectArray);
        }
        return null;
    }

    private final boolean checkNotInitialCommit(T commitEditingData) {
        List commitList = ((MultipleCommitEditingData)commitEditingData).getSelection().getCachedMetadata();
        Iterable $this$forEach$iv = commitList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VcsCommitMetadata commit = (VcsCommitMetadata)element$iv;
            boolean bl = false;
            if (commit instanceof LoadingDetails || !commit.getParents().isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    protected String checkNotMergeCommit(@NotNull T commitEditingData) {
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
        List commitList = ((MultipleCommitEditingData)commitEditingData).getSelection().getCachedMetadata();
        Iterable $this$forEach$iv = commitList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VcsCommitMetadata commit = (VcsCommitMetadata)element$iv;
            boolean bl = false;
            if (commit instanceof LoadingDetails || commit.getParents().size() <= 1) continue;
            Object[] objectArray = new Object[]{commit.getParents().size()};
            return GitBundle.message((String)"rebase.log.commit.editing.action.disabled.parents.description", (Object[])objectArray);
        }
        return null;
    }

    private final String checkCommitsCanBeEdited(T commitEditingData) {
        List commitList = ((MultipleCommitEditingData)commitEditingData).getSelection().getCommits();
        GitRepository repository2 = ((MultipleCommitEditingData)commitEditingData).getRepository();
        Object[] objectArray = new CommitId[]{CollectionsKt.first((List)commitList), CollectionsKt.last((List)commitList)};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommitId commit = (CommitId)element$iv;
            boolean bl = false;
            ContainingBranchesGetter containingBranchesGetter = ((MultipleCommitEditingData)commitEditingData).getLogData().getContainingBranchesGetter();
            VirtualFile virtualFile = commit.getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            Hash hash = commit.getHash();
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
            List branches = containingBranchesGetter.getContainingBranchesQuickly(virtualFile, hash);
            if (branches == null) continue;
            if (!branches.contains("HEAD")) {
                return GitBundle.message((String)"rebase.log.commit.editing.action.commit.not.in.head.error.text", (Object[])new Object[0]);
            }
            String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(repository2, branches);
            if (protectedBranch == null) continue;
            Object[] objectArray2 = new Object[]{protectedBranch};
            return GitBundle.message((String)"rebase.log.commit.editing.action.commit.pushed.to.protected.branch.error.text", (Object[])objectArray2);
        }
        return null;
    }

    private final String checkNotRebaseDuringRebase(T commitEditingData) {
        ProhibitRebaseDuringRebasePolicy policy = this.getProhibitRebaseDuringRebasePolicy();
        if (!Intrinsics.areEqual((Object)policy, (Object)ProhibitRebaseDuringRebasePolicy.Allow.INSTANCE)) {
            if (policy instanceof ProhibitRebaseDuringRebasePolicy.Prohibit) {
                String message = this.getProhibitedStateMessage(commitEditingData, ((ProhibitRebaseDuringRebasePolicy.Prohibit)policy).getOperation());
                if (message != null) {
                    return message;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return null;
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        CommitEditingDataCreationResult<T> commitEditingDataCreationResult = this.createCommitEditingData(e);
        Intrinsics.checkNotNull(commitEditingDataCreationResult, (String)"null cannot be cast to non-null type git4idea.rebase.log.GitCommitEditingActionBase.CommitEditingDataCreationResult.Created<T of git4idea.rebase.log.GitCommitEditingActionBase>");
        Object commitEditingRequirements = ((CommitEditingDataCreationResult.Created)commitEditingDataCreationResult).getData();
        String description = this.lastCheckCommitsEditingAvailability(commitEditingRequirements);
        if (description != null) {
            Messages.showErrorDialog((Project)((MultipleCommitEditingData)commitEditingRequirements).getProject(), (String)description, (String)this.getFailureTitle());
            return;
        }
        if (!this.checkNotInitialCommit(commitEditingRequirements)) {
            String string = GitBundle.message((String)"rebase.log.commit.editing.action.initial.commit.dialog.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String string2 = GitBundle.message((String)"rebase.log.commit.editing.action.initial.commit.dialog.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            MessageDialogBuilder.YesNo yesNo = MessageDialogBuilder.Companion.yesNo(string, string2);
            String string3 = CommonBundle.getContinueButtonText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getContinueButtonText(...)");
            MessageDialogBuilder.YesNo yesNo2 = (MessageDialogBuilder.YesNo)yesNo.yesText(string3);
            String string4 = CommonBundle.getCancelButtonText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getCancelButtonText(...)");
            boolean ans = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)yesNo2.noText(string4)).icon(Messages.getWarningIcon())).ask(((MultipleCommitEditingData)commitEditingRequirements).getProject());
            if (!ans) {
                return;
            }
        }
        this.actionPerformedAfterChecks(commitEditingRequirements);
    }

    @Nls
    @Nullable
    protected String lastCheckCommitsEditingAvailability(@NotNull T commitEditingData) {
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
        String string = GitBundle.message((String)"rebase.log.multiple.commit.editing.action.progress.indicator.action.possibility.check", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String description = Companion.checkHeadLinearHistory((MultipleCommitEditingData)commitEditingData, string);
        if (description != null) {
            return description;
        }
        CommitId lastCommit = (CommitId)CollectionsKt.last((List)((MultipleCommitEditingData)commitEditingData).getSelection().getCommits());
        VcsLogData vcsLogData = ((MultipleCommitEditingData)commitEditingData).getLogData();
        VirtualFile virtualFile = lastCommit.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        Hash hash = lastCommit.getHash();
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"getHash(...)");
        List<String> branches = Companion.findContainingBranches(vcsLogData, virtualFile, hash);
        String protectedBranch = GitProtectedBranchesKt.findProtectedRemoteBranch(((MultipleCommitEditingData)commitEditingData).getRepository(), (Collection<String>)branches);
        if (protectedBranch != null) {
            Object[] objectArray = new Object[]{protectedBranch};
            return GitBundle.message((String)"rebase.log.commit.editing.action.commit.pushed.to.protected.branch.error.text", (Object[])objectArray);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final CommitEditingDataCreationResult<T> createCommitEditingData(AnActionEvent e) {
        Object[] objectArray;
        void $this$mapTo$iv$iv;
        List list;
        Project project = e.getProject();
        VcsLogCommitSelection selection = (VcsLogCommitSelection)e.getData(VcsLogDataKeys.VCS_LOG_COMMIT_SELECTION);
        VcsLogData logDataProvider = (VcsLogData)e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        if (project == null || selection == null || logDataProvider == null) {
            return new CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        List it = list = selection.getCommits();
        boolean bl = false;
        List list2 = !((Collection)it).isEmpty() ? list : null;
        if (list2 == null) {
            return new CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        List commitList = list2;
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getRepositoryManager(...)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        Iterable $this$map$iv = commitList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            CommitId commitId = (CommitId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it2.getRoot());
        }
        VirtualFile virtualFile = (VirtualFile)CollectionsKt.singleOrNull((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        if (virtualFile == null) {
            objectArray = new Object[]{commitList.size()};
            return new CommitEditingDataCreationResult.Prohibited(GitBundle.message((String)"rebase.log.multiple.commit.editing.action.disabled.multiple.repository.description", (Object[])objectArray));
        }
        VirtualFile root = virtualFile;
        GitRepository gitRepository = (GitRepository)repositoryManager.getRepositoryForRootQuick(root);
        if (gitRepository == null) {
            return new CommitEditingDataCreationResult.Prohibited(null, 1, null);
        }
        GitRepository repository2 = gitRepository;
        if (repositoryManager.isExternal(repository2)) {
            objectArray = new Object[]{commitList.size()};
            return new CommitEditingDataCreationResult.Prohibited(GitBundle.message((String)"rebase.log.multiple.commit.editing.action.disabled.external.repository.description", (Object[])objectArray));
        }
        return this.createCommitEditingData(repository2, selection, logDataProvider);
    }

    @Nullable
    protected String getProhibitedStateMessage(@NotNull T commitEditingData, @Nls @NotNull String operation) {
        Intrinsics.checkNotNullParameter(commitEditingData, (String)"commitEditingData");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return switch (WhenMappings.$EnumSwitchMapping$0[((MultipleCommitEditingData)commitEditingData).getRepository().getState().ordinal()]) {
            case 1, 2 -> null;
            case 3 -> {
                Object[] var3_3 = new Object[]{operation};
                yield GitBundle.message((String)"rebase.log.commit.editing.action.prohibit.state.rebasing", (Object[])var3_3);
            }
            case 4 -> {
                Object[] var3_4 = new Object[]{operation};
                yield GitBundle.message((String)"rebase.log.commit.editing.action.prohibit.state.merging", (Object[])var3_4);
            }
            case 5 -> {
                Object[] var3_5 = new Object[]{operation};
                yield GitBundle.message((String)"rebase.log.commit.editing.action.prohibit.state.grafting", (Object[])var3_5);
            }
            case 6 -> {
                Object[] var3_6 = new Object[]{operation};
                yield GitBundle.message((String)"rebase.log.commit.editing.action.prohibit.state.reverting", (Object[])var3_6);
            }
            default -> {
                Object[] var3_7 = new Object[]{operation};
                yield GitBundle.message((String)"rebase.log.commit.editing.action.prohibit.state", (Object[])var3_7);
            }
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002\u0006\u0007B\t\b\u0004\u00a2\u0006\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "", "<init>", "()V", "Created", "Prohibited", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Created;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Prohibited;", "intellij.vcs.git"})
    protected static abstract class CommitEditingDataCreationResult<T extends MultipleCommitEditingData> {
        private CommitEditingDataCreationResult() {
        }

        public /* synthetic */ CommitEditingDataCreationResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0004\u001a\u00028\u0002\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\n"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Created;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "data", "<init>", "(Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;)V", "getData", "()Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "intellij.vcs.git"})
        public static final class Created<T extends MultipleCommitEditingData>
        extends CommitEditingDataCreationResult<T> {
            @NotNull
            private final T data;

            public Created(@NotNull T data2) {
                Intrinsics.checkNotNullParameter(data2, (String)"data");
                super(null);
                this.data = data2;
            }

            @NotNull
            public final T getData() {
                return this.data;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000*\b\b\u0002\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0018\u0012\u000f\b\u0002\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0018\u0010\u0004\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult$Prohibited;", "T", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$CommitEditingDataCreationResult;", "description", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class Prohibited<T extends MultipleCommitEditingData>
        extends CommitEditingDataCreationResult<T> {
            @Nullable
            private final String description;

            public Prohibited(@Nullable String description) {
                super(null);
                this.description = description;
            }

            public /* synthetic */ Prohibited(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    string = null;
                }
                this(string);
            }

            @Nullable
            public final String getDescription() {
                return this.description;
            }

            public Prohibited() {
                this(null, 1, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ&\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0006H\u0007J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\n\u0010\u0017\u001a\u00060\u0016j\u0002`\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$Companion;", "", "<init>", "()V", "findContainingBranches", "", "", "data", "Lcom/intellij/vcs/log/data/VcsLogData;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "hash", "Lcom/intellij/vcs/log/Hash;", "findContainingBranchesQuickly", "checkHeadLinearHistory", "commitEditingData", "Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "progressText", "getCommitIdByNodeId", "Lcom/intellij/vcs/log/CommitId;", "permanentGraph", "Lcom/intellij/vcs/log/graph/impl/facade/PermanentGraphImpl;", "", "nodeId", "Lcom/intellij/vcs/log/graph/api/permanent/VcsLogGraphNodeId;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> findContainingBranches(@NotNull VcsLogData data2, @NotNull VirtualFile root, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            List<String> branches = this.findContainingBranchesQuickly(data2, root, hash);
            if (branches == null) {
                ContainingBranchesGetter containingBranchesGetter = data2.getContainingBranchesGetter();
                Intrinsics.checkNotNullExpressionValue((Object)containingBranchesGetter, (String)"getContainingBranchesGetter(...)");
                ContainingBranchesGetter branchesGetter = containingBranchesGetter;
                Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Companion.findContainingBranches$lambda$0(branchesGetter, root, hash), GitBundle.message((String)"rebase.log.commit.editing.action.progress.containing.branches.title", (Object[])new Object[0]), true, data2.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runProcessWithProgressSynchronously(...)");
                return (List)object;
            }
            return branches;
        }

        @Nullable
        public final List<String> findContainingBranchesQuickly(@NotNull VcsLogData data2, @NotNull VirtualFile root, @NotNull Hash hash) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            ContainingBranchesGetter containingBranchesGetter = data2.getContainingBranchesGetter();
            Intrinsics.checkNotNullExpressionValue((Object)containingBranchesGetter, (String)"getContainingBranchesGetter(...)");
            ContainingBranchesGetter branchesGetter = containingBranchesGetter;
            return branchesGetter.getContainingBranchesQuickly(root, hash);
        }

        @Nls
        @Nullable
        public final String checkHeadLinearHistory(@NotNull MultipleCommitEditingData commitEditingData, @NlsContexts.ProgressTitle @NotNull String progressText) {
            Intrinsics.checkNotNullParameter((Object)commitEditingData, (String)"commitEditingData");
            Intrinsics.checkNotNullParameter((Object)progressText, (String)"progressText");
            Project project = commitEditingData.getProject();
            VirtualFile virtualFile = commitEditingData.getRepository().getRoot();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
            VirtualFile root = virtualFile;
            VcsLogData logData = commitEditingData.getLogData();
            DataPack dataPack = logData.getDataPack();
            Intrinsics.checkNotNullExpressionValue((Object)dataPack, (String)"getDataPack(...)");
            DataPack dataPack2 = dataPack;
            PermanentGraph permanentGraph = dataPack2.getPermanentGraph();
            Intrinsics.checkNotNull((Object)permanentGraph, (String)"null cannot be cast to non-null type com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl<kotlin.Int>");
            PermanentGraphImpl permanentGraph2 = (PermanentGraphImpl)permanentGraph;
            PermanentCommitsInfoImpl commitsInfo = permanentGraph2.getPermanentCommitsInfo();
            List commitIndices = commitEditingData.getSelection().getIds();
            Ref.ObjectRef description = new Ref.ObjectRef();
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> Companion.checkHeadLinearHistory$lambda$2(commitsInfo, commitIndices, dataPack2, root, logData, permanentGraph2, description), progressText, true, project);
            return (String)description.element;
        }

        private final CommitId getCommitIdByNodeId(VcsLogData data2, PermanentGraphImpl<Integer> permanentGraph, int nodeId) {
            CommitId commitId = data2.getCommitId(((Number)permanentGraph.getPermanentCommitsInfo().getCommitId(nodeId)).intValue());
            Intrinsics.checkNotNull((Object)commitId);
            return commitId;
        }

        private static final List findContainingBranches$lambda$0(ContainingBranchesGetter $branchesGetter, VirtualFile $root, Hash $hash) {
            return $branchesGetter.getContainingBranchesSynchronously($root, $hash);
        }

        private static final boolean checkHeadLinearHistory$lambda$2$lambda$1(LiteLinearGraph $graph, VcsLogData $logData, PermanentGraphImpl $permanentGraph, Ref.ObjectRef $description, int $maxNodeId, Set $commitNodeIds, int nodeId) {
            boolean bl;
            ProgressManager.checkCanceled();
            List list = $graph.getNodes(nodeId, LiteLinearGraph.NodeFilter.DOWN);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNodes(...)");
            List parents = list;
            if (parents.size() != 1) {
                CommitId commit = Companion.getCommitIdByNodeId($logData, (PermanentGraphImpl<Integer>)$permanentGraph, nodeId);
                Object[] objectArray = new Object[]{commit.getHash(), parents.size()};
                $description.element = GitBundle.message((String)"rebase.log.multiple.commit.editing.action.specific.commit.root.or.merge", (Object[])objectArray);
                bl = false;
            } else if (nodeId > $maxNodeId) {
                CommitId commitNotInHead = Companion.getCommitIdByNodeId($logData, (PermanentGraphImpl<Integer>)$permanentGraph, ((Number)CollectionsKt.first((Iterable)$commitNodeIds)).intValue());
                Object[] objectArray = new Object[]{commitNotInHead.getHash()};
                $description.element = GitBundle.message((String)"rebase.log.multiple.commit.editing.action.specific.commit.not.in.head", (Object[])objectArray);
                bl = false;
            } else {
                $commitNodeIds.remove(nodeId);
                bl = !((Collection)$commitNodeIds).isEmpty();
            }
            return bl;
        }

        private static final void checkHeadLinearHistory$lambda$2(PermanentCommitsInfoImpl $commitsInfo, List $commitIndices, DataPack $dataPack, VirtualFile $root, VcsLogData $logData, PermanentGraphImpl $permanentGraph, Ref.ObjectRef $description) {
            Set commitNodeIds = CollectionsKt.toMutableSet((Iterable)$commitsInfo.convertToNodeIds((Collection)$commitIndices));
            VcsRef vcsRef = VcsLogUtil.findBranch((RefsModel)$dataPack.getRefsModel(), (VirtualFile)$root, (String)"HEAD");
            Intrinsics.checkNotNull((Object)vcsRef);
            VcsRef headRef = vcsRef;
            int headIndex = $logData.getCommitIndex(headRef.getCommitHash(), $root);
            int headId = $commitsInfo.getNodeId((Object)headIndex);
            Comparable comparable = CollectionsKt.maxOrNull((Iterable)commitNodeIds);
            Intrinsics.checkNotNull((Object)comparable);
            int maxNodeId = ((Number)((Object)comparable)).intValue();
            LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph((LinearGraph)((LinearGraph)$permanentGraph.getLinearGraph()));
            Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
            LiteLinearGraph graph = liteLinearGraph;
            BitSetFlags used = new BitSetFlags($permanentGraph.getLinearGraph().nodesCount());
            new DfsWalk((Collection)CollectionsKt.listOf((Object)headId), graph, (Flags)used).walk(true, arg_0 -> Companion.checkHeadLinearHistory$lambda$2$lambda$1(graph, $logData, $permanentGraph, $description, maxNodeId, commitNodeIds, arg_0));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$MultipleCommitEditingData;", "", "repository", "Lgit4idea/repo/GitRepository;", "selection", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "<init>", "(Lgit4idea/repo/GitRepository;Lcom/intellij/vcs/log/VcsLogCommitSelection;Lcom/intellij/vcs/log/data/VcsLogData;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "getSelection", "()Lcom/intellij/vcs/log/VcsLogCommitSelection;", "getLogData", "()Lcom/intellij/vcs/log/data/VcsLogData;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    public static class MultipleCommitEditingData {
        @NotNull
        private final GitRepository repository;
        @NotNull
        private final VcsLogCommitSelection selection;
        @NotNull
        private final VcsLogData logData;
        @NotNull
        private final Project project;

        public MultipleCommitEditingData(@NotNull GitRepository repository2, @NotNull VcsLogCommitSelection selection, @NotNull VcsLogData logData) {
            Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            this.repository = repository2;
            this.selection = selection;
            this.logData = logData;
            Project project = this.repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            this.project = project;
        }

        @NotNull
        public final GitRepository getRepository() {
            return this.repository;
        }

        @NotNull
        public final VcsLogCommitSelection getSelection() {
            return this.selection;
        }

        @NotNull
        public final VcsLogData getLogData() {
            return this.logData;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b4\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "", "<init>", "()V", "Allow", "Prohibit", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Allow;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "intellij.vcs.git"})
    protected static abstract class ProhibitRebaseDuringRebasePolicy {
        private ProhibitRebaseDuringRebasePolicy() {
        }

        public /* synthetic */ ProhibitRebaseDuringRebasePolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Allow;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "<init>", "()V", "intellij.vcs.git"})
        public static final class Allow
        extends ProhibitRebaseDuringRebasePolicy {
            @NotNull
            public static final Allow INSTANCE = new Allow();

            private Allow() {
                super(null);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy$Prohibit;", "Lgit4idea/rebase/log/GitCommitEditingActionBase$ProhibitRebaseDuringRebasePolicy;", "operation", "", "<init>", "(Ljava/lang/String;)V", "getOperation", "()Ljava/lang/String;", "intellij.vcs.git"})
        public static final class Prohibit
        extends ProhibitRebaseDuringRebasePolicy {
            @NotNull
            private final String operation;

            public Prohibit(@Nls @NotNull String operation) {
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                super(null);
                this.operation = operation;
            }

            @NotNull
            public final String getOperation() {
                return this.operation;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Repository.State.values().length];
            try {
                nArray[Repository.State.NORMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.DETACHED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.REBASING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.MERGING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.GRAFTING.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Repository.State.REVERTING.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

