/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.Indent;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDocTokenType;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.SemanticEditorPosition;
import com.intellij.psi.impl.source.codeStyle.lineIndent.JavaLikeLangLineIndentProvider;
import com.intellij.psi.tree.IElementType;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaLineIndentProvider
extends JavaLikeLangLineIndentProvider {
    private static final Map<IElementType, SemanticEditorPosition.SyntaxElement> SYNTAX_MAP = Map.ofEntries(Map.entry(TokenType.WHITE_SPACE, JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace), Map.entry(JavaTokenType.SEMICOLON, JavaLikeLangLineIndentProvider.JavaLikeElement.Semicolon), Map.entry(JavaTokenType.LBRACE, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockOpeningBrace), Map.entry(JavaTokenType.RBRACE, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockClosingBrace), Map.entry(JavaTokenType.LBRACKET, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayOpeningBracket), Map.entry(JavaTokenType.RBRACKET, JavaLikeLangLineIndentProvider.JavaLikeElement.ArrayClosingBracket), Map.entry(JavaTokenType.RPARENTH, JavaLikeLangLineIndentProvider.JavaLikeElement.RightParenthesis), Map.entry(JavaTokenType.LPARENTH, JavaLikeLangLineIndentProvider.JavaLikeElement.LeftParenthesis), Map.entry(JavaTokenType.COLON, JavaLikeLangLineIndentProvider.JavaLikeElement.Colon), Map.entry(JavaTokenType.CASE_KEYWORD, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchCase), Map.entry(JavaTokenType.DEFAULT_KEYWORD, JavaLikeLangLineIndentProvider.JavaLikeElement.SwitchDefault), Map.entry(JavaTokenType.IF_KEYWORD, JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword), Map.entry(JavaTokenType.WHILE_KEYWORD, JavaLikeLangLineIndentProvider.JavaLikeElement.IfKeyword), Map.entry(JavaTokenType.ELSE_KEYWORD, JavaLikeLangLineIndentProvider.JavaLikeElement.ElseKeyword), Map.entry(JavaTokenType.FOR_KEYWORD, JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword), Map.entry(JavaTokenType.DO_KEYWORD, JavaLikeLangLineIndentProvider.JavaLikeElement.DoKeyword), Map.entry(JavaTokenType.C_STYLE_COMMENT, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment), Map.entry(JavaDocTokenType.DOC_COMMENT_START, JavaLikeLangLineIndentProvider.JavaLikeElement.DocBlockStart), Map.entry(JavaDocTokenType.DOC_COMMENT_END, JavaLikeLangLineIndentProvider.JavaLikeElement.DocBlockEnd), Map.entry(JavaTokenType.COMMA, JavaLikeLangLineIndentProvider.JavaLikeElement.Comma), Map.entry(JavaTokenType.END_OF_LINE_COMMENT, JavaLikeLangLineIndentProvider.JavaLikeElement.LineComment), Map.entry(JavaTokenType.TRY_KEYWORD, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword));

    @Nullable
    protected SemanticEditorPosition.SyntaxElement mapType(@NotNull IElementType tokenType) {
        if (tokenType == null) {
            JavaLineIndentProvider.$$$reportNull$$$0(0);
        }
        return SYNTAX_MAP.get(tokenType);
    }

    public boolean isSuitableForLanguage(@NotNull Language language) {
        if (language == null) {
            JavaLineIndentProvider.$$$reportNull$$$0(1);
        }
        return language.isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @Nullable
    protected Indent getIndentInBlock(@NotNull Project project, @Nullable Language language, @NotNull SemanticEditorPosition blockStartPosition) {
        SemanticEditorPosition beforeStart;
        if (project == null) {
            JavaLineIndentProvider.$$$reportNull$$$0(2);
        }
        if (blockStartPosition == null) {
            JavaLineIndentProvider.$$$reportNull$$$0(3);
        }
        if ((beforeStart = blockStartPosition.before().beforeOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace)).isAt(JavaTokenType.EQ) || beforeStart.isAt(JavaTokenType.RBRACKET) || beforeStart.isAt(JavaTokenType.LPARENTH)) {
            return JavaLineIndentProvider.getDefaultIndentFromType((Indent.Type)Indent.Type.CONTINUATION);
        }
        if (beforeStart.isAt(JavaTokenType.IDENTIFIER)) {
            JavaLineIndentProvider.moveBeforeExtendsImplementsAndIdentifier(beforeStart);
            if (beforeStart.isAt(JavaTokenType.CLASS_KEYWORD) && JavaLineIndentProvider.doNotIndentClassMembers(beforeStart)) {
                return Indent.getNoneIndent();
            }
        }
        return super.getIndentInBlock(project, language, blockStartPosition);
    }

    private static void moveBeforeExtendsImplementsAndIdentifier(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLineIndentProvider.$$$reportNull$$$0(4);
        }
        while (position.isAt(JavaTokenType.IDENTIFIER) || position.isAtAnyOf(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.Comma}) || position.isAt(JavaTokenType.EXTENDS_KEYWORD) || position.isAt(JavaTokenType.IMPLEMENTS_KEYWORD)) {
            position.moveBefore();
        }
    }

    private static boolean doNotIndentClassMembers(@NotNull SemanticEditorPosition position) {
        if (position == null) {
            JavaLineIndentProvider.$$$reportNull$$$0(5);
        }
        Editor editor = position.getEditor();
        CommonCodeStyleSettings javaSettings = CodeStyle.getSettings((Editor)editor).getCommonSettings((Language)JavaLanguage.INSTANCE);
        return javaSettings.DO_NOT_INDENT_TOP_LEVEL_CLASS_MEMBERS;
    }

    protected boolean isInsideForLikeConstruction(SemanticEditorPosition position) {
        return position.isAfterOnSameLine(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.ForKeyword, JavaLikeLangLineIndentProvider.JavaLikeElement.TryKeyword});
    }

    protected boolean isInArray(@NotNull Editor editor, int offset) {
        if (editor == null) {
            JavaLineIndentProvider.$$$reportNull$$$0(6);
        }
        SemanticEditorPosition position = this.getPosition(editor, offset);
        position.moveBefore();
        if (position.isAt(JavaTokenType.LBRACE) && position.before().beforeOptional((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace).isAt(JavaTokenType.RBRACKET)) {
            return true;
        }
        return super.isInArray(editor, offset);
    }

    protected boolean isIndentProvider(@NotNull SemanticEditorPosition position, boolean ignoreLabels) {
        if (position == null) {
            JavaLineIndentProvider.$$$reportNull$$$0(7);
        }
        return !position.afterOptionalMix(new SemanticEditorPosition.SyntaxElement[]{JavaLikeLangLineIndentProvider.JavaLikeElement.Whitespace, JavaLikeLangLineIndentProvider.JavaLikeElement.BlockComment}).after().isAt((SemanticEditorPosition.SyntaxElement)JavaLikeLangLineIndentProvider.JavaLikeElement.Colon) || !position.isAt(JavaTokenType.IDENTIFIER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStartPosition";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/JavaLineIndentProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "mapType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableForLanguage";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentInBlock";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "moveBeforeExtendsImplementsAndIdentifier";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doNotIndentClassMembers";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isInArray";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isIndentProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

