/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.telemetry;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.telemetry.DisabledMetricsUtil;
import com.google.cloud.firestore.telemetry.EnabledMetricsUtil;
import com.google.cloud.firestore.telemetry.TelemetryConstants;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@InternalApi
public interface MetricsUtil {
    public static final Logger logger = Logger.getLogger(MetricsUtil.class.getName());
    public static final String ENABLE_METRICS_ENV_VAR = "FIRESTORE_ENABLE_METRICS";

    public static MetricsUtil getInstance(@Nonnull FirestoreOptions firestoreOptions) {
        if (MetricsUtil.shouldCreateEnabledInstance()) {
            return new EnabledMetricsUtil(firestoreOptions);
        }
        return new DisabledMetricsUtil();
    }

    public static boolean shouldCreateEnabledInstance() {
        boolean shouldCreateEnabledInstance = false;
        String enableMetricsEnvVar = System.getenv(ENABLE_METRICS_ENV_VAR);
        if (enableMetricsEnvVar != null) {
            switch (enableMetricsEnvVar.toLowerCase()) {
                case "true": 
                case "on": {
                    break;
                }
                case "false": 
                case "off": {
                    shouldCreateEnabledInstance = false;
                    break;
                }
                default: {
                    logger.warning("Invalid value for FIRESTORE_ENABLE_METRICS: " + enableMetricsEnvVar);
                }
            }
        }
        return shouldCreateEnabledInstance;
    }

    public MetricsContext createMetricsContext(String var1);

    public void addMetricsTracerFactory(List<ApiTracerFactory> var1);

    public static interface MetricsContext {
        public <T> void recordLatencyAtFuture(TelemetryConstants.MetricType var1, ApiFuture<T> var2);

        public void recordLatency(TelemetryConstants.MetricType var1);

        public void recordLatency(TelemetryConstants.MetricType var1, Throwable var2);

        public <T> void recordCounterAtFuture(TelemetryConstants.MetricType var1, ApiFuture<T> var2);

        public void incrementCounter();
    }
}

