/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.collection.iteration.ArrayIterable;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.sequence.BasedSequence;
import com.vladsch.flexmark.util.sequence.BasedSequenceImpl;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.ReplacedBasedSequence;
import com.vladsch.flexmark.util.sequence.SegmentedSequenceFull;
import com.vladsch.flexmark.util.sequence.SegmentedSequenceTree;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.builder.SequenceBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SegmentedSequence
extends BasedSequenceImpl
implements ReplacedBasedSequence {
    protected final BasedSequence baseSeq;
    protected final int startOffset;
    protected final int endOffset;
    protected final int length;

    protected SegmentedSequence(BasedSequence baseSeq, int startOffset, int endOffset, int length) {
        super(0);
        assert (baseSeq == baseSeq.getBaseSequence());
        if (startOffset < 0 && endOffset < 0) {
            startOffset = 0;
            endOffset = 0;
        }
        assert (startOffset >= 0) : "startOffset: " + startOffset;
        assert (endOffset >= startOffset && endOffset <= baseSeq.length()) : "endOffset: " + endOffset;
        this.baseSeq = baseSeq;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.length = length;
    }

    @Override
    @NotNull
    public final Object getBase() {
        return this.baseSeq.getBase();
    }

    @Override
    @NotNull
    public final BasedSequence getBaseSequence() {
        return this.baseSeq;
    }

    @Override
    public final int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public final int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public final int getOptionFlags() {
        return this.getBaseSequence().getOptionFlags();
    }

    @Override
    public final boolean allOptions(int options) {
        return this.getBaseSequence().allOptions(options);
    }

    @Override
    public final boolean anyOptions(int options) {
        return this.getBaseSequence().anyOptions(options);
    }

    @Override
    public final <T> T getOption(DataKeyBase<T> dataKey) {
        return this.getBaseSequence().getOption(dataKey);
    }

    @Override
    @Nullable
    public final DataHolder getOptions() {
        return this.getBaseSequence().getOptions();
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    @NotNull
    public final Range getSourceRange() {
        return Range.of(this.getStartOffset(), this.getEndOffset());
    }

    @Override
    @NotNull
    public final BasedSequence baseSubSequence(int startIndex, int endIndex) {
        SequenceUtils.validateStartEnd(startIndex, endIndex, this.baseSeq.length());
        return this.baseSeq.baseSubSequence(startIndex, endIndex);
    }

    public static BasedSequence create(BasedSequence basedSequence, @NotNull Iterable<? extends BasedSequence> segments) {
        return SegmentedSequence.create((SequenceBuilder)basedSequence.getBuilder().addAll(segments));
    }

    public static BasedSequence create(BasedSequence ... segments) {
        return segments.length == 0 ? BasedSequence.NULL : SegmentedSequence.create(segments[0], (Iterable<? extends BasedSequence>)new ArrayIterable((Object[])segments));
    }

    public static BasedSequence create(SequenceBuilder builder) {
        BasedSequence baseSubSequence = builder.getSingleBasedSequence();
        if (baseSubSequence != null) {
            return baseSubSequence;
        }
        if (!builder.isEmpty()) {
            BasedSequence baseSequence = builder.getBaseSequence();
            if (baseSequence.anyOptions(F_FULL_SEGMENTED_SEQUENCES)) {
                return SegmentedSequenceFull.create(baseSequence, builder.getSegmentBuilder());
            }
            if (baseSequence.anyOptions(F_TREE_SEGMENTED_SEQUENCES)) {
                return SegmentedSequenceTree.create(baseSequence, builder.getSegmentBuilder());
            }
            return SegmentedSequenceTree.create(baseSequence, builder.getSegmentBuilder());
        }
        return BasedSequence.NULL;
    }

    @Deprecated
    public static BasedSequence of(BasedSequence basedSequence, @NotNull Iterable<? extends BasedSequence> segments) {
        return SegmentedSequence.create(basedSequence, segments);
    }

    @Deprecated
    public static BasedSequence of(BasedSequence ... segments) {
        return SegmentedSequence.create(segments);
    }
}

