/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.tcp;

import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContext;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.crypto.Cipher;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;

public class SslContextBuilder {
    private static final String[] NULL_STRING_ARRAY = new String[0];
    private static final Logger logger = LogManager.getLogger(SslContextBuilder.class);
    private SslClientAuthentication clientAuthentication = SslClientAuthentication.NONE;
    private final String certificatePath;
    private final String keyPath;
    private final char[] keyPassphrase;
    private String[] certificateAuthorities = NULL_STRING_ARRAY;
    private String[] extraChainCerts = NULL_STRING_ARRAY;
    private String[] supportedProtocols = NULL_STRING_ARRAY;
    private String[] cipherSuites = NULL_STRING_ARRAY;

    public static List<String> getSupportedCipherSuites() {
        return Arrays.asList(((SSLServerSocketFactory)SSLServerSocketFactory.getDefault()).getSupportedCipherSuites());
    }

    public SslContextBuilder(String certificatePath, String keyPath, String keyPassphrase) {
        if (!Files.isReadable(Paths.get(certificatePath, new String[0]))) {
            throw new IllegalArgumentException(String.format("Certificate file cannot be read. Please confirm the user running Logstash has permissions to read: %s", certificatePath));
        }
        if (!Files.isReadable(Paths.get(keyPath, new String[0]))) {
            throw new IllegalArgumentException(String.format("Private key file cannot be read. Please confirm the user running Logstash has permissions to read: %s", keyPath));
        }
        this.keyPath = keyPath;
        this.certificatePath = certificatePath;
        this.keyPassphrase = keyPassphrase == null ? null : keyPassphrase.toCharArray();
    }

    public SslContextBuilder setClientAuthentication(SslClientAuthentication clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
        return this;
    }

    public SslContextBuilder setCertificateAuthorities(String[] paths) {
        this.certificateAuthorities = paths;
        return this;
    }

    public SslContextBuilder setExtraChainCerts(String[] paths) {
        this.extraChainCerts = paths;
        return this;
    }

    public SslContextBuilder setSupportedProtocols(String[] protocols) {
        this.supportedProtocols = protocols;
        return this;
    }

    String[] getSupportedProtocols() {
        return this.supportedProtocols;
    }

    SslClientAuthentication getClientAuthentication() {
        return this.clientAuthentication;
    }

    String[] getCertificateAuthorities() {
        return this.certificateAuthorities;
    }

    String[] getCipherSuites() {
        return this.cipherSuites;
    }

    public SslContextBuilder setCipherSuites(String[] suites) {
        if (suites.length > 0) {
            HashSet<String> supportedCipherSuites = new HashSet<String>(SslContextBuilder.getSupportedCipherSuites());
            for (String cipher : suites) {
                if (!supportedCipherSuites.contains(cipher)) {
                    throw new IllegalArgumentException("Cipher `" + cipher + "` is not available");
                }
                logger.debug("{} cipher is supported", (Object)cipher);
            }
        }
        this.cipherSuites = suites;
        return this;
    }

    public SslContext buildContext() throws Exception {
        PEMDecryptorProvider decryptor;
        PrivateKey privateKey;
        CertificateFactory certFactory;
        List<Certificate> certChain;
        SslContextBuilder.installBouncyCastleProvider();
        if (Cipher.getMaxAllowedKeyLength("AES") <= 128) {
            logger.warn("JCE Unlimited Strength Jurisdiction Policy not installed - max key length is 128 bits");
        }
        if ((certChain = SslContextBuilder.getCertificatesFromFile(this.certificatePath, certFactory = CertificateFactory.getInstance("X.509"))).isEmpty()) {
            logger.warn("Failed to read certificate from path: {}", (Object)this.certificatePath);
            throw new IllegalArgumentException("failed to read certificate from ssl_certificate path");
        }
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
        converter.setProvider((Provider)new BouncyCastleProvider());
        Object obj = new PEMParser((Reader)new FileReader(this.keyPath)).readObject();
        if (obj instanceof PEMKeyPair) {
            privateKey = converter.getKeyPair((PEMKeyPair)obj).getPrivate();
        } else if (obj instanceof PrivateKeyInfo) {
            privateKey = converter.getPrivateKey((PrivateKeyInfo)obj);
        } else if (obj instanceof PEMEncryptedKeyPair) {
            decryptor = new JcePEMDecryptorProviderBuilder().build(this.keyPassphrase);
            PEMKeyPair keyPair = ((PEMEncryptedKeyPair)obj).decryptKeyPair(decryptor);
            privateKey = converter.getKeyPair(keyPair).getPrivate();
        } else if (obj instanceof PKCS8EncryptedPrivateKeyInfo) {
            decryptor = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(this.keyPassphrase);
            PrivateKeyInfo keyInfo = ((PKCS8EncryptedPrivateKeyInfo)obj).decryptPrivateKeyInfo((InputDecryptorProvider)decryptor);
            privateKey = converter.getPrivateKey(keyInfo);
        } else {
            throw new IllegalArgumentException("unexpected key format (" + (obj == null ? null : obj.getClass()) + ")");
        }
        for (PEMDecryptorProvider certPath : this.extraChainCerts) {
            certChain.addAll(SslContextBuilder.getCertificatesFromFile((String)certPath, certFactory));
        }
        io.netty.handler.ssl.SslContextBuilder sslContextBuilder = io.netty.handler.ssl.SslContextBuilder.forServer((PrivateKey)privateKey, (String)(this.keyPassphrase == null ? null : new String(this.keyPassphrase)), (X509Certificate[])certChain.toArray(new X509Certificate[certChain.size()]));
        ArrayList<Certificate> trustedCerts = new ArrayList<Certificate>();
        for (String certPath : this.certificateAuthorities) {
            trustedCerts.addAll(SslContextBuilder.getCertificatesFromFile(certPath, certFactory));
        }
        if (!trustedCerts.isEmpty()) {
            sslContextBuilder.trustManager(trustedCerts.toArray(new X509Certificate[trustedCerts.size()]));
        }
        sslContextBuilder.clientAuth(this.clientAuthentication.toClientAuth());
        if (this.supportedProtocols.length > 0) {
            sslContextBuilder.protocols(this.supportedProtocols);
        }
        if (this.cipherSuites.length > 0) {
            sslContextBuilder.ciphers(Arrays.asList(this.cipherSuites));
        }
        try {
            return sslContextBuilder.build();
        }
        catch (SSLException e) {
            logger.debug("Failed to initialize SSL", (Throwable)e);
            if (("failed to initialize the server-side SSL context".equals(e.getMessage()) || "failed to initialize the client-side SSL context".equals(e.getMessage())) && e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (Exception e) {
            logger.debug("Failed to initialize SSL", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<Certificate> getCertificatesFromFile(String file, CertificateFactory factory) throws IOException, CertificateException {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        try (FileInputStream fis = new FileInputStream(file);){
            while (fis.available() > 0) {
                try {
                    certificates.add(factory.generateCertificate(fis));
                }
                catch (CertificateException e) {
                    logger.debug("Failed to read certificate", (Throwable)e);
                    Throwable cause = e.getCause();
                    if (cause == null || !"Empty input".equals(cause.getMessage())) throw e;
                    logger.debug("Detected empty input while reading certificate (" + cause + ")");
                    continue;
                    return certificates;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installBouncyCastleProvider() {
        Class<Security> clazz = Security.class;
        synchronized (Security.class) {
            if (Security.getProvider("BC") == null) {
                Security.addProvider((Provider)new BouncyCastleProvider());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static enum SslClientAuthentication {
        NONE(ClientAuth.NONE),
        OPTIONAL(ClientAuth.OPTIONAL),
        REQUIRED(ClientAuth.REQUIRE);

        private final ClientAuth clientAuth;

        private SslClientAuthentication(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }

        public static SslClientAuthentication of(String sslClientAuthentication) {
            return SslClientAuthentication.valueOf(sslClientAuthentication.toUpperCase());
        }

        ClientAuth toClientAuth() {
            return this.clientAuth;
        }
    }
}

