/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.management;

import com.headius.backport9.stack.StackWalker;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.SoftReference;
import java.util.stream.Stream;
import org.jruby.Ruby;
import org.jruby.RubyThread;
import org.jruby.exceptions.RaiseException;
import org.jruby.management.RuntimeMBean;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.backtrace.TraceType;

public class Runtime
implements RuntimeMBean {
    private final SoftReference<Ruby> ruby;
    private static final StackWalker WALKER = ThreadContext.WALKER;

    public Runtime(Ruby ruby) {
        this.ruby = new SoftReference<Ruby>(ruby);
    }

    @Override
    public int getExceptionCount() {
        return this.ruby.get().getExceptionCount();
    }

    @Override
    public int getBacktraceCount() {
        return this.ruby.get().getBacktraceCount();
    }

    @Override
    public int getCallerCount() {
        return this.ruby.get().getCallerCount();
    }

    @Override
    public String threadDump() {
        return this.dumpThreads(TraceType.Gather.NORMAL);
    }

    @Override
    public String rawThreadDump() {
        return this.dumpThreads(TraceType.Gather.RAW);
    }

    @Override
    public String fullThreadDump() {
        return this.dumpThreads(TraceType.Gather.FULL);
    }

    public String dumpThreads(TraceType.Gather gather) {
        Ruby ruby = this.ruby.get();
        RubyThread[] thrs = ruby.getThreadService().getActiveRubyThreads();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("All threads known to Ruby instance " + ruby.hashCode());
        pw.println();
        for (RubyThread th : thrs) {
            Runtime.dumpThread(ruby, th, gather, pw);
        }
        return sw.toString();
    }

    private static void dumpThread(Ruby ruby, RubyThread th, TraceType.Gather gather, PrintWriter pw) {
        pw.println("Thread: " + th.getNativeThread().getName());
        pw.println("Stack:");
        ThreadContext tc = th.getContext();
        StringBuilder builder = new StringBuilder();
        if (tc != null) {
            TraceType.Format.JRUBY.renderBacktrace(WALKER.walk(th.getNativeThread().getStackTrace(), stream -> gather.getBacktraceData(tc, (Stream<StackWalker.StackFrame>)stream)).getBacktrace(ruby), builder, false);
            pw.println(builder);
            builder.setLength(0);
        } else {
            pw.println("    [no longer alive]");
        }
        pw.println();
    }

    @Override
    public String executeRuby(final String code) {
        final String[] result2 = new String[1];
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    result2[0] = Runtime.this.ruby.get().evalScriptlet(code).toString();
                }
                catch (RaiseException re) {
                    result2[0] = Runtime.this.ruby.get().getInstanceConfig().getTraceType().printBacktrace(re.getException(), false);
                }
                catch (Throwable t) {
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    result2[0] = sw.toString();
                }
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return result2[0];
    }
}

