/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.io.Closeable;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.zeromq.SocketType;
import org.zeromq.ZMQ;
import org.zeromq.ZThread;
import zmq.util.function.BiFunction;

public class ZContext
implements Closeable {
    private final ZMQ.Context context;
    private final Set<ZMQ.Socket> sockets;
    private final Set<Selector> selectors;
    private final Set<ZContext> shadows;
    private final int ioThreads;
    private final boolean main;
    private volatile int linger;
    private int pipehwm;
    private volatile int sndhwm;
    private volatile int rcvhwm;

    public ZContext() {
        this(1);
    }

    public ZContext(int ioThreads) {
        this(null, ioThreads);
    }

    private ZContext(ZContext parent, int ioThreads) {
        if (parent == null) {
            this.main = true;
            this.context = ZMQ.context(ioThreads);
            this.shadows = Collections.newSetFromMap(new ConcurrentHashMap());
        } else {
            this.main = false;
            this.context = parent.context;
            this.shadows = parent.shadows;
            this.shadows.add(this);
        }
        this.sockets = Collections.newSetFromMap(new ConcurrentHashMap());
        this.selectors = Collections.newSetFromMap(new ConcurrentHashMap());
        this.ioThreads = ioThreads;
        this.linger = 0;
        this.pipehwm = 1000;
        this.sndhwm = 1000;
        this.rcvhwm = 1000;
    }

    public void destroy() {
        for (ZMQ.Socket socket : this.sockets) {
            socket.internalClose();
        }
        this.sockets.clear();
        for (Selector selector : this.selectors) {
            this.context.close(selector);
        }
        this.selectors.clear();
        if (this.isMain()) {
            for (ZContext child : this.shadows) {
                child.close();
            }
            this.context.term();
        } else {
            this.shadows.remove(this);
        }
    }

    public ZMQ.Socket createSocket(SocketType type2) {
        ZMQ.Socket socket = new ZMQ.Socket(this, type2);
        socket.setRcvHWM(this.rcvhwm);
        socket.setSndHWM(this.sndhwm);
        socket.setLinger(this.linger);
        this.sockets.add(socket);
        return socket;
    }

    @Deprecated
    public ZMQ.Socket createSocket(int type2) {
        return this.createSocket(SocketType.type(type2));
    }

    @Deprecated
    public void destroySocket(ZMQ.Socket s) {
        if (s == null) {
            return;
        }
        s.setLinger(this.linger);
        try {
            s.internalClose();
        }
        finally {
            this.sockets.remove(s);
        }
    }

    void closeSocket(ZMQ.Socket s) {
        if (s == null) {
            return;
        }
        try {
            s.internalClose();
        }
        finally {
            this.sockets.remove(s);
        }
    }

    @Deprecated
    public Selector createSelector() {
        return this.selector();
    }

    Selector selector() {
        Selector selector = this.context.selector();
        this.selectors.add(selector);
        return selector;
    }

    @Deprecated
    public void closeSelector(Selector selector) {
        if (this.selectors.remove(selector)) {
            this.context.close(selector);
        }
    }

    public ZMQ.Poller createPoller(int size) {
        return new ZMQ.Poller(this.context, size);
    }

    @Deprecated
    public static ZContext shadow(ZContext ctx) {
        return ctx.shadow();
    }

    public ZContext shadow() {
        if (!this.main) {
            throw new IllegalStateException("Shadow contexts don't cast shadows");
        }
        ZContext context = new ZContext(this, this.ioThreads);
        context.linger = this.linger;
        context.sndhwm = this.sndhwm;
        context.rcvhwm = this.rcvhwm;
        context.pipehwm = this.pipehwm;
        return context;
    }

    public ZMQ.Socket fork(ZThread.IAttachedRunnable runnable, Object ... args) {
        return ZThread.fork(this, runnable, args);
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    @Deprecated
    public void setIoThreads(int ioThreads) {
    }

    public int getLinger() {
        return this.linger;
    }

    public void setLinger(int linger) {
        this.linger = linger;
    }

    public void setRcvHWM(int rcvhwm) {
        this.rcvhwm = rcvhwm;
    }

    public void setSndHWM(int sndhwm) {
        this.sndhwm = sndhwm;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.context.setUncaughtExceptionHandler(handler);
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.context.getUncaughtExceptionHandler();
    }

    public void setNotificationExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        this.context.setNotificationExceptionHandler(handler);
    }

    public Thread.UncaughtExceptionHandler getNotificationExceptionHandler() {
        return this.context.getNotificationExceptionHandler();
    }

    public void setThreadFactor(BiFunction<Runnable, String, Thread> threadFactory) {
        this.context.setThreadFactor(threadFactory);
    }

    public BiFunction<Runnable, String, Thread> getThreadFactory() {
        return this.context.getThreadFactory();
    }

    public boolean isMain() {
        return this.main;
    }

    public boolean isEmpty() {
        return this.shadows.isEmpty() && this.sockets.isEmpty() && this.selectors.isEmpty();
    }

    @Deprecated
    public void setMain(boolean main) {
    }

    public ZMQ.Context getContext() {
        return this.context;
    }

    @Deprecated
    public void setContext(ZMQ.Context ctx) {
    }

    public List<ZMQ.Socket> getSockets() {
        return new ArrayList<ZMQ.Socket>(this.sockets);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public boolean isClosed() {
        return this.context.isClosed();
    }
}

