/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.frame;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.layout.Thickness;
import org.jetbrains.letsPlot.core.plot.base.theme.Theme;
import org.jetbrains.letsPlot.core.plot.builder.FrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.MarginSide;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.frame.FrameOfReferenceProviderBase;
import org.jetbrains.letsPlot.core.plot.builder.frame.SquareFrameOfReference;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.AxisLayoutQuad;
import org.jetbrains.letsPlot.core.plot.builder.layout.GeomMarginsLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.TileLayoutProvider;
import org.jetbrains.letsPlot.core.plot.builder.layout.tile.InsideOutTileLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.tile.TopDownTileLayout;
import org.jetbrains.letsPlot.core.plot.builder.scale.AxisPosition;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001#Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\u0010\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\nH\u0016J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0010\u00a2\u0006\u0002\b\"R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReferenceProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/frame/FrameOfReferenceProviderBase;", "plotContext", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "hScaleProto", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "vScaleProto", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "flipAxis", "", "hAxisPosition", "Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;", "vAxisPosition", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "domainByMargin", "", "Lorg/jetbrains/letsPlot/core/plot/builder/MarginSide;", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "(Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;Lorg/jetbrains/letsPlot/core/plot/base/Scale;Lorg/jetbrains/letsPlot/core/plot/base/Scale;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;ZLorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;Lorg/jetbrains/letsPlot/core/plot/builder/scale/AxisPosition;Lorg/jetbrains/letsPlot/core/plot/base/theme/Theme;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Ljava/util/Map;)V", "createTileFrame", "Lorg/jetbrains/letsPlot/core/plot/builder/FrameOfReference;", "layoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutInfo;", "coordProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "debugDrawing", "createTileLayoutProvider", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutProvider;", "axisLayoutQuad", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;", "createTileLayoutProvider$plot_builder", "MyTileLayoutProvider", "plot-builder"})
public final class SquareFrameOfReferenceProvider
extends FrameOfReferenceProviderBase {
    @NotNull
    private final DoubleRectangle adjustedDomain;

    public SquareFrameOfReferenceProvider(@NotNull PlotContext plotContext, @NotNull Scale hScaleProto, @NotNull Scale vScaleProto, @NotNull DoubleRectangle adjustedDomain, boolean flipAxis, @NotNull AxisPosition hAxisPosition, @NotNull AxisPosition vAxisPosition, @NotNull Theme theme, @NotNull GeomMarginsLayout marginsLayout, @NotNull Map<MarginSide, DoubleSpan> domainByMargin) {
        Intrinsics.checkNotNullParameter((Object)plotContext, (String)"plotContext");
        Intrinsics.checkNotNullParameter((Object)hScaleProto, (String)"hScaleProto");
        Intrinsics.checkNotNullParameter((Object)vScaleProto, (String)"vScaleProto");
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)((Object)hAxisPosition), (String)"hAxisPosition");
        Intrinsics.checkNotNullParameter((Object)((Object)vAxisPosition), (String)"vAxisPosition");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
        Intrinsics.checkNotNullParameter(domainByMargin, (String)"domainByMargin");
        super(plotContext, hScaleProto, vScaleProto, flipAxis, hAxisPosition, vAxisPosition, theme, marginsLayout, domainByMargin, false);
        this.adjustedDomain = adjustedDomain;
    }

    @Override
    @NotNull
    public TileLayoutProvider createTileLayoutProvider$plot_builder(@NotNull AxisLayoutQuad axisLayoutQuad) {
        Intrinsics.checkNotNullParameter((Object)axisLayoutQuad, (String)"axisLayoutQuad");
        return new MyTileLayoutProvider(axisLayoutQuad, this.adjustedDomain, this.getMarginsLayout(), this.getTheme().panel().inset(), this.getFlipAxis());
    }

    @Override
    @NotNull
    public FrameOfReference createTileFrame(@NotNull TileLayoutInfo layoutInfo, @NotNull CoordProvider coordProvider, boolean debugDrawing) {
        Intrinsics.checkNotNullParameter((Object)layoutInfo, (String)"layoutInfo");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        AxisLayoutInfo axisLayoutInfo = layoutInfo.getAxisInfos().getBottom();
        if (axisLayoutInfo == null && (axisLayoutInfo = layoutInfo.getAxisInfos().getTop()) == null) {
            throw new IllegalStateException("No top/bottom axis info.");
        }
        AxisLayoutInfo hAxisLayoutInfo = axisLayoutInfo;
        AxisLayoutInfo axisLayoutInfo2 = layoutInfo.getAxisInfos().getLeft();
        if (axisLayoutInfo2 == null && (axisLayoutInfo2 = layoutInfo.getAxisInfos().getRight()) == null) {
            throw new IllegalStateException("No left/right axis info.");
        }
        AxisLayoutInfo vAxisLayoutInfo = axisLayoutInfo2;
        DoubleVector client = new DoubleVector(hAxisLayoutInfo.getAxisLength(), vAxisLayoutInfo.getAxisLength());
        CoordinateSystem coord = coordProvider.createCoordinateSystem(this.adjustedDomain, client);
        SquareFrameOfReference tileFrameOfReference = new SquareFrameOfReference(this.getPlotContext(), hAxisLayoutInfo.getAxisBreaks(), vAxisLayoutInfo.getAxisBreaks(), this.adjustedDomain, coord, layoutInfo, this.getMarginsLayout(), this.getTheme(), this.getFlipAxis());
        tileFrameOfReference.setDebugDrawing(debugDrawing);
        return tileFrameOfReference;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/frame/SquareFrameOfReferenceProvider$MyTileLayoutProvider;", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayoutProvider;", "axisLayoutQuad", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;", "adjustedDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "marginsLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;", "panelInset", "Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;", "flipAxis", "", "(Lorg/jetbrains/letsPlot/core/plot/builder/layout/AxisLayoutQuad;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Lorg/jetbrains/letsPlot/core/plot/builder/layout/GeomMarginsLayout;Lorg/jetbrains/letsPlot/core/plot/base/layout/Thickness;Z)V", "hvDomain", "createInsideOutTileLayout", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/TileLayout;", "createTopDownTileLayout", "plot-builder"})
    private static final class MyTileLayoutProvider
    implements TileLayoutProvider {
        @NotNull
        private final AxisLayoutQuad axisLayoutQuad;
        @NotNull
        private final GeomMarginsLayout marginsLayout;
        @NotNull
        private final Thickness panelInset;
        @NotNull
        private final DoubleRectangle hvDomain;

        public MyTileLayoutProvider(@NotNull AxisLayoutQuad axisLayoutQuad, @NotNull DoubleRectangle adjustedDomain, @NotNull GeomMarginsLayout marginsLayout, @NotNull Thickness panelInset, boolean flipAxis) {
            Intrinsics.checkNotNullParameter((Object)axisLayoutQuad, (String)"axisLayoutQuad");
            Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
            Intrinsics.checkNotNullParameter((Object)marginsLayout, (String)"marginsLayout");
            Intrinsics.checkNotNullParameter((Object)panelInset, (String)"panelInset");
            this.axisLayoutQuad = axisLayoutQuad;
            this.marginsLayout = marginsLayout;
            this.panelInset = panelInset;
            this.hvDomain = adjustedDomain.flipIf(flipAxis);
        }

        @Override
        @NotNull
        public TileLayout createTopDownTileLayout() {
            return new TopDownTileLayout(this.axisLayoutQuad, this.hvDomain.xRange(), this.hvDomain.yRange(), this.marginsLayout, this.panelInset);
        }

        @Override
        @NotNull
        public TileLayout createInsideOutTileLayout() {
            return new InsideOutTileLayout(this.axisLayoutQuad, this.hvDomain.xRange(), this.hvDomain.yRange(), this.marginsLayout);
        }
    }
}

